/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.bgmddatalock;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockCacheHelper;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockUtils;
import kd.epm.eb.common.bgmddatalock.DataLockPageUserSelect;
import kd.epm.eb.common.bgmddatalock.IBgmdDataLockCache;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.lazytree.bgmdDatalock.BgmdEntityTree;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class BgmdDataLockService {
    private static final Log log = LogFactory.getLog(BgmdDataLockService.class);
    private static final BgmdDataLockService SERVICE = new BgmdDataLockService();
    private static final String BGMD_DATALOCK = "bgmd_datalock";

    public static BgmdDataLockService getInstance() {
        return SERVICE;
    }

    public Map<String, Integer> getDataLockData(long modelId, long businessModelId, DataLockPageUserSelect dataLockPageUserSelect) {
        if (IDUtils.isEmptyLong(dataLockPageUserSelect.getPeriod()).booleanValue() || IDUtils.isEmptyLong(dataLockPageUserSelect.getVersion()).booleanValue() || IDUtils.isEmptyLong(dataLockPageUserSelect.getDataType()).booleanValue() || IDUtils.isEmptyLong(dataLockPageUserSelect.getAuditTrail()).booleanValue()) {
            return Collections.emptyMap();
        }
        Map<String, Map<String, Integer>> dataLockMap = BgmdDataLockCacheHelper.getDataLock(modelId, businessModelId);
        if (dataLockMap.isEmpty()) {
            return Collections.emptyMap();
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        Map<String, Integer> stringSetHashMap = this.fillEntityAndPeriod(businessModelId, dataLockMap, modelCache, dataLockPageUserSelect, false);
        if (stringSetHashMap == null) {
            return Collections.emptyMap();
        }
        return stringSetHashMap;
    }

    private Map<String, Integer> fillEntityAndPeriod(long businessModelId, Map<String, Map<String, Integer>> dataLockMap, IModelCacheHelper modelCache, DataLockPageUserSelect dataLockPageUserSelect, boolean isOnlyLeaf) {
        String cacheKey = BgmdDataLockUtils.getCacheKey(modelCache, dataLockPageUserSelect);
        if (StringUtils.isEmpty(cacheKey) || !dataLockMap.containsKey(cacheKey)) {
            return Collections.emptyMap();
        }
        Map<String, Integer> entityMap = dataLockMap.get(cacheKey);
        if (!isOnlyLeaf) {
            return entityMap;
        }
        Long entityViewId = modelCache.getViewByBusModelAndDimNumber(businessModelId, SysDimensionEnum.Entity.getNumber());
        HashMap<String, Integer> returnMap = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : entityMap.entrySet()) {
            List<Member> entityMembers = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, entry.getKey(), RangeEnum.ALL_DETAIL_INCLUDE.getIndex());
            if (CollectionUtils.isEmpty(entityMembers)) continue;
            Integer value = entry.getValue();
            for (Member entityMember : entityMembers) {
                returnMap.put(entityMember.getNumber(), value);
            }
        }
        return returnMap;
    }

    public Map<String, Map<String, Integer>> buildCache(Long modelId, Long businessModelId) {
        HashMap<DataLockPageUserSelect, Map> collectMap = new HashMap<DataLockPageUserSelect, Map>();
        DataLockPageUserSelect tryKey = null;
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("businessmodel", "=", (Object)businessModelId));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"bgmdDataLockBuildCache", (String)BGMD_DATALOCK, (String)"year,version,datatype,audittrail,entity,periodinteger", (QFilter[])qFilter.toArray(), (String)"year,version,datatype,audittrail");){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Long yearId = next.getLong("year");
                Long versionId = next.getLong("version");
                Long datatypeId = next.getLong("datatype");
                Long audittrailId = next.getLong("audittrail");
                DataLockPageUserSelect currentKey = new DataLockPageUserSelect(yearId, versionId, datatypeId, audittrailId);
                if (tryKey == null || !tryKey.equals(currentKey)) {
                    tryKey = currentKey;
                }
                String entityNumber = next.getString("entity");
                Integer periodinteger = next.getInteger("periodinteger");
                Map entity2PeriodMap = collectMap.computeIfAbsent(tryKey, v -> new HashMap());
                entity2PeriodMap.put(entityNumber, periodinteger);
            }
        }
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)collectMap.size());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        for (Map.Entry entry : collectMap.entrySet()) {
            String cacheKey = BgmdDataLockUtils.getCacheKey(modelCache, (DataLockPageUserSelect)entry.getKey());
            if (cacheKey == null) continue;
            returnMap.put(cacheKey, entry.getValue());
        }
        return returnMap;
    }

    public void saveDataLock(long modelId, long businessModelId, DataLockPageUserSelect dataLockPageUserSelect, BgmdEntityTree treeRoot, String usage) {
        Integer oldInteger;
        Map<String, Integer> beginLockData = this.getDataLockData(modelId, businessModelId, dataLockPageUserSelect);
        beginLockData = beginLockData.entrySet().stream().filter(map -> treeRoot.getNodeByNumber((String)map.getKey()) != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<String, Integer> newLockData = new HashMap<String, Integer>(16);
        HashMap<String, Integer> newNoLeafLockData = new HashMap<String, Integer>(16);
        BgmdDataLockUtils.buildLockDataMap(treeRoot, newLockData, newNoLeafLockData, usage);
        Integer integer = (Integer)newLockData.get(treeRoot.getNumber());
        if (integer == null || integer == 0) {
            newLockData.remove(treeRoot.getNumber());
        }
        ArrayList<DynamicObject> savez = new ArrayList<DynamicObject>();
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
        for (Map.Entry entry : newLockData.entrySet()) {
            oldInteger = beginLockData.get(entry.getKey());
            if (oldInteger == null) {
                DynamicObject datalockDoj = BusinessDataServiceHelper.newDynamicObject((String)BGMD_DATALOCK);
                datalockDoj.set("model", (Object)modelId);
                datalockDoj.set("businessmodel", (Object)businessModelId);
                datalockDoj.set("year", (Object)dataLockPageUserSelect.getPeriod());
                datalockDoj.set("version", (Object)dataLockPageUserSelect.getVersion());
                datalockDoj.set("datatype", (Object)dataLockPageUserSelect.getDataType());
                datalockDoj.set("audittrail", (Object)dataLockPageUserSelect.getAuditTrail());
                datalockDoj.set("entity", entry.getKey());
                datalockDoj.set("periodinteger", entry.getValue());
                savez.add(datalockDoj);
                continue;
            }
            if (!oldInteger.equals(entry.getValue())) {
                updateList.add(new Object[]{entry.getValue(), entry.getKey()});
            }
            beginLockData.remove(entry.getKey());
        }
        for (Map.Entry entry : newNoLeafLockData.entrySet()) {
            oldInteger = beginLockData.get(entry.getKey());
            if (oldInteger == null) continue;
            updateList.add(new Object[]{oldInteger, entry.getKey()});
            beginLockData.remove(entry.getKey());
        }
        try (TXHandle tx = TX.requiresNew((String)"saveDataLock");){
            try {
                if (!savez.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])savez.toArray(new DynamicObject[0]));
                }
                if (!updateList.isEmpty()) {
                    String sql = "update t_bgmd_datalock set fperiodinteger = ? where fentitynumber = ? and fyearid = " + dataLockPageUserSelect.getPeriod() + " and fversionid = " + dataLockPageUserSelect.getVersion() + " and fdatatypeid = " + dataLockPageUserSelect.getDataType() + " and faudittrailid = " + dataLockPageUserSelect.getAuditTrail();
                    DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, updateList);
                }
                if (!beginLockData.isEmpty()) {
                    QFilter qFilter = new QFilter("year", "=", (Object)dataLockPageUserSelect.getPeriod()).and("version", "=", (Object)dataLockPageUserSelect.getVersion()).and("datatype", "=", (Object)dataLockPageUserSelect.getDataType()).and("audittrail", "=", (Object)dataLockPageUserSelect.getAuditTrail());
                    qFilter.and(new QFilter("entity", "in", beginLockData.keySet()));
                    DeleteServiceHelper.delete((String)BGMD_DATALOCK, (QFilter[])qFilter.toArray());
                }
            }
            catch (Exception e) {
                tx.markRollback();
                log.error(BGMD_DATALOCK, (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)BGMD_DATALOCK));
        BgmdDataLockCacheHelper.clearDataLock(modelId, businessModelId);
    }

    public IBgmdDataLockCache getDataLockCache(Long modelId, Long bizModelId) {
        return DataLockService.getInstance().getCheckerByBizModel(modelId, bizModelId);
    }

    public IBgmdDataLockCache getDataLockCache(IModelCacheHelper modelCache, Long dataSetId) {
        return DataLockService.getInstance().getChecker(modelCache.getModelobj().getId(), dataSetId);
    }
}

