/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.bgmddatalock;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockPeriodPolymer;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockPeriodTreeNode;
import kd.epm.eb.common.bgmddatalock.DataLockPageUserSelect;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.ViewUsageEnum;
import kd.epm.eb.common.lazytree.bgmdDatalock.BgmdEntityTree;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class BgmdDataLockUtils {
    private static final String BGMD_DATA_LOCK_CACHE = "BGMD_DATA_LOCK_CACHE";
    public static final String BGMD_DATA_LOCK_LIST = "bgmd_datalocklist";
    private static final Map<String, Integer> controlDimension = new HashMap<String, Integer>(16);

    public static BgmdEntityTree buildTree(Long modelId, long businessModelId, Map<String, Integer> dataLockData, Long viewId) {
        if (IDUtils.isEmptyLong(modelId).booleanValue() || businessModelId == 0L) {
            return new BgmdEntityTree(-1L, SysDimensionEnum.Entity.getChineseName(), SysDimensionEnum.Entity.getNumber(), null, null, 0);
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        Member rootMember = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), viewId, SysDimensionEnum.Entity.getNumber());
        Integer periodInteger = dataLockData == null ? null : (dataLockData.get(rootMember.getNumber()) == null ? Integer.valueOf(0) : dataLockData.get(rootMember.getNumber()));
        return BgmdDataLockUtils.createBgmdEntityTree(dataLockData, null, rootMember, periodInteger);
    }

    private static BgmdEntityTree createBgmdEntityTree(Map<String, Integer> dataLockData, BgmdEntityTree parent, Member member, Integer periodInteger) {
        if (periodInteger == null) {
            periodInteger = dataLockData == null ? null : dataLockData.get(member.getNumber());
        }
        BgmdEntityTree rootTree = new BgmdEntityTree(member.getId(), member.getName(), member.getNumber(), parent, null, periodInteger);
        rootTree.setChildren(BgmdDataLockUtils.createChildren(rootTree, member, dataLockData));
        return rootTree;
    }

    private static List<BgmdEntityTree> createChildren(BgmdEntityTree parent, Member parentMember, Map<String, Integer> dataLockData) {
        List<Member> children = parentMember.getChildren(true);
        if (CollectionUtils.isNotEmpty(children)) {
            ArrayList entityTrees = Lists.newArrayListWithExpectedSize((int)children.size());
            for (Member child : children) {
                entityTrees.add(BgmdDataLockUtils.createBgmdEntityTree(dataLockData, parent, child, null));
            }
            return entityTrees;
        }
        return null;
    }

    public static String getCacheKey(IModelCacheHelper modelCache, DataLockPageUserSelect dataLockPageUserSelect) {
        Member budgetPeriod = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), (Long)0L, dataLockPageUserSelect.getPeriod());
        Member version = modelCache.getMember(SysDimensionEnum.Version.getNumber(), (Long)0L, dataLockPageUserSelect.getVersion());
        Member dataType = modelCache.getMember(SysDimensionEnum.DataType.getNumber(), (Long)0L, dataLockPageUserSelect.getDataType());
        Member auditTrail = modelCache.getMember(SysDimensionEnum.AuditTrail.getNumber(), (Long)0L, dataLockPageUserSelect.getAuditTrail());
        if (budgetPeriod == null || version == null || dataType == null || auditTrail == null) {
            return null;
        }
        return BgmdDataLockUtils.getCacheKey(budgetPeriod.getNumber(), version.getNumber(), dataType.getNumber(), auditTrail.getNumber());
    }

    public static String getCacheKey(String yearNumber, String versionNumber, String dataTypeNumber, String auditTrailNumber) {
        return yearNumber + "`" + versionNumber + "`" + dataTypeNumber + "`" + auditTrailNumber;
    }

    public static String getCacheKey(Long modelId, Long businessModelId) {
        return BGMD_DATA_LOCK_CACHE + modelId + businessModelId;
    }

    public static String getCacheKey(Long modelId) {
        return BGMD_DATA_LOCK_CACHE + modelId;
    }

    public static List<BgmdDataLockPeriodTreeNode> getPeriodNumberList() {
        return BgmdDataLockPeriodPolymer.getTreeNodeSort();
    }

    public static Map<String, BgmdDataLockPeriodTreeNode> getPeriodNumberMap() {
        return BgmdDataLockPeriodPolymer.getTreeNodeMap();
    }

    public static BgmdDataLockPeriodTreeNode getPeriodTreeNode(String periodNumber) {
        Map<String, BgmdDataLockPeriodTreeNode> treeNodeMap = BgmdDataLockPeriodPolymer.getTreeNodeMap();
        return treeNodeMap.get(periodNumber.toLowerCase());
    }

    public static boolean checkLock(int source, int compare) {
        int enable = source & compare;
        return enable > 0;
    }

    public static void changeNodePeriodStatus(BgmdEntityTree currentNode, String periodNumber, boolean newVal, String usage) {
        int periodInteger = currentNode.getPeriodIntegerCascadeSuper();
        BgmdDataLockPeriodTreeNode periodTreeNode = BgmdDataLockUtils.getPeriodNumberMap().get(periodNumber);
        periodInteger = BgmdDataLockUtils.genNewPeriodInteger(newVal, periodInteger, periodTreeNode);
        if (currentNode.getParent() != null && periodInteger == currentNode.getParent().getPeriodIntegerCascadeSuper()) {
            currentNode.setPeriodInteger(null);
        } else {
            currentNode.setPeriodInteger(periodInteger);
        }
        BgmdDataLockUtils.changeEntityChildrenPeriodStatus(currentNode, newVal, periodTreeNode, periodInteger, usage);
        BgmdDataLockUtils.changeEntityParentPeriodStatus(currentNode.getParent(), usage);
    }

    public static Integer getNewValue(Boolean newVal, String periodNumber, Integer periodInteger) {
        BgmdDataLockPeriodTreeNode periodTreeNode = BgmdDataLockUtils.getPeriodNumberMap().get(periodNumber);
        return BgmdDataLockUtils.genNewPeriodInteger(newVal, periodInteger, periodTreeNode);
    }

    private static void changeEntityParentPeriodStatus(BgmdEntityTree currentNode, String usage) {
        Integer childrenPeriodInteger;
        if (currentNode == null) {
            return;
        }
        int periodInteger = currentNode.getPeriodIntegerCascadeSuper();
        if (periodInteger != (childrenPeriodInteger = currentNode.getChildrenPeriodInteger())) {
            currentNode.setPeriodInteger(childrenPeriodInteger);
            for (BgmdEntityTree child : currentNode.getChildren()) {
                Integer childPeriodInteger = child.getPeriodInteger();
                if (childPeriodInteger == null) {
                    child.setPeriodInteger(periodInteger);
                    continue;
                }
                if (!childPeriodInteger.equals(childrenPeriodInteger) || ViewUsageEnum.ANALYSIS.getIndex().equals(usage)) continue;
                child.setPeriodInteger(null);
            }
            BgmdDataLockUtils.changeEntityParentPeriodStatus(currentNode.getParent(), usage);
        }
    }

    private static void changeEntityChildrenPeriodStatus(BgmdEntityTree currentNode, boolean newVal, BgmdDataLockPeriodTreeNode periodTreeNode, int parentPeriodInteger, String usage) {
        List<BgmdEntityTree> children = currentNode.getChildren();
        if (children != null) {
            for (BgmdEntityTree child : children) {
                int beginParentPeriodInteger = parentPeriodInteger;
                Integer childPeriodInteger = child.getPeriodInteger();
                if (childPeriodInteger != null) {
                    childPeriodInteger = BgmdDataLockUtils.genNewPeriodInteger(newVal, childPeriodInteger, periodTreeNode);
                    if (ViewUsageEnum.ANALYSIS.getIndex().equals(usage) && child.isLeaf()) {
                        beginParentPeriodInteger = childPeriodInteger;
                        child.setPeriodInteger(childPeriodInteger);
                    } else if (beginParentPeriodInteger == childPeriodInteger) {
                        child.setPeriodInteger(null);
                    } else {
                        beginParentPeriodInteger = childPeriodInteger;
                        child.setPeriodInteger(childPeriodInteger);
                    }
                } else if (ViewUsageEnum.ANALYSIS.getIndex().equals(usage) && child.isLeaf()) {
                    child.setPeriodInteger(beginParentPeriodInteger);
                } else if (!ViewUsageEnum.ANALYSIS.getIndex().equals(usage)) {
                    child.setPeriodInteger(beginParentPeriodInteger);
                }
                BgmdDataLockUtils.changeEntityChildrenPeriodStatus(child, newVal, periodTreeNode, beginParentPeriodInteger, usage);
            }
        }
    }

    private static int genNewPeriodInteger(boolean newVal, int periodInteger, BgmdDataLockPeriodTreeNode periodTreeNode) {
        if (newVal) {
            periodInteger |= periodTreeNode.getPeriodsCascadeChildren();
            periodInteger = BgmdDataLockUtils.changePeriodParent(periodTreeNode.getParent(), periodInteger);
        } else {
            periodInteger &= Integer.MAX_VALUE & ~periodTreeNode.getPeriodsCascadeChildren() & ~periodTreeNode.getPeriodsCascadeParents();
        }
        return periodInteger;
    }

    public static int changePeriodParent(BgmdDataLockPeriodTreeNode parent, int periodInteger) {
        if (parent != null) {
            boolean checked = true;
            for (BgmdDataLockPeriodTreeNode child : parent.getChildren()) {
                if (BgmdDataLockUtils.checkLock(periodInteger, child.getPeriods())) continue;
                checked = false;
                break;
            }
            if (checked) {
                periodInteger |= parent.getPeriods();
            }
            periodInteger = BgmdDataLockUtils.changePeriodParent(parent.getParent(), periodInteger);
        }
        return periodInteger;
    }

    public static void buildLockDataMap(BgmdEntityTree entityTree, Map<String, Integer> newLockData, Map<String, Integer> newNoLeafLockData, String usage) {
        Integer periodInteger = entityTree.getPeriodInteger();
        if (periodInteger != null) {
            if (ViewUsageEnum.ANALYSIS.getIndex().equals(usage)) {
                if (entityTree.isLeaf()) {
                    newLockData.put(entityTree.getNumber(), periodInteger);
                } else {
                    newNoLeafLockData.put(entityTree.getNumber(), periodInteger);
                }
            } else {
                newLockData.put(entityTree.getNumber(), periodInteger);
            }
        }
        if (CollectionUtils.isNotEmpty(entityTree.getChildren())) {
            for (BgmdEntityTree child : entityTree.getChildren()) {
                BgmdDataLockUtils.buildLockDataMap(child, newLockData, newNoLeafLockData, usage);
            }
        }
    }

    public static Map<String, Integer> getControlDimNumberMap() {
        return controlDimension;
    }

    public static String getTips(Long modelId, Map<String, String> memberMapByCell, Map<String, Long> dimensionView, DynamicObject caseDoj) {
        if (IDUtils.isEmptyLong(modelId).booleanValue() || MapUtils.isEmpty(memberMapByCell)) {
            return null;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        return ResManager.loadResFormat((String)"\u7ef4\u5ea6\u7ec4\u5408\uff1a%1\uff1b %2\uff1b %3\uff1b %4\uff1b %5\uff0c\u6570\u636e\u7ec4\u5408\u5df2\u88ab\u65b9\u6848\u3010%6\u3011\u9501\u5b9a\uff0c\u8bf7\u7533\u8bf7\u89e3\u9501\u3002", (String)"BgmdDataLockUtils_1", (String)"epm-eb-common", (Object[])new Object[]{BgmdDataLockUtils.tryToGetName(memberMapByCell, dimensionView, modelCache, SysDimensionEnum.BudgetPeriod.getNumber()), BgmdDataLockUtils.tryToGetName(memberMapByCell, dimensionView, modelCache, SysDimensionEnum.Version.getNumber()), BgmdDataLockUtils.tryToGetName(memberMapByCell, dimensionView, modelCache, SysDimensionEnum.Entity.getNumber()), BgmdDataLockUtils.tryToGetName(memberMapByCell, dimensionView, modelCache, SysDimensionEnum.DataType.getNumber()), BgmdDataLockUtils.tryToGetName(memberMapByCell, dimensionView, modelCache, SysDimensionEnum.AuditTrail.getNumber()), caseDoj.getString("name")});
    }

    private static String tryToGetName(Map<String, String> memberMapByCell, Map<String, Long> dimensionView, IModelCacheHelper modelCache, String number) {
        Member member = modelCache.getMember(number, dimensionView.get(number), memberMapByCell.get(number));
        if (member == null) {
            return null;
        }
        return member.getName();
    }

    static {
        controlDimension.put(SysDimensionEnum.BudgetPeriod.getNumber(), 0);
        controlDimension.put(SysDimensionEnum.Version.getNumber(), 1);
        controlDimension.put(SysDimensionEnum.DataType.getNumber(), 2);
        controlDimension.put(SysDimensionEnum.AuditTrail.getNumber(), 3);
        controlDimension.put(SysDimensionEnum.Entity.getNumber(), 4);
    }
}

