/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.bgmddatalock.v2;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.bgmddatalock.v2.DataLockCacheContext;
import kd.epm.eb.common.bgmddatalock.v2.DataLockChecker;
import kd.epm.eb.common.bgmddatalock.v2.IDataLockChecker;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.eventbus.event.MemberChangeEvent;
import kd.epm.eb.common.olapdao.BgmdShrekLockDao;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;
import kd.epm.eb.common.utils.cache.Cache;
import org.apache.commons.collections4.CollectionUtils;

public class DataLockService {
    private static final DataLockService service = new DataLockService();
    private static final Log log = LogFactory.getLog(DataLockService.class);
    private static LoadingCache<String, DataLockCacheContext> caches = CacheBuilder.newBuilder().maximumSize(16L).expireAfterAccess(2L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, DataLockCacheContext>(){

        public DataLockCacheContext load(String key) {
            String[] split = key.split(":");
            return DataLockService.getInstance().initCache(Long.parseLong(split[0]), Long.parseLong(split[1]));
        }
    });
    private static final long MODEL_MAX_SIZE = 16L;
    private static final long MODEL_OVER_TIME = 2L;
    public static final String CACHE_RULE_GRAPHNODE_Version_KEY = "epm:cacheDataLock:v2:";

    public static DataLockService getInstance() {
        return service;
    }

    public IDataLockChecker getChecker(Long modelId, Long dataSetId) {
        if (modelId == null || modelId == 0L || dataSetId == null || dataSetId == 0L) {
            return null;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
        return this.getCheckerByBizModel(modelId, bizModelId);
    }

    public IDataLockChecker getCheckerByBizModel(Long modelId, Long bizModelId) {
        DataLockCacheContext cacheContext;
        if (modelId == null || modelId == 0L || bizModelId == null || bizModelId == 0L) {
            return null;
        }
        String key = modelId + ":" + bizModelId;
        try {
            cacheContext = (DataLockCacheContext)caches.get((Object)key);
        }
        catch (ExecutionException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        String versionNum = this.getVersionFromRedis(modelId, bizModelId);
        if (cacheContext != null && !cacheContext.getVersionId().equals(versionNum)) {
            caches.refresh((Object)key);
            try {
                cacheContext = (DataLockCacheContext)caches.get((Object)key);
            }
            catch (ExecutionException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
        }
        if (cacheContext != null) {
            return cacheContext.getDataLockChecker();
        }
        return this.initCache(modelId, bizModelId).getDataLockChecker();
    }

    private String getCacheKey(Long modelId, Long bizModelId) {
        return CACHE_RULE_GRAPHNODE_Version_KEY + modelId + ":" + bizModelId;
    }

    private DataLockCacheContext initCache(Long modelId, Long bizModelId) {
        String sign = "datalock_" + modelId;
        if (!UpdateRecordHelper.isUpdated(sign)) {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
            List<Long> busModelIds = BusinessModelServiceHelper.getInstance().getBusModelIdsByModelId(modelId);
            if (!busModelIds.isEmpty()) {
                QFBuilder qfBuilder = new QFBuilder();
                qfBuilder.add("model", "=", modelId);
                qfBuilder.add("bizmodel", "in", busModelIds);
                DynamicObject[] caseObjs = BusinessDataServiceHelper.load((String)"bgmd_datalockcase", (String)"id,name,period,version,datatype,audittrail,entityview.id,bizmodel.id", (QFilter[])qfBuilder.toArray());
                Set caseIds = Arrays.stream(caseObjs).map(e -> e.getLong("id")).collect(Collectors.toSet());
                DynamicObjectCollection detailList = QueryServiceHelper.query((String)"bgmd_datalockcasedetail", (String)"id,case.id,entity,period", (QFilter[])new QFilter[]{new QFilter("case.id", "in", caseIds)});
                Map<Long, List<DynamicObject>> caseGroupMap = detailList.stream().collect(Collectors.groupingBy(e -> e.getLong("case.id")));
                for (DynamicObject caseObj : caseObjs) {
                    this.updateCaseLock(caseObj, (Collection<DynamicObject>)caseGroupMap.get(caseObj.getLong("id")), modelCache);
                }
            }
            UpdateRecordHelper.addRecord(sign, null, null, true);
        }
        DataLockCacheContext dataLockCacheContext = new DataLockCacheContext();
        String versionNum = this.getVersionFromRedis(modelId, bizModelId);
        DataLockChecker dataLockChecker = DataLockChecker.initByBizModel(modelId, bizModelId);
        dataLockCacheContext.setVersionId(versionNum);
        dataLockCacheContext.setDataLockChecker(dataLockChecker);
        return dataLockCacheContext;
    }

    private String getVersionFromRedis(Long modelId, Long bizModelId) {
        String versionStr = Cache.get().get(this.getCacheKey(modelId, bizModelId));
        if (StringUtils.isNotEmpty(versionStr)) {
            return versionStr;
        }
        String newVersionNum = DBServiceHelper.genStringId();
        Cache.get().set(this.getCacheKey(modelId, bizModelId), newVersionNum);
        return newVersionNum;
    }

    public void clearCache(Long modelId, Long bizModelId) {
        if (bizModelId == null) {
            return;
        }
        Cache.get().remove(this.getCacheKey(modelId, bizModelId));
        caches.invalidate((Object)(modelId + ":" + bizModelId));
    }

    public void clearCache(MemberChangeEvent event) {
        IModelCacheHelper modelCache;
        Dimension dimension;
        Long modelId = event.getModelId();
        if (IDUtils.isNotNull(event.getDimensionId()) && (dimension = (modelCache = ModelCacheContext.getOrCreate(modelId)).getDimension(event.getDimensionId())) != null && !SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
            return;
        }
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"eb_businessmodel", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray(), null, (int)1000);
        for (Object pkId : pkIds) {
            this.clearCache(modelId, (Long)pkId);
        }
    }

    public void lock(OperationResult operationResult, Long modelId, Long busModelId, Long viewId, Long versionId, Long dataTypeId, Long auditTrailId, String entityNumber, Long periodId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        IDataLockChecker checker = this.getCheckerByBizModel(modelId, busModelId);
        Member versionMember = modelCache.getMember(SysDimensionEnum.Version.getNumber(), null, versionId);
        Member datatypeMember = modelCache.getMember(SysDimensionEnum.DataType.getNumber(), null, dataTypeId);
        Member audittrailMember = modelCache.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, auditTrailId);
        Member periodMember = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, periodId);
        if (!QueryServiceHelper.exists((String)"eb_dimensionview", (Object)viewId)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u53c2\u6570\u9519\u8bef,\u89c6\u56feid\u4e0d\u5b58\u5728(%1)", (String)"DataLockService_37", (String)"epm-eb-common", (Object[])new Object[]{viewId}));
        }
        if (checker != null && checker.isDataLock(new String[]{periodMember.getNumber(), versionMember.getNumber(), datatypeMember.getNumber(), audittrailMember.getNumber(), entityNumber})) {
            return;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", modelId);
        qfBuilder.add("bizmodel", "=", busModelId);
        DynamicObject[] otherCaseDoj = BusinessDataServiceHelper.load((String)"bgmd_datalockcase", (String)"name,period,version,datatype,audittrail,entityview.id", (QFilter[])qfBuilder.toArray());
        DynamicObject currCase = null;
        for (DynamicObject doj : otherCaseDoj) {
            if (!this.isContains(versionId, dataTypeId, auditTrailId, periodId, modelCache, doj) || !viewId.equals(doj.getLong("entityview.id"))) continue;
            if (!this.isAllEquals(versionId, dataTypeId, auditTrailId, periodId, modelCache, doj)) {
                operationResult.setShowMessage(true);
                operationResult.setMessage(ResManager.loadKDString((String)"\u6309\u7ec4\u7ec7\u63d0\u4ea4\u81ea\u52a8\u751f\u6210\u6570\u636e\u9501\u5b9a\u65b9\u6848\u5931\u8d25\uff08\u4e0e\u73b0\u6709\u65b9\u6848\u5b58\u5728\u4ea4\u96c6\uff09\uff0c\u8bf7\u901a\u77e5\u7ba1\u7406\u5458\u624b\u52a8\u9501\u5b9a\u3002", (String)"DataLockService_3", (String)"epm-eb-common", (Object[])new Object[0]));
                return;
            }
            currCase = doj;
            break;
        }
        if (currCase == null) {
            currCase = this.buildCurrCase(modelCache, modelId, busModelId, viewId, versionId, dataTypeId, auditTrailId, periodId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{currCase});
        } else if (!this.hasPeriod(currCase, periodId)) {
            this.addPeriodInCase(currCase, periodId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{currCase});
        }
        DynamicObject doj = BusinessDataServiceHelper.newDynamicObject((String)"bgmd_datalockcasedetail");
        doj.set("entity", (Object)entityNumber);
        doj.set("period", (Object)periodMember.getNumber());
        doj.set("case", (Object)currCase.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{doj});
        DynamicObject dbCase = BusinessDataServiceHelper.loadSingle((Object)currCase.getLong("id"), (String)"bgmd_datalockcase");
        DynamicObjectCollection detailList = QueryServiceHelper.query((String)"bgmd_datalockcasedetail", (String)"id,case.id,entity,period", (QFilter[])new QFilter[]{new QFilter("case.id", "in", (Object)currCase.getLong("id"))});
        this.updateCaseLock(dbCase, (Collection<DynamicObject>)detailList, modelCache);
        DataLockService.getInstance().clearCache(modelId, busModelId);
    }

    private DynamicObject buildCurrCase(IModelCacheHelper modelCache, Long modelId, Long busModelId, Long viewId, Long versionId, Long dataTypeId, Long auditTrailId, Long periodId) {
        DynamicObject currCase = BusinessDataServiceHelper.newDynamicObject((String)"bgmd_datalockcase");
        currCase.set("id", (Object)DBServiceHelper.genGlobalLongId());
        currCase.set("name", (Object)this.getName(modelCache, versionId, dataTypeId, auditTrailId));
        currCase.set("model", (Object)modelId);
        currCase.set("bizmodel", (Object)busModelId);
        currCase.set("entityview", (Object)viewId);
        this.putInDoj(periodId, "period", currCase);
        this.putInDoj(versionId, "version", currCase);
        this.putInDoj(dataTypeId, "datatype", currCase);
        this.putInDoj(auditTrailId, "audittrail", currCase);
        return currCase;
    }

    private String getName(IModelCacheHelper modelCache, Long versionId, Long dataTypeId, Long auditTrailId) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bgmd_datalockcase", (String)"name", (QFilter[])new QFilter("model", "=", (Object)modelCache.getModelobj().getId()).toArray());
        HashSet<String> existNames = new HashSet<String>();
        for (DynamicObject doj : query) {
            existNames.add(doj.getString("name"));
        }
        Member versionMember = modelCache.getMember(SysDimensionEnum.Version.getNumber(), (Long)0L, versionId);
        Member dataTypeMember = modelCache.getMember(SysDimensionEnum.DataType.getNumber(), (Long)0L, dataTypeId);
        Member auditTrailMember = modelCache.getMember(SysDimensionEnum.AuditTrail.getNumber(), (Long)0L, auditTrailId);
        String name = versionMember.getName() + "_" + dataTypeMember.getName() + "_" + auditTrailMember.getName();
        if (existNames.add(name)) {
            return name;
        }
        name = name + "_";
        int index = 1;
        String name2;
        while (!existNames.add(name2 = name + index)) {
            ++index;
        }
        return name2;
    }

    private void putInDoj(Long id, String propertyName, DynamicObject dynamicObject) {
        DynamicObjectCollection periodDojs = dynamicObject.getDynamicObjectCollection(propertyName);
        DynamicObject doj = periodDojs.addNew();
        doj.set("fbasedataid_id", (Object)id);
    }

    private void addPeriodInCase(DynamicObject currCase, Long periodId) {
        DynamicObjectCollection dojs = currCase.getDynamicObjectCollection("period");
        DynamicObject doj = dojs.addNew();
        doj.set("fbasedataid_id", (Object)periodId);
    }

    private boolean hasPeriod(DynamicObject currCase, Long periodId) {
        DynamicObjectCollection dojs = currCase.getDynamicObjectCollection("period");
        for (DynamicObject propertyDoj : dojs) {
            long id = propertyDoj.getLong("fbasedataid_id");
            if (id != periodId) continue;
            return true;
        }
        return false;
    }

    private boolean isAllEquals(Long versionId, Long dataTypeId, Long auditTrailId, Long periodId, IModelCacheHelper modelCache, DynamicObject doj) {
        return this.checkEquals(modelCache, versionId, "version", doj) && this.checkEquals(modelCache, dataTypeId, "datatype", doj) && this.checkEquals(modelCache, auditTrailId, "audittrail", doj);
    }

    private boolean checkEquals(IModelCacheHelper modelCache, Long memberId, String dimNumber, DynamicObject doj) {
        DynamicObjectCollection dojs = doj.getDynamicObjectCollection(dimNumber);
        return dojs.size() <= 1;
    }

    private boolean isContains(Long versionId, Long dataTypeId, Long auditTrailId, Long periodId, IModelCacheHelper modelCache, DynamicObject doj) {
        return this.checkIntersection(modelCache, versionId, "version", doj) && this.checkIntersection(modelCache, dataTypeId, "datatype", doj) && this.checkIntersection(modelCache, auditTrailId, "audittrail", doj) && this.checkIntersectionPeriod(modelCache, periodId, doj);
    }

    private boolean checkIntersectionPeriod(IModelCacheHelper modelCache, Long periodId, DynamicObject doj) {
        DynamicObjectCollection dojs = doj.getDynamicObjectCollection("period");
        for (DynamicObject propertyDoj : dojs) {
            long id = propertyDoj.getLong("fbasedataid_id");
            Member member = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), (Long)0L, id);
            List<Member> allMembers = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), (Long)0L, member.getNumber(), RangeEnum.ALL.getIndex());
            for (Member allMember : allMembers) {
                if (!allMember.getId().equals(periodId)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkIntersection(IModelCacheHelper modelCache, Long memberId, String dimNumber, DynamicObject doj) {
        DynamicObjectCollection dojs = doj.getDynamicObjectCollection(dimNumber);
        for (DynamicObject propertyDoj : dojs) {
            long id = propertyDoj.getLong("fbasedataid_id");
            if (id != memberId) continue;
            return true;
        }
        return false;
    }

    public void unLock(OperationResult operationResult, Long modelId, Long busModelId, Long viewId, Long versionId, Long dataTypeId, Long auditTrailId, String entityNumber, Long periodId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        IDataLockChecker checker = this.getCheckerByBizModel(modelId, busModelId);
        Member versionMember = modelCache.getMember(SysDimensionEnum.Version.getNumber(), null, versionId);
        Member datatypeMember = modelCache.getMember(SysDimensionEnum.DataType.getNumber(), null, dataTypeId);
        Member audittrailMember = modelCache.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, auditTrailId);
        Member periodMember = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, periodId);
        if (checker != null && !checker.isDataLock(new String[]{periodMember.getNumber(), versionMember.getNumber(), datatypeMember.getNumber(), audittrailMember.getNumber(), entityNumber})) {
            return;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", modelId);
        qfBuilder.add("bizmodel", "=", busModelId);
        DynamicObject[] otherCaseDoj = BusinessDataServiceHelper.load((String)"bgmd_datalockcase", (String)"name,period,version,datatype,audittrail,entityview.id,bizmodel.id", (QFilter[])qfBuilder.toArray());
        DynamicObject currCase = null;
        for (DynamicObject doj : otherCaseDoj) {
            if (!this.isContains(versionId, dataTypeId, auditTrailId, periodId, modelCache, doj) || !viewId.equals(doj.getLong("entityview.id"))) continue;
            if (!this.isAllEquals(versionId, dataTypeId, auditTrailId, periodId, modelCache, doj) || !this.hasPeriod(doj, periodId)) {
                operationResult.setShowMessage(true);
                operationResult.setMessage(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u65f6\u89e3\u9501\u6570\u636e\u9501\u5b9a\u5931\u8d25(\u4e0e\u73b0\u6709\u65b9\u6848\u5b58\u5728\u4ea4\u96c6)\uff0c\u8bf7\u901a\u77e5\u7ba1\u7406\u5458\u624b\u52a8\u89e3\u9501\u3002", (String)"DataLockService_4", (String)"epm-eb-common", (Object[])new Object[0]));
                return;
            }
            currCase = doj;
            break;
        }
        if (currCase != null) {
            QFBuilder qfBuilder1 = new QFBuilder();
            qfBuilder1.add("case", "=", currCase.getLong("id"));
            qfBuilder1.add("entity", "=", entityNumber);
            qfBuilder1.add("period", "=", periodMember.getNumber());
            if (QueryServiceHelper.exists((String)"bgmd_datalockcasedetail", (QFilter[])qfBuilder1.toArray())) {
                DeleteServiceHelper.delete((String)"bgmd_datalockcasedetail", (QFilter[])qfBuilder1.toArray());
                DynamicObjectCollection detailList = QueryServiceHelper.query((String)"bgmd_datalockcasedetail", (String)"id,case.id,entity,period", (QFilter[])new QFilter[]{new QFilter("case.id", "in", (Object)currCase.getLong("id"))});
                this.updateCaseLock(currCase, (Collection<DynamicObject>)detailList, modelCache);
            } else {
                operationResult.setShowMessage(true);
                operationResult.setMessage(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u65f6\u89e3\u9501\u6570\u636e\u9501\u5b9a\u5931\u8d25\uff0c\u8bf7\u901a\u77e5\u7ba1\u7406\u5458\u624b\u52a8\u89e3\u9501\u3002", (String)"DataLockService_5", (String)"epm-eb-common", (Object[])new Object[0]));
            }
        }
        DataLockService.getInstance().clearCache(modelId, busModelId);
    }

    public void dropLockRule(Long caseId, Long busModelId, IModelCacheHelper modelCache) {
        List<Long> datasetList = DatasetServiceHelper.getDataSetIdByBusModelIds(Sets.newHashSet((Object[])new Long[]{busModelId}));
        for (Long datasetId : datasetList) {
            String cubeNumber = this.getCubeNumber(datasetId);
            List<String> cubeLockRuleNames = BgmdShrekLockDao.getInstance().getCubeLockRuleNames(modelCache.getModelobj(), cubeNumber);
            String ruleName = String.valueOf(caseId);
            for (String cubeLockRuleName : cubeLockRuleNames) {
                if (!cubeLockRuleName.startsWith(ruleName)) continue;
                BgmdShrekLockDao.getInstance().dropLockRule(modelCache.getModelobj(), cubeNumber, cubeLockRuleName);
            }
        }
        this.clearCache(modelCache.getModelobj().getId(), busModelId);
    }

    public void updateOrCreateLockRule(Long caseId, Map<String, LinkedHashMap<String, Set<String>>> lockScopeMap, Long busModelId, IModelCacheHelper modelCache) {
        List<Long> datasetList = DatasetServiceHelper.getDataSetIdByBusModelIds(Sets.newHashSet((Object[])new Long[]{busModelId}));
        for (Long datasetId : datasetList) {
            String cubeNumber = this.getCubeNumber(datasetId);
            List<String> cubeLockRuleNames = BgmdShrekLockDao.getInstance().getCubeLockRuleNames(modelCache.getModelobj(), cubeNumber);
            for (Map.Entry<String, LinkedHashMap<String, Set<String>>> entry : lockScopeMap.entrySet()) {
                String bp = org.apache.commons.lang3.StringUtils.remove((String)entry.getKey(), (String)".");
                LinkedHashMap<String, Set<String>> lockScope = entry.getValue();
                String ruleName = caseId + "_" + bp;
                if (cubeLockRuleNames.contains(ruleName)) {
                    BgmdShrekLockDao.getInstance().alterLockScope(modelCache.getModelobj(), cubeNumber, ruleName, lockScope);
                    continue;
                }
                BgmdShrekLockDao.getInstance().createLockRule(modelCache.getModelobj(), cubeNumber, ruleName, lockScope);
            }
            this.clearCache(modelCache.getModelobj().getId(), busModelId);
        }
    }

    public void updateLockRuleAsync(String dimNumber, List<Long> dataSetIds, Long modelId) {
        EpmThreadPools.CommPools.execute(() -> {
            if (!org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)dimNumber, (CharSequence[])new CharSequence[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.AuditTrail.getNumber(), SysDimensionEnum.DataType.getNumber()})) {
                return;
            }
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
            if (modelCache.getModelobj().isModelByEB()) {
                return;
            }
            Set bizModelIds = QueryServiceHelper.query((String)"eb_dataset", (String)"businessmodel.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)dataSetIds)}).stream().map(e -> e.getLong("businessmodel.id")).collect(Collectors.toSet());
            Map caseMap = BusinessDataServiceHelper.loadFromCache((String)"bgmd_datalockcase", (String)"id,bizmodel.id,version,audittrail,datatype,entityview.id", (QFilter[])new QFilter[]{new QFilter("model.id", "=", (Object)modelId), new QFilter("bizmodel.id", "in", bizModelIds)});
            Set caseIds = caseMap.values().stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            Map caseDetailMap = BusinessDataServiceHelper.loadFromCache((String)"bgmd_datalockcasedetail", (String)"id,case.id,entity,period", (QFilter[])new QFilter[]{new QFilter("case.id", "in", caseIds)});
            for (DynamicObject caseObj : caseMap.values()) {
                List<DynamicObject> detailList = caseDetailMap.values().stream().filter(e -> caseObj.getLong("id") == e.getLong("case.id")).collect(Collectors.toList());
                this.updateCaseLock(caseObj, detailList, modelCache);
            }
            for (Long bizModelId : bizModelIds) {
                this.clearCache(modelId, bizModelId);
            }
        });
    }

    private void updateCaseLock(DynamicObject caseObj, Collection<DynamicObject> detailList, IModelCacheHelper modelCache) {
        long bizModesId = caseObj.getLong("bizmodel.id");
        if (CollectionUtils.isEmpty(detailList)) {
            this.dropLockRule(caseObj.getLong("id"), bizModesId, modelCache);
            return;
        }
        Set versionSet = caseObj.getDynamicObjectCollection("version").stream().map(e -> e.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toSet());
        Set auditSet = caseObj.getDynamicObjectCollection("audittrail").stream().map(e -> e.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toSet());
        Set dataTypeSet = caseObj.getDynamicObjectCollection("datatype").stream().map(e -> e.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toSet());
        Map<String, Set> bgGroup = detailList.stream().collect(Collectors.toMap(e -> e.getString("period"), e -> Sets.newHashSet((Object[])new String[]{e.getString("entity")}), (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        }));
        HashMap lockScopeMap = Maps.newHashMapWithExpectedSize((int)10);
        bgGroup.forEach((bp, groupSet) -> {
            HashSet bpSet = Sets.newHashSetWithExpectedSize((int)10);
            bpSet.addAll(modelCache.getMemberIncludeCosmic(SysDimensionEnum.BudgetPeriod.getNumber(), null, (String)bp, RangeEnum.ALL.getIndex()).stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
            HashSet entitySet = Sets.newHashSetWithExpectedSize((int)1);
            groupSet.forEach(item -> entitySet.addAll(modelCache.getMemberIncludeCosmic(SysDimensionEnum.Entity.getNumber(), caseObj.getLong("entityview.id"), (String)item, RangeEnum.ALL.getIndex()).stream().map(BaseCache::getNumber).collect(Collectors.toSet())));
            LinkedHashMap lockScope = Maps.newLinkedHashMap();
            lockScope.put(SysDimensionEnum.BudgetPeriod.getNumber(), bpSet);
            lockScope.put(SysDimensionEnum.Version.getNumber(), versionSet);
            lockScope.put(SysDimensionEnum.DataType.getNumber(), dataTypeSet);
            lockScope.put(SysDimensionEnum.AuditTrail.getNumber(), auditSet);
            lockScope.put(SysDimensionEnum.Entity.getNumber(), entitySet);
            lockScopeMap.put(bp, lockScope);
        });
        List<Long> datasetList = DatasetServiceHelper.getDataSetIdByBusModelIds(Sets.newHashSet((Object[])new Long[]{bizModesId}));
        for (Long datasetId : datasetList) {
            String cubeNumber = this.getCubeNumber(datasetId);
            List<String> cubeLockRuleNames = BgmdShrekLockDao.getInstance().getCubeLockRuleNames(modelCache.getModelobj(), cubeNumber);
            for (Map.Entry entry : lockScopeMap.entrySet()) {
                String bp2 = org.apache.commons.lang3.StringUtils.remove((String)((String)entry.getKey()), (String)".");
                LinkedHashMap lockScope = (LinkedHashMap)entry.getValue();
                String ruleName = caseObj.getLong("id") + "_" + bp2;
                if (cubeLockRuleNames.contains(ruleName)) {
                    BgmdShrekLockDao.getInstance().alterLockScope(modelCache.getModelobj(), cubeNumber, ruleName, lockScope);
                    continue;
                }
                BgmdShrekLockDao.getInstance().createLockRule(modelCache.getModelobj(), cubeNumber, ruleName, lockScope);
            }
        }
    }

    public String getCubeNumber(Long dataSetId) {
        Dataset dataSet = DatasetServiceHelper.getInstance().getDataSet(dataSetId);
        return this.getCubeNumber(dataSet);
    }

    public String getCubeNumber(Dataset dataSet) {
        return "CUBE" + dataSet.getNumber() + dataSet.getId();
    }

    static {
        try {
            ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            scheduledExecutor.scheduleAtFixedRate(() -> {
                log.info("\u5b9a\u65f6\u6e05\u7406\u6570\u636e\u9501\u5b9a\u7f13\u5b58");
                caches.cleanUp();
            }, 10L, 30L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            log.warn("\u5b9a\u65f6\u6e05\u7406\u6570\u636e\u9501\u5b9a\u7f13\u5b58\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }
}

