/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache;

import com.google.common.cache.Cache;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import kd.epm.eb.common.cache.GlobalCacheServiceHelper;
import kd.epm.eb.common.cache.ICache;
import kd.epm.eb.common.log.BcmLogFactory;
import kd.epm.eb.common.log.WatchLogger;

public abstract class AbstractCache
implements ICache {
    private final Cache<String, Object> _cache;
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(AbstractCache.class);

    public AbstractCache(Cache<String, Object> cache) {
        Objects.requireNonNull(cache);
        this._cache = cache;
    }

    @Override
    public <T> T getOrLoad(String key, GlobalCacheServiceHelper.ILoader<T> loader) {
        try {
            return (T)this._cache.get((Object)key, loader::load);
        }
        catch (ExecutionException e) {
            log.error(e);
            throw new RuntimeException(String.format("getOrLoad key[%s] fail!", key), e);
        }
    }

    @Override
    public void invalidateStartsWithKey(String key) {
        ArrayList cacheKeylst = new ArrayList();
        this._cache.asMap().keySet().forEach(cacheKey -> {
            if (cacheKey.startsWith(key)) {
                cacheKeylst.add(cacheKey);
            }
        });
        this._cache.invalidateAll(cacheKeylst);
    }

    @Override
    public void invalidateByKey(String key) {
        this._cache.invalidate((Object)key);
    }

    @Override
    public void invalidateAll() {
        this._cache.invalidateAll();
    }

    @Override
    public <T> T getIfPresent(String key) {
        return (T)this._cache.getIfPresent((Object)key);
    }

    @Override
    public void replaceCache(String key, Object v) {
        this._cache.put((Object)key, v);
    }
}

