/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.perm.DimMembPermCacheContext;
import kd.epm.eb.common.cache.impl.perm.MemberPermCacheItem;
import kd.epm.eb.common.cache.impl.perm.MemberRecord;
import kd.epm.eb.common.cache.impl.perm.PermCheckResult;
import kd.epm.eb.common.cache.impl.perm.RowRecord;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.enums.DataPermTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.membPerm.DimMembPermFilterReader;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.DimMemberPermLogChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.permission.pojo.MemberTree;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.pojo.BooleanObj;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.LogSignHelper;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.UserUtils;

public class DimMembPermHelper {
    public static final Set<String> noCheckDimsOnManPerm = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.Period.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.AuditTrail.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.Metric.getNumber(), SysDimensionEnum.ChangeType.getNumber()});
    private static final Log log = LogFactory.getLog(DimMembPermHelper.class);
    private static final String logStr = "model:%s,dimension:%s,bizModel:%s,view:%s,user:%s,permType:%s,timeCost:%s,memberIds:%s,refInfo:%s";

    @Deprecated
    public static Set<Long> getPermMembIds(String dimensionNumber, Long modelId, Long bizCtrlRangeId, DataPermTypeEnum permTypeEnum, boolean needHasPerm) {
        DimMembPermType permType = DimMembPermHelper.switchOldPermType(permTypeEnum);
        return DimMembPermHelper.getPermMemberIds(dimensionNumber, modelId, bizCtrlRangeId, null, permType, needHasPerm);
    }

    @Deprecated
    public static Set<Long> getReadPermMembIds(String dimensionNumber, Long modelId, Long bizCtrlRangeId, boolean needHasPerm) {
        return DimMembPermHelper.getPermMemberIds(dimensionNumber, modelId, bizCtrlRangeId, null, DimMembPermType.READ, needHasPerm);
    }

    public static Set<Long> getReadPermMembIds(String dimensionNumber, Long modelId, Long bizCtrlRangeId, Long viewId, boolean needHasPerm) {
        return DimMembPermHelper.getPermMemberIds(dimensionNumber, modelId, bizCtrlRangeId, viewId, DimMembPermType.READ, needHasPerm);
    }

    @Deprecated
    public static Set<Long> getPermMembIds(String dimensionNumber, Long modelId, Long bizCtrlRangeId, DimMembPermType permType, boolean needHasPerm) {
        return DimMembPermHelper.getPermMemberIds(dimensionNumber, modelId, bizCtrlRangeId, null, permType, needHasPerm);
    }

    public static Set<Long> getPermMembIds(String dimensionNumber, Long modelId, Long bizCtrlRangeId, Long viewId, DimMembPermType permType, boolean needHasPerm) {
        return DimMembPermHelper.getPermMemberIds(dimensionNumber, modelId, bizCtrlRangeId, viewId, permType, needHasPerm);
    }

    @Deprecated
    public static Set<String> getPermMembNumbers(String dimensionNumber, Long modelId, Long bizCtrlRangeId, DimMembPermType permTypeEnum, boolean needHasPerm) {
        return DimMembPermHelper.getPermMembNumbers(UserUtils.getUserId(), dimensionNumber, modelId, bizCtrlRangeId, null, permTypeEnum, needHasPerm);
    }

    public static Set<String> getPermMembNumbers(String dimensionNumber, Long modelId, Long bizCtrlRangeId, Long viewId, DimMembPermType permTypeEnum, boolean needHasPerm) {
        return DimMembPermHelper.getPermMembNumbers(UserUtils.getUserId(), dimensionNumber, modelId, bizCtrlRangeId, viewId, permTypeEnum, needHasPerm);
    }

    @Deprecated
    public static Set<String> getPermMembNumbers(Long userId, String dimensionNumber, Long modelId, Long bizCtrlRangeId, DimMembPermType permTypeEnum, boolean needHasPerm) {
        return DimMembPermHelper.getPermMembNumbers(userId, dimensionNumber, modelId, bizCtrlRangeId, null, permTypeEnum, needHasPerm);
    }

    public static Set<String> getPermMembNumbers(Long userId, String dimensionNumber, Long modelId, Long bizCtrlRangeId, Long viewId, DimMembPermType permTypeEnum, boolean needHasPerm) {
        viewId = DimMembPermUtil.switchViewId(modelId, bizCtrlRangeId, dimensionNumber, viewId);
        Set<Long> membIds = DimMembPermHelper.getPermMemberIds(userId, dimensionNumber, modelId, bizCtrlRangeId, viewId, permTypeEnum, needHasPerm);
        HashSet<String> membNumbers = null;
        if (membIds != null) {
            membNumbers = new HashSet<String>(membIds.size());
            List<Member> members = ModelCacheContext.getOrCreate(modelId).getMembers(viewId, dimensionNumber, true);
            for (Member member : members) {
                if (!membIds.contains(member.getId())) continue;
                membNumbers.add(member.getNumber());
            }
        }
        return membNumbers;
    }

    @Deprecated
    public static Set<Long> getPermMembIds(Long userId, String dimensionNumber, Long modelId, Long bizCtrlRangeId, DataPermTypeEnum permTypeEnum, boolean needHasPerm) {
        DimMembPermType permType = DimMembPermHelper.switchOldPermType(permTypeEnum);
        return DimMembPermHelper.getPermMemberIds(userId, dimensionNumber, modelId, bizCtrlRangeId, null, permType, needHasPerm);
    }

    public static DimMembPermType switchOldPermType(DataPermTypeEnum permTypeEnum) {
        DimMembPermType result = null;
        switch (permTypeEnum) {
            case WRITE: 
            case NOWRITE: {
                result = DimMembPermType.WRITE;
                break;
            }
            case READ: 
            case NOREAD: {
                result = DimMembPermType.READ;
                break;
            }
            case DELETE: 
            case EDIT: 
            case NEW: 
            case NODELETE: 
            case NOEDIT: 
            case NoNEW: {
                result = DimMembPermType.MANAGER;
                break;
            }
            case NOMANAGER: 
            case MANAGER: {
                result = DimMembPermType.GIVE;
                break;
            }
            default: {
                result = DimMembPermType.READ;
            }
        }
        return result;
    }

    private static void selectPermMemb(Set<Long> membIds, Member member, BitSet membPermCacheItem, boolean needHasPerm) {
        boolean hasPerm;
        boolean bl = hasPerm = membPermCacheItem != null && membPermCacheItem.get(member.getGlobalSeq());
        if (hasPerm && needHasPerm || !hasPerm && !needHasPerm) {
            membIds.add(member.getId());
        }
    }

    public static boolean hasManagerPerm(Long membId, String dimNum, Long viewId, Long userId, Long modelId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        Dimension dimension = modelCacheHelper.getDimension(dimNum);
        return DimMembPermHelper.hasManagerPerm(membId, viewId, dimension, userId, modelId);
    }

    private static boolean hasManagerPerm(Long membId, Long viewId, Dimension dimension, Long userId, Long modelId) {
        if (ModelServiceHelper.isUserHasRootPermByModel(userId, modelId)) {
            return true;
        }
        if (dimension == null || noCheckDimsOnManPerm.contains(dimension.getNumber())) {
            return false;
        }
        viewId = DimMembPermUtil.switchViewId(modelId, null, dimension.getNumber(), viewId);
        Member member = dimension.getMember(viewId, membId);
        if (member == null) {
            return false;
        }
        Set<Long> permMemberIds = DimMembPermHelper.getPermMembIds(dimension.getNumber(), modelId, (Long)0L, viewId, DimMembPermType.MANAGER, true);
        return permMemberIds == null || permMemberIds.contains(membId);
    }

    @Deprecated
    public static boolean hasManagerPerm(Long membId, Long dimId, Long userId, Long modelId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        Dimension dimension = modelCacheHelper.getDimension(dimId);
        return DimMembPermHelper.hasManagerPerm(membId, null, dimension, userId, modelId);
    }

    public static boolean hasManagerPerm(Long membId, Long viewId, Long dimId, Long userId, Long modelId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        Dimension dimension = modelCacheHelper.getDimension(dimId);
        return DimMembPermHelper.hasManagerPerm(membId, viewId, dimension, userId, modelId);
    }

    public static Map<String, Set<String>> getAllDataPermInfoOfEB(Long modelId, String dimNum, long userId) {
        HashSet readPermNumbers = new HashSet();
        HashSet noPermNumbers = new HashSet();
        HashSet readwritePermNumbers = new HashSet();
        boolean isModelManager = ModelServiceHelper.isUserHasRootPermByModel(userId, modelId);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        if (isModelManager || !DimMembPermUtil.needCheckDataPerm(dimNum, modelId)) {
            List<Member> members = modelCacheHelper.getMembers(0L, dimNum);
            members.forEach(mem -> readwritePermNumbers.add(mem.getNumber()));
        } else {
            MemberPermCacheItem cacheItem = DimMembPermCacheContext.getOrCreateSingleDimPerm(modelId, 0L, dimNum, userId, UserUtils.getAllRefUserGroupIds(userId), true);
            Member rootMember = modelCacheHelper.getMember(dimNum, null, dimNum);
            if (rootMember != null) {
                BitSet singleDimWritePermInfo = cacheItem.getSingleDimWritePermInfo();
                BitSet singleDimReadPermInfo = cacheItem.getSingleDimReadPermInfo();
                rootMember.iterate(member -> {
                    if (singleDimWritePermInfo != null && singleDimWritePermInfo.get(member.getGlobalSeq())) {
                        readwritePermNumbers.add(member.getNumber());
                    } else if (singleDimReadPermInfo != null && singleDimReadPermInfo.get(member.getGlobalSeq())) {
                        readPermNumbers.add(member.getNumber());
                    } else {
                        noPermNumbers.add(member.getNumber());
                    }
                });
            }
        }
        HashMap<String, Set<String>> allPermInfo = new HashMap<String, Set<String>>();
        allPermInfo.put("read", readPermNumbers);
        allPermInfo.put("write", readwritePermNumbers);
        allPermInfo.put("noperm", noPermNumbers);
        return allPermInfo;
    }

    public static boolean ifUserHasRootPermByModel(Long userId, Long modelId) {
        if (System.getProperty("isGalaxySystem") != null && System.getProperty("isGalaxySystem").equalsIgnoreCase("true")) {
            return false;
        }
        Set<Long> groupIds = DimMembPermHelper.queryAllGroupByUserId(userId);
        groupIds.add(userId);
        QFilter filter1 = new QFilter("model", "=", (Object)modelId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"MemberPermHelper.ifUserHasRootPermByModel", (String)"epm_modelperm", (String)"id,modelpermentry.eusers.id", (QFilter[])new QFilter[]{filter1}, null);){
            for (Row row : ds) {
                if (!groupIds.contains(row.getLong("modelpermentry.eusers.id"))) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static Set<Long> queryAllGroupByUserId(long userId) {
        if (ThreadCache.exists((Object)"usergroup")) {
            return (Set)ThreadCache.get((Object)"usergroup");
        }
        HashSet<Long> usergroupIdList = new HashSet<Long>();
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)DimMembPermHelper.class.getName(), (String)"bos_usergroupstaff", (String)"usergroup", (QFilter[])new QFilter[]{userFilter}, null);){
            for (Row row : ds) {
                usergroupIdList.add(row.getLong("usergroup"));
            }
        }
        ThreadCache.put((Object)"usergroup", usergroupIdList);
        return usergroupIdList;
    }

    public static Set<String> getRefDimGroupNums(Long modelId, String dimNum) {
        HashSet<String> refDimNums = new HashSet<String>(16);
        List<PermDimGroup> permControlDimGroup = DimMembPermUtil.getPermControlDimGroup(modelId);
        for (PermDimGroup permDimGroup : permControlDimGroup) {
            for (BasedataPojo pojo : permDimGroup.getDimGroup()) {
                if (!pojo.getNumber().equals(dimNum)) continue;
                permDimGroup.getDimGroup().forEach(dimObj -> refDimNums.add(dimObj.getNumber()));
            }
        }
        refDimNums.remove(dimNum);
        return refDimNums;
    }

    @Deprecated
    public static Set<Long> getPermMembIdsByGroup(String dimensionNumber, Long modelId, Long busModelId, Map<String, Set<Long>> refDimMembers, DimMembPermType permTypeEnum) {
        return DimMembPermHelper.getPermMembIdsByGroup(null, dimensionNumber, null, modelId, busModelId, null, refDimMembers, permTypeEnum);
    }

    public static Set<Long> getPermMembIdsByGroup(String dimensionNumber, Long modelId, Long busModelId, Long viewId, Map<String, Set<Long>> refDimMembers, DimMembPermType permTypeEnum) {
        return DimMembPermHelper.getPermMembIdsByGroup(null, dimensionNumber, null, modelId, busModelId, viewId, refDimMembers, permTypeEnum);
    }

    public static Set<Long> getPermMembIdsByGroup(Long userId, String dimensionNumber, List<String> targetGroupDimNums, Long modelId, Long busModelId, Long viewId, Map<String, Set<Long>> refDimMembers, DimMembPermType permTypeEnum) {
        if (userId == null) {
            userId = UserUtils.getUserId();
        }
        viewId = DimMembPermUtil.switchViewId(modelId, busModelId, dimensionNumber, viewId);
        Set<Long> memberIds = null;
        boolean matchAllDim = targetGroupDimNums != null;
        long beginTime = System.currentTimeMillis();
        if (!matchAllDim && (refDimMembers == null || refDimMembers.isEmpty())) {
            memberIds = DimMembPermHelper.getPermMemberIds(userId, dimensionNumber, modelId, busModelId, viewId, permTypeEnum, true);
        } else {
            DimMembPermFilterReader permReader = new DimMembPermFilterReader(targetGroupDimNums, dimensionNumber, viewId);
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
            permReader.setMatchAllDim(matchAllDim);
            permReader.init(modelCacheHelper, busModelId, userId, Collections.singletonList(permTypeEnum), matchAllDim ? targetGroupDimNums : Collections.singletonList(dimensionNumber));
            if (!permReader.hasAllPerm()) {
                memberIds = permReader.readPerm(refDimMembers);
            }
        }
        long endTime = System.currentTimeMillis();
        if (LogSignHelper.needLog("DimMembPermHelper", "getPermMembIdsByGroup")) {
            CommonServiceHelper.handleLog(log, "PermMembIdsByGroup", String.format(logStr, modelId, dimensionNumber, busModelId, viewId, userId, permTypeEnum.name(), endTime - beginTime, memberIds == null ? "null" : memberIds.toString(), refDimMembers == null ? "null" : refDimMembers.toString()));
        }
        return memberIds;
    }

    public static Set<Long> getPermMemberIds(String dimensionNumber, Long modelId, Long bizCtrlRangeId, Long viewId, DimMembPermType permTypeEnum, boolean needHasPerm) {
        return DimMembPermHelper.getPermMemberIds(UserUtils.getUserId(), dimensionNumber, modelId, bizCtrlRangeId, viewId, permTypeEnum, needHasPerm);
    }

    public static Set<Long> getPermMemberIds(Long userId, String dimensionNumber, Long modelId, Long bizCtrlRangeId, Long viewId, DimMembPermType permTypeEnum, boolean needHasPerm) {
        long beginTime = System.currentTimeMillis();
        viewId = DimMembPermUtil.switchViewId(modelId, bizCtrlRangeId, dimensionNumber, viewId);
        Set<Long> memberIds = DimMembPermHelper.getAllPermMemberIds(userId, dimensionNumber, modelId, bizCtrlRangeId, viewId, permTypeEnum, false, needHasPerm);
        long endTime = System.currentTimeMillis();
        if (LogSignHelper.needLog("DimMembPermHelper", "getPermMemberIds")) {
            CommonServiceHelper.handleLog(log, "PermMemberIds", String.format(logStr, modelId, dimensionNumber, bizCtrlRangeId, viewId, userId, permTypeEnum.name(), endTime - beginTime, memberIds == null ? "null" : memberIds.toString(), ""));
        }
        return memberIds;
    }

    private static Set<Long> getAllPermMemberIds(Long userId, String dimensionNumber, Long modelId, Long bizCtrlRangeId, Long viewId, DimMembPermType permTypeEnum, boolean matchAllDim, boolean needHasPerm) {
        if (permTypeEnum == DimMembPermType.READ || permTypeEnum == DimMembPermType.WRITE) {
            if (DimMembPermUtil.needCheckDataPerm(dimensionNumber, modelId) && !ModelServiceHelper.isUserHasRootPermByModel(userId, modelId)) {
                bizCtrlRangeId = DimMembPermUtil.switchBizModelId(bizCtrlRangeId, dimensionNumber, modelId);
                List<Long> allRefUserGroupIds = UserUtils.getAllRefUserGroupIds(userId);
                MemberPermCacheItem memberPermCacheItem = DimMembPermCacheContext.getOrCreateSingleDimPerm(modelId, bizCtrlRangeId, dimensionNumber, userId, allRefUserGroupIds, true);
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
                Dimension dimension = modelCacheHelper.getDimension(dimensionNumber);
                HashSet<Long> membIds = new HashSet<Long>(dimension.getMemberSize());
                BitSet permInfo = permTypeEnum == DimMembPermType.READ ? memberPermCacheItem.getSingleDimReadPermInfo() : memberPermCacheItem.getSingleDimWritePermInfo();
                Member rootMember = modelCacheHelper.getRootMember(dimensionNumber, viewId);
                if (rootMember != null) {
                    if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
                        List<Member> children = rootMember.getChildren();
                        if (children != null && children.size() > 0) {
                            List<Long> dataSetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(bizCtrlRangeId);
                            HashSet<Long> refDatasetIds = bizCtrlRangeId == null || bizCtrlRangeId.equals(0L) ? null : new HashSet<Long>(dataSetIds);
                            children.forEach(childMemb -> {
                                if (refDatasetIds == null || refDatasetIds.contains(childMemb.getDatasetId())) {
                                    childMemb.iterate(memb -> DimMembPermHelper.selectPermMemb(membIds, memb, permInfo, needHasPerm));
                                }
                            });
                        }
                        DimMembPermHelper.selectPermMemb(membIds, rootMember, permInfo, needHasPerm);
                    } else {
                        rootMember.iterate(memb -> DimMembPermHelper.selectPermMemb(membIds, memb, permInfo, needHasPerm));
                    }
                }
                return membIds;
            }
        } else if (!ModelServiceHelper.isUserHasRootPermByModel(userId, modelId)) {
            HashSet<Long> result = new HashSet<Long>(16);
            if (permTypeEnum == DimMembPermType.MANAGER) {
                bizCtrlRangeId = 0L;
                if (noCheckDimsOnManPerm.contains(dimensionNumber)) {
                    IModelCacheHelper modelCacheHelper;
                    Member rootMemb;
                    if (!needHasPerm && (rootMemb = (modelCacheHelper = ModelCacheContext.getOrCreate(modelId)).getMember(dimensionNumber, viewId, dimensionNumber)) != null) {
                        rootMemb.iterate(memb -> result.add(rootMemb.getId()));
                    }
                } else {
                    Member rootMember;
                    Map<Long, List<RowRecord>> usersPermRecords = MembPermRecordUtil.getUserPermRowRecords(modelId, bizCtrlRangeId, Collections.singletonList(dimensionNumber), UserUtils.getAllRefUserGroupIds(userId), PermGroupEnum.MANAGER, false, false, true);
                    IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
                    Dimension dimension = modelCacheHelper.getDimension(dimensionNumber);
                    HashSet permMemberIds = new HashSet(16);
                    if (usersPermRecords != null) {
                        MemberPropCache propCache = MemberPropCacheService.getOrCreate(modelId);
                        Set<Long> views = DimensionViewServiceHelper.getViewsByViewId(viewId);
                        MemberTree dimTree = new MemberTree(dimension, views);
                        usersPermRecords.values().forEach(userPerms -> userPerms.forEach(rowRecord -> {
                            MemberRecord memberRecord = rowRecord.getMemberRecords().get(0);
                            if (permTypeEnum.hasPerm(rowRecord.getPermVal())) {
                                if (memberRecord.isMember()) {
                                    Member member;
                                    if ((views.size() == 0 || views.contains(memberRecord.getViewId())) && (member = dimension.getMember(memberRecord.getViewId(), memberRecord.getId())) != null) {
                                        member.iterate(child -> permMemberIds.add(child.getId()));
                                    }
                                } else {
                                    Set<String> refMemberNums = propCache.getRefMemberNums(dimension.getDimNum(), memberRecord.getId());
                                    if (refMemberNums != null) {
                                        for (String memberNum : refMemberNums) {
                                            Member member = dimTree.getMember(memberNum);
                                            if (member == null) continue;
                                            member.iterate(child -> permMemberIds.add(child.getId()));
                                        }
                                    }
                                }
                            }
                        }));
                    }
                    if ((rootMember = modelCacheHelper.getRootMember(dimensionNumber, viewId)) != null) {
                        rootMember.iterate(child -> {
                            if (permMemberIds.contains(child.getId()) == needHasPerm) {
                                result.add(child.getId());
                            }
                        });
                    }
                }
            } else if (permTypeEnum == DimMembPermType.GIVE) {
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
                HashSet permMemberIds = new HashSet(16);
                DimMembPermHelper.readMemberPerm(modelId, bizCtrlRangeId, Sets.newHashSet((Object[])new String[]{dimensionNumber}), userId, Collections.singletonList(permTypeEnum), false, matchAllDim, null, permCheckResult -> {
                    Map<String, MemberItem> memberGroup = permCheckResult.getMemberGroup();
                    MemberItem memberItem = memberGroup.get(dimensionNumber);
                    if (memberItem != null) {
                        permMemberIds.add(memberItem.getMemberId());
                    }
                });
                Member rootMember = modelCacheHelper.getRootMember(dimensionNumber, viewId);
                if (rootMember != null) {
                    rootMember.iterate(child -> {
                        if (permMemberIds.contains(child.getId()) == needHasPerm) {
                            result.add(child.getId());
                        }
                    });
                }
            }
            return result;
        }
        return null;
    }

    public static void readMemberPermBat(Long modelId, Long bizModelId, List<List<String>> dimGroups, List<Long> userIds, List<DimMembPermType> permTypes, Map<String, Map<String, Set<Long>>> memberFilters, Consumer<PermCheckResult> permInfoConsumer) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        Map<Long, Set<Long>> allRefUserInfo = UserUtils.getAllRefUserInfo(userIds, false);
        Set<Long> allManager = ModelServiceHelper.getManagersByModel(modelId, true, true);
        HashSet<Long> allRefUserGroupIds = new HashSet<Long>(16);
        allRefUserInfo.values().forEach(allRefUserGroupIds::addAll);
        PermGroupEnum permGroup = permTypes.get(0).getPermGroup();
        boolean hasNotDataPerm = DimMembPermUtil.hasNotDataPermType(permTypes);
        Map<String, Set<Long>> memberFilterIds = null;
        boolean splitPermByGroup = permGroup == PermGroupEnum.MANAGER && !modelCacheHelper.getModelobj().isModelByEB();
        for (List<String> dimNums : dimGroups) {
            boolean _splitPermByGroup;
            boolean loadRowRefInfo = dimNums.size() == 1;
            memberFilterIds = memberFilters == null ? null : memberFilters.get(DimMembPermUtil.getDimShortNumsStr(modelCacheHelper, dimNums, false));
            boolean bl = _splitPermByGroup = splitPermByGroup && SysDimensionEnum.dimHasView(dimNums.get(0));
            if (_splitPermByGroup) {
                DimMembPermHelper.readMemberManagerPermBat(bizModelId, allManager, allRefUserGroupIds, userIds, permTypes, memberFilterIds, modelCacheHelper, dimNums, permGroup, loadRowRefInfo, hasNotDataPerm, allRefUserInfo, permInfoConsumer);
                continue;
            }
            DimMembPermHelper.readMemberPermBat(bizModelId, allManager, allRefUserGroupIds, userIds, permTypes, memberFilterIds, modelCacheHelper, dimNums, permGroup, loadRowRefInfo, hasNotDataPerm, allRefUserInfo, permInfoConsumer);
        }
    }

    public static void readMemberPermBat(Long bizModelId, Set<Long> allManager, Set<Long> allRefUserGroupIds, List<Long> userIds, List<DimMembPermType> permTypes, Map<String, Set<Long>> memberFilterIds, IModelCacheHelper modelCacheHelper, List<String> dimNums, PermGroupEnum permGroup, boolean loadRowRefInfo, boolean hasNotDataPerm, Map<Long, Set<Long>> allRefUserInfo, Consumer<PermCheckResult> permInfoConsumer) {
        Map<String, Map<Long, List<RowRecord>>> allUserGroupPermRecord = MembPermRecordUtil.getUsersPermRowRecords(modelCacheHelper, bizModelId, dimNums, allRefUserGroupIds, permGroup, false, loadRowRefInfo, hasNotDataPerm);
        int count = 0;
        int endIndex = userIds.size();
        HashSet<Long> userIdList = new HashSet<Long>(16);
        HashSet<Long> toSearchUIds = new HashSet<Long>(16);
        Long modelId = modelCacheHelper.getModelobj().getId();
        for (Long userId : userIds) {
            ++count;
            if (!allManager.contains(userId)) {
                userIdList.add(userId);
                if (!allRefUserGroupIds.contains(userId)) {
                    toSearchUIds.add(userId);
                }
            }
            if (userIdList.size() <= 100 && count != endIndex) continue;
            Map<String, Map<Long, List<RowRecord>>> allUserPermRecord = MembPermRecordUtil.getUsersPermRowRecords(modelCacheHelper, bizModelId, dimNums, toSearchUIds, permGroup, false, loadRowRefInfo, hasNotDataPerm);
            for (Long uId : userIdList) {
                Set<Long> refGroupIds = allRefUserInfo.get(uId);
                if (refGroupIds != null) {
                    for (Long groupId : refGroupIds) {
                        MembPermRecordUtil.mergeRecordOnUser(allUserGroupPermRecord, allUserPermRecord, groupId);
                    }
                }
                if (!toSearchUIds.contains(uId)) {
                    MembPermRecordUtil.mergeRecordOnUser(allUserGroupPermRecord, allUserPermRecord, uId);
                }
                DimMembPermHelper.readMemberPerm(modelId, bizModelId, new HashSet<String>(dimNums), null, uId, permTypes, true, true, allUserPermRecord, memberFilterIds, permInfoConsumer);
            }
            toSearchUIds.clear();
            userIdList.clear();
        }
    }

    public static void readMemberManagerPermBat(Long bizModelId, Set<Long> allManager, Set<Long> allRefUserGroupIds, List<Long> userIds, List<DimMembPermType> permTypes, Map<String, Set<Long>> memberFilterIds, IModelCacheHelper modelCacheHelper, List<String> dimNums, PermGroupEnum permGroup, boolean loadRowRefInfo, boolean hasNotDataPerm, Map<Long, Set<Long>> allRefUserInfo, Consumer<PermCheckResult> permInfoConsumer) {
        Long modelId = modelCacheHelper.getModelobj().getId();
        Map<Long, Set<Long>> allRefViewIds = DimMembPermUtil.getAllViewAndGroupFromCache(modelId, modelCacheHelper.getDimension(dimNums.get(0)).getId());
        if (allRefViewIds.isEmpty()) {
            DimMembPermHelper.readMemberPermBat(bizModelId, allManager, allRefUserGroupIds, userIds, permTypes, memberFilterIds, modelCacheHelper, dimNums, permGroup, loadRowRefInfo, hasNotDataPerm, allRefUserInfo, permInfoConsumer);
        } else {
            Map<String, Map<Long, Map<Long, List<RowRecord>>>> allUserGroupPermRecord = MembPermRecordUtil.getUsersManagerPermRowRecords(modelCacheHelper, bizModelId, dimNums, allRefUserGroupIds, permGroup, dimNums.size() == 1, loadRowRefInfo, hasNotDataPerm);
            int count = 0;
            int endIndex = userIds.size();
            HashSet<Long> userIdList = new HashSet<Long>(16);
            HashSet<Long> toSearchUIds = new HashSet<Long>(16);
            for (Long userId : userIds) {
                ++count;
                if (!allManager.contains(userId)) {
                    userIdList.add(userId);
                    if (!allRefUserGroupIds.contains(userId)) {
                        toSearchUIds.add(userId);
                    }
                }
                if (userIdList.size() <= 100 && count != endIndex) continue;
                Map<String, Map<Long, Map<Long, List<RowRecord>>>> allUserPermRecord = MembPermRecordUtil.getUsersManagerPermRowRecords(modelCacheHelper, bizModelId, dimNums, toSearchUIds, permGroup, dimNums.size() == 1, loadRowRefInfo, hasNotDataPerm);
                for (Long uId : userIdList) {
                    Set<Long> refGroupIds = allRefUserInfo.get(uId);
                    allRefViewIds.forEach((viewGroupId, refViewIds) -> {
                        HashMap<String, Map<Long, List<RowRecord>>> _allUserPermRecord = new HashMap<String, Map<Long, List<RowRecord>>>(16);
                        if (refGroupIds != null) {
                            for (Long groupId : refGroupIds) {
                                MembPermRecordUtil.mergeRecordOnUser(allUserGroupPermRecord, viewGroupId, _allUserPermRecord, groupId);
                            }
                        }
                        if (!toSearchUIds.contains(uId)) {
                            MembPermRecordUtil.mergeRecordOnUser(allUserGroupPermRecord, viewGroupId, _allUserPermRecord, uId);
                        } else {
                            MembPermRecordUtil.mergeRecordOnUser(allUserPermRecord, viewGroupId, _allUserPermRecord, uId);
                        }
                        if (_allUserPermRecord.size() > 0) {
                            HashSet _refViewIds = new HashSet(16);
                            BooleanObj hasProp = new BooleanObj();
                            _allUserPermRecord.values().forEach(allUPerm -> allUPerm.values().forEach(allRecord -> allRecord.forEach(row -> {
                                MemberRecord memberRecord = row.getMemberRecords().get(0);
                                if (memberRecord.isMember()) {
                                    _refViewIds.add(memberRecord.getViewId());
                                } else {
                                    hasProp.mark(true);
                                }
                            })));
                            if (!hasProp.marked()) {
                                refViewIds = _refViewIds;
                            }
                            HashMap<String, Set<Long>> allViewIds = new HashMap<String, Set<Long>>(1);
                            allViewIds.put((String)dimNums.get(0), (Set<Long>)refViewIds);
                            DimMembPermHelper.readMemberPerm(modelId, bizModelId, new HashSet<String>(dimNums), allViewIds, uId, permTypes, true, true, _allUserPermRecord, memberFilterIds, permInfoConsumer);
                        }
                    });
                }
                toSearchUIds.clear();
                userIdList.clear();
            }
        }
    }

    public static boolean readMemberPerm(Long modelId, Long bizModelId, Set<String> dimNums, Long userId, List<DimMembPermType> permTypes, boolean readAllRefUGroup, boolean matchALlDim, Map<String, Map<Long, List<RowRecord>>> allRowRecords, Consumer<PermCheckResult> permInfoConsumer) {
        return DimMembPermHelper.readMemberPerm(modelId, bizModelId, dimNums, null, userId, permTypes, readAllRefUGroup, matchALlDim, allRowRecords, null, permInfoConsumer);
    }

    public static boolean readMemberPerm(Long modelId, Long bizModelId, Set<String> dimNums, Map<String, Set<Long>> allViewIds, Long userId, List<DimMembPermType> permTypes, boolean readAllRefUGroup, boolean matchALlDim, Map<String, Map<Long, List<RowRecord>>> allRowRecords, Map<String, Set<Long>> filterMembers, Consumer<PermCheckResult> permInfoConsumer) {
        if (ModelServiceHelper.isUserHasRootPermByModel(userId, modelId) || dimNums.size() == 0) {
            return true;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate(modelId);
        List<String> dimNumbers = modelCacheHelper.getDimensionList().stream().map(BaseCache::getNumber).filter(dimNums::contains).collect(Collectors.toList());
        if (allRowRecords == null) {
            List<Long> refUserIds = UserUtils.getAllRefUserGroupIds(userId);
            allRowRecords = MembPermRecordUtil.getUsersPermRowRecords(modelCacheHelper, bizModelId, dimNumbers, refUserIds, permTypes.get(0).getPermGroup(), !matchALlDim && dimNumbers.size() == 1, false, false);
        }
        String dimShortNumsStr = DimMembPermUtil.getDimShortNumsStr(modelCacheHelper, dimNumbers, false);
        if (dimNumbers.size() > 1) {
            Map<Long, List<RowRecord>> allRowRecord = allRowRecords.get(dimShortNumsStr);
            List<MemberTree> dimTrees = DimMembPermUtil.getDimViews(dimNumbers, allViewIds, modelCacheHelper, bizModelId);
            DimMembPermUtil.parsePermRecord(dimShortNumsStr, allRowRecord, dimTrees, memberPropCache, permTypes, readAllRefUGroup, filterMembers, permInfoConsumer);
        } else if (allRowRecords.size() > 0) {
            allRowRecords.forEach((dimShortStr, userPermRecords) -> {
                List<String> dNumbers = DimMembPermUtil.getDimNumsByShortStr(dimShortStr, modelCacheHelper);
                List<MemberTree> dimTrees = DimMembPermUtil.getDimViews(dNumbers, allViewIds, modelCacheHelper, bizModelId);
                DimMembPermUtil.parsePermRecord(dimShortStr, userPermRecords, dimTrees, memberPropCache, permTypes, readAllRefUGroup, filterMembers, permInfoConsumer);
            });
        }
        return false;
    }

    public static boolean readMemberPerm(Long modelId, Long bizModelId, Set<String> dimNums, Long userId, List<DimMembPermType> permTypes, Map<String, Map<Long, List<RowRecord>>> allRowRecords, Consumer<PermCheckResult> permInfoConsumer) {
        return DimMembPermHelper.readMemberPerm(modelId, bizModelId, dimNums, userId, permTypes, false, false, allRowRecords, permInfoConsumer);
    }

    public static DimMemberPermChecker getPermChecker(Long modelId, Long datasetId, Long userId, DimMembPermType permType) {
        if (userId == null) {
            userId = UserUtils.getUserId();
        }
        DimMemberPermChecker instance = DimMembPermHelper.getPermCheckerInstance();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        Long bizModelId = modelCacheHelper.getBusModelByDataSet(datasetId);
        List<Dimension> dimensions = modelCacheHelper.getDimensionList(datasetId);
        ArrayList<String> dimNums = new ArrayList<String>(16);
        if (dimensions != null) {
            dimensions.forEach(f -> dimNums.add(f.getNumber()));
        }
        instance.init(modelCacheHelper, bizModelId, userId, Collections.singletonList(permType), dimNums);
        return instance;
    }

    private static DimMemberPermChecker getPermCheckerInstance() {
        if (LogSignHelper.needLog("DimMemberPermChecker", "permCheck")) {
            return new DimMemberPermLogChecker();
        }
        return new DimMemberPermChecker();
    }

    public static DimMemberPermChecker getWritePermChecker(Long modelId, Long datasetId) {
        return DimMembPermHelper.getPermChecker(modelId, datasetId, null, DimMembPermType.WRITE);
    }

    public static DimMemberPermChecker getReadPermChecker(Long modelId, Long datasetId) {
        return DimMembPermHelper.getPermChecker(modelId, datasetId, null, DimMembPermType.READ);
    }

    public static DimMemberPermChecker getPermChecker(Long modelId, Long bizModelId, List<String> dimNums, Long userId, DimMembPermType permType) {
        return DimMembPermHelper.getPermChecker(modelId, bizModelId, dimNums, false, userId, permType);
    }

    public static DimMemberPermChecker getPermChecker(Long modelId, Long bizModelId, List<String> dimNums, boolean matchAllDim, Long userId, DimMembPermType permType) {
        if (userId == null) {
            userId = UserUtils.getUserId();
        }
        DimMemberPermChecker instance = DimMembPermHelper.getPermCheckerInstance();
        instance.setMatchAllDim(matchAllDim);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        instance.init(modelCacheHelper, bizModelId, userId, Collections.singletonList(permType), dimNums);
        return instance;
    }

    public static List<PermDimGroup> getPermDimGroupWithData(Long modelId, Long dataSetId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        Long bizModelId = modelCacheHelper.getBusModelByDataSet(dataSetId);
        List<PermDimGroup> permControlDimGroup = DimMembPermUtil.getPermControlDimGroup(modelId, bizModelId);
        if (permControlDimGroup.size() > 0) {
            Long userId = UserUtils.getUserId();
            Set<String> dimShortNumStrWithData = MembPermRecordUtil.getDimShortNumStrWithData(modelId, bizModelId, null, userId, PermGroupEnum.DATA);
            permControlDimGroup.removeIf(group -> !dimShortNumStrWithData.contains(group.getDimShortNumStr()));
        }
        return permControlDimGroup;
    }
}

