/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.enums.ViewUsageEnum;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;

public class DimMembPermVerHelper {
    private static final Log log = LogFactory.getLog(DimMembPermVerHelper.class);
    private static final String addSql = "insert into t_eb_membpermversion(fid,fuser,fdimshortnums,fmodel,fbizrange,frefdimgroup,faddtime,fversion) values(?,?,?,?,?,?,?,?)";
    private static final String delSql = "delete from t_eb_membpermversion where fid in(%s)";
    private static final Long defaultVersion = 1L;

    public static Map<Long, Long> batGetMemberPermVersion(String dimShortNumStr, Long modelId, Long bizRangeId, Collection<Long> userIds, boolean refDimGroup) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fversion,faddtime,fuser from t_eb_membpermversion where", new Object[0]);
        sqlBuilder.append("fmodel = ?", new Object[]{modelId});
        sqlBuilder.append("and fbizrange = ?", new Object[]{bizRangeId});
        sqlBuilder.append("and fdimshortnums = ?", new Object[]{dimShortNumStr});
        sqlBuilder.append("and frefdimgroup = ?", new Object[]{refDimGroup});
        sqlBuilder.appendIn("and fuser", userIds.toArray());
        HashMap<Long, VersionInfo> versionTime = new HashMap<Long, VersionInfo>();
        LinkedList<Long> toDelIds = new LinkedList<Long>();
        try (DataSet dataSet = DB.queryDataSet((String)"GetMemberPermVersion", (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                Long id = row.getLong("fid");
                Long version = row.getLong("fversion");
                Long addTime = row.getLong("faddtime");
                Long userId2 = row.getLong("fuser");
                VersionInfo versionInfo = (VersionInfo)versionTime.get(userId2);
                if (versionInfo != null) {
                    if (version.compareTo(versionInfo.addTime) > 0) {
                        toDelIds.add(versionInfo.id);
                        versionInfo.addTime = addTime;
                        versionInfo.version = version;
                        versionInfo.id = id;
                        continue;
                    }
                    toDelIds.add(id);
                    continue;
                }
                versionTime.put(userId2, new VersionInfo(version, addTime, id));
            }
        }
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        versionTime.forEach((userId, userInfo) -> result.put((Long)userId, userInfo.version));
        if (result.size() < userIds.size()) {
            LinkedList<Long> toAddUserIds = new LinkedList<Long>();
            for (Long userId3 : userIds) {
                if (result.containsKey(userId3)) continue;
                toAddUserIds.add(userId3);
                result.put(userId3, defaultVersion);
            }
            DimMembPermVerHelper.addPermVersion(dimShortNumStr, modelId, bizRangeId, toAddUserIds, refDimGroup);
        }
        DimMembPermVerHelper.delPermVersion(toDelIds);
        return result;
    }

    private static void addPermVersion(String dimShortNumStr, Long modelId, Long bizRangeId, List<Long> toAddUserIds, boolean refDimGroup) {
        if (toAddUserIds.isEmpty()) {
            return;
        }
        ArrayList<Object[]> objectInfo = new ArrayList<Object[]>(toAddUserIds.size());
        long[] ids = GlobalIdUtil.genGlobalLongIds(toAddUserIds.size());
        for (int i = 0; i < toAddUserIds.size(); ++i) {
            Object[] obj = new Object[]{ids[i], toAddUserIds.get(i), dimShortNumStr, modelId, bizRangeId, refDimGroup, System.currentTimeMillis(), defaultVersion};
            objectInfo.add(obj);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)addSql, objectInfo);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private static void delPermVersion(Collection<Long> toDelIds) {
        if (toDelIds.isEmpty()) {
            return;
        }
        String sql = String.format(delSql, SqlBatchUtils.getBatchParamsSql(toDelIds.size()));
        DB.execute((DBRoute)BgFormConstant.DBROUTE, (String)sql, (Object[])toDelIds.toArray());
    }

    public static Long getMembPermVersion(String dimShortNumStr, Long modelId, Long bizRangeId, Long userId, boolean refDimGroup) {
        Map<Long, Long> versionMap = DimMembPermVerHelper.batGetMemberPermVersion(dimShortNumStr, modelId, bizRangeId, Collections.singleton(userId), refDimGroup);
        return versionMap.get(userId);
    }

    public static void updateVer4Auth(String dimShortStr, Long bizModelId, Long modelId, Long userId, boolean isUser) {
        QFilter userQfter;
        if (!isUser) {
            Set<Long> userIds = UserUtils.queryAllUserByGroupId(userId);
            userIds.add(userId);
            userQfter = new QFilter("user", "in", userIds);
        } else {
            userQfter = new QFilter("user", "=", (Object)userId);
        }
        LinkedList<String> shortNumsList = new LinkedList<String>();
        DimMembPermVerHelper.selSingleDimShortNumStr(shortNumsList, dimShortStr);
        shortNumsList.add(dimShortStr);
        QFilter dimQfter = new QFilter("dimshortnums", "in", shortNumsList);
        dimQfter.and("bizrange", "=", (Object)bizModelId);
        QFilter qModel = new QFilter("model", "=", (Object)modelId);
        DimMembPermVerHelper.update(new QFilter[]{userQfter, dimQfter, qModel}, "updateVer4Auth");
    }

    public static void selSingleDimShortNumStr(Collection<String> dimShortNumStrs, String dimShortNumStr) {
        if (StringUtils.isNotEmpty(dimShortNumStr)) {
            String[] dimShortNums;
            for (String num : dimShortNums = dimShortNumStr.split("!")) {
                if (!StringUtils.isNotEmpty(num)) continue;
                dimShortNumStrs.add("!" + num + "!");
            }
        }
    }

    public static void updateVer(Long modelId, Set<Long> userIds, Set<String> dimShortNumStr, Set<Long> bizCtrlRangeIds) {
        Set<Long> refUserIds = UserUtils.queryAllUserByGroupId(userIds);
        if (refUserIds.size() > 0) {
            userIds = new HashSet<Long>(userIds);
            userIds.addAll(refUserIds);
        }
        HashSet singleDimShortNumStrs = new HashSet(16);
        dimShortNumStr.forEach(shortNumStr -> DimMembPermVerHelper.selSingleDimShortNumStr(singleDimShortNumStrs, shortNumStr));
        dimShortNumStr.addAll(singleDimShortNumStrs);
        QFilter qFilter = new QFilter("bizrange", "in", bizCtrlRangeIds);
        qFilter.and("dimshortnums", "in", dimShortNumStr);
        qFilter.and("user", "in", userIds);
        qFilter.and("model", "=", (Object)modelId);
        DimMembPermVerHelper.update(new QFilter[]{qFilter}, "updateVer");
    }

    public static void updateVer4MembChanged(Long viewId, Long modelId, Long dimensionId, String logKey) {
        Set<String> refDimShortNums = DimMembPermUtil.getRefDimShortNums(Collections.singleton(dimensionId), modelId);
        if (refDimShortNums.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("dimshortnums", "in", refDimShortNums);
        qFilter.and("model", "=", (Object)modelId);
        if (viewId != null && !viewId.equals(0L)) {
            List<Long> bizModelIds;
            DynamicObject viewObj = BusinessDataServiceHelper.loadSingleFromCache((Object)viewId, (String)"eb_dimensionview", (String)"parent,usage");
            if (viewObj == null) {
                return;
            }
            boolean isAnalysisView = ViewUsageEnum.ANALYSIS.getIndex().equals(viewObj.getString("usage"));
            if (isAnalysisView) {
                viewId = viewObj.getLong("parent.id");
            }
            if ((bizModelIds = BusinessModelServiceHelper.getInstance().getRefBizModelIdsByViewId(viewId, modelId)) != null && !bizModelIds.isEmpty()) {
                qFilter.and("bizrange", "in", bizModelIds);
            } else {
                return;
            }
        }
        DimMembPermVerHelper.update(new QFilter[]{qFilter}, logKey);
    }

    private static void update(QFilter[] qFilters, String logKey) {
        StringBuilder sb = new StringBuilder(logKey).append("->qFilters:");
        for (QFilter qFilter : qFilters) {
            sb.append(qFilter.toString()).append("---");
        }
        DynamicObject[] permVersion = BusinessDataServiceHelper.load((String)"eb_membpermversion", (String)"version", (QFilter[])qFilters);
        if (permVersion != null && permVersion.length > 0) {
            Long versionId = DBServiceHelper.genGlobalLongId();
            for (DynamicObject versionObj : permVersion) {
                versionObj.set("version", (Object)versionId);
                sb.append(versionObj.getLong("id")).append('.');
            }
            SaveServiceHelper.update((DynamicObject[])permVersion);
            sb.append("|version:").append(versionId);
        }
        log.info(sb.toString());
    }

    public static void updateVer4refViewChanged(Long bizCtrlRangeId, Set<Long> changedDimId, Long modelId) {
        if (changedDimId.size() > 0) {
            Set<String> refDimShortNums = DimMembPermUtil.getRefDimShortNums(changedDimId, modelId);
            QFilter qFilter = new QFilter("bizrange", "=", (Object)bizCtrlRangeId);
            qFilter.and("dimshortnums", "in", refDimShortNums);
            qFilter.and("model", "=", (Object)modelId);
            DimMembPermVerHelper.update(new QFilter[]{qFilter}, "updateVer4refViewChanged");
        }
    }

    public static void updateVer4BatDimension(List<Long> dimensionIds, Long modelId, boolean splitRefDimGroup) {
        if (!dimensionIds.isEmpty()) {
            Set<String> refDimShortNums = DimMembPermUtil.getRefDimShortNums(dimensionIds, modelId);
            DimMembPermVerHelper.updateVer4DimShortNums(refDimShortNums, modelId, splitRefDimGroup);
        }
    }

    public static void updateVer4DimShortNums(Set<String> refDimShortNums, Long modelId, boolean splitRefDimGroup) {
        if (!refDimShortNums.isEmpty()) {
            if (splitRefDimGroup) {
                HashSet<String> singleDim = new HashSet<String>(16);
                StringBuilder sb = new StringBuilder();
                int preC = 44;
                for (String dimShortNumStr : refDimShortNums) {
                    for (int n : dimShortNumStr.toCharArray()) {
                        if (n == 33 && preC == 33) {
                            singleDim.add(sb.toString());
                            sb.setLength(0);
                        }
                        sb.append((char)n);
                        preC = n;
                    }
                    if (sb.length() <= 0) continue;
                    singleDim.add(sb.toString());
                }
                refDimShortNums.addAll(singleDim);
            }
            QFilter qFilter = new QFilter("dimshortnums", "in", refDimShortNums);
            QFilter qModel = new QFilter("model", "=", (Object)modelId);
            DimMembPermVerHelper.update(new QFilter[]{qFilter, qModel}, "upateVer4BatDimension");
        }
    }

    private static class VersionInfo {
        Long version;
        Long addTime;
        Long id;

        public VersionInfo(Long version, Long addTime, Long id) {
            this.version = version;
            this.addTime = addTime;
            this.id = id;
        }
    }
}

