/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.cache.ThreadCache;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.cache.ICache;
import kd.epm.eb.common.cache.factory.CacheGenFactory;
import kd.epm.eb.common.enums.CacheTypeEnum;

public class GlobalCacheServiceHelper {
    private static final Map<String, String> coderMap = new ConcurrentHashMap<String, String>();
    private static final AtomicInteger incrementer = new AtomicInteger(0);

    public static String getOrCreateCacheKey() {
        return (String)ThreadCache.get((Object)"cache_node_prefix", () -> DBServiceHelper.genStringId());
    }

    private static String packKey(String prefix, String key) {
        return prefix + "|" + key;
    }

    public static <T> T getOrLoadFromCommonCache(String key, ILoader<T> loader) {
        return CacheGenFactory.getCommonCache().getOrLoad(key, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEncoderKey(String key) {
        if (coderMap.get(key) != null) {
            return coderMap.get(key);
        }
        Map<String, String> map = coderMap;
        synchronized (map) {
            coderMap.put(key, "" + incrementer.getAndIncrement() + "||");
        }
        return coderMap.get(key);
    }

    public static <T> T getOrLoadNode(String key, ILoader<T> loader) {
        return CacheGenFactory.getTemporaryCache().getOrLoad(GlobalCacheServiceHelper.packKey(GlobalCacheServiceHelper.getOrCreateCacheKey(), key.toLowerCase()), loader);
    }

    public static <T> T getOrLoadNodeFixKey(String key, ILoader<T> loader) {
        return CacheGenFactory.getTemporaryCache().getOrLoad(key.toLowerCase(), loader);
    }

    public static <T> T getIfPresent(String key) {
        return CacheGenFactory.getTemporaryCache().getIfPresent(GlobalCacheServiceHelper.packKey(GlobalCacheServiceHelper.getOrCreateCacheKey(), key.toLowerCase()));
    }

    public static void invalidateAllCurrentCache(String processId) {
        CacheGenFactory.getTemporaryCache().invalidateStartsWithKey(processId);
    }

    public static void invalidateCacheByKey(String key) {
        CacheGenFactory.getTemporaryCache().invalidateByKey(key);
    }

    public static <T> T getImmutableTemplateModelOn(String key, ILoader<T> loader) {
        return CacheGenFactory.getTemplateModelReadCache().getOrLoad(key, loader);
    }

    public static void invalidateTemplateModel(String key) {
        CacheGenFactory.getTemplateModelReadCache().invalidateByKey(key);
    }

    public static <T> T getOrLoadAboutDim(String modelNum, String key, ILoader<T> loader) {
        String cacheKey = GlobalCacheServiceHelper.packAboutDimCacheKey(modelNum, key);
        return CacheGenFactory.getDimMemberCacheCache().getOrLoad(cacheKey, loader);
    }

    public static void invalidateAboutDim(String modelNum, String key) {
        String cacheKey = GlobalCacheServiceHelper.packAboutDimCacheKey(modelNum, key);
        CacheGenFactory.getDimMemberCacheCache().invalidateByKey(cacheKey);
    }

    public static void invalidateAllAboutDim(String modelNum, String key) {
        String prefix = GlobalCacheServiceHelper.packAboutDimCacheKey(modelNum, key);
        CacheGenFactory.getDimMemberCacheCache().invalidateStartsWithKey(prefix);
    }

    public static void invalidateAllAboutDimByFixedKey(String key) {
        CacheGenFactory.getDimMemberCacheCache().invalidateStartsWithKey(key);
    }

    private static String packAboutDimCacheKey(String modelNum, String key) {
        return GlobalCacheServiceHelper.getEncoderKey(modelNum) + key;
    }

    public static void invalidateAnyCache(CacheTypeEnum cacheType) {
        if (CacheTypeEnum.DimMemberCache == cacheType) {
            CacheGenFactory.getDimMemberCacheCache().invalidateAll();
        } else if (CacheTypeEnum.TemplateModelReadCache == cacheType) {
            CacheGenFactory.getTemplateModelReadCache().invalidateAll();
        } else if (CacheTypeEnum.CommonCache == cacheType) {
            CacheGenFactory.getCommonCache().invalidateAll();
        } else {
            CacheGenFactory.getDimMemberCacheCache().invalidateAll();
            CacheGenFactory.getTemplateModelReadCache().invalidateAll();
            CacheGenFactory.getCommonCache().invalidateAll();
        }
    }

    public static void replaceCache(CacheTypeEnum cacheType, String cacheKey, Object value) {
        if (CacheTypeEnum.DimMemberCache == cacheType) {
            CacheGenFactory.getDimMemberCacheCache().replaceCache(cacheKey, value);
        } else if (CacheTypeEnum.TemplateModelReadCache == cacheType) {
            CacheGenFactory.getTemplateModelReadCache().replaceCache(cacheKey, value);
        } else if (CacheTypeEnum.CommonCache == cacheType) {
            CacheGenFactory.getCommonCache().replaceCache(cacheKey, value);
        } else {
            CacheGenFactory.getTemporaryCache().replaceCache(cacheKey, value);
        }
    }

    public static ICache getCache(CacheTypeEnum cacheType) {
        if (CacheTypeEnum.DimMemberCache == cacheType) {
            return CacheGenFactory.getDimMemberCacheCache();
        }
        if (CacheTypeEnum.TemplateModelReadCache == cacheType) {
            return CacheGenFactory.getTemplateModelReadCache();
        }
        if (CacheTypeEnum.CommonCache == cacheType) {
            return CacheGenFactory.getCommonCache();
        }
        if (CacheTypeEnum.TemporaryCache == cacheType) {
            return CacheGenFactory.getTemporaryCache();
        }
        throw new RuntimeException(String.format("not support cache type %s", cacheType == null ? "null" : cacheType.toString()));
    }

    public static ICache getCommonCache() {
        return GlobalCacheServiceHelper.getCache(CacheTypeEnum.CommonCache);
    }

    public static ICache getDimMemberCache() {
        return GlobalCacheServiceHelper.getCache(CacheTypeEnum.DimMemberCache);
    }

    public static interface ILoader<T> {
        public T load();
    }
}

