/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IDNumberTreeNode {
    private Long id;
    private String number;
    private IDNumberTreeNode parent;
    private List<IDNumberTreeNode> children;

    public IDNumberTreeNode(Long id, String number) {
        this.id = id;
        this.number = number;
    }

    public void addChild(IDNumberTreeNode id) {
        if (this.children == null) {
            this.children = new ArrayList<IDNumberTreeNode>();
        }
        this.children.add(id);
    }

    public IDNumberTreeNode getParent() {
        return this.parent;
    }

    public void setParent(IDNumberTreeNode parent) {
        this.parent = parent;
    }

    public Long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public List<IDNumberTreeNode> getAllChildren(int childType) {
        ArrayList<IDNumberTreeNode> nodes = new ArrayList<IDNumberTreeNode>();
        if (this.children == null) {
            return nodes;
        }
        for (IDNumberTreeNode node : this.children) {
            switch (childType) {
                case 0: {
                    nodes.add(node);
                    break;
                }
                case 1: {
                    if (node.isLeaf()) break;
                    nodes.add(node);
                    break;
                }
                case 2: {
                    if (!node.isLeaf()) break;
                    nodes.add(node);
                }
            }
            if (node.isLeaf()) continue;
            nodes.addAll(node.getAllChildren(childType));
        }
        return nodes;
    }

    public List<IDNumberTreeNode> getAllChildren() {
        return this.getAllChildren(0);
    }

    public List<IDNumberTreeNode> getBrother() {
        ArrayList<IDNumberTreeNode> ids = new ArrayList<IDNumberTreeNode>();
        if (this.getParent() == null) {
            return ids;
        }
        for (IDNumberTreeNode node : this.getParent().getChildren()) {
            if (node.getId().equals(this.id)) continue;
            ids.add(node);
        }
        return ids;
    }

    public IDNumberTreeNode parent(Object id) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getId().equals(id)) {
            return this.parent;
        }
        return this.parent.parent(id);
    }

    public IDNumberTreeNode closest(Object id) {
        if (this.getId().equals(id)) {
            return this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.closest(id);
    }

    public List<IDNumberTreeNode> getChildren() {
        return this.children == null ? new ArrayList(0) : this.children;
    }

    public Set<Long> getChildrenIds() {
        HashSet<Long> ids = new HashSet<Long>();
        if (this.children != null) {
            for (IDNumberTreeNode node : this.children) {
                ids.add(node.getId());
            }
        }
        return ids;
    }
}

