/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelationCache;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.common.utils.cache.ICache;
import org.jetbrains.annotations.NotNull;

public class ModelCacheContext {
    public static final Log log = LogFactory.getLog(ModelCacheContext.class);
    public static final long MODEL_MAX_SIZE = 16L;
    public static final long MODEL_OVER_TIME = 2L;
    public static final Map<String, Map<Long, Integer>> allDimMemberSeq = new ConcurrentHashMap<String, Map<Long, Integer>>();
    public static volatile LoadingCache<String, Model> models = CacheBuilder.newBuilder().maximumSize(16L).expireAfterAccess(2L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, Model>(){

        @NotNull
        public Model load(@NotNull String modelKey) {
            return ModelCacheContext.initModel(modelKey);
        }
    });
    private static volatile ThreadLocal<Map<String, Model>> current;
    public static final Long DEFAULT_VERSION;

    public static String getAcctId() {
        return Instance.getClusterName() + '.' + RequestContext.get().getAccountId();
    }

    public static String getAcctId(@NotNull Long baseDataId) {
        return String.valueOf(baseDataId) + '.' + Instance.getClusterName() + '.' + RequestContext.get().getAccountId();
    }

    public static Long getBaseDataId(@NotNull String accountId) {
        String[] tmpStr = accountId.split("\\.");
        if (tmpStr.length == 3) {
            return IDUtils.toLong(tmpStr[0]);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u521d\u59cb\u5316\u9519\u8bef\u3002", (String)"ModelCacheContext_0", (String)"epm-eb-common", (Object[])new Object[0]));
    }

    protected static LoadingCache<String, Model> getModels() {
        return models;
    }

    public static ThreadLocal<Map<String, Model>> getCurrent() {
        return current;
    }

    public static void remove() {
        ModelCacheContext.getCurrent().remove();
        DimRelationCache.removeThreadLocal();
    }

    public static IModelCacheHelper getOrCreate(Long modelId) {
        if (modelId == null || modelId == 0L) {
            throw new KDBizException("getOrCreate error.(modelId is null)");
        }
        Map<String, Model> _models = ModelCacheContext.getCurrent().get();
        if (_models == null && (_models = ModelCacheContext.getCurrent().get()) == null) {
            _models = new HashMap<String, Model>();
            ModelCacheContext.getCurrent().set(_models);
        }
        Model model = _models.computeIfAbsent(ModelCacheContext.getAcctId(modelId), f -> ModelCacheContext._getOrCreate(modelId, false));
        return new ModelCacheHelper(model);
    }

    public static synchronized IModelCacheHelper getOrCreate(Long modelId, boolean reBuilder) {
        if (modelId == null || modelId == 0L) {
            throw new KDBizException("getOrCreate error.(modelId is null)");
        }
        if (reBuilder) {
            ModelCacheContext.removeModel(modelId);
            CubeUtils.updateCubeVersion(modelId);
            Map<String, Model> _models = ModelCacheContext.getCurrent().get();
            if (_models == null) {
                _models = new HashMap<String, Model>();
                ModelCacheContext.getCurrent().set(_models);
            }
            _models.put(ModelCacheContext.getAcctId(modelId), ModelCacheContext._getOrCreate(modelId, true));
            return new ModelCacheHelper(_models.get(ModelCacheContext.getAcctId(modelId)));
        }
        return ModelCacheContext.getOrCreate(modelId);
    }

    private static Model _getOrCreate(Long modelId, boolean reBuilder) {
        Model model;
        if (modelId == null || modelId == 0L) {
            throw new KDBizException("getOrCreate error.(modelId is null)");
        }
        if (reBuilder) {
            Model model2 = ModelCacheContext.reBuilderModel(modelId);
            return model2;
        }
        try {
            model = (Model)ModelCacheContext.getModels().get((Object)ModelCacheContext.getAcctId(modelId));
            model.setCheckVersion(true);
        }
        catch (ExecutionException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        Long versionNo = ModelCacheContext.getCubeVersion(modelId);
        if (versionNo.compareTo(model.getVersion()) != 0) {
            model = ModelCacheContext.reBuilderModel(modelId);
        }
        return model;
    }

    private static synchronized Model reBuilderModel(Long modelId) {
        if (modelId == null || modelId == 0L) {
            throw new KDBizException("getOrCreate error.(modelId is null)");
        }
        Model model = ModelCacheContext.initModel(modelId);
        ModelCacheContext.getModels().put((Object)ModelCacheContext.getAcctId(modelId), (Object)model);
        return model;
    }

    private static Model initModel(@NotNull String modelKey) {
        return ModelCacheContext.initModel(IDUtils.toLong(ModelCacheContext.getBaseDataId(modelKey)));
    }

    private static Model initModel(@NotNull Long modelId) {
        Model model = ModelCacheServiceHelper.getInstance().initModel(modelId);
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u521d\u59cb\u5316\u9519\u8bef\u3002", (String)"ModelCacheContext_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        return model;
    }

    public static void removeModel(@NotNull Long modelId) {
        if (IDUtils.isNull(modelId)) {
            return;
        }
        ModelCacheContext.getCurrent().remove();
        ModelCacheContext.getModels().invalidate((Object)ModelCacheContext.getAcctId(modelId));
        ModelCacheContext.getModels().cleanUp();
        log.info("remove-model:" + modelId);
    }

    public static void removeAllModel() {
        ModelCacheContext.getCurrent().remove();
        ModelCacheContext.getModels().invalidateAll();
        ModelCacheContext.getModels().cleanUp();
        log.info("remove-all.");
    }

    public static Long getCubeVersion(@NotNull Long cubeId) {
        String cacheKey;
        if (IDUtils.isNull(cubeId)) {
            return DEFAULT_VERSION;
        }
        Long version = null;
        ICache cache = Cache.get();
        String versionStr = cache.get(cacheKey = CubeUtils.getCacheModelIdKey(cubeId));
        if (StringUtils.isNotEmpty(versionStr)) {
            try {
                version = Long.valueOf(versionStr);
            }
            catch (Throwable ex) {
                log.error("tranToLong-error", ex);
            }
        }
        if (version != null) {
            return version;
        }
        try (DataSet ds = DB.queryDataSet((String)"queryCubeVersion", (DBRoute)BgBaseConstant.epm, (String)"select fversion from t_eb_model where fid = ?", (Object[])new Object[]{cubeId});){
            if (ds != null && ds.hasNext()) {
                version = ds.next().getLong("fversion");
                CubeUtils.updateModelVersionNoByVersion(cubeId, version);
            }
        }
        if (version == null) {
            version = DEFAULT_VERSION;
        }
        return version;
    }

    static {
        try {
            ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            scheduledExecutor.scheduleAtFixedRate(() -> {
                log.info("\u5b9a\u65f6\u6e05\u7406\u4f53\u7cfb\u7f13\u5b58");
                models.cleanUp();
            }, 10L, 30L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            log.warn("\u5b9a\u65f6\u6e05\u7406\u4f53\u7cfb\u7f13\u5b58\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        current = new ThreadLocal();
        DEFAULT_VERSION = 0L;
    }
}

