/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache;

import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class ModelCacheHelper
implements IModelCacheHelper {
    private static final Log log = LogFactory.getLog(ModelCacheHelper.class);
    private Model model;

    public ModelCacheHelper(@NotNull Model model) {
        this.model = model;
        if (this.model.isCheckVersion() && EpmThreadLocalUtils.needDimCheckVersion(model.getId())) {
            this.model.checkDimensionVersion();
        }
    }

    @Override
    public Model getModelobj() {
        return this.model;
    }

    @Override
    public void setModelobj(Model model) {
        this.model = model;
    }

    @Override
    public Dimension getDimension(String dimensionNumber) {
        return this.model.getDimension(dimensionNumber);
    }

    @Override
    public Dimension getDimension(Long dimensionId) {
        return this.model.getDimension(dimensionId);
    }

    @Override
    public Map<Dimension, Collection<Member>> getMembers(Map<String, Collection<String>> dimAndMembers, Map<String, Long> viewIds) {
        return ModelCacheServiceHelper.getMembers(this.model, dimAndMembers, viewIds);
    }

    @Override
    public List<Member> getMembers(String dimensionNumber, Collection<String> memberNumber) {
        return ModelCacheServiceHelper.getMembers(this.model, dimensionNumber, memberNumber);
    }

    @Override
    public List<Member> getMembers(String dimensionNumber, Long viewId, Collection<String> memberNumber) {
        if (viewId != null && viewId != 0L) {
            return ModelCacheServiceHelper.getMembers(this.model, dimensionNumber, viewId, memberNumber);
        }
        return ModelCacheServiceHelper.getMembers(this.model, dimensionNumber, memberNumber);
    }

    @Override
    public List<Member> getMembers(String dimensionNumber, Long viewId, List<Long> memberIds) {
        return ModelCacheServiceHelper.getMembers(this.model, dimensionNumber, viewId, memberIds);
    }

    @Override
    public List<Member> getMembers(Dimension dimension, Collection<String> memberNumber) {
        return ModelCacheServiceHelper.getMembers(dimension, null, memberNumber);
    }

    @Override
    public List<Member> getMembers(Dimension dimension, Long viewId, Collection<String> memberNumber) {
        return ModelCacheServiceHelper.getMembers(dimension, viewId, memberNumber);
    }

    @Override
    public List<Member> getMembersByViews(Dimension dimension, Collection<Long> viewIds, Collection<String> memberNumber) {
        List<Member> members;
        if (dimension == null || memberNumber == null || memberNumber.isEmpty()) {
            return Collections.emptyList();
        }
        if (viewIds != null) {
            LinkedHashSet _members = Sets.newLinkedHashSet();
            for (Long _viewId : viewIds) {
                _members.addAll(this.getMembers(dimension, _viewId, memberNumber));
            }
            members = new ArrayList<Member>(_members);
        } else {
            members = this.getMembers(dimension, null, memberNumber);
        }
        return members;
    }

    @Override
    public List<Member> getMembers(String dimensionNumber) {
        return ModelCacheServiceHelper.getMembers(this.model, dimensionNumber);
    }

    @Override
    public List<Member> getMembers(String dimensionNumber, int level) {
        return ModelCacheServiceHelper.getMembers(this.model, dimensionNumber, level);
    }

    @Override
    public List<Member> getMembers(Long viewId, String dimensionNumber) {
        if (viewId != null && viewId != 0L) {
            return ModelCacheServiceHelper.getMembers(this.model, dimensionNumber, viewId);
        }
        return ModelCacheServiceHelper.getMembers(this.model, dimensionNumber);
    }

    @Override
    public Map<String, Member> getMemberMap(Long viewId, String dimensionNumber) {
        if (viewId != null && viewId != 0L) {
            return ModelCacheServiceHelper.getMemberMap(this.model, dimensionNumber, viewId);
        }
        return ModelCacheServiceHelper.getMemberMap(this.model, dimensionNumber);
    }

    @Override
    public List<Member> getMembers(Long viewId, String dimensionNumber, boolean hasViewMember) {
        return ModelCacheServiceHelper.getMembers(this.model, dimensionNumber, viewId, hasViewMember);
    }

    @Override
    public Member getMember(String dimensionNumber, String memberNumber) {
        return ModelCacheServiceHelper.getMember(this.model, dimensionNumber, memberNumber);
    }

    @Override
    public Member getMemberByAnyView(String dimensionNumber, String memberNumber) {
        return ModelCacheServiceHelper.getMemberByAnyView(this.model, null, dimensionNumber, memberNumber);
    }

    @Override
    public Member getMemberByAnyView(Long busModelId, String dimensionNumber, String memberNumber) {
        return ModelCacheServiceHelper.getMemberByAnyView(this.model, busModelId, dimensionNumber, memberNumber);
    }

    @Override
    public Member getMemberByAnyView(Long busModelId, String dimensionNumber, Long memberId) {
        return ModelCacheServiceHelper.getMemberByAnyView(this.model, busModelId, dimensionNumber, memberId);
    }

    @Override
    public Member getMemberByAnyView(String dimensionNumber, Long memberId) {
        return ModelCacheServiceHelper.getMemberByAnyView(this.model, null, dimensionNumber, memberId);
    }

    @Override
    public Member getMember(String dimensionNumber, Long viewId, String memberNumber) {
        if (viewId != null && viewId != 0L) {
            return ModelCacheServiceHelper.getMember(this.model, dimensionNumber, viewId, memberNumber);
        }
        return ModelCacheServiceHelper.getMember(this.model, dimensionNumber, memberNumber);
    }

    @Override
    public Member getMemberByShowNumber(String dimensionNumber, Long viewId, String memberShowNumber) {
        return ModelCacheServiceHelper.getMemberByShowNumber(this.model, dimensionNumber, viewId, memberShowNumber);
    }

    @Override
    public Member getRootMember(String dimensionNumber, Long viewId) {
        return ModelCacheServiceHelper.getRootMember(this.model, dimensionNumber, viewId);
    }

    @Override
    public Member getMember(String dimensionNumber, Long memberId) {
        return ModelCacheServiceHelper.getMember(this.model, dimensionNumber, memberId);
    }

    @Override
    public Member getMember(String dimensionNumber, Long viewId, Long memberId) {
        if (viewId != null && viewId != 0L) {
            return ModelCacheServiceHelper.getMember(this.model, dimensionNumber, viewId, memberId);
        }
        return ModelCacheServiceHelper.getMember(this.model, dimensionNumber, memberId);
    }

    @Override
    public Member getMemberByVid(String dimensionNumber, Long viewId, Long vId) {
        if (IDUtils.isEmptyLong(viewId).booleanValue()) {
            return null;
        }
        return ModelCacheServiceHelper.getMemberByVid(this.model, dimensionNumber, viewId, vId);
    }

    @Override
    public Map<Long, String> getMemberRate(String dimensionNumber, Long memberId) {
        return ModelCacheServiceHelper.getMemberRate(this.model, dimensionNumber, memberId);
    }

    @Override
    public List<Member> getMember(String dimensionNumber, String memberNumber, int range) {
        return ModelCacheServiceHelper.getMember(this.model, dimensionNumber, memberNumber, range);
    }

    @Override
    public List<Member> getMemberByAnyView(String dimensionNumber, Long busModelId, String memberNumber, int range) {
        return ModelCacheServiceHelper.getMemberByAnyView(this.model, dimensionNumber, busModelId, memberNumber, range);
    }

    @Override
    public List<Member> getMember(String dimensionNumber, Long viewId, String memberNumber, int range) {
        return this.getMember(dimensionNumber, viewId, memberNumber, range, 0);
    }

    @Override
    public List<Member> getMember(String dimensionNumber, Long viewId, Long memberId, int range) {
        if (viewId == null) {
            viewId = 0L;
        }
        return ModelCacheServiceHelper.getMemberById(this.model, this.model.getDimension(dimensionNumber), viewId, memberId, range, 0, false);
    }

    @Override
    public List<Member> getMember(String dimensionNumber, Long viewId, String memberNumber, int range, int rangeLevel) {
        if (viewId == null) {
            viewId = 0L;
        }
        return ModelCacheServiceHelper.getMember(this.model, dimensionNumber, viewId, memberNumber, range, rangeLevel, false);
    }

    @Override
    public Set<String> getMemberNumber(String dimensionNumber, Long viewId) {
        if (StringUtils.isEmpty(dimensionNumber)) {
            return Collections.emptySet();
        }
        Set<String> allMemberNumbers = Collections.emptySet();
        Dimension dimension = this.getModelobj().getDimension(dimensionNumber);
        if (dimension != null) {
            if (IDUtils.isNotNull(viewId)) {
                View view = dimension.getView(viewId);
                if (view != null) {
                    allMemberNumbers = new HashSet<String>(view.getAllMemberMap().keySet());
                }
            } else {
                allMemberNumbers = new HashSet<String>(dimension.getAllMemberMap().keySet());
            }
        }
        return allMemberNumbers;
    }

    @Override
    public List<Member> getChildren(Member member, boolean hasIncludeSelf) {
        return ModelCacheServiceHelper.getChildren(member, hasIncludeSelf);
    }

    @Override
    public List<Member> getMemberSort(String dimensionNumber, String memberNumber, int range) {
        return this.getMemberSort(dimensionNumber, 0L, memberNumber, range);
    }

    @Override
    public List<Member> getMemberSort(String dimensionNumber, Long viewId, String memberNumber, int range) {
        return this.getMemberSort(dimensionNumber, viewId, memberNumber, range, 0);
    }

    @Override
    public List<Member> getMemberSort(String dimensionNumber, Long viewId, String memberNumber, int range, int rangeLevel) {
        if (viewId == null) {
            viewId = 0L;
        }
        return ModelCacheServiceHelper.getMemberSort(this.model, dimensionNumber, viewId, memberNumber, range, rangeLevel, false);
    }

    @Override
    public List<Member> getMembersIncludeCosmic(String dimensionNumber, String memberNumber, int range) {
        return this.getMemberIncludeCosmic(dimensionNumber, 0L, memberNumber, range);
    }

    @Override
    public List<Member> getMemberIncludeCosmic(String dimensionNumber, Long viewId, String memberNumber, int range) {
        return this.getMemberIncludeCosmic(dimensionNumber, viewId, memberNumber, range, 0);
    }

    @Override
    public List<Member> getMemberIncludeCosmic(String dimensionNumber, Long viewId, String memberNumber, int range, int rangeLevel) {
        if (viewId == null) {
            viewId = 0L;
        }
        return ModelCacheServiceHelper.getMember(this.model, dimensionNumber, viewId, memberNumber, range, rangeLevel, true);
    }

    @Override
    public List<Member> getMemberSortIncludeCosmic(String dimensionNumber, String memberNumber, int range) {
        return this.getMemberSortIncludeCosmic(dimensionNumber, 0L, memberNumber, range);
    }

    @Override
    public List<Member> getMemberSortIncludeCosmic(String dimensionNumber, Long viewId, String memberNumber, int range) {
        return this.getMemberSortIncludeCosmic(dimensionNumber, viewId, memberNumber, range, 0);
    }

    @Override
    public List<Member> getMemberSortIncludeCosmic(String dimensionNumber, Long viewId, String memberNumber, int range, int rangeLevel) {
        if (viewId == null) {
            viewId = 0L;
        }
        return ModelCacheServiceHelper.getMemberSort(this.model, dimensionNumber, viewId, memberNumber, range, rangeLevel, true);
    }

    @Override
    public Member getMemberOffset(String dimensionNumber, String memberNumber, int offset) {
        return this.getMemberOffset(dimensionNumber, memberNumber, offset, false);
    }

    @Override
    public Member getMemberOffset(String dimensionNumber, String memberNumber, int offset, boolean sortByNumber) {
        return ModelCacheServiceHelper.getMemberOffset(this.model, dimensionNumber, memberNumber, offset, sortByNumber);
    }

    @Override
    public Member getMemberOffsetByLevel(String dimensionNumber, Long viewId, String memberNumber, int offset, int level) {
        return this.getMemberOffsetByLevel(dimensionNumber, viewId, memberNumber, offset, false, level);
    }

    @Override
    public Member getMemberOffsetByLevel(String dimensionNumber, Long viewId, String memberNumber, int offset, boolean sortByNumber, int level) {
        return ModelCacheServiceHelper.getMemberOffsetByLevel(this.model, dimensionNumber, viewId, memberNumber, offset, sortByNumber, level);
    }

    @Override
    public List<Member> getMemberBetween(String dimensionNumber, String memberNumber1, String memberNumber2, boolean includeSelf) {
        return ModelCacheServiceHelper.getMemberBetween(this.model, dimensionNumber, memberNumber1, memberNumber2, includeSelf);
    }

    @Override
    public List<Member> getAllChildrenSort(Member member, boolean hasIncludeSelf) {
        return ModelCacheServiceHelper.getAllChildrenSort(member, hasIncludeSelf);
    }

    @Override
    public List<Member> getDirect(Member member) {
        return ModelCacheServiceHelper.getDirect(member);
    }

    @Override
    public List<Member> getDirectSort(Member member) {
        return ModelCacheServiceHelper.getDirectSort(member);
    }

    @Override
    public List<Member> getNotDetailChildren(Member member) {
        return ModelCacheServiceHelper.getNotDetailChildren(member);
    }

    @Override
    public List<Member> getNotDetailChildrenSort(Member member) {
        return ModelCacheServiceHelper.getNotDetailChildrenSort(member);
    }

    @Override
    public List<Member> getDetailChildren(Member member) {
        return ModelCacheServiceHelper.getDetailChildren(member);
    }

    @Override
    public List<Member> getDetailChildrenSort(Member member) {
        return ModelCacheServiceHelper.getDetailChildrenSort(member);
    }

    @Override
    public List<Member> getLeaf(Member member) {
        return ModelCacheServiceHelper.getLeaf(member);
    }

    @Override
    public List<Member> getLeafSort(Member member) {
        return ModelCacheServiceHelper.getLeafSort(member);
    }

    @Override
    public List<String> getLeafOfNumbers(Member member) {
        return ModelCacheServiceHelper.getLeafOfNums(member);
    }

    @Override
    public List<String> getLeafOfNumsSort(Member member) {
        return ModelCacheServiceHelper.getLeafOfNumsSort(member);
    }

    @Override
    public List<Member> getNoLeaf(Member member) {
        return ModelCacheServiceHelper.getNoLeaf(member);
    }

    @Override
    public List<Member> getNoLeafSort(Member member) {
        return ModelCacheServiceHelper.getNoLeafSort(member);
    }

    @Override
    public Member getParent(Member member) {
        return ModelCacheServiceHelper.getParent(0L, member);
    }

    @Override
    public Member getParent(Long viewId, Member member) {
        return ModelCacheServiceHelper.getParent(viewId, member);
    }

    @Override
    public List<Member> getParents(Member member, boolean hasSelf) {
        return ModelCacheServiceHelper.getParents(0L, member, hasSelf);
    }

    @Override
    public List<Member> getParents(Long viewId, Member member, boolean hasSelf) {
        return ModelCacheServiceHelper.getParents(viewId, member, hasSelf);
    }

    @Override
    public List<Member> getParentsByOrder(Long viewId, Member member, boolean hasSelf) {
        return ModelCacheServiceHelper.getParentsByOrder(viewId, member, hasSelf);
    }

    @Override
    public List<Member> getBrother(Member member, boolean hasIncludeSelf) {
        return ModelCacheServiceHelper.getBrother(0L, member, hasIncludeSelf);
    }

    @Override
    public List<Member> getBrother(Long viewId, Member member, boolean hasIncludeSelf) {
        return ModelCacheServiceHelper.getBrother(viewId, member, hasIncludeSelf);
    }

    @Override
    public List<Member> getBrotherSort(Member member, boolean hasIncludeSelf) {
        return ModelCacheServiceHelper.getBrotherSort(0L, member, hasIncludeSelf);
    }

    @Override
    public List<Member> getBrotherSort(Long viewId, Member member, boolean hasIncludeSelf) {
        return ModelCacheServiceHelper.getBrotherSort(viewId, member, hasIncludeSelf);
    }

    @Override
    public Map<Long, Dimension> getDimensions() {
        return this.getModelobj().getDimensions();
    }

    @Override
    public Map<Long, Dimension> getDimensions(Long datasetId) {
        return this.getModelobj().getDimensions(datasetId);
    }

    @Override
    public Map<String, Dimension> getDimensionMap() {
        List<Dimension> dimensions = this.getModelobj().getDimension();
        return dimensions.stream().collect(Collectors.toMap(BaseCache::getNumber, Dimension2 -> Dimension2));
    }

    @Override
    public Map<Long, Dimension> getDimensionMapById() {
        List<Dimension> dimensions = this.getModelobj().getDimension();
        return dimensions.stream().collect(Collectors.toMap(BaseCache::getId, Dimension2 -> Dimension2));
    }

    @Override
    public Map<String, Dimension> getDimensionMap(Long datasetId) {
        List<Dimension> dimensions = this.getModelobj().getDimensionByDataset(datasetId);
        return dimensions.stream().collect(Collectors.toMap(BaseCache::getNumber, Dimension2 -> Dimension2));
    }

    @Override
    public Map<String, Dimension> getDimensionMap(String[] dimNumbers) {
        return this.getModelobj().getDimensionMapByNum(dimNumbers);
    }

    @Override
    public List<Dimension> getDimensionList() {
        return this.getModelobj().getDimension();
    }

    @Override
    public Dataset getDataSet(Long datasetId) {
        return this.getModelobj().getDataset(datasetId);
    }

    @Override
    public List<Dimension> getDimensionList(@NotNull Long datasetId) {
        return this.getModelobj().getDimensionByDataset(datasetId);
    }

    @Override
    public List<Dimension> getDimensionListByBusModel(@NotNull Long busModelId) {
        return this.getModelobj().getDimensionByBusModel(busModelId);
    }

    @Override
    public Map<String, Long> getViewsByBusModel(@NotNull Long busModelId) {
        return this.getModelobj().getViewsByBusModel(busModelId);
    }

    @Override
    public Map<String, Long> getViewGroupsByBusModel(@NotNull Long busModelId) {
        return this.getModelobj().getViewGroupsByBusModel(busModelId);
    }

    @Override
    public Map<String, Long> getViewGroupsByDataSet(@NotNull Long dataSetId) {
        return this.getModelobj().getViewGroupsByDataSet(dataSetId);
    }

    @Override
    public Map<String, List<Long>> getViewGroupViewsByBusModel(@NotNull Long busModelId) {
        return this.getModelobj().getViewGroupViewsByBusModel(busModelId);
    }

    @Override
    public List<Long> getViewGroupViewsByBusModelAndDimNumber(@NotNull Long busModelId, String dimNumber) {
        return this.getModelobj().getViewsByBusModelAndDimNumber(busModelId, dimNumber);
    }

    @Override
    public Map<String, Long> getViewsByBusModelIncludeBase(@NotNull Long busModelId) {
        return this.getModelobj().getViewsByBusModelIncludeBase(busModelId);
    }

    @Override
    public Map<String, Long> getViewsByDataSet(@NotNull Long dataSetId) {
        return this.getModelobj().getViewsByDataSet(dataSetId);
    }

    @Override
    public Map<String, List<Long>> getViewGroupViewsByDataSet(@NotNull Long dataSetId) {
        return this.getModelobj().getViewGroupViewsByDataSet(dataSetId);
    }

    @Override
    public List<Long> getViewGroupViewsByDataSetAndDimNumber(@NotNull Long dataSetId, String dimNumber) {
        return this.getModelobj().getViewsByDataSetAndDimNumber(dataSetId, dimNumber);
    }

    @Override
    public Map<String, Long> getViewsByDataSetIncludeBase(@NotNull Long dataSetId) {
        return this.getModelobj().getViewsByDataSetIncludeBase(dataSetId);
    }

    @Override
    public Long getViewByDataSetAndDimNumber(@NotNull Long dataSetId, String dimNumber) {
        return this.getModelobj().getViewByDataSetAndDimNumber(dataSetId, dimNumber);
    }

    @Override
    public Long getViewByBusModelAndDimNumber(@NotNull Long busModelId, String dimNumber) {
        return this.getModelobj().getViewByBusModelAndDimNumber(busModelId, dimNumber);
    }

    @Override
    public Long getViewGroupByDataSetAndDimNumber(@NotNull Long datasetId, String dimNumber) {
        return this.getModelobj().getViewGroupByDataSetAndDimNumber(datasetId, dimNumber);
    }

    @Override
    public Long getViewGroupByBusModelAndDimNumber(@NotNull Long busModelId, String dimNumber) {
        return this.getModelobj().getViewGroupByBusModelAndDimNumber(busModelId, dimNumber);
    }

    @Override
    public Long getBusModelByDataSet(@NotNull Long datasetId) {
        return this.getModelobj().getBusModelByDataSet(datasetId);
    }

    @Override
    public List<Dimension> getDimensionList(String[] dimNumbers) {
        return this.getModelobj().getDimensionList(dimNumbers);
    }

    @Override
    public String[] getDimensionNums() {
        List<Dimension> dimensions = this.getDimensionList();
        return this.getDimensionNums(dimensions);
    }

    @Override
    public String[] getDimensionNums(@NotNull Long datasetId) {
        List<Dimension> dimensions = this.getDimensionList(datasetId);
        return this.getDimensionNums(dimensions);
    }

    @Override
    public String[] getDimensionNumsByBusModel(@NotNull Long busModelId) {
        List<Dimension> dimensions = this.getDimensionListByBusModel(busModelId);
        return this.getDimensionNums(dimensions);
    }

    private String[] getDimensionNums(List<Dimension> dimensions) {
        String[] numbers = new String[dimensions.size()];
        int in = dimensions.size();
        for (int i = 0; i < in; ++i) {
            numbers[i] = dimensions.get(i).getNumber();
        }
        return numbers;
    }

    @Override
    public Map<String, Integer> getDimIndexMap(boolean hasShortNumber) {
        return this.getDimIndexMap(this.getDimensionList(), hasShortNumber);
    }

    @Override
    public Map<String, Integer> getDimIndexMap(Long datasetId, boolean hasShortNumber) {
        return this.getDimIndexMap(this.getDimensionList(datasetId), hasShortNumber);
    }

    @Override
    public Map<String, Integer> getDimIndexMapByBusModel(Long busModelId, boolean hasShortNumber) {
        return this.getDimIndexMap(this.getDimensionListByBusModel(busModelId), hasShortNumber);
    }

    private Map<String, Integer> getDimIndexMap(List<Dimension> dimensions, boolean hasShortNumber) {
        HashMap<String, Integer> dimIndexMap = new HashMap<String, Integer>();
        if (hasShortNumber) {
            int in = dimensions.size();
            for (int i = 0; i < in; ++i) {
                dimIndexMap.put(dimensions.get(i).getShortNumber(), i);
            }
        } else {
            int in = dimensions.size();
            for (int i = 0; i < in; ++i) {
                dimIndexMap.put(dimensions.get(i).getNumber(), i);
            }
        }
        return dimIndexMap;
    }

    @Override
    public boolean checkContainByScope(Member sourceMember, String targetMemberNum, String scopeNum) {
        String sourceNum1 = sourceMember.getNumber();
        switch (scopeNum) {
            case "10": {
                if (!sourceMember.getNumber().equals(targetMemberNum)) break;
                return true;
            }
            case "40": {
                for (Member childMemb : sourceMember.getAllMembers()) {
                    if (childMemb.getNumber().equals(sourceNum1) || !childMemb.getNumber().equals(targetMemberNum)) continue;
                    return true;
                }
                break;
            }
            case "50": {
                if (sourceMember.getNumber().equals(targetMemberNum)) {
                    return true;
                }
                for (Member childMemb : sourceMember.getAllMembers()) {
                    if (!childMemb.getNumber().equals(targetMemberNum)) continue;
                    return true;
                }
                break;
            }
            case "90": {
                for (Member childMemb : ModelCacheServiceHelper.getDetailChildren(sourceMember)) {
                    if (!childMemb.getNumber().equals(targetMemberNum)) continue;
                    return true;
                }
                break;
            }
            case "110": {
                for (Member childMemb : ModelCacheServiceHelper.getNotDetailChildren(sourceMember)) {
                    if (!childMemb.getNumber().equals(targetMemberNum)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    @Override
    public boolean checkContainByScope(String dimNum, Long viewId, String sourceMembNum, String targetMembNum, int scopeNum) {
        List<Member> members = this.getMemberSort(dimNum, viewId, sourceMembNum, scopeNum);
        if (members != null && members.size() > 0) {
            for (Member member : members) {
                if (!member.getNumber().equals(targetMembNum)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void reBuildDimension(Dimension dimension, Long version) {
        if (dimension != null) {
            dimension.reBuilder();
            dimension.setVersion(version);
        }
    }

    @Override
    public List<Member> getEntityViewMembersByBusModel(Long bizModelId) {
        List<Member> members;
        Map<String, Long> busModelViews = this.getViewsByBusModel(bizModelId);
        if (busModelViews.containsKey(SysDimensionEnum.Entity.getNumber())) {
            Long viewId = busModelViews.get(SysDimensionEnum.Entity.getNumber());
            members = this.getDimension(SysDimensionEnum.Entity.getNumber()).getAllMembers(viewId);
        } else {
            members = this.getDimension(SysDimensionEnum.Entity.getNumber()).getAllMembers();
        }
        return members;
    }

    @Override
    public void logModelVersion() {
        StringBuilder stringBuilder = new StringBuilder();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat format2 = new SimpleDateFormat("HH:mm:ss");
        stringBuilder.append("logModelVersion:").append("model(").append(this.model.getNumber()).append(",").append(this.model.getVersion()).append(",").append(format.format(this.model.getCreateTime())).append(");");
        stringBuilder.append("dimension[");
        for (Dimension dimension : this.model.getDimension()) {
            stringBuilder.append(dimension.getNumber()).append(",").append(dimension.getVersion()).append(",").append(format2.format(dimension.getCreateTime()));
            Map<Long, View> views = dimension.getViews();
            if (!views.isEmpty()) {
                stringBuilder.append(",view(");
                for (Map.Entry<Long, View> entry : views.entrySet()) {
                    View view = entry.getValue();
                    stringBuilder.append(view.getNumber()).append(",").append(view.getVersion()).append(",").append(format2.format(view.getCreateTime())).append(";");
                }
                stringBuilder.append(")");
            }
            stringBuilder.append(";");
        }
        stringBuilder.append("]");
        log.info(stringBuilder.toString());
    }

    @Override
    public String getDataSetNumberByDataSet(Long datasetId) {
        return this.getModelobj().getDataSetNumberByDataSet(datasetId);
    }

    @Override
    public Long getAnalyzeMemberViewId(Long baseViewId, Member member) {
        List<Long> analyzeViewId = this.model.getAnalyzeViewIdByBaseViewId(baseViewId);
        if (CollectionUtils.isNotEmpty(analyzeViewId)) {
            Dimension dimension = this.getDimension(member.getDimension().getNumber());
            for (Long viewId : analyzeViewId) {
                View view = dimension.getView(viewId);
                Member viewMember = view.getMember(member.getNumber());
                if (viewMember == null) continue;
                return viewId;
            }
        }
        return null;
    }

    @Override
    public Long getDefaultViewIdOnDim(String dimNumber) {
        Long defaultViewId = 0L;
        Dimension dimension = this.getDimension(dimNumber);
        if (dimension != null) {
            defaultViewId = dimension.getDefaultViewId();
        }
        return defaultViewId;
    }
}

