/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.AbstractTree;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class ModelCacheServiceHelper {
    private static final Log log = LogFactory.getLog(ModelCacheServiceHelper.class);
    public static final String MODEL_FIELDS = "id, name, number, shownumber, reportType, version, datasource, creator, level";

    static ModelCacheServiceHelper getInstance() {
        return new ModelCacheServiceHelper();
    }

    public Model initModel(@NotNull Long modelId) {
        Model model = new Model();
        if (modelId == null || modelId == 0L) {
            return model;
        }
        LogStats stats = new LogStats("budget-data-log : ");
        stats.addInfo("begin initModel. modelId = " + modelId);
        QFilter filter = new QFilter("id", "=", (Object)modelId);
        DynamicObject object = QueryServiceHelper.queryOne((String)"epm_model", (String)MODEL_FIELDS, (QFilter[])filter.toArray());
        if (object == null) {
            // empty if block
        }
        if (object != null) {
            model.setLang(RequestContext.get().getLang());
            model.setId(object.getLong("id"));
            model.setName(object.getString("name"));
            model.setNumber(object.getString("shownumber"));
            model.setCubeNumber(object.getString("number"));
            model.setVersion(object.getLong("version"));
            model.setReportType(object.getString("reportType"));
            model.setDataSourceId(object.getLong("datasource"));
            model.setCreator(object.getLong("creator"));
            if (object.containsProperty("level")) {
                model.setLevelLong(object.getLong("level"));
            }
        } else {
            throw new KDBizException(ResManager.loadResFormat((String)"\u67e5\u8be2\u7684\u4f53\u7cfb\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"ModelCacheServiceHelper_0", (String)"epm-eb-common", (Object[])new Object[]{modelId}));
        }
        model.buildDimensions(null);
        model.buildShareMembers();
        stats.addInfo("init-dimension-size=" + model.getDimension().size());
        stats.addInfo("end initModel.");
        log.info(stats.toString());
        return model;
    }

    public static Map<Dimension, Collection<Member>> getMembers(Model model, Map<String, Collection<String>> dimAndMembers, Map<String, Long> viewIds) {
        if (model == null || dimAndMembers == null || dimAndMembers.isEmpty()) {
            return null;
        }
        HashMap<Dimension, Collection<Member>> members = new HashMap<Dimension, Collection<Member>>(dimAndMembers.size());
        for (Map.Entry<String, Collection<String>> dimensionEntry : dimAndMembers.entrySet()) {
            Dimension dimension = model.getDimension(dimensionEntry.getKey());
            View view = dimension.getView(viewIds.get(dimension.getNumber()));
            if (view == null) {
                members.put(dimension, dimension.getMember(dimensionEntry.getValue()));
                continue;
            }
            members.put(dimension, view.getMember(dimensionEntry.getValue()));
        }
        return members;
    }

    public static List<Member> getMembers(Model model, String dimensionNumber, Collection<String> memberNumber) {
        return ModelCacheServiceHelper.getMembers(model, dimensionNumber, (Long)0L, memberNumber);
    }

    public static List<Member> getMembers(Model model, String dimensionNumber, List<Long> memberIds) {
        return ModelCacheServiceHelper.getMembers(model, dimensionNumber, (Long)0L, memberIds);
    }

    public static List<Member> getMembers(Model model, String dimensionNumber, Long viewId, Collection<String> memberNumber) {
        List<Member> members = new ArrayList<Member>();
        if (model == null || dimensionNumber == null || memberNumber == null || memberNumber.isEmpty()) {
            return members;
        }
        Dimension dimension = model.getDimension(dimensionNumber);
        if (dimension != null) {
            members = ModelCacheServiceHelper.getMembers(dimension, viewId, memberNumber);
        }
        return members;
    }

    public static List<Member> getMembers(Model model, String dimensionNumber, Long viewId, List<Long> memberIds) {
        List<Member> members = new ArrayList<Member>();
        if (model == null || dimensionNumber == null || memberIds == null || memberIds.isEmpty()) {
            return members;
        }
        Dimension dimension = model.getDimension(dimensionNumber);
        if (dimension != null) {
            members = ModelCacheServiceHelper.getMembers(dimension, viewId, memberIds);
        }
        return members;
    }

    public static List<Member> getMembers(Dimension dimension, Long viewId, Collection<String> memberNumber) {
        List<Member> members = new ArrayList<Member>();
        if (dimension == null || memberNumber == null || memberNumber.isEmpty()) {
            return members;
        }
        View view = dimension.getView(viewId);
        members = view != null ? view.getMember(memberNumber) : dimension.getMember(memberNumber);
        return members;
    }

    public static List<Member> getMembers(Dimension dimension, Long viewId, List<Long> memberIds) {
        List<Member> members = new ArrayList<Member>();
        if (dimension == null || memberIds == null || memberIds.isEmpty()) {
            return members;
        }
        View view = dimension.getView(viewId);
        members = view != null ? view.getMembers(memberIds) : dimension.getMembers(memberIds);
        return members;
    }

    public static List<Member> getMembers(Model model, String dimensionNumber) {
        return ModelCacheServiceHelper.getMembers(model, dimensionNumber, 0L);
    }

    public static List<Member> getMembers(Model model, String dimensionNumber, int level) {
        return ModelCacheServiceHelper.getMembers(model, dimensionNumber, 0L, level, false);
    }

    public static List<Member> getMembers(Model model, String dimensionNumber, boolean hasViewMember) {
        return ModelCacheServiceHelper.getMembers(model, dimensionNumber, (Long)0L, hasViewMember);
    }

    public static List<Member> getMembers(Model model, String dimensionNumber, Long viewId) {
        return ModelCacheServiceHelper.getMembers(model, dimensionNumber, viewId, false);
    }

    public static List<Member> getMembers(Model model, String dimensionNumber, Long viewId, boolean hasViewMember) {
        return ModelCacheServiceHelper.getMembers(model, dimensionNumber, viewId, -1, hasViewMember);
    }

    public static List<Member> getMembers(Model model, String dimensionNumber, Long viewId, int level, boolean hasViewMember) {
        List<Member> members = new LinkedList<Member>();
        if (model == null || dimensionNumber == null) {
            return members;
        }
        Dimension dimension = model.getDimension(dimensionNumber);
        if (dimension != null) {
            View view = dimension.getView(viewId);
            if (view != null) {
                members = level > 0 ? view.getAllMembers(level) : view.getAllMembers();
            } else {
                if (level > 0) {
                    members.addAll(dimension.getAllMembers(level));
                } else {
                    members.addAll(dimension.getAllMembers());
                }
                if (hasViewMember) {
                    members.addAll(dimension.getViewMember());
                }
            }
        }
        return members;
    }

    public static Map<String, Member> getMemberMap(Model model, String dimensionNumber) {
        return ModelCacheServiceHelper.getMemberMap(model, dimensionNumber, 0L);
    }

    public static Map<String, Member> getMemberMap(Model model, String dimensionNumber, Long viewId) {
        Map<String, Member> members = new HashMap<String, Member>();
        if (model == null || dimensionNumber == null) {
            return members;
        }
        Dimension dimension = model.getDimension(dimensionNumber);
        if (dimension != null) {
            View view = dimension.getView(viewId);
            members = view != null ? view.getAllMemberMap() : dimension.getAllMemberMap();
        }
        return members;
    }

    public static Member getRootMember(Model model, String dimensionNumber, Long viewId) {
        if (model == null || dimensionNumber == null) {
            return null;
        }
        Member member = null;
        Dimension dimension = model.getDimension(dimensionNumber);
        if (dimension != null) {
            String memberNumber = dimensionNumber;
            View view = dimension.getView(viewId);
            if (view != null) {
                if (!"1".equals(view.getSource())) {
                    memberNumber = dimensionNumber + "_" + view.getNumber();
                }
                member = view.getMember(memberNumber);
            } else {
                member = dimension.getMember(memberNumber);
            }
            if (member == null) {
                member = dimension.getStructOfMember(dimension.getNumber());
            }
        }
        return member;
    }

    public static Member getRootMember(IModelCacheHelper modelCacheHelper, String dimensionNumber, Long busModelId) {
        if (modelCacheHelper == null || dimensionNumber == null || busModelId == null) {
            return null;
        }
        Map<String, Long> viewIds = modelCacheHelper.getViewsByBusModel(busModelId);
        return ModelCacheServiceHelper.getRootMember(modelCacheHelper.getModelobj(), dimensionNumber, viewIds.get(dimensionNumber));
    }

    public static Member getMember(Model model, String dimensionNumber, String memberNumber) {
        return ModelCacheServiceHelper.getMember(model, dimensionNumber, (Long)0L, memberNumber);
    }

    public static Member getMemberByAnyView(Model model, Long busModelId, String dimensionNumber, String memberNumber) {
        Pair<Member, Long> pair = ModelCacheServiceHelper.getMemberByAnyViewPair(model, busModelId, dimensionNumber, memberNumber);
        if (pair != null) {
            return (Member)pair.p1;
        }
        return null;
    }

    public static Pair<Member, Long> getMemberByAnyViewPair(Model model, Long busModelId, String dimensionNumber, String memberNumber) {
        List<Pair<Member, Long>> pairs = ModelCacheServiceHelper.getMemberByAnyViewPair(model, busModelId, dimensionNumber, memberNumber, true);
        if (pairs != null && !pairs.isEmpty()) {
            return pairs.get(0);
        }
        return null;
    }

    public static List<Pair<Member, Long>> getMemberByAnyViewPair(Model model, Long busModelId, String dimensionNumber, String memberNumber, boolean isOne) {
        if (model == null || dimensionNumber == null || memberNumber == null) {
            return null;
        }
        ArrayList<Pair<Member, Long>> pairs = new ArrayList<Pair<Member, Long>>(10);
        Member member = null;
        Dimension dimension = model.getDimension(dimensionNumber);
        if (dimension != null) {
            Map<Object, Object> viewIds = IDUtils.isNotNull(busModelId) ? model.getViewsByBusModel(busModelId) : Collections.emptyMap();
            Long viewId = (Long)viewIds.get(dimensionNumber);
            member = dimension.getMember(viewId, memberNumber);
            if (member == null) {
                List<Long> viewList;
                List<Long> list = viewList = IDUtils.isNotNull(busModelId) ? model.getViewsByBusModelAndDimNumber(busModelId, dimensionNumber) : dimension.getViewList();
                if (CollectionUtils.isNotEmpty(viewList)) {
                    for (Long _viewId : viewList) {
                        member = dimension.getMember(_viewId, memberNumber);
                        if (member == null && dimensionNumber.equals(memberNumber)) {
                            member = ModelCacheServiceHelper.getRootMember(model, dimensionNumber, _viewId);
                        }
                        if (member == null) continue;
                        pairs.add(Pair.onePair(member, _viewId));
                        if (!isOne) continue;
                        return pairs;
                    }
                }
            } else {
                pairs.add(Pair.onePair(member, viewId));
            }
        }
        return pairs;
    }

    public static Member getMemberByAnyView(Model model, Long busModelId, String dimensionNumber, Long memberId) {
        Member member;
        block3: {
            List<Long> viewList;
            Map viewIds;
            Long viewId;
            if (model == null || dimensionNumber == null || memberId == null) {
                return null;
            }
            member = null;
            Dimension dimension = model.getDimension(dimensionNumber);
            if (dimension == null || (member = dimension.getMember(viewId = (Long)(viewIds = IDUtils.isNotNull(busModelId) ? model.getViewsByBusModel(busModelId) : Collections.emptyMap()).get(dimensionNumber), memberId)) != null) break block3;
            List<Long> list = viewList = IDUtils.isNotNull(busModelId) ? model.getViewsByBusModelAndDimNumber(busModelId, dimensionNumber) : dimension.getViewList();
            if (CollectionUtils.isNotEmpty(viewList)) {
                Long _viewId;
                Iterator iterator = viewList.iterator();
                while (iterator.hasNext() && (member = dimension.getMember(_viewId = (Long)iterator.next(), memberId)) == null) {
                }
            }
        }
        return member;
    }

    public static Map<Long, String> getMemberRate(Model model, String dimensionNumber, Long memberId) {
        if (model == null || StringUtils.isEmpty(dimensionNumber) || !SysDimensionEnum.Account.getNumber().equals(dimensionNumber) || memberId == null || memberId == 0L) {
            return Collections.emptyMap();
        }
        Map<Long, String> memberRate = null;
        Dimension dimension = model.getDimension(dimensionNumber);
        if (dimension != null) {
            memberRate = dimension.getMemberRate(memberId);
        }
        return memberRate;
    }

    public static Member getMember(Model model, String dimensionNumber, Long viewId, String memberNumber) {
        if (model == null || dimensionNumber == null || memberNumber == null) {
            return null;
        }
        Member member = null;
        Dimension dimension = model.getDimension(dimensionNumber);
        if (dimension != null) {
            View view = dimension.getView(viewId);
            member = view != null ? view.getMember(memberNumber) : dimension.getMember(memberNumber);
        }
        if (member == null && dimensionNumber.equals(memberNumber)) {
            member = ModelCacheServiceHelper.getRootMember(model, dimensionNumber, viewId);
        }
        return member;
    }

    public static Member getMemberByShowNumber(Model model, String dimensionNumber, Long viewId, String memberShowNumber) {
        if (model == null || dimensionNumber == null || memberShowNumber == null) {
            return null;
        }
        Member member = null;
        Dimension dimension = model.getDimension(dimensionNumber);
        if (dimension != null) {
            View view = dimension.getView(viewId);
            member = view != null ? view.getMemberByShowNumber(memberShowNumber) : dimension.getMemberByShowNumber(memberShowNumber);
        }
        return member;
    }

    public static Member getMember(Model model, String dimensionNumber, Long memberId) {
        return ModelCacheServiceHelper.getMember(model, dimensionNumber, (Long)0L, memberId);
    }

    public static Member getMember(Model model, String dimensionNumber, Long viewId, Long memberId) {
        if (model == null || dimensionNumber == null || memberId == null || memberId == 0L) {
            return null;
        }
        Member member = null;
        Dimension dimension = model.getDimension(dimensionNumber);
        if (dimension != null) {
            View view = dimension.getView(viewId);
            member = view != null ? view.getMember(memberId) : dimension.getMember(memberId);
        }
        return member;
    }

    public static Member getMemberByVid(Model model, String dimensionNumber, Long viewId, Long vId) {
        View view;
        if (model == null || dimensionNumber == null || vId == null || vId == 0L) {
            return null;
        }
        Member member = null;
        Dimension dimension = model.getDimension(dimensionNumber);
        if (dimension != null && (view = dimension.getView(viewId)) != null) {
            member = view.getMemberByVid(vId);
        }
        return member;
    }

    public static List<Member> getMemberByAnyView(Model model, String dimensionNumber, Long busModelId, String memberNumber, int range) {
        if (IDUtils.isNull(busModelId)) {
            return ModelCacheServiceHelper.getMember(model, dimensionNumber, 0L, memberNumber, range);
        }
        Pair<Member, Long> pair = ModelCacheServiceHelper.getMemberByAnyViewPair(model, busModelId, dimensionNumber, memberNumber);
        if (pair == null) {
            return new LinkedList<Member>();
        }
        return ModelCacheServiceHelper.getMember(model, dimensionNumber, (Long)pair.p2, memberNumber, range);
    }

    public static List<Member> getMember(Model model, String dimensionNumber, String memberNumber, int range) {
        return ModelCacheServiceHelper.getMember(model, dimensionNumber, 0L, memberNumber, range);
    }

    public static List<Member> getMember(Model model, String dimensionNumber, Long viewId, String memberNumber, int range) {
        return ModelCacheServiceHelper.getMember(model, dimensionNumber, viewId, memberNumber, range, 0, false, true, false);
    }

    public static List<Member> getMember(Model model, String dimensionNumber, Long viewId, String memberNumber, int range, int rangeLevel, boolean includeCosmic) {
        return ModelCacheServiceHelper.getMember(model, dimensionNumber, viewId, memberNumber, range, rangeLevel, false, true, includeCosmic);
    }

    public static List<Member> getMemberSort(Model model, String dimensionNumber, Long viewId, String memberNumber, int range, int rangLevel, boolean includeCosmic) {
        return ModelCacheServiceHelper.getMember(model, dimensionNumber, viewId, memberNumber, range, rangLevel, true, true, includeCosmic);
    }

    public static Member getMemberOffset(Model model, String dimensionNumber, String memberNumber, int offset, boolean sortByNumber) {
        Member member = ModelCacheServiceHelper.getMember(model, dimensionNumber, memberNumber);
        if (member == null) {
            return null;
        }
        if (offset == 0) {
            return member;
        }
        Member rootMember = ModelCacheServiceHelper.getMember(model, dimensionNumber, dimensionNumber);
        if (rootMember == null) {
            return null;
        }
        List<Member> allMembers = rootMember.getLevelMembers(member.getLevel());
        List<Member> currentLevelMember = allMembers.stream().filter(e -> !e.getNumber().endsWith("._inv")).collect(Collectors.toList());
        if (sortByNumber) {
            currentLevelMember.sort(Comparator.comparing(BaseCache::getNumber));
        } else {
            currentLevelMember.sort(Comparator.comparingInt(BaseCache::getSeq));
        }
        int index = -1;
        index = sortByNumber ? ModelCacheServiceHelper.binarySearch(currentLevelMember, member.getNumber(), 0, currentLevelMember.size()) : ModelCacheServiceHelper.binarySearch(currentLevelMember, member.getSeq(), 0, currentLevelMember.size());
        if (index == -1) {
            return null;
        }
        int offIndex = index + offset;
        if (offIndex < 0 || offIndex >= currentLevelMember.size()) {
            return null;
        }
        return currentLevelMember.get(offIndex);
    }

    public static Member getMemberOffsetByLevel(Model model, String dimensionNumber, Long viewId, String memberNumber, int offset, boolean sortByNumber, int level) {
        Member member = ModelCacheServiceHelper.getParentByLevel(model, dimensionNumber, viewId, memberNumber, level);
        if (member == null) {
            return null;
        }
        if (offset == 0) {
            return member;
        }
        Member rootMember = ModelCacheServiceHelper.getMember(model, dimensionNumber, dimensionNumber);
        if (rootMember == null) {
            return null;
        }
        List<Member> allMembers = rootMember.getLevelMembers(level);
        List<Member> currentLevelMember = allMembers.stream().filter(e -> !e.getNumber().endsWith("._inv")).collect(Collectors.toList());
        if (sortByNumber) {
            currentLevelMember.sort(Comparator.comparing(BaseCache::getNumber));
        } else {
            currentLevelMember.sort(Comparator.comparingInt(BaseCache::getSeq));
        }
        int index = -1;
        index = sortByNumber ? ModelCacheServiceHelper.binarySearch(currentLevelMember, member.getNumber(), 0, currentLevelMember.size()) : ModelCacheServiceHelper.binarySearch(currentLevelMember, member.getSeq(), 0, currentLevelMember.size());
        if (index == -1) {
            return null;
        }
        int offIndex = index + offset;
        if (offIndex < 0 || offIndex >= currentLevelMember.size()) {
            return null;
        }
        return currentLevelMember.get(offIndex);
    }

    private static Member getParentByLevel(Model model, String dimensionNumber, Long viewId, String memberNumber, int level) {
        Long datasetId;
        Member member = ModelCacheServiceHelper.getMember(model, dimensionNumber, viewId, memberNumber);
        if (member == null || member.getParentId() == null || member.getParentId() == 0L) {
            return null;
        }
        if (member.getLevel() == level) {
            return member;
        }
        Dimension dimension = member.getDimension();
        Member parentMember = dimension.getMember(viewId, member.getParentId());
        boolean hasAccount = SysDimensionEnum.Account.getNumber().equals(dimension.getNumber());
        if (hasAccount && (datasetId = member.getDatasetId()) != null && datasetId != 0L) {
            List<Member> collect = parentMember.getChildren().stream().filter(e -> datasetId.equals(e.getDatasetId())).collect(Collectors.toList());
            Member _parentMember = new Member(parentMember.getDimension());
            _parentMember.setId(parentMember.getId());
            _parentMember.setName(parentMember.getName());
            _parentMember.setNumber(parentMember.getNumber());
            _parentMember.setDatasetId(parentMember.getDatasetId());
            _parentMember.setChildren(collect);
            return _parentMember;
        }
        if (parentMember.getLevel() == level) {
            return parentMember;
        }
        return ModelCacheServiceHelper.getParentByLevel(model, dimensionNumber, viewId, parentMember.getNumber(), level);
    }

    public static List<Member> getMemberBetween(Model model, String dimensionNumber, String memberNumber1, String memberNumber2, boolean includeSelf) {
        Member member1 = ModelCacheServiceHelper.getMember(model, dimensionNumber, memberNumber1);
        Member member2 = ModelCacheServiceHelper.getMember(model, dimensionNumber, memberNumber2);
        if (member1 == null || member2 == null) {
            return Collections.emptyList();
        }
        if (member1.getLevel() != member2.getLevel()) {
            return Collections.emptyList();
        }
        int maxSeq = Math.max(member1.getSeq(), member2.getSeq());
        int minSeq = Math.min(member1.getSeq(), member2.getSeq());
        if (minSeq == maxSeq) {
            return Collections.emptyList();
        }
        Member rootMember = ModelCacheServiceHelper.getMember(model, dimensionNumber, dimensionNumber);
        if (rootMember == null) {
            return Collections.emptyList();
        }
        List<Member> currentLevelMember = rootMember.getLevelMembers(member1.getLevel());
        currentLevelMember.sort(Comparator.comparingInt(BaseCache::getSeq));
        int maxIndex = -1;
        int minIndex = ModelCacheServiceHelper.binarySearch(currentLevelMember, minSeq, 0, currentLevelMember.size());
        maxIndex = ModelCacheServiceHelper.binarySearch(currentLevelMember, maxSeq, 0, currentLevelMember.size());
        if (minIndex == -1 || maxIndex == -1) {
            return Collections.emptyList();
        }
        int collectionSize = maxIndex - minIndex - 1;
        ArrayList betweenMember = Lists.newArrayListWithExpectedSize((int)collectionSize);
        if (includeSelf) {
            for (int i = minIndex; i < maxIndex + 1; ++i) {
                betweenMember.add(currentLevelMember.get(i));
            }
        } else {
            for (int i = minIndex + 1; i < maxIndex; ++i) {
                betweenMember.add(currentLevelMember.get(i));
            }
        }
        return betweenMember;
    }

    private static int binarySearch(List<Member> members, String number, int low, int high) {
        if (low > high) {
            return -1;
        }
        int mid = low + (high - low) / 2;
        Member midMember = members.get(mid);
        String midNumber = midMember.getNumber();
        if (midNumber.compareTo(number) == 0) {
            return mid;
        }
        if (midNumber.compareTo(number) > 0) {
            return ModelCacheServiceHelper.binarySearch(members, number, low, mid - 1);
        }
        if (midNumber.compareTo(number) < 0) {
            return ModelCacheServiceHelper.binarySearch(members, number, mid + 1, high);
        }
        return -1;
    }

    private static int binarySearch(List<Member> members, int seq, int low, int high) {
        if (low > high) {
            return -1;
        }
        int mid = low + (high - low) / 2;
        Member midMember = members.get(mid);
        int midSeq = midMember.getSeq();
        if (midSeq == seq) {
            return mid;
        }
        if (midSeq > seq) {
            return ModelCacheServiceHelper.binarySearch(members, seq, low, mid - 1);
        }
        if (midSeq < seq) {
            return ModelCacheServiceHelper.binarySearch(members, seq, mid + 1, high);
        }
        return -1;
    }

    public static List<Member> getMemberByEb(Model model, String dimensionNumber, String memberNumber, int range, boolean hasShare) {
        return ModelCacheServiceHelper.getMember(model, dimensionNumber, (Long)0L, memberNumber, range, 0, false, hasShare, false);
    }

    private static List<Member> getMember(Model model, String dimensionNumber, Long viewId, String memberNumber, int range, int rangeLevel, boolean needSort, boolean hasShare, boolean includeCosmic) {
        return ModelCacheServiceHelper.getMember(model, model.getDimension(dimensionNumber), viewId, memberNumber, range, rangeLevel, needSort, hasShare, includeCosmic);
    }

    private static List<Member> getMember(Model model, Dimension dimension, Long viewId, String memberNumber, int range, int level, boolean needSort, boolean hasShare, boolean includeCosmic) {
        Member member;
        Member _member;
        View view;
        if (model == null || dimension == null || StringUtils.isEmpty(memberNumber)) {
            return Collections.emptyList();
        }
        List<Member> members = new LinkedList<Member>();
        Map<Long, List<Member>> shareMap = null;
        if (hasShare && model.isModelByEB()) {
            shareMap = model.getShareMembers().get(dimension.getId());
        }
        if ((view = dimension.getView(viewId)) != null) {
            _member = view.getMember(memberNumber);
            if (_member == null && dimension.getNumber().equals(memberNumber)) {
                _member = ModelCacheServiceHelper.getRootMember(model, dimension.getNumber(), viewId);
            }
        } else {
            _member = dimension.getMember(memberNumber);
        }
        if ((member = _member) != null) {
            Long datasetId = SysDimensionEnum.Account.getNumber().equals(dimension.getNumber()) ? member.getDatasetId() : null;
            if (RangeEnum.ONLY.getIndex() == range) {
                members.add(member);
            } else if (RangeEnum.DIRECTSUB_EXCLUDE.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getDirect(member, needSort, shareMap));
            } else if (RangeEnum.DIRECTSUB.getIndex() == range) {
                members.add(member);
                members.addAll(ModelCacheServiceHelper.getDirect(member, needSort, shareMap));
            } else if (RangeEnum.ALL_EXCLUDE.getIndex() == range || RangeEnum.LEVEL_EXCLUDE.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getChildren(member, false, needSort, shareMap));
                if (RangeEnum.LEVEL_EXCLUDE.getIndex() == range && level > 0) {
                    members.removeIf(child -> child.getLevel() - level != member.getLevel());
                } else if (level > 0) {
                    members.removeIf(child -> child.getLevel() - level > member.getLevel());
                }
            } else if (RangeEnum.ALL.getIndex() == range || RangeEnum.LEVEL.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getChildren(member, true, needSort, shareMap));
                if (RangeEnum.LEVEL.getIndex() == range && level > 0) {
                    members.removeIf(child -> child.getLevel() - level != member.getLevel() && child.getLevel() != member.getLevel());
                } else if (level > 0) {
                    members.removeIf(child -> child.getLevel() - level > member.getLevel());
                }
            } else if (RangeEnum.PEERS_EXCLUDE.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getBrother(viewId, member, false, needSort, shareMap));
            } else if (RangeEnum.PEERS.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getBrother(viewId, member, true, needSort, shareMap));
            } else if (RangeEnum.ALL_DETAIL.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getLeaf(member, needSort, shareMap));
            } else if (RangeEnum.ALL_DETAIL_INCLUDE.getIndex() == range) {
                if (!member.isLeaf()) {
                    members.add(member);
                }
                members.addAll(ModelCacheServiceHelper.getLeaf(member, needSort, shareMap));
            } else if (RangeEnum.ALL_NOTDETAIL.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getNoLeaf(member, needSort, shareMap));
            } else if (RangeEnum.ANCESTOR.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getParents(viewId, member, true));
            } else if (RangeEnum.ANCESTOR_EXCLUDE.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getParents(viewId, member, false));
            }
            if (IDUtils.isNotNull(datasetId)) {
                members = members.stream().filter(m -> m.getDatasetId() != null && datasetId.compareTo(m.getDatasetId()) == 0).collect(Collectors.toList());
            }
            if (!includeCosmic) {
                members = members.stream().filter(m -> !m.getNumber().endsWith("._inv")).collect(Collectors.toList());
            }
        }
        return members;
    }

    public static List<Member> getMemberById(Model model, Dimension dimension, Long viewId, Long memberId, int range, boolean needSort) {
        return ModelCacheServiceHelper.getMemberById(model, dimension, viewId, memberId, range, 0, needSort);
    }

    public static List<Member> getMemberById(Model model, Dimension dimension, Long viewId, Long memberId, int range, int level, boolean needSort) {
        List<Member> members = new LinkedList<Member>();
        if (model == null || dimension == null || IDUtils.isNull(memberId)) {
            return members;
        }
        Map<Long, List<Member>> shareMap = null;
        View view = dimension.getView(viewId);
        Member member = view != null ? view.getMember(memberId) : dimension.getMember(memberId);
        if (member != null) {
            Long datasetId = SysDimensionEnum.Account.getNumber().equals(dimension.getNumber()) ? member.getDatasetId() : null;
            if (RangeEnum.ONLY.getIndex() == range) {
                members.add(member);
            } else if (RangeEnum.DIRECTSUB_EXCLUDE.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getDirect(member, needSort, shareMap));
            } else if (RangeEnum.DIRECTSUB.getIndex() == range) {
                members.add(member);
                members.addAll(ModelCacheServiceHelper.getDirect(member, needSort, shareMap));
            } else if (RangeEnum.ALL_EXCLUDE.getIndex() == range || RangeEnum.LEVEL_EXCLUDE.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getChildren(member, false, needSort, shareMap));
                if (RangeEnum.LEVEL_EXCLUDE.getIndex() == range && level > 0) {
                    members.removeIf(child -> child.getLevel() - level > member.getLevel());
                }
            } else if (RangeEnum.ALL.getIndex() == range || RangeEnum.LEVEL.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getChildren(member, true, needSort, shareMap));
                if (RangeEnum.LEVEL.getIndex() == range && level > 0) {
                    members.removeIf(child -> child.getLevel() - level > member.getLevel());
                }
            } else if (RangeEnum.PEERS_EXCLUDE.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getBrother(viewId, member, false, needSort, shareMap));
            } else if (RangeEnum.PEERS.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getBrother(viewId, member, true, needSort, shareMap));
            } else if (RangeEnum.ALL_DETAIL.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getLeaf(member, needSort, shareMap));
            } else if (RangeEnum.ALL_DETAIL_INCLUDE.getIndex() == range) {
                if (!member.isLeaf()) {
                    members.add(member);
                }
                members.addAll(ModelCacheServiceHelper.getLeaf(member, needSort, shareMap));
            } else if (RangeEnum.ALL_NOTDETAIL.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getNoLeaf(member, needSort, shareMap));
            } else if (RangeEnum.ANCESTOR.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getParents(viewId, member, true));
            } else if (RangeEnum.ANCESTOR_EXCLUDE.getIndex() == range) {
                members.addAll(ModelCacheServiceHelper.getParents(viewId, member, false));
            }
            if (IDUtils.isNotNull(datasetId)) {
                members = members.stream().filter(m -> datasetId.compareTo(m.getDatasetId()) == 0).collect(Collectors.toList());
            }
        }
        return members;
    }

    public static List<Member> getDirect(Member member) {
        List<Member> direct = ModelCacheServiceHelper.getDirect(member, false, null);
        return direct.stream().filter(m -> !m.getNumber().endsWith("._inv")).collect(Collectors.toList());
    }

    public static List<Member> getDirectSort(Member member) {
        return ModelCacheServiceHelper.getDirect(member, true, null);
    }

    private static List<Member> getDirect(Member member, boolean hasSort, Map<Long, List<Member>> shareMap) {
        List<Member> shares;
        LinkedList<Member> direct = new LinkedList<Member>();
        if (member == null) {
            return direct;
        }
        direct.addAll(member.getChildren(hasSort));
        if (shareMap != null && !shareMap.isEmpty() && (shares = shareMap.get(member.getId())) != null) {
            direct.addAll(shares);
        }
        return direct;
    }

    public static List<Member> getChildren(Member member, boolean hasIncludeSelf) {
        return ModelCacheServiceHelper.getChildren(member, hasIncludeSelf, false, null);
    }

    public static List<Member> getAllChildrenSort(Member member, boolean hasIncludeSelf) {
        return ModelCacheServiceHelper.getChildren(member, hasIncludeSelf, true, null);
    }

    private static List<Member> getChildren(Member member, boolean hasIncludeSelf, boolean hasSort, Map<Long, List<Member>> shareMap) {
        LinkedList<Member> children = new LinkedList<Member>();
        if (member == null) {
            return children;
        }
        if (hasIncludeSelf) {
            children.add(member);
        }
        ModelCacheServiceHelper.getChildren(children, member, hasSort);
        if (shareMap != null && !shareMap.isEmpty()) {
            LinkedList<Member> shareChildren = new LinkedList<Member>();
            for (Member child : children) {
                List<Member> shares = shareMap.get(child.getId());
                if (shares == null) continue;
                shareChildren.addAll(shares);
            }
            List<Member> shares = shareMap.get(member.getId());
            if (shares != null) {
                shareChildren.addAll(shares);
            }
            children.addAll(shareChildren);
        }
        return children;
    }

    private static void getChildren(List<Member> members, Member member, boolean hasSort) {
        if (members == null || member == null) {
            return;
        }
        if (member.getChildren() != null && !member.getChildren().isEmpty()) {
            List<Member> children = member.getChildren(hasSort);
            for (Member child : children) {
                members.add(child);
                ModelCacheServiceHelper.getChildren(members, child, hasSort);
            }
        }
    }

    public static List<Member> getNotDetailChildren(Member member) {
        return ModelCacheServiceHelper.getNotDetailChildren(member, false);
    }

    public static List<Member> getNotDetailChildrenSort(Member member) {
        return ModelCacheServiceHelper.getNotDetailChildren(member, true);
    }

    private static List<Member> getNotDetailChildren(Member member, boolean hasSort) {
        LinkedList<Member> members = new LinkedList<Member>();
        if (member == null) {
            return members;
        }
        ModelCacheServiceHelper.getNotDetailChildren(members, member, member, hasSort);
        return members;
    }

    private static void getNotDetailChildren(List<Member> members, Member member, Member root, boolean hasSort) {
        if (members == null || member == null) {
            return;
        }
        if (member.getChildren() != null && !member.getChildren().isEmpty()) {
            if (member != root) {
                members.add(member);
            }
            for (Member child : member.getChildren(hasSort)) {
                ModelCacheServiceHelper.getNotDetailChildren(members, child, root, hasSort);
            }
        }
    }

    public static List<Member> getDetailChildren(Member member) {
        return ModelCacheServiceHelper.getDetailChildren(member, false);
    }

    public static List<Member> getDetailChildrenSort(Member member) {
        return ModelCacheServiceHelper.getDetailChildren(member, true);
    }

    private static List<Member> getDetailChildren(Member member, boolean hasSort) {
        LinkedList<Member> members = new LinkedList<Member>();
        if (member == null) {
            return members;
        }
        ModelCacheServiceHelper.getDetailChildren(members, member, member, hasSort);
        return members;
    }

    private static void getDetailChildren(List<Member> members, Member member, Member root, boolean hasSort) {
        if (members == null || member == null) {
            return;
        }
        if (member.getChildren() != null && !member.getChildren().isEmpty()) {
            for (Member child : member.getChildren(hasSort)) {
                ModelCacheServiceHelper.getDetailChildren(members, child, root, hasSort);
            }
        } else if (member != root) {
            members.add(member);
        }
    }

    public static List<String> getLeafOfNumsSort(Member member) {
        return ModelCacheServiceHelper.getLeafOfNums(member, true);
    }

    public static List<String> getLeafOfNums(Member member) {
        return ModelCacheServiceHelper.getLeafOfNums(member, false);
    }

    private static List<String> getLeafOfNums(Member member, boolean needSort) {
        LinkedList<String> leafNums = new LinkedList<String>();
        List<Member> leaf = ModelCacheServiceHelper.getLeaf(member, needSort, null);
        for (Member _member : leaf) {
            leafNums.add(_member.getNumber());
        }
        return leafNums;
    }

    public static List<Member> getLeaf(Member member) {
        return ModelCacheServiceHelper.getLeaf(member, false, null);
    }

    public static List<Member> getLeafSort(Member member) {
        return ModelCacheServiceHelper.getLeaf(member, true, null);
    }

    private static List<Member> getLeaf(Member member, boolean needSort, Map<Long, List<Member>> shareMap) {
        LinkedList<Member> leaf = new LinkedList<Member>();
        if (member == null) {
            return leaf;
        }
        ModelCacheServiceHelper.getLeaf(leaf, member, needSort, member, shareMap);
        return leaf;
    }

    private static void getLeaf(List<Member> leaf, Member member, boolean needSort, Member root, Map<Long, List<Member>> shareMap) {
        if (member == null || leaf == null || root == null) {
            return;
        }
        if (member.getChildren() == null || member.getChildren().isEmpty()) {
            List<Member> shares;
            List<Member> list = shares = shareMap != null ? shareMap.get(member.getId()) : null;
            if (shares != null && !shares.isEmpty()) {
                for (Member share : shares) {
                    ModelCacheServiceHelper.getLeaf(leaf, share, needSort, root, shareMap);
                }
            } else {
                leaf.add(member);
            }
        } else {
            List<Member> children = member.getChildren(needSort);
            for (Member child : children) {
                ModelCacheServiceHelper.getLeaf(leaf, child, needSort, root, shareMap);
            }
        }
    }

    public static List<Member> getNoLeafSort(Member member) {
        return ModelCacheServiceHelper.getNoLeaf(member, true, null);
    }

    public static List<Member> getNoLeaf(Member member) {
        return ModelCacheServiceHelper.getNoLeaf(member, false, null);
    }

    private static List<Member> getNoLeaf(Member member, boolean hasSort, Map<Long, List<Member>> shareMap) {
        LinkedList<Member> noLeaf = new LinkedList<Member>();
        if (member == null) {
            return noLeaf;
        }
        ModelCacheServiceHelper.getNoLeaf(noLeaf, member, hasSort, member, shareMap);
        return noLeaf;
    }

    private static void getNoLeaf(List<Member> noLeaf, Member member, boolean hasSort, Member root, Map<Long, List<Member>> shareMap) {
        block5: {
            List<Member> shares;
            block4: {
                if (member == null || noLeaf == null || root == null) {
                    return;
                }
                List<Member> children = member.getChildren();
                if (children == null || children.isEmpty()) break block4;
                if (member != root) {
                    noLeaf.add(member);
                }
                for (Member child : children) {
                    ModelCacheServiceHelper.getNoLeaf(noLeaf, child, hasSort, root, shareMap);
                }
                break block5;
            }
            List<Member> list = shares = shareMap != null ? shareMap.get(member.getId()) : null;
            if (shares == null || shares.isEmpty()) break block5;
            noLeaf.add(member);
            for (Member share : shares) {
                ModelCacheServiceHelper.getNoLeaf(noLeaf, share, hasSort, root, shareMap);
            }
        }
    }

    public static Member getParent(Long viewId, Member member) {
        Long datasetId;
        if (member == null || member.getParentId() == null || member.getParentId() == 0L) {
            return null;
        }
        Dimension dimension = member.getDimension();
        Member parentMember = dimension.getMember(viewId, member.getParentId());
        boolean hasAccount = SysDimensionEnum.Account.getNumber().equals(dimension.getNumber());
        if (hasAccount && (datasetId = member.getDatasetId()) != null && datasetId != 0L) {
            List<Member> collect = parentMember.getChildren().stream().filter(e -> datasetId.equals(e.getDatasetId())).collect(Collectors.toList());
            Member _parentMember = new Member(parentMember.getDimension());
            _parentMember.setId(parentMember.getId());
            _parentMember.setName(parentMember.getName());
            _parentMember.setNumber(parentMember.getNumber());
            _parentMember.setDatasetId(parentMember.getDatasetId());
            _parentMember.setChildren(collect);
            return _parentMember;
        }
        return parentMember;
    }

    public static List<Member> getParents(Long viewId, Member member, boolean hasSelf) {
        Long datasetId;
        ArrayList<Member> ancestors = new ArrayList<Member>(16);
        if (member == null) {
            return ancestors;
        }
        if (hasSelf) {
            ancestors.add(member);
        }
        ModelCacheServiceHelper.getParent(viewId, member, ancestors);
        Dimension dimension = member.getDimension();
        boolean hasAccount = SysDimensionEnum.Account.getNumber().equals(dimension.getNumber());
        if (hasAccount && (datasetId = member.getDatasetId()) != null && datasetId != 0L) {
            Member root = (Member)ancestors.remove(ancestors.size() - 1);
            List<Member> collect = root.getChildren().stream().filter(e -> e.getDatasetId().equals(datasetId)).collect(Collectors.toList());
            Member _root = new Member(root.getDimension());
            _root.setId(root.getId());
            _root.setName(root.getName());
            _root.setNumber(root.getNumber());
            _root.setChildren(collect);
            ancestors.add(_root);
        }
        return ancestors;
    }

    private static void getParent(Long viewId, Member member, List<Member> ancestors) {
        if (member == null || member.getParentId() == null || member.getParentId() == 0L) {
            return;
        }
        Dimension dimension = member.getDimension();
        Member parent = dimension.getMember(viewId, member.getParentId());
        if (parent != null) {
            ancestors.add(parent);
            ModelCacheServiceHelper.getParent(viewId, parent, ancestors);
        }
    }

    public static List<Member> getParentsByOrder(Long viewId, Member member, boolean hasSelf) {
        LinkedList<Member> parents = new LinkedList<Member>();
        if (member == null || member.getDimension() == null || member.getLongNumber() == null) {
            if (hasSelf && member != null) {
                parents.add(member);
            }
            return parents;
        }
        String longNumber = member.getLongNumber();
        String[] numbers = longNumber.split("!");
        if (!hasSelf) {
            String[] clone = new String[numbers.length - 1];
            System.arraycopy(numbers, 0, clone, 0, clone.length);
            numbers = clone;
        }
        if (numbers != null && numbers.length > 0) {
            View view = member.getDimension().getView(viewId);
            if (view != null) {
                parents.addAll(view.getMember(Arrays.asList(numbers)));
            } else {
                parents.addAll(member.getDimension().getMember(Arrays.asList(numbers)));
            }
        }
        return parents;
    }

    public static List<Member> getBrother(Long viewId, Member member, boolean hasIncludeSelf) {
        return ModelCacheServiceHelper.getBrother(viewId, member, hasIncludeSelf, false, null);
    }

    public static List<Member> getBrotherSort(Long viewId, Member member, boolean hasIncludeSelf) {
        return ModelCacheServiceHelper.getBrother(viewId, member, hasIncludeSelf, true, null);
    }

    private static List<Member> getBrother(Long viewId, Member member, boolean hasIncludeSelf, boolean hasSort, Map<Long, List<Member>> shareMap) {
        LinkedList<Member> brothers = new LinkedList<Member>();
        if (member == null) {
            return brothers;
        }
        Dimension dimension = member.getDimension();
        Member parent = dimension.getMember(viewId, member.getParentId());
        if (parent != null) {
            List<Member> shares;
            List<Member> children = parent.getChildren(hasSort);
            for (Member _brother : children) {
                if (!hasIncludeSelf && _brother.equals(member)) continue;
                brothers.add(_brother);
            }
            if (shareMap != null && (shares = shareMap.get(parent.getId())) != null) {
                brothers.addAll(shares);
            }
        }
        return brothers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMemberGlobalSeq(Member member) {
        if (member == null) {
            return 0;
        }
        Map allMemberSeq = ModelCacheContext.allDimMemberSeq.get(member.getDimension().getNumber());
        if (allMemberSeq == null) {
            Map<String, Map<Long, Integer>> map = ModelCacheContext.allDimMemberSeq;
            synchronized (map) {
                allMemberSeq = ModelCacheContext.allDimMemberSeq.computeIfAbsent(member.getDimension().getNumber(), k -> new HashMap(16));
                Integer seq = (Integer)allMemberSeq.get(member.getId());
                if (seq == null) {
                    ModelCacheServiceHelper.initAllMemberSeq(member.getViewOrDim(), allMemberSeq);
                    seq = allMemberSeq.getOrDefault(member.getId(), 0);
                }
                return seq;
            }
        }
        Integer seq = allMemberSeq.get(member.getId());
        if (seq == null) {
            Map<String, Map<Long, Integer>> map = ModelCacheContext.allDimMemberSeq;
            synchronized (map) {
                seq = (Integer)allMemberSeq.get(member.getId());
                if (seq == null) {
                    ModelCacheServiceHelper.initAllMemberSeq(member.getViewOrDim(), allMemberSeq);
                    seq = allMemberSeq.getOrDefault(member.getId(), 0);
                }
            }
        }
        return seq;
    }

    private static void initAllMemberSeq(AbstractTree viewOrDim, Map<Long, Integer> allMemberSeq) {
        if (viewOrDim != null) {
            int beginIndex = allMemberSeq.size();
            List<Member> allMembers = viewOrDim.getAllMembers();
            for (Member member : allMembers) {
                if (allMemberSeq.get(member.getId()) != null) continue;
                allMemberSeq.put(member.getId(), beginIndex);
                ++beginIndex;
            }
        }
    }
}

