/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.control;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.control.Centralized;
import org.jetbrains.annotations.NotNull;

public class BgControlCache {
    public static final long MODEL_MAX_SIZE = 8L;
    public static final long MODEL_OVER_TIME = 2L;
    private static final Log log = LogFactory.getLog(BgControlCache.class);
    private static volatile LoadingCache<String, List<Centralized>> centralizedMap = CacheBuilder.newBuilder().maximumSize(8L).expireAfterAccess(2L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, List<Centralized>>(){

        public List<Centralized> load(String centralizedKey) {
            return BgControlCache.$loadCentralized(centralizedKey);
        }
    });

    private static LoadingCache<String, List<Centralized>> getCentralizedMap() {
        return centralizedMap;
    }

    public static List<Centralized> getCentralized(@NotNull String centralizedKey) {
        List centralized;
        LogStats stats = new LogStats("budget-control-log : ");
        stats.addInfo("begin-getCentralized.");
        stats.addInfo("centralizedKey:" + centralizedKey);
        Long modelId = 0L;
        String[] _centKeys = centralizedKey.split("@");
        if (_centKeys.length == 2) {
            modelId = Long.valueOf(_centKeys[0]);
        }
        try {
            centralized = (List)BgControlCache.getCentralizedMap().get((Object)centralizedKey);
            Long oldVersion = !centralized.isEmpty() ? ((Centralized)centralized.get(0)).getVersion() : Long.valueOf(0L);
            Long cacheVersion = CacheServiceHelper.getVersionCacheByCentralized(centralizedKey);
            stats.addInfo("oldVersion:" + oldVersion);
            stats.addInfo("cacheVersion:" + (cacheVersion == null ? "null" : cacheVersion));
            if (cacheVersion == null || cacheVersion.compareTo(oldVersion) != 0) {
                BgControlCache.clearCentralized(modelId, false);
                centralized = (List)BgControlCache.getCentralizedMap().get((Object)centralizedKey);
            }
        }
        catch (ExecutionException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        finally {
            stats.add("end-getCentralized.");
            log.info(stats.toString());
        }
        return centralized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Centralized> $loadCentralized(@NotNull String centralizedKey) {
        LogStats stats = new LogStats("budget-control-log : ");
        stats.addInfo("begin-load-$loadCentralized");
        stats.addInfo("centralizedKey:" + centralizedKey);
        try {
            String[] _centKeys = centralizedKey.split("@");
            if (_centKeys.length == 2) {
                Long modelId = Long.valueOf(_centKeys[0]);
                Long busModelId = Long.valueOf(_centKeys[1]);
                List<Centralized> list = CacheServiceHelper.queryCacheByCentralized(modelId, busModelId, stats);
                return list;
            }
            stats.addInfo("error-centralizedKey:" + centralizedKey);
        }
        finally {
            stats.add("end-load-$loadCentralized");
            log.info(stats.toString());
        }
        return Collections.emptyList();
    }

    public static void clearCentralized(@NotNull Long modelId) {
        BgControlCache.clearCentralized(modelId, true);
    }

    public static void clearCentralized(@NotNull Long modelId, boolean upVersion) {
        LogStats stats = new LogStats("budget-control-log : ");
        stats.addInfo("begin-clear-Centralized.");
        stats.addInfo("clear-modelId:" + modelId);
        String _centralizedKey = modelId + "@";
        if (upVersion) {
            long version = DBServiceHelper.genGlobalLongId();
            stats.addInfo("rebuild-version:" + version);
            DB.execute((DBRoute)BgBaseConstant.epm, (String)"update t_eb_centralized_entity set fversion = ? where fmodel = ?", (Object[])new Object[]{version, modelId});
        }
        for (String centralizedKey : BgControlCache.getCentralizedMap().asMap().keySet()) {
            if (centralizedKey.startsWith(_centralizedKey)) {
                BgControlCache.getCentralizedMap().invalidate((Object)centralizedKey);
                stats.addInfo("release-loading-key:" + _centralizedKey);
                continue;
            }
            stats.addInfo("ignore-loading-key:" + _centralizedKey);
        }
        BgControlCache.getCentralizedMap().cleanUp();
        CacheServiceHelper.clearCacheByCentralized(modelId, stats);
        CacheServiceHelper.clearVersionCacheByCentralized(modelId, stats);
        stats.add("end-clear-Centralized.");
        log.info(stats.toString());
    }
}

