/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.control;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.control.BgLockMapping;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.LogUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;

public class BgLockCacheServiceHelper {
    private static final Log log = LogFactory.getLog(BgLockCacheServiceHelper.class);
    public static final long MAX_LOCK_TIME = 120000L;
    private static volatile Map<String, Long> mappingTimestampMap = Collections.synchronizedMap(new HashMap());
    private static volatile LoadingCache<String, BgLockMapping> mappingMap = CacheBuilder.newBuilder().maximumSize(8L).expireAfterAccess(2L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, BgLockMapping>(){

        public BgLockMapping load(String mappingId) {
            return BgLockCacheServiceHelper.$loadMapping(mappingId);
        }
    });

    public static void reloadCacheByView(Long bizModelId, Long dimensionId, Long viewId) {
        DynamicObject dimension = BusinessDataServiceHelper.loadSingle((Object)dimensionId, (String)"epm_dimension");
        if (dimension != null && SysDimensionEnum.Entity.getNumber().equals(dimension.getString("number"))) {
            BgLockCacheServiceHelper.reloadCacheByBizModel(bizModelId);
        }
    }

    public static void reloadCacheByParam(DynamicObject dataEntity) {
        if (dataEntity == null || dataEntity.getDataEntityType() == null) {
            return;
        }
        if (!"bg_control_param".equals(dataEntity.getDataEntityType().getName())) {
            return;
        }
        if (dataEntity.containsProperty("lock_orgunit") && Boolean.TRUE.equals(dataEntity.getBoolean("lock_orgunit"))) {
            long modelId = dataEntity.getDynamicObject("model").getLong("id");
            BgLockCacheServiceHelper.reloadCacheByBizModel(modelId);
        }
    }

    private static void reloadCacheByBizModel(Long bizModelId) {
        QFilter qf1 = new QFilter("model.id", "=", (Object)bizModelId);
        Map busModels = BusinessDataServiceHelper.loadFromCache((String)"eb_businessmodel", (String)"id, name, number", (QFilter[])new QFilter[]{qf1});
        if (busModels != null && !busModels.isEmpty()) {
            busModels.values().forEach(f -> BgLockCacheServiceHelper.reloadCache(bizModelId, f.getLong("id")));
        } else {
            BgLockCacheServiceHelper.reloadCache(bizModelId, 0L);
        }
    }

    public static void reloadCache(Long bizModelId, Long bussModelId) {
        String traceId = RequestContext.getOrCreate().getTraceId();
        EpmThreadPools.CommPools.execute(() -> {
            RequestContext.getOrCreate().setTraceId(traceId);
            LogStats stats = new LogStats("budget-control-lock-log : ");
            BgLockCacheServiceHelper.lock(bizModelId, bussModelId, stats, true);
            log.info(stats.toString());
        });
    }

    private static void reloadCacheInLock(Long bizModelId, Long bussModelId, LogStats stats) {
        BgLockMapping mapping = new BgLockMapping();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(bizModelId);
        Dimension entityDim = modelCache.getDimension(SysDimensionEnum.Entity.getNumber());
        SqlBuilder sql = new SqlBuilder();
        sql.append("select distinct fbudimmemberid from t_eb_membermapping where ", new Object[0]);
        sql.append("fid in(select fid from t_eb_dimmembermapping where fmodel = ? and fbussmodelid = ? and fdim = ?)", new Object[]{bizModelId, bussModelId, SysDimensionEnum.Entity.getNumber()});
        sql.append("and fbudimmemberid in (select fparentid from t_eb_structofent where fmodelid = ? and fparentid <> ?)", new Object[]{bizModelId, 0L});
        HashSet<Long> noLeafIds = new HashSet<Long>(100);
        try (DataSet ds = DB.queryDataSet((String)"querynoleafmapping", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            for (Row row : ds) {
                noLeafIds.add(row.getLong("fbudimmemberid"));
            }
        }
        BgLockCacheServiceHelper.buildMapping(mapping, entityDim, noLeafIds, modelCache, bussModelId);
        String cacheKey = BgLockCacheServiceHelper.getCacheKey(bizModelId, bussModelId);
        Map<String, Long> timeCache = BgLockCacheServiceHelper.getCacheTimeMap();
        timeCache.put(cacheKey, mapping.getTime().getTime());
        Map<String, String> cacheMap = BgLockCacheServiceHelper.getCacheMap();
        String json = JSONUtils.toString(mapping);
        String compress = ObjectSerialUtil.compress4GZip(json);
        String old = cacheMap.get(cacheKey);
        BgLockMapping oldmapping = null;
        if (StringUtils.isNotEmpty(old)) {
            oldmapping = JsonUtils.readValue(ObjectSerialUtil.uncompress(old.substring(6)), BgLockMapping.class);
        }
        if (mapping.equals(oldmapping)) {
            return;
        }
        log.info("budget-control-lock-log : -oldtime=" + (oldmapping == null ? "" : Long.valueOf(oldmapping.getTime().getTime())) + " newtime=" + mapping.getTime().getTime() + " bizModelId=" + bizModelId + " bussModelId=" + bussModelId);
        cacheMap.put(cacheKey, compress);
        CacheServiceHelper.put("CONTROL_LOCK_CACHE", cacheMap);
        CacheServiceHelper.put("CONTROL_LOCK_TIMESTAMP_CACHE", timeCache);
    }

    private static void buildMapping(BgLockMapping mapping, Dimension entityDim, Set<Long> noLeafIds, IModelCacheHelper modelCache, Long bussmodelId) {
        Member member = null;
        HashSet parentIds = new HashSet(10);
        HashSet childIds = new HashSet(100);
        List<Member> members = null;
        for (Long id : noLeafIds) {
            parentIds.clear();
            childIds.clear();
            member = modelCache.getMemberByAnyView(bussmodelId, entityDim.getNumber(), id);
            if (member == null) continue;
            members = member.getAllMembers();
            members.forEach(f -> childIds.add(f.getId()));
            members = ModelCacheServiceHelper.getParents(0L, member, true);
            members.forEach(f -> parentIds.add(f.getId()));
            mapping.add(id, new HashSet<Long>(parentIds), new HashSet<Long>(childIds));
        }
    }

    private static String getCacheKey(Long bizModelId, Long bussModelId) {
        return bizModelId + "!" + bussModelId;
    }

    private static Map<String, String> getCacheMap() {
        long beginTotal = System.nanoTime();
        StringBuilder logStr = new StringBuilder();
        HashMap<String, String> cacheMap = CacheServiceHelper.get("CONTROL_LOCK_CACHE", Map.class);
        if (cacheMap == null) {
            cacheMap = new HashMap<String, String>();
        }
        logStr.append("query-cache-lock.get lock cache, use=").append(LogUtils.use(beginTotal));
        log.info(logStr.toString());
        return cacheMap;
    }

    private static Map<String, Long> getCacheTimeMap() {
        HashMap cacheTimeMap = CacheServiceHelper.get("CONTROL_LOCK_TIMESTAMP_CACHE", Map.class);
        if (cacheTimeMap == null) {
            cacheTimeMap = new HashMap();
        }
        return cacheTimeMap;
    }

    public static String getLockKey(Long bizModelId, Long bussModelId) {
        return "eb/controllock/" + bizModelId + "/" + bussModelId;
    }

    public static BgLockMapping getNoLeafLockMember(Long bizModelId, Long bussModelId, LogStats stats) {
        log.info("budget-control-lock-log : begin-getNoLeafLockMember bizModelId=" + bizModelId + " bussModelid=" + bussModelId);
        Long timestamp = BgLockCacheServiceHelper.lock(bizModelId, bussModelId, stats, false);
        if (timestamp == null) {
            BgLockCacheServiceHelper.lock(bizModelId, bussModelId, stats, true);
        }
        if ((timestamp = BgLockCacheServiceHelper.lock(bizModelId, bussModelId, stats, false)) == null) {
            ControlException.errorControlLock();
            return null;
        }
        Long time1 = mappingTimestampMap.get(BgLockCacheServiceHelper.getCacheKey(bizModelId, bussModelId));
        if (!timestamp.equals(time1) || BgLockCacheServiceHelper.getMappingMap().getIfPresent((Object)BgLockCacheServiceHelper.getCacheKey(bizModelId, bussModelId)) == null) {
            String compress = BgLockCacheServiceHelper.getCacheMap().get(BgLockCacheServiceHelper.getCacheKey(bizModelId, bussModelId));
            if (StringUtils.isEmpty(compress)) {
                BgLockCacheServiceHelper.lock(bizModelId, bussModelId, stats, true);
                compress = BgLockCacheServiceHelper.getCacheMap().get(BgLockCacheServiceHelper.getCacheKey(bizModelId, bussModelId));
            }
            BgLockMapping mapping = JsonUtils.readValue(ObjectSerialUtil.uncompress(compress.substring(6)), BgLockMapping.class);
            mappingTimestampMap.put(BgLockCacheServiceHelper.getCacheKey(bizModelId, bussModelId), mapping.getTime().getTime());
            BgLockCacheServiceHelper.getMappingMap().put((Object)BgLockCacheServiceHelper.getCacheKey(bizModelId, bussModelId), (Object)mapping);
        }
        BgLockMapping mapping = (BgLockMapping)BgLockCacheServiceHelper.getMappingMap().getIfPresent((Object)BgLockCacheServiceHelper.getCacheKey(bizModelId, bussModelId));
        if (stats != null) {
            stats.add("getNoLeafLockMember timestamp = " + timestamp + " time1 = " + time1 + "lock = " + JsonUtils.getJsonString(mapping.getPojoMap().keySet()));
        }
        return mapping;
    }

    private static Long getTimeInCache(Long bizModelId, Long bussModelId) {
        return BgLockCacheServiceHelper.getCacheTimeMap().get(BgLockCacheServiceHelper.getCacheKey(bizModelId, bussModelId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long lock(Long bizModelId, Long bussModelId, LogStats stats, boolean isLoad) {
        String lockKey = BgLockCacheServiceHelper.getLockKey(bizModelId, bussModelId);
        if (stats != null) {
            stats.addInfo("begin-try-loadlock.");
        }
        try (DLock lock = DLock.create((String)lockKey);){
            boolean isLock = false;
            try {
                isLock = lock.tryLock(120000L);
            }
            catch (Throwable e) {
                lock.unlock();
                throw e;
            }
            if (isLock) {
                if (stats != null) {
                    stats.add("end-try-loadlock.");
                }
                if (stats != null) {
                    stats.addInfo("begin-try-loadlock.");
                }
                if (stats != null) {
                    stats.add("end-try-loadlock.");
                }
                if (isLoad) {
                    BgLockCacheServiceHelper.reloadCacheInLock(bizModelId, bussModelId, stats);
                    Long l = null;
                    return l;
                }
                Long l = BgLockCacheServiceHelper.getTimeInCache(bizModelId, bussModelId);
                return l;
                finally {
                    lock.unlock();
                }
            }
            ControlException.errorControlLock();
        }
        return null;
    }

    private static LoadingCache<String, BgLockMapping> getMappingMap() {
        return mappingMap;
    }

    protected static BgLockMapping $loadMapping(String mappingId) {
        return null;
    }
}

