/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.control;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BgLockMapping
implements Serializable {
    private static final long serialVersionUID = -5166675339671474597L;
    private Timestamp time = new Timestamp(System.currentTimeMillis());
    private Map<Long, Set<Long>> parentPojoMap = new HashMap<Long, Set<Long>>(100);
    private Map<Long, BgLockMappingPojo> pojoMap = new HashMap<Long, BgLockMappingPojo>(100);
    private Map<Long, Long> childPojoMap = new HashMap<Long, Long>(100);

    public void add(Long id, Set<Long> parentIds, Set<Long> childIds) {
        if (this.childPojoMap.containsKey(id)) {
            return;
        }
        BgLockMappingPojo pojo = new BgLockMappingPojo();
        pojo.id = id;
        pojo.parentIds = parentIds;
        pojo.childIds = childIds;
        for (Long childId : pojo.childIds) {
            BgLockMappingPojo child = this.pojoMap.get(childId);
            if (child == null) continue;
            this.pojoMap.remove(childId);
            Iterator<Map.Entry<Long, Set<Long>>> it = this.parentPojoMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, Set<Long>> entry = it.next();
                entry.getValue().remove(child.id);
                if (!entry.getValue().isEmpty()) continue;
                it.remove();
            }
        }
        this.pojoMap.put(id, pojo);
        pojo.parentIds.forEach(f -> this.parentPojoMap.computeIfAbsent((Long)f, a -> new HashSet(10)).add(pojo.id));
        pojo.childIds.forEach(f -> this.childPojoMap.put((Long)f, pojo.id));
    }

    @Deprecated
    public Map<Long, Set<Long>> getParentPojoMap() {
        return this.parentPojoMap;
    }

    @Deprecated
    public void setParentPojoMap(Map<Long, Set<Long>> parentPojoMap) {
        this.parentPojoMap = parentPojoMap;
    }

    @Deprecated
    public Map<Long, Long> getChildPojoMap() {
        return this.childPojoMap;
    }

    @Deprecated
    public void setChildPojoMap(Map<Long, Long> childPojoMap) {
        this.childPojoMap = childPojoMap;
    }

    @Deprecated
    public Map<Long, BgLockMappingPojo> getPojoMap() {
        return this.pojoMap;
    }

    @Deprecated
    public void setPojoMap(Map<Long, BgLockMappingPojo> pojoMap) {
        this.pojoMap = pojoMap;
    }

    public Timestamp getTime() {
        return this.time;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BgLockMapping) {
            BgLockMapping old = (BgLockMapping)obj;
            if (!old.pojoMap.keySet().equals(this.pojoMap.keySet())) {
                return false;
            }
            BgLockMappingPojo oldPojo = null;
            for (Map.Entry<Long, BgLockMappingPojo> entry : this.pojoMap.entrySet()) {
                oldPojo = old.pojoMap.get(entry.getKey());
                if (oldPojo == null) {
                    return false;
                }
                if (!entry.getValue().childIds.equals(oldPojo.childIds)) {
                    return false;
                }
                if (entry.getValue().parentIds.equals(oldPojo.parentIds)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Set<Long> getLockOrgIds(@NotNull Set<Long> orgIds) {
        if (orgIds.isEmpty()) {
            return new HashSet<Long>(1);
        }
        HashSet<Long> result = new HashSet<Long>(orgIds.size());
        for (Long id : orgIds) {
            if (this.pojoMap.containsKey(id)) {
                result.add(id);
                continue;
            }
            if (this.childPojoMap.containsKey(id)) {
                result.add(this.childPojoMap.get(id));
                continue;
            }
            if (id == 0L) continue;
            result.add(id);
        }
        return result;
    }

    public static class BgLockMappingPojo
    implements Serializable {
        private static final long serialVersionUID = -218408409268069708L;
        Long id = null;
        Set<Long> parentIds = null;
        Set<Long> childIds = null;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Set<Long> getChildIds() {
            return this.childIds;
        }

        public void setChildIds(Set<Long> childIds) {
            this.childIds = childIds;
        }

        public Set<Long> getParentIds() {
            return this.parentIds;
        }

        public void setParentIds(Set<Long> parentIds) {
            this.parentIds = parentIds;
        }
    }
}

