/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.impl;

import java.util.HashSet;
import java.util.LinkedList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.impl.AbstractTree;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.utils.ObjectCache;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;

public abstract class AbstractDimension
extends AbstractTree {
    private static final long serialVersionUID = -5680999268783046322L;
    private Model model = null;
    private boolean preset = false;
    private String shortNumber = null;
    private String fieldMapped = null;
    private String memberModel = null;
    private transient boolean treeModel = true;

    public void setModel(Model model) {
        this.model = model;
    }

    public Model getModel() {
        return this.model;
    }

    public void setPreset(boolean preset) {
        this.preset = preset;
    }

    public boolean isPreset() {
        return this.preset;
    }

    public void setShortNumber(String shortNumber) {
        this.shortNumber = shortNumber;
    }

    public String getShortNumber() {
        return this.shortNumber;
    }

    public void setFieldMapped(String fieldMapped) {
        this.fieldMapped = fieldMapped;
    }

    public String getFieldMapped() {
        return this.fieldMapped;
    }

    public void setMemberModel(String memberModel) {
        this.memberModel = memberModel;
    }

    public String getMemberModel() {
        return this.memberModel;
    }

    public String getMemberTable() {
        SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByMemberTreemodel(this.getMemberModel());
        if (dimensionEnum != null) {
            return dimensionEnum.getMemberTreetable();
        }
        return "t_eb_structofdefined";
    }

    public void setTreeModel(boolean treeModel) {
        this.treeModel = treeModel;
    }

    public boolean isTreeModel() {
        return this.treeModel;
    }

    public boolean isOrder() {
        return SysDimensionEnum.BudgetPeriod.getNumber().equals(this.getNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init() {
        if (this.isInit()) {
            return;
        }
        Class<AbstractDimension> clazz = AbstractDimension.class;
        synchronized (AbstractDimension.class) {
            this.initData();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void initData() {
        LogStats stats = new LogStats("budget-model-init-log : ");
        stats.addInfo("begin buildMembers.");
        stats.addInfo("model number = " + this.getModel().getNumber());
        stats.addInfo("dimension number = " + this.getNumber());
        stats.addInfo("version = " + this.getVersion());
        if (this.isInit()) {
            stats.addInfo("initData is end.");
            log.info(stats.toString());
            return;
        }
        LinkedList<Member> members = new LinkedList<Member>();
        ObjectCache objCache = ObjectCache.get();
        boolean isOrgUnit = this.isOrgUnit();
        boolean isAccount = this.isAccount();
        boolean isDataType = this.isDataType();
        boolean isChangeType = this.isChangeType();
        boolean isBudgetPeriod = this.isBudgetPeriod();
        boolean isExchangeRateOrg = this.isExchangeRateOrg();
        boolean isMetric = this.isMetric();
        boolean isAuditTrail = this.isAuditTrail();
        boolean isUserDefined = this.isUserDefined();
        boolean isEb = ApplicationTypeEnum.isEB(ApplicationTypeEnum.getEnumByIndex(this.getModel().getReportType()));
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)this.getModel().getId()));
        builder.add(new QFilter("dimension", "=", (Object)this.getId()));
        if (this.isInternalCompany()) {
            builder.add(new QFilter("enable", "=", (Object)"1"));
        }
        StringBuilder selectField = new StringBuilder("id, name, number, shownumber, longnumber, parent, aggoprt, level, dseq, creator, membersource, disable, enable");
        if (isAccount) {
            selectField.append(", drcrdirect");
            if (isEb) {
                selectField.append(", datatype");
            } else {
                selectField.append(", dataset, simplename");
            }
        } else if (isMetric) {
            selectField.append(", datatype, isagg, use, storagenodetail");
        } else if (isDataType && !isEb) {
            selectField.append(", datestart");
        } else if (isChangeType && !isEb) {
            selectField.append(", isPeriodDistribution");
        } else if (isAuditTrail) {
            selectField.append(", use");
        } else if (isUserDefined) {
            selectField.append(", simplename");
        }
        if (isEb) {
            selectField.append(", storagetype");
            if (isExchangeRateOrg) {
                builder.add(new QFilter("isexchangerate", "=", (Object)"0"));
            }
        } else if (isOrgUnit) {
            selectField.append(", simplename, offsetsource");
        }
        String orderBy = null;
        if (isBudgetPeriod) {
            orderBy = "longnumber";
        }
        HashSet<String> aggOprts = new HashSet<String>();
        aggOprts.add(AggOprtEnum.SUBSTRACT.getSign());
        aggOprts.add(AggOprtEnum.SKIP.getSign());
        String defaultStorageType = StorageTypeEnum.DEFAULT.getOIndex();
        this.setLang(RequestContext.get().getLang());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMember", (String)this.getMemberModel(), (String)selectField.toString(), (QFilter[])builder.toArrays(), (String)orderBy);){
            if (ds != null) {
                if (isEb) {
                    for (Row obj : ds) {
                        Member member = this.createMember();
                        member.setId(obj.getLong("id"));
                        member.setName(obj.getString("name"));
                        member.setNumber(objCache.valueOf(obj.getString("number")));
                        member.setShowNumber(objCache.valueOf(obj.getString("shownumber")));
                        member.setLongNumber(obj.getString("longnumber"));
                        member.setParentId(objCache.valueOf(obj.getLong("parent")));
                        member.setAggType(objCache.valueOf(obj.getString("aggoprt")));
                        member.setStorageType(objCache.valueOf(obj.getString("storagetype")));
                        member.setLevel(obj.getInteger("level"));
                        member.setSeq(obj.getInteger("dseq"));
                        member.setCreator(objCache.valueOf(obj.getLong("creator")));
                        member.setSource(objCache.valueOf(obj.getString("membersource")));
                        member.setDisable(obj.getBoolean("disable"));
                        member.setEnable(obj.getBoolean("enable"));
                        if (isAccount) {
                            member.setAccountDirection(obj.getString("drcrdirect"));
                            member.setDatatype(obj.getString("datatype"));
                        } else if (isMetric) {
                            member.setDatatype(obj.getString("datatype"));
                            member.setHasAgg(obj.getBoolean("isagg"));
                            member.setUse(obj.getString("use"));
                            member.setNoLeafStorage(obj.getBoolean("storagenodetail"));
                        } else if (isBudgetPeriod) {
                            member.setDatatype(this.getPeriodType(member));
                        } else if (isAuditTrail) {
                            member.setAuditTrailUse(obj.getString("use"));
                        }
                        members.add(member);
                    }
                } else {
                    for (Row obj : ds) {
                        Member member = this.createMember();
                        member.setId(obj.getLong("id"));
                        member.setName(obj.getString("name"));
                        member.setNumber(objCache.valueOf(obj.getString("number")));
                        member.setShowNumber(objCache.valueOf(obj.getString("shownumber")));
                        member.setLongNumber(obj.getString("longnumber"));
                        member.setParentId(objCache.valueOf(obj.getLong("parent")));
                        member.setAggType(objCache.valueOf(obj.getString("aggoprt")));
                        member.setStorageType(defaultStorageType);
                        member.setLevel(obj.getInteger("level"));
                        member.setSeq(obj.getInteger("dseq"));
                        member.setCreator(objCache.valueOf(obj.getLong("creator")));
                        member.setSource(objCache.valueOf(obj.getString("membersource")));
                        member.setDisable(obj.getBoolean("disable"));
                        member.setEnable(obj.getBoolean("enable"));
                        if (isMetric) {
                            member.setDatatype(obj.getString("datatype"));
                            member.setHasAgg(obj.getBoolean("isagg"));
                            member.setUse(obj.getString("use"));
                            member.setNoLeafStorage(obj.getBoolean("storagenodetail"));
                        } else if (isAccount) {
                            if (!this.isHasAgg() && aggOprts.contains(member.getAggType())) {
                                this.setHasAgg(true);
                            }
                            member.setAccountDirection(objCache.valueOf(obj.getString("drcrdirect")));
                            member.setSimpleName(objCache.valueOf(obj.getString("simplename")));
                            member.setDatasetId(objCache.valueOf(obj.getLong("dataset")));
                        } else if (isBudgetPeriod) {
                            member.setDatatype(this.getPeriodType(member));
                        } else if (isChangeType) {
                            if (!this.isHasAgg() && aggOprts.contains(member.getAggType())) {
                                this.setHasAgg(true);
                            }
                            member.setHasPeriodDistribution(obj.getBoolean("isPeriodDistribution"));
                        } else if (isAuditTrail) {
                            member.setAuditTrailUse(obj.getString("use"));
                        } else if (isExchangeRateOrg || isUserDefined) {
                            member.setSimpleName(objCache.valueOf(obj.getString("simplename")));
                        }
                        members.add(member);
                    }
                }
            }
        }
        this.buildMemberTree(members, stats);
        if (isAccount) {
            this.clearScheme();
        }
        stats.addInfo("member size = " + members.size());
        stats.addInfo("end buildMembers.");
        log.info(stats.toString());
        this.setInit(true);
        this.afterInit();
    }

    @Override
    protected String getEntityNumber() {
        return this.getMemberModel();
    }

    @Override
    protected long getModelId() {
        return this.getModel().getId();
    }

    @Override
    protected long getDimensionId() {
        return this.getId();
    }

    protected abstract void clearScheme();

    @Override
    protected void addRefNumMember(Member member) {
        if (member == null || StorageTypeEnum.SHARE.getOIndex().equals(member.getStorageType())) {
            return;
        }
        super.addRefNumMember(member);
    }

    protected boolean isOrgUnit() {
        return SysDimensionEnum.Entity.getNumber().equals(this.getNumber());
    }

    protected boolean isInternalCompany() {
        return SysDimensionEnum.InternalCompany.getNumber().equals(this.getNumber());
    }

    private boolean isAccount() {
        return SysDimensionEnum.Account.getNumber().equals(this.getNumber());
    }

    private boolean isDataType() {
        return SysDimensionEnum.DataType.getNumber().equals(this.getNumber());
    }

    protected boolean isChangeType() {
        return SysDimensionEnum.ChangeType.getNumber().equals(this.getNumber());
    }

    private boolean isBudgetPeriod() {
        return SysDimensionEnum.BudgetPeriod.getNumber().equals(this.getNumber());
    }

    protected boolean isExchangeRateOrg() {
        return SysDimensionEnum.Entity.getNumber().equals(this.getNumber());
    }

    private boolean isMetric() {
        return SysDimensionEnum.Metric.getNumber().equals(this.getNumber());
    }

    private boolean isAuditTrail() {
        return SysDimensionEnum.AuditTrail.getNumber().equals(this.getNumber());
    }

    protected boolean isUserDefined() {
        return !SysDimensionEnum.include(this.getNumber(), true);
    }

    private String getPeriodType(Member member) {
        if (member == null || member.getNumber() == null) {
            return null;
        }
        return String.valueOf(member.getLevel());
    }

    @Override
    public String getName() {
        Lang currLang = RequestContext.get().getLang();
        if (this.getModel() == null || this.getModel().getLang() == currLang) {
            return super.getName();
        }
        if (!this.getModel().getLangs().contains(currLang)) {
            this.getModel().initLang(currLang);
        }
        return this.getNames() != null ? this.getNames().get(currLang) : "";
    }
}

