/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;

public abstract class AbstractTree
extends BaseCache {
    public static final Log log = LogFactory.getLog(AbstractTree.class);
    private static final long serialVersionUID = -8072255163797510740L;
    private final Map<Long, Member> members = Maps.newLinkedHashMap();
    private Map<Long, Member> refMember = Maps.newLinkedHashMap();
    private Map<String, Member> refNumMember = Maps.newLinkedHashMap();
    private Map<Long, Member> refViewMember = Maps.newLinkedHashMap();
    private Map<String, Member> refShowNumMember = Maps.newLinkedHashMap();
    private Long version = 0L;
    protected Date createTime;
    private boolean hasAgg = false;
    private boolean isInitData = false;
    private Lang lang = null;
    private Set<Lang> langs = Sets.newHashSetWithExpectedSize((int)16);
    private Map<Lang, String> names = null;

    protected Map<Long, Member> getMembers() {
        return this.members;
    }

    protected Map<Long, Member> getRefMember() {
        return Collections.unmodifiableMap(this.refMember);
    }

    protected Map<String, Member> getRefNumMember() {
        return Collections.unmodifiableMap(this.refNumMember);
    }

    protected Map<Long, Member> getRefViewMember() {
        return Collections.unmodifiableMap(this.refViewMember);
    }

    protected Map<String, Member> getRefShowNumMember() {
        return Collections.unmodifiableMap(this.refShowNumMember);
    }

    public int getMemberSize() {
        this.init();
        return this.members.size();
    }

    public final Long getVersion() {
        return this.version;
    }

    public final void setVersion(Long version) {
        this.version = version != null ? version : Long.valueOf(0L);
        this.createTime = new Date();
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setHasAgg(boolean hasAgg) {
        this.hasAgg = hasAgg;
    }

    public boolean isHasAgg() {
        return this.hasAgg;
    }

    protected abstract void init();

    protected void afterInit() {
    }

    public String getDimNum() {
        return this.getNumber();
    }

    protected boolean isInit() {
        return this.isInitData;
    }

    protected void setInit(boolean initData) {
        this.isInitData = initData;
    }

    protected void buildMemberTree(List<Member> members, LogStats stats) {
        this.clearData();
        if (members == null || members.isEmpty()) {
            return;
        }
        this.refMember = Maps.newHashMapWithExpectedSize((int)members.size());
        this.refNumMember = Maps.newHashMapWithExpectedSize((int)members.size());
        this.refViewMember = Maps.newHashMapWithExpectedSize((int)members.size());
        this.refShowNumMember = Maps.newHashMapWithExpectedSize((int)members.size());
        for (Member member : members) {
            this.addRef(member);
        }
        for (Member member : members) {
            this.add(member, stats);
        }
    }

    protected void addMember(Member member) {
        if (member == null) {
            return;
        }
        this.addRef(member);
        this.add(member);
    }

    private void addRef(Member member) {
        if (member == null) {
            return;
        }
        this.addRefMember(member);
        this.addRefNumMember(member);
        this.addRefViewMember(member);
        this.addRefShowNumMember(member);
    }

    private void add(Member member) {
        this.add(member, null);
    }

    private void add(Member member, LogStats stats) {
        if (member == null) {
            return;
        }
        if (member.getParentId() == null || member.getParentId() == 0L) {
            this.members.put(member.getId(), member);
        } else {
            Member parent = this.refMember.get(member.getParentId());
            if (parent != null) {
                parent.addChild(member);
            } else if (stats != null) {
                stats.addInfo("add member error. parent no exists. number = " + member.getNumber() + "; parentId = " + member.getParentId());
            }
        }
    }

    protected abstract Member createMember();

    protected void addRefMember(Member member) {
        this.refMember.put(member.getId(), member);
    }

    protected void addRefNumMember(Member member) {
        this.refNumMember.put(member.getNumber(), member);
    }

    protected void addRefViewMember(Member member) {
        if (member instanceof ViewMember) {
            this.refViewMember.put(((ViewMember)member).getVid(), member);
        }
    }

    protected void addRefShowNumMember(Member member) {
        this.refShowNumMember.put(member.getShowNumber(), member);
    }

    public void reBuilder() {
        this.clearAll();
        this.init();
    }

    public void update(Map<String, Object> objectMap) {
        Object value2;
        if (objectMap == null || objectMap.isEmpty()) {
            return;
        }
        Object value = objectMap.get("fname");
        if (value instanceof String) {
            this.setName((String)value);
        }
        if ((value2 = objectMap.get("fversion")) instanceof Long) {
            this.setVersion((Long)value2);
        }
    }

    protected void clearAll() {
        this.clearData();
        this.clearOther();
    }

    protected void clearData() {
        this.members.clear();
        this.refMember.clear();
        this.refNumMember.clear();
        this.refViewMember.clear();
        this.refShowNumMember.clear();
        this.langs = Sets.newHashSetWithExpectedSize((int)16);
        this.isInitData = false;
    }

    protected void clearOther() {
    }

    public List<Member> getRootMember() {
        this.init();
        Map<Long, Member> memberMap = this.getMembers();
        ArrayList members = Lists.newArrayListWithExpectedSize((int)memberMap.size());
        members.addAll(memberMap.values());
        return Collections.unmodifiableList(members);
    }

    public Member getMember(String memberNumber) {
        if (memberNumber == null) {
            return null;
        }
        this.init();
        return this.refNumMember.get(memberNumber);
    }

    public Member getMemberByShowNumber(String memberShowNumber) {
        if (memberShowNumber == null) {
            return null;
        }
        this.init();
        return this.refShowNumMember.get(memberShowNumber);
    }

    public Member getMemberByNoView(String memberNumber) {
        if (memberNumber == null) {
            return null;
        }
        this.init();
        return this.refNumMember.get(memberNumber);
    }

    public List<Member> getMemberByNoView(Collection<String> memberNumbers) {
        if (memberNumbers == null || memberNumbers.isEmpty()) {
            return Collections.emptyList();
        }
        this.init();
        ArrayList<Member> members = new ArrayList<Member>(memberNumbers.size());
        for (String memberNumber : memberNumbers) {
            Member member = this.refNumMember.get(memberNumber);
            if (member == null) continue;
            members.add(member);
        }
        return members;
    }

    public Member getMember(Long memberId) {
        if (memberId == null || memberId == 0L) {
            return null;
        }
        this.init();
        return this.refMember.get(memberId);
    }

    public Member getMemberByVid(Long vId) {
        if (vId == null || vId == 0L) {
            return null;
        }
        this.init();
        return this.refViewMember.get(vId);
    }

    public List<Member> getMember(Collection<String> memberNumbers) {
        if (memberNumbers == null || memberNumbers.isEmpty()) {
            return Collections.emptyList();
        }
        this.init();
        ArrayList<Member> members = new ArrayList<Member>(memberNumbers.size());
        for (String memberNumber : memberNumbers) {
            Member member = this.refNumMember.get(memberNumber);
            if (member == null) continue;
            members.add(member);
        }
        return members;
    }

    public List<Member> getMembers(Collection<Long> memberIds) {
        if (memberIds == null || memberIds.isEmpty()) {
            return Collections.emptyList();
        }
        this.init();
        ArrayList<Member> members = new ArrayList<Member>(memberIds.size());
        for (Long memberId : memberIds) {
            Member member = this.refMember.get(memberId);
            if (member == null) continue;
            members.add(member);
        }
        return members;
    }

    public List<Long> getMemberId(Collection<String> memberNumbers) {
        if (memberNumbers == null || memberNumbers.isEmpty()) {
            return Collections.emptyList();
        }
        this.init();
        ArrayList<Long> members = new ArrayList<Long>(memberNumbers.size());
        for (String memberNumber : memberNumbers) {
            Member member = this.refNumMember.get(memberNumber);
            if (member == null) continue;
            members.add(member.getId());
        }
        return members;
    }

    public List<Member> getMemberByIds(Collection<Long> memberIds) {
        if (memberIds == null || memberIds.isEmpty()) {
            return Collections.emptyList();
        }
        this.init();
        ArrayList members = Lists.newArrayListWithExpectedSize((int)memberIds.size());
        for (Long memberId : memberIds) {
            Member member = this.refMember.get(memberId);
            if (member == null) continue;
            members.add(member);
        }
        return members;
    }

    public List<Member> getMemberByNumbers(Collection<String> memberNumbers) {
        if (memberNumbers == null || memberNumbers.isEmpty()) {
            return Collections.emptyList();
        }
        this.init();
        ArrayList members = Lists.newArrayListWithExpectedSize((int)memberNumbers.size());
        for (String memberNumber : memberNumbers) {
            Member member = this.refNumMember.get(memberNumber);
            if (member == null) continue;
            members.add(member);
        }
        return members;
    }

    public Map<String, Member> getAllMemberMap() {
        this.init();
        Map<String, Member> refNumMember = this.getRefNumMember();
        return Collections.unmodifiableMap(refNumMember);
    }

    public List<Member> getAllMembers() {
        this.init();
        LinkedList<Member> members = new LinkedList<Member>();
        for (Member member : this.members.values()) {
            members.addAll(member.getAllMembers());
        }
        return Collections.unmodifiableList(members);
    }

    public List<Member> getAllMembersByDataSetId(Long datasetId) {
        if (datasetId == null || datasetId == 0L) {
            return Collections.emptyList();
        }
        this.init();
        LinkedList<Member> members = new LinkedList<Member>();
        if (SysDimensionEnum.Account.getNumber().equals(this.getNumber())) {
            for (Member value : this.members.values()) {
                members.addAll(value.getAllMembers());
            }
            Optional<Member> first = members.stream().filter(m -> SysDimensionEnum.Account.getNumber().equals(m.getNumber())).findFirst();
            if (!members.isEmpty()) {
                members.removeIf(e -> !datasetId.equals(e.getDatasetId()));
            }
            if (first.isPresent()) {
                Member rootMember = first.get();
                List<Member> children = rootMember.getChildren();
                children = children.stream().filter(m -> datasetId.equals(m.getDatasetId())).collect(Collectors.toList());
                rootMember = (Member)rootMember.clone();
                rootMember.setChildren(children);
                members.add(rootMember);
            }
        } else {
            throw new KDBizException("unable to support not account dimension.");
        }
        return Collections.unmodifiableList(members);
    }

    public List<Member> getAllMembers(int level) {
        this.init();
        LinkedList<Member> members = new LinkedList<Member>();
        for (Member member : this.refMember.values()) {
            members.addAll(member.getAllMembers(level));
        }
        return Collections.unmodifiableList(members);
    }

    public List<Member> getLeafMembers() {
        this.init();
        LinkedList<Member> members = new LinkedList<Member>();
        for (Member member : this.members.values()) {
            if (member.isLeaf()) {
                members.add(member);
                continue;
            }
            members.addAll(member.getLeaf());
        }
        return Collections.unmodifiableList(members);
    }

    public List<Member> getLeafMembers(Set<Long> memberIds) {
        if (memberIds == null || memberIds.isEmpty()) {
            return Collections.emptyList();
        }
        this.init();
        LinkedList<Member> members = new LinkedList<Member>();
        for (Long memberId : memberIds) {
            Member member = this.refMember.get(memberId);
            if (member == null) continue;
            if (member.isLeaf()) {
                members.add(member);
                continue;
            }
            members.addAll(member.getLeaf());
        }
        return members;
    }

    public Set<String> getLeaf(Set<String> numbers) {
        if (numbers == null || numbers.isEmpty()) {
            return Collections.emptySet();
        }
        this.init();
        LinkedHashSet<String> leaves = new LinkedHashSet<String>();
        for (String number : numbers) {
            Member member = this.getMember(number);
            if (member == null) continue;
            List<Member> children = member.getLeaf();
            leaves.addAll(children.stream().map(BaseCache::getNumber).collect(Collectors.toList()));
        }
        return leaves;
    }

    public Set<String> getLeaf(Set<String> numbers, Long datasetId) {
        if (numbers == null || numbers.isEmpty()) {
            return Collections.emptySet();
        }
        this.init();
        LinkedHashSet<String> leaves = new LinkedHashSet<String>();
        boolean isCheckDataset = IDUtils.isNotEmptyLong(datasetId);
        for (String number : numbers) {
            Member member = this.getMember(number);
            if (member == null || isCheckDataset && !datasetId.equals(member.getDatasetId())) continue;
            List<Member> children = member.getLeaf();
            leaves.addAll(children.stream().map(BaseCache::getNumber).collect(Collectors.toList()));
        }
        return leaves;
    }

    public List<Member> getParents(String memberNumber) {
        if (memberNumber == null) {
            return Collections.emptyList();
        }
        this.init();
        LinkedList<Member> members = new LinkedList<Member>();
        Map<String, Member> refNumMember = this.getRefNumMember();
        Member member = refNumMember.get(memberNumber);
        if (member != null) {
            Map<Long, Member> refMember = this.getRefMember();
            this.getParents(member, members, refMember);
        }
        return members;
    }

    public List<Member> getParents(Long memberId) {
        if (IDUtils.isNull(memberId)) {
            return Collections.emptyList();
        }
        this.init();
        LinkedList<Member> parents = new LinkedList<Member>();
        Member member = this.getRefMember().get(memberId);
        if (member != null) {
            this.getParents(member, parents, this.getRefMember());
        }
        return parents;
    }

    private void getParents(Member member, List<Member> members, Map<Long, Member> refMember) {
        Member parent;
        if (member == null || members == null || refMember == null) {
            return;
        }
        if (member.getParentId() != null && member.getParentId() != 0L && (parent = refMember.get(member.getParentId())) != null) {
            members.add(parent);
            this.getParents(parent, members, refMember);
        }
    }

    public List<Member> getAllMemberSort() {
        this.init();
        LinkedList<Member> members = new LinkedList<Member>();
        for (Member member : this.getMembers().values()) {
            members.addAll(member.getAllMembers());
        }
        List collect = members.stream().sorted(Comparator.comparing(BaseCache::getSeq)).sorted(Comparator.comparing(Member::getLevel)).collect(Collectors.toList());
        return Collections.unmodifiableList(collect);
    }

    @Deprecated
    public Collection<Member> getViewMember() {
        return Collections.emptyList();
    }

    protected void setLang(Lang lang) {
        this.lang = lang;
    }

    protected Lang getLang() {
        return this.lang;
    }

    protected Set<Lang> getLangs() {
        return this.langs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initLang(Lang lang) {
        if (lang == null || this.getLangs().contains(lang)) {
            return;
        }
        if (this.getLangs().add(lang)) {
            LogStats stats = new LogStats("member-log:");
            stats.addInfo("begin-init-dimension:" + this.getNumber() + ",lang:" + lang);
            try {
                DynamicObjectCollection members = QueryServiceHelper.query((String)this.getEntityNumber(), (String)this.getFields(), (QFilter[])this.getBuilder().toArray());
                for (DynamicObject _member : members) {
                    Member member = this.getRefMember().get(_member.getLong("id"));
                    if (member == null) continue;
                    member.addName(lang, _member.getString("name"));
                }
            }
            catch (Throwable ex) {
                log.error(CommonServiceHelper.getStackTraceStr(ex));
            }
            finally {
                stats.add("end-init-lang.");
                log.info(stats.toString());
            }
        }
    }

    protected abstract String getEntityNumber();

    protected String getFields() {
        return "id,name";
    }

    protected QFBuilder getBuilder() {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", this.getModelId());
        builder.add("dimension", "=", this.getDimensionId());
        return builder;
    }

    protected abstract long getModelId();

    protected abstract long getDimensionId();

    public void addName(Lang lang, String name) {
        if (lang == null || name == null) {
            return;
        }
        if (this.names == null) {
            this.names = new HashMap<Lang, String>();
        }
        this.names.put(lang, name);
    }

    protected Map<Lang, String> getNames() {
        return this.names;
    }
}

