/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.impl.AbstractTree;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.cache.utils.ObjectCache;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractView
extends AbstractTree {
    private static final Log log = LogFactory.getLog(AbstractView.class);
    private Model model = null;
    private Dimension dimension = null;
    private String source = null;
    private String usage = null;
    private Long viewGroupId = null;
    public static final String VIEW_FIELDS = "id,number,name,source,usage,version,viewgroup.id";

    public void setModel(Model model) {
        this.model = model;
    }

    public Model getModel() {
        return this.model;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setViewGroupId(Long viewGroupId) {
        this.viewGroupId = viewGroupId;
    }

    public Long getViewGroupId() {
        return this.viewGroupId;
    }

    public AbstractView() {
    }

    public AbstractView(Long viewId) {
        DynamicObject view = BusinessDataServiceHelper.loadSingleFromCache((Object)viewId, (String)"eb_dimensionview", (String)VIEW_FIELDS);
        if (view == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u89c6\u56fe\u4e0d\u5b58\u5728\uff0c\u89c6\u56feid\u4e3a\uff1a%1", (String)"AbstractView_0", (String)"epm-eb-common", (Object[])new Object[]{viewId}));
        }
        this.setId(view.getLong("id"));
        this.setName(view.getString("name"));
        this.setNumber(view.getString("number"));
        this.source = view.getString("source");
        this.usage = view.getString("usage");
        this.viewGroupId = view.getLong("viewgroup.id");
        this.setVersion(view.getLong("version"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init() {
        if (this.isInit()) {
            return;
        }
        Class<AbstractView> clazz = AbstractView.class;
        synchronized (AbstractView.class) {
            this.initData();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void initData() {
        if (this.getId() == null) {
            throw new KDBizException("view init error. viewId is null.");
        }
        if (this.getModel() == null || this.getModel().getId() == null) {
            throw new KDBizException("view init error. model is null.");
        }
        Dimension dimension = this.getDimension();
        if (dimension == null || dimension.getId() == null) {
            throw new KDBizException("view init error. dimension is null.");
        }
        LogStats stats = new LogStats("budget-data-log : ");
        stats.addInfo("begin buildMembers.");
        stats.addInfo("model number = " + this.getModel().getNumber());
        stats.addInfo("dimension number = " + dimension.getNumber());
        stats.addInfo("view id = " + this.getId());
        if (this.isInit()) {
            stats.addInfo("initData is end.");
            log.info(stats.toString());
            return;
        }
        boolean hasSimpleName = Dimension.hasSimpleName(dimension.getMemberModel());
        LinkedList members = Lists.newLinkedList();
        ObjectCache objCache = ObjectCache.get();
        LinkedHashMap viewMemberMap = Maps.newLinkedHashMap();
        LinkedHashMap viewIdMap = Maps.newLinkedHashMap();
        this.setLang(RequestContext.get().getLang());
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", this.getModel().getId());
        builder.add("dimension", "=", dimension.getId());
        builder.add("view", "=", this.getId());
        if (SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) {
            builder.add("enable", "=", "1");
        }
        String fields = "id,memberid,refview,number,name,shownumber,longnumber,level,parent.id,aggoprt,dseq,disable,membersource";
        if (hasSimpleName) {
            fields = fields + ",simplename";
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryViewMember", (String)"eb_viewmember", (String)fields, (QFilter[])builder.toArray(), null);){
            if (ds != null) {
                for (Row obj : ds) {
                    Long refViewId;
                    Long id = objCache.valueOf(obj.getLong("id"));
                    Long memberId = obj.getLong("memberid");
                    Long parentId = objCache.valueOf(obj.getLong("parent.id"));
                    viewIdMap.put(id, memberId);
                    Member member = this.createMember();
                    member.setId(memberId);
                    member.setName(obj.getString("name"));
                    member.setNumber(objCache.valueOf(obj.getString("number")));
                    member.setShowNumber(objCache.valueOf(obj.getString("shownumber")));
                    member.setLongNumber(obj.getString("longnumber"));
                    member.setLevel(obj.getInteger("level"));
                    member.setParentId(objCache.valueOf(parentId));
                    member.setAggType(objCache.valueOf(obj.getString("aggoprt")));
                    member.setSeq(obj.getInteger("dseq"));
                    member.setDisable(obj.getBoolean("disable"));
                    member.setSource(objCache.valueOf(obj.getString("membersource")));
                    if (hasSimpleName) {
                        member.setSimpleName(objCache.valueOf(obj.getString("simplename")));
                    }
                    if (IDUtils.isNotEmptyLong(refViewId = obj.getLong("refview")).booleanValue()) {
                        member.setRefViewId(refViewId);
                    }
                    if (member instanceof ViewMember) {
                        ((ViewMember)member).setVId(id);
                    }
                    members.add(member);
                    viewMemberMap.put(member.getId(), member);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)members)) {
            for (Member _member : members) {
                _member.setParentId(viewIdMap.getOrDefault(_member.getParentId(), 0L));
            }
        }
        if (dimension.isChangeType() && !viewMemberMap.isEmpty()) {
            this.handleMemberSpecialField(viewMemberMap);
        }
        this.buildMemberTree(members, stats);
        stats.addInfo("member size = " + this.getRefMember().size());
        stats.addInfo("end buildMembers.");
        log.info(stats.toString());
        this.setInit(true);
        this.afterInit();
    }

    private void handleMemberSpecialField(Map<Long, Member> viewMemberMap) {
        Dimension dimension = this.getDimension();
        boolean isChangeType = dimension.isChangeType();
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)this.getModel().getId()));
        builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        builder.add(new QFilter("id", "in", (Object)viewMemberMap.values().stream().map(BaseCache::getId).distinct().toArray()));
        StringBuilder selectField = new StringBuilder("id");
        if (isChangeType) {
            selectField.append(", isPeriodDistribution");
        }
        HashSet<String> aggOprts = new HashSet<String>();
        aggOprts.add(AggOprtEnum.SUBSTRACT.getSign());
        aggOprts.add(AggOprtEnum.SKIP.getSign());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"loadMember", (String)this.dimension.getMemberModel(), (String)selectField.toString(), (QFilter[])builder.toArrays(), null);){
            if (ds != null) {
                for (Row obj : ds) {
                    Long id = obj.getLong("id");
                    if (!viewMemberMap.containsKey(id)) continue;
                    Member member = viewMemberMap.get(id);
                    if (!isChangeType) continue;
                    if (!this.isHasAgg() && aggOprts.contains(member.getAggType())) {
                        this.setHasAgg(true);
                    }
                    member.setHasPeriodDistribution(obj.getBoolean("isPeriodDistribution"));
                }
            }
        }
    }

    @Override
    public String getDimNum() {
        return this.getDimension().getDimNum();
    }

    @Override
    protected String getEntityNumber() {
        return "eb_viewmember";
    }

    @Override
    protected String getFields() {
        return "memberid as id,name";
    }

    @Override
    protected QFBuilder getBuilder() {
        QFBuilder builder = super.getBuilder();
        builder.add("view", "=", this.getId());
        return builder;
    }

    @Override
    protected long getModelId() {
        return this.getDimension().getModel().getId();
    }

    @Override
    protected long getDimensionId() {
        return this.getDimension().getId();
    }
}

