/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.impl;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.impl.Dimension;

public class Dataset
implements Serializable {
    private static final long serialVersionUID = -1519547396994405910L;
    public static final Log log = LogFactory.getLog(Dataset.class);
    private Long id;
    private String number;
    private String name;
    private List<String> dimensionList;
    private long busModelId;
    private Map<String, Long> viewMap;
    private Map<String, Long> includeBaseViewMap;
    private String cubeNumber;
    private Map<String, List<Long>> viewGroupViewsMap;
    private Map<Long, List<Long>> viewGroupViewsMapByDimId;
    private List<Long> dimensionIdList;
    private Map<String, Long> viewGroupMap;
    private Map<Integer, Dimension> dimensionMap = new TreeMap<Integer, Dimension>((Comparator & Serializable)(o1, o2) -> o1 - o2);
    private Map<String, Long> viewIds = Maps.newHashMapWithExpectedSize((int)16);

    public Dataset() {
    }

    public Dataset(Long id, String number) {
        this.id = id;
        this.number = number;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getNumber() {
        return this.number;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setBusModelId(long busModelId) {
        this.busModelId = busModelId;
    }

    public long getBusModelId() {
        return this.busModelId;
    }

    public void setDimensionList(List<String> dimensionList) {
        this.dimensionList = dimensionList;
        if (dimensionList != null) {
            log.info("budget-cache-log : " + String.format("id=%s; dataset-dimension-size=%s", this.getId(), dimensionList.size()));
        }
    }

    public List<String> getDimensionList() {
        return Collections.unmodifiableList(this.dimensionList);
    }

    public void setViewMap(Map<String, Long> viewMap) {
        this.viewMap = viewMap;
    }

    public Map<String, Long> getViewMap() {
        return this.viewMap;
    }

    public void setIncludeBaseViewMap(Map<String, Long> includeBaseViewMap) {
        this.includeBaseViewMap = includeBaseViewMap;
    }

    public Map<String, Long> getIncludeBaseViewMap() {
        return this.includeBaseViewMap;
    }

    public void setCubeNumber(String cubeNumber) {
        this.cubeNumber = cubeNumber;
    }

    public String getCubeNumber() {
        return this.cubeNumber;
    }

    public Map<String, List<Long>> getViewGroupViewsMap() {
        return this.viewGroupViewsMap;
    }

    public void setViewGroupViewsMap(Map<String, List<Long>> viewGroupViewsMap) {
        this.viewGroupViewsMap = viewGroupViewsMap;
    }

    public Map<Long, List<Long>> getViewGroupViewsMapByDimId() {
        return this.viewGroupViewsMapByDimId;
    }

    public void setViewGroupViewsMapByDimId(Map<Long, List<Long>> viewGroupViewsMapByDimId) {
        this.viewGroupViewsMapByDimId = viewGroupViewsMapByDimId;
    }

    public List<Long> getDimensionIdList() {
        return this.dimensionIdList;
    }

    public void setDimensionIdList(List<Long> dimensionIdList) {
        this.dimensionIdList = dimensionIdList;
    }

    public Map<String, Long> getViewGroupMap() {
        return this.viewGroupMap;
    }

    public void setViewGroupMap(Map<String, Long> viewGroupMap) {
        this.viewGroupMap = viewGroupMap;
    }

    public List<String> getDimensions() {
        ArrayList dimNumbers = new ArrayList(16);
        this.dimensionMap.values().forEach(f -> dimNumbers.add(f.getNumber()));
        return Collections.unmodifiableList(dimNumbers);
    }

    public void addDimension(Dimension dimension) {
        if (dimension != null) {
            this.dimensionMap.put(dimension.getSeq(), dimension);
        }
    }

    public void addViewIds(Map<String, Long> viewIds) {
        if (viewIds == null || viewIds.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Long> entry : viewIds.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getValue() == 0L) continue;
            viewIds.put(entry.getKey(), entry.getValue());
        }
    }

    public Long getViewId(String dimensionNumber) {
        return this.viewIds.get(dimensionNumber);
    }

    public static Dataset of(DynamicObject dataset) {
        DynamicObjectCollection entrys;
        if (dataset == null) {
            return null;
        }
        Dataset _dataset = new Dataset();
        _dataset.setId(dataset.getLong("id"));
        _dataset.setNumber(dataset.getString("number"));
        if (dataset.getDataEntityType().getProperties().containsKey((Object)"name")) {
            _dataset.setName(dataset.getString("name"));
        }
        if (dataset.getDataEntityType().getProperties().get((Object)"entryentity") != null && (entrys = dataset.getDynamicObjectCollection("entryentity")) != null && !entrys.isEmpty()) {
            for (DynamicObject entry : entrys) {
                DynamicObject _dimension = entry.getDynamicObject("datasetdim");
                if (_dimension == null) continue;
                Dimension dimension = new Dimension();
                dimension.setId(_dimension.getLong("id"));
                dimension.setNumber(_dimension.getString("number"));
                dimension.setSeq(_dimension.getInt("dseq"));
                _dataset.addDimension(dimension);
            }
        }
        return _dataset;
    }

    public static List<Dataset> of(DynamicObjectCollection datasets) {
        if (datasets == null || datasets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Dataset> _datasets = new ArrayList<Dataset>(datasets.size());
        for (DynamicObject obj : datasets) {
            Dataset dataset = Dataset.of(obj);
            if (dataset == null) continue;
            _datasets.add(dataset);
        }
        return _datasets;
    }

    public static List<Dataset> of(Map<Object, DynamicObject> datasetMap) {
        if (datasetMap == null) {
            return null;
        }
        ArrayList<Dataset> datasets = new ArrayList<Dataset>(datasetMap.size());
        for (DynamicObject obj : datasetMap.values()) {
            Dataset dataset = Dataset.of(obj);
            if (dataset == null) continue;
            datasets.add(dataset);
        }
        return datasets;
    }
}

