/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.common.cache.impl.AbstractDimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public final class Dimension
extends AbstractDimension {
    private static final long serialVersionUID = -3290820211595208979L;
    public static final Set<String> DISABLE_DIMS = new HashSet<String>();
    private static final Set<String> SIMPLE_NAME_DIMS = new HashSet<String>();
    private transient Boolean userDefinedDim = null;
    private Long defaultViewId = 0L;
    private List<Long> viewList = new ArrayList<Long>(16);
    private Map<Long, View> views = new Hashtable<Long, View>();
    private Map<Long, Map<Long, String>> rates = null;
    private transient String noneNumber = null;

    public boolean hasUserDefinedDim() {
        if (this.userDefinedDim == null) {
            this.userDefinedDim = StringUtils.equals("epm_userdefinedmembertree", this.getMemberModel());
        }
        return this.userDefinedDim;
    }

    public static boolean hasDisable(String memberModel) {
        return DISABLE_DIMS.contains(memberModel);
    }

    public static boolean hasSimpleName(String memberModel) {
        return SIMPLE_NAME_DIMS.contains(memberModel);
    }

    public List<Long> getViewList() {
        return this.viewList;
    }

    public void setViewList(List<Long> viewList) {
        this.viewList = viewList;
    }

    public Map<Long, View> getViews() {
        return this.views;
    }

    public View getView(Long viewId) {
        if (this.getModel().isModelByEB()) {
            return null;
        }
        if (viewId == null || viewId == 0L) {
            viewId = this.getDefaultViewId();
        }
        if (viewId == 0L) {
            return null;
        }
        Long finalViewId = viewId;
        return this.getViews().computeIfAbsent(viewId, k -> {
            View v = new View(finalViewId);
            v.setModel(this.getModel());
            v.setDimension(this);
            return v;
        });
    }

    public Set<String> getLeaf(Long viewId, Set<String> numbers) {
        View view = this.getView(viewId);
        return view != null ? view.getLeaf(numbers) : this.getLeaf(numbers);
    }

    @Override
    protected void clearData() {
        super.clearData();
        if (this.rates != null) {
            this.rates = null;
        }
    }

    @Override
    protected void clearOther() {
        super.clearOther();
        this.views.clear();
    }

    @Override
    public void clearScheme() {
        if (this.rates != null) {
            this.rates = null;
        }
    }

    public Map<Long, String> getMemberRate(Long memberId) {
        if (this.rates == null || this.rates.isEmpty()) {
            this.initRate();
        }
        return this.rates.get(memberId);
    }

    private synchronized void initRate() {
        if (this.rates == null || this.rates.isEmpty()) {
            this.init();
            this.rates = new HashMap<Long, Map<Long, String>>();
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fid,fmetric,fchange from t_eb_accountmetric where ", new Object[0]).appendIn("fid", this.getRefMember().keySet().toArray());
            DB.query((DBRoute)BgBaseConstant.epm, (SqlBuilder)sql, rs -> {
                while (rs.next()) {
                    Long accountId = rs.getLong("fid");
                    Long metricId = rs.getLong("fmetric");
                    String rate = rs.getString("fchange");
                    this.rates.computeIfAbsent(accountId, v -> new HashMap()).put(metricId, rate);
                }
                return null;
            });
        }
    }

    @Override
    protected Member createMember() {
        return new Member(this);
    }

    public String getNoneNumber() {
        if (this.noneNumber == null) {
            this.noneNumber = this.getShortNumber() + "None";
        }
        return this.noneNumber;
    }

    @Override
    public Object clone() {
        Dimension dimension = (Dimension)super.clone();
        dimension.setShortNumber(this.getShortNumber());
        dimension.setFieldMapped(this.getFieldMapped());
        dimension.setMemberModel(this.getMemberModel());
        dimension.setPreset(this.isPreset());
        Date createTime = this.getCreateTime();
        dimension.setVersion(this.getVersion());
        dimension.setCreateTime(createTime);
        Member _memClone = null;
        for (Member member : this.getMembers().values()) {
            _memClone = (Member)member.clone();
            dimension.addMember(_memClone);
        }
        return dimension;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getId() == null || this.getNumber() == null) {
            return false;
        }
        if (obj instanceof Dimension) {
            Dimension _dimension = (Dimension)obj;
            if (_dimension.getId() == null || _dimension.getNumber() == null) {
                return false;
            }
            if (this.getId().compareTo(_dimension.getId()) == 0 && this.getNumber().equals(_dimension.getNumber())) {
                return true;
            }
        }
        return false;
    }

    public List<Member> getAllMembersOnSameLevel(int level) {
        Member member;
        int currentLevel;
        Member rootMemb = this.getMember(this.getNumber());
        LinkedList<Member> membList = new LinkedList<Member>();
        LinkedList<Member> levelMemb = new LinkedList<Member>();
        membList.add(rootMemb);
        while (!membList.isEmpty() && (currentLevel = (member = (Member)membList.removeFirst()).getLevel()) <= level) {
            if (currentLevel == level) {
                levelMemb.add(member);
                continue;
            }
            if (currentLevel == level - 1) {
                levelMemb.addAll(member.getChildren(true));
                continue;
            }
            membList.addAll(member.getChildren(true));
        }
        return levelMemb;
    }

    public List<Member> getAllMembers(Long viewId) {
        View view = this.getView(viewId);
        if (view != null) {
            return view.getAllMembers();
        }
        return this.getAllMembers();
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        return 0;
    }

    public boolean isKeepTree() {
        return true;
    }

    public boolean hasWeight() {
        return SysDimensionEnum.Account.getNumber().equals(this.getNumber()) || SysDimensionEnum.ChangeType.getNumber().equals(this.getNumber()) || SysDimensionEnum.Entity.getNumber().equals(this.getNumber()) || SysDimensionEnum.AuditTrail.getNumber().equals(this.getNumber()) || SysDimensionEnum.InternalCompany.getNumber().equals(this.getNumber()) || "epm_userdefinedmembertree".equals(this.getMemberModel());
    }

    public boolean hasAggregate() {
        return SysDimensionEnum.Metric.getNumber().equals(this.getNumber());
    }

    public boolean hasProperty() {
        return SysDimensionEnum.BudgetPeriod.getNumber().equals(this.getNumber());
    }

    public boolean hasCustomProperty() {
        return SysDimensionEnum.Entity.getNumber().equals(this.getNumber()) || !this.isPreset();
    }

    public Long getDefaultViewId() {
        return this.defaultViewId;
    }

    public void setDefaultViewId(Long defaultViewId) {
        this.defaultViewId = defaultViewId;
    }

    @Override
    public List<Member> getAllMembers() {
        View view;
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getAllMembers();
        }
        return super.getAllMembers();
    }

    @Override
    public int getMemberSize() {
        View view;
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getMemberSize();
        }
        return super.getMemberSize();
    }

    @Override
    public List<Member> getRootMember() {
        View view;
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getRootMember();
        }
        return super.getRootMember();
    }

    @Override
    @Deprecated
    public Member getMember(String memberNumber) {
        View view;
        if (memberNumber == null) {
            return null;
        }
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getMember(memberNumber);
        }
        return super.getMember(memberNumber);
    }

    public Member getMember(Long viewId, String member) {
        View view = this.getView(viewId);
        return view != null ? view.getMember(member) : this.getMember(member);
    }

    @Override
    public Member getMemberByShowNumber(String memberShowNumber) {
        View view;
        if (memberShowNumber == null) {
            return null;
        }
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getMemberByShowNumber(memberShowNumber);
        }
        return super.getMemberByShowNumber(memberShowNumber);
    }

    @Override
    public Member getMemberByNoView(String memberNumber) {
        View view;
        if (memberNumber == null) {
            return null;
        }
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getMemberByNoView(memberNumber);
        }
        return super.getMemberByNoView(memberNumber);
    }

    @Override
    public List<Member> getMemberByNoView(Collection<String> memberNumbers) {
        View view;
        if (memberNumbers == null || memberNumbers.isEmpty()) {
            return Collections.emptyList();
        }
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getMemberByNoView(memberNumbers);
        }
        return super.getMemberByNoView(memberNumbers);
    }

    @Override
    @Deprecated
    public Member getMember(Long memberId) {
        View view;
        if (memberId == null || memberId == 0L) {
            return null;
        }
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getMember(memberId);
        }
        return super.getMember(memberId);
    }

    public Member getMember(Long viewId, Long memberId) {
        View view = this.getView(viewId);
        return view != null ? view.getMember(memberId) : this.getMember(memberId);
    }

    public Member getStructOfMember(Long memberId) {
        if (memberId == null || memberId == 0L) {
            return null;
        }
        return super.getMember(memberId);
    }

    public Member getStructOfMember(String memberNumber) {
        return super.getMember(memberNumber);
    }

    public List<Member> getStructOfMember(Collection<Long> memberIds) {
        if (memberIds == null || memberIds.isEmpty()) {
            return Collections.emptyList();
        }
        return super.getMemberByIds(memberIds);
    }

    @Override
    @Deprecated
    public List<Member> getMember(Collection<String> memberNumbers) {
        View view;
        if (memberNumbers == null || memberNumbers.isEmpty()) {
            return Collections.emptyList();
        }
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getMember(memberNumbers);
        }
        return super.getMember(memberNumbers);
    }

    @Override
    @Deprecated
    public List<Member> getMemberByNumbers(Collection<String> memberNumbers) {
        View view;
        if (memberNumbers == null || memberNumbers.isEmpty()) {
            return Collections.emptyList();
        }
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getMemberByNumbers(memberNumbers);
        }
        return super.getMemberByNumbers(memberNumbers);
    }

    public List<Member> getMemberByNumbers(Long viewId, Collection<String> memberNumbers) {
        View view = this.getView(viewId);
        return view != null ? view.getMemberByNumbers(memberNumbers) : this.getMemberByNumbers(memberNumbers);
    }

    @Override
    @Deprecated
    public List<Member> getMembers(Collection<Long> memberIds) {
        return this.getMembers(memberIds, this.defaultViewId);
    }

    public List<Member> getMember(Long viewId, Collection<Long> memberIds) {
        View view = this.getView(viewId);
        return view != null ? view.getMemberByIds(memberIds) : this.getMemberByIds(memberIds);
    }

    public List<Member> getMembers(Collection<Long> memberIds, Long viewId) {
        View view;
        if (memberIds == null || memberIds.isEmpty()) {
            return Collections.emptyList();
        }
        if (IDUtils.isNotEmptyLong(viewId).booleanValue() && (view = this.getView(viewId)) != null) {
            return view.getMembers(memberIds);
        }
        return super.getMembers(memberIds);
    }

    @Override
    @Deprecated
    public List<Long> getMemberId(Collection<String> memberNumbers) {
        View view;
        if (memberNumbers == null || memberNumbers.isEmpty()) {
            return Collections.emptyList();
        }
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getMemberId(memberNumbers);
        }
        return super.getMemberId(memberNumbers);
    }

    public List<Long> getMemberId(Long viewId, Collection<String> memberNumbers) {
        View view = this.getView(viewId);
        if (view != null) {
            return view.getMemberId(memberNumbers);
        }
        return super.getMemberId(memberNumbers);
    }

    @Override
    @Deprecated
    public List<Member> getMemberByIds(Collection<Long> memberIds) {
        View view;
        if (memberIds == null || memberIds.isEmpty()) {
            return Collections.emptyList();
        }
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getMemberByIds(memberIds);
        }
        return super.getMemberByIds(memberIds);
    }

    public Map<String, Member> getAllMemberMap(Long viewId) {
        View view;
        if (IDUtils.isNotEmptyLong(viewId).booleanValue() && (view = this.getView(viewId)) != null) {
            return view.getAllMemberMap();
        }
        return super.getAllMemberMap();
    }

    @Override
    public List<Member> getAllMembers(int level) {
        View view;
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getAllMembers(level);
        }
        return super.getAllMembers(level);
    }

    public List<Member> getLeafMembers(Long viewId) {
        View view;
        if (IDUtils.isNotEmptyLong(viewId).booleanValue() && (view = this.getView(viewId)) != null) {
            return view.getLeafMembers();
        }
        return super.getLeafMembers();
    }

    @Override
    public List<Member> getLeafMembers() {
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue()) {
            return this.getLeafMembers(this.defaultViewId);
        }
        return super.getLeafMembers();
    }

    @Override
    public List<Member> getLeafMembers(Set<Long> memberIds) {
        View view;
        if (memberIds == null || memberIds.isEmpty()) {
            return Collections.emptyList();
        }
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getLeafMembers(memberIds);
        }
        return super.getLeafMembers(memberIds);
    }

    @Override
    public Set<String> getLeaf(Set<String> numbers) {
        View view;
        if (numbers == null || numbers.isEmpty()) {
            return Collections.emptySet();
        }
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getLeaf(numbers);
        }
        return super.getLeaf(numbers);
    }

    @Override
    public List<Member> getParents(String memberNumber) {
        View view;
        if (memberNumber == null) {
            return Collections.emptyList();
        }
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getParents(memberNumber);
        }
        return super.getParents(memberNumber);
    }

    @Override
    public List<Member> getParents(Long memberId) {
        View view;
        if (IDUtils.isNull(memberId)) {
            return Collections.emptyList();
        }
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getParents(memberId);
        }
        return super.getParents(memberId);
    }

    @Override
    public List<Member> getAllMemberSort() {
        View view;
        if (IDUtils.isNotEmptyLong(this.defaultViewId).booleanValue() && (view = this.getView(this.defaultViewId)) != null) {
            return view.getAllMemberSort();
        }
        return super.getAllMemberSort();
    }

    public Map<Long, List<Member>> getAllMemberMapByAllView() {
        LinkedHashMap allMemberMap = Maps.newLinkedHashMap();
        List<Long> viewList = this.getViewList();
        if (CollectionUtils.isEmpty(viewList)) {
            List<Member> allMembers = this.getAllMembers();
            allMemberMap.put(0L, allMembers);
            return Collections.unmodifiableMap(allMemberMap);
        }
        for (Long viewId : viewList) {
            View view = this.getView(viewId);
            if (view == null) continue;
            allMemberMap.put(viewId, view.getAllMembers());
        }
        return Collections.unmodifiableMap(allMemberMap);
    }

    public List<Member> getAllMembersByAllView() {
        LinkedList members = new LinkedList();
        Map<Long, List<Member>> allMemberMapByAllView = this.getAllMemberMapByAllView();
        if (allMemberMapByAllView.isEmpty()) {
            return Collections.emptyList();
        }
        for (Map.Entry<Long, List<Member>> entry : allMemberMapByAllView.entrySet()) {
            members.addAll(entry.getValue());
        }
        return Collections.unmodifiableList(members);
    }

    static {
        DISABLE_DIMS.add("Account");
        DISABLE_DIMS.add("DataType");
        DISABLE_DIMS.add("Version");
        DISABLE_DIMS.add("Metric");
        DISABLE_DIMS.add("Entity");
        DISABLE_DIMS.add("InternalCompany");
        DISABLE_DIMS.add(SysDimensionEnum.Entity.getMemberTreemodel());
        DISABLE_DIMS.add(SysDimensionEnum.Account.getMemberTreemodel());
        DISABLE_DIMS.add(SysDimensionEnum.DataType.getMemberTreemodel());
        DISABLE_DIMS.add(SysDimensionEnum.Version.getMemberTreemodel());
        DISABLE_DIMS.add(SysDimensionEnum.Metric.getMemberTreemodel());
        DISABLE_DIMS.add(SysDimensionEnum.InternalCompany.getMemberTreemodel());
        DISABLE_DIMS.add("epm_userdefinedmembertree");
        SIMPLE_NAME_DIMS.add(SysDimensionEnum.Entity.getMemberTreemodel());
        SIMPLE_NAME_DIMS.add(SysDimensionEnum.Account.getMemberTreemodel());
        SIMPLE_NAME_DIMS.add("epm_userdefinedmembertree");
    }
}

