/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DynamicMember
implements Serializable {
    private long id;
    private String name;
    private String number;
    private DynamicMember parent;
    private List<DynamicMember> childs = new ArrayList<DynamicMember>();
    private Map<String, Object> otherVals = null;

    public DynamicMember(long id, String name, String number) {
        this.id = id;
        this.name = name;
        this.number = number;
    }

    public DynamicMember(long id, String number) {
        this.id = id;
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public long getId() {
        return this.id;
    }

    public DynamicMember getParent() {
        return this.parent;
    }

    public List<DynamicMember> getChilds() {
        return this.childs;
    }

    public <T> T get(String key) {
        if (this.otherVals == null) {
            return null;
        }
        return (T)this.otherVals.get(key);
    }

    public <T> T get(String key, T defaultVal) {
        if (this.otherVals == null) {
            return defaultVal;
        }
        Object t = this.otherVals.get(key);
        return (T)(t == null ? defaultVal : t);
    }

    public void addChild(DynamicMember chilldMemb) {
        this.childs.add(chilldMemb);
        chilldMemb.parent = this;
    }

    public DynamicMember getChildMembById(long membId) {
        DynamicMember target = null;
        for (DynamicMember member : this.childs) {
            if (member.id == membId) {
                return member;
            }
            target = member.getChildMembById(member.getId());
            if (target == null) continue;
            return target;
        }
        return null;
    }

    public DynamicMember getChildMembByNumber(String number) {
        DynamicMember target = null;
        for (DynamicMember member : this.childs) {
            if (member.number.equals(number)) {
                return member;
            }
            target = member.getChildMembByNumber(number);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    public boolean checkContainByScope(String membNum, String scope) {
        boolean result = false;
        switch (scope) {
            case "10": {
                if (!this.number.equals(membNum)) break;
                return true;
            }
            case "40": {
                for (DynamicMember childMemb : this.getChilds()) {
                    if (this.number.equals(membNum)) {
                        return true;
                    }
                    result = childMemb.checkContainByScope(membNum, scope);
                    if (!result) continue;
                    return true;
                }
                break;
            }
            case "50": {
                if (this.number.equals(membNum)) {
                    return true;
                }
                for (DynamicMember childMemb : this.getChilds()) {
                    result = childMemb.checkContainByScope(membNum, scope);
                    if (!result) continue;
                    return true;
                }
                break;
            }
            case "90": {
                for (DynamicMember childMemb : this.getChilds()) {
                    if (childMemb.getChilds().isEmpty() && childMemb.number.equals(membNum)) {
                        return true;
                    }
                    result = childMemb.checkContainByScope(membNum, scope);
                    if (!result) continue;
                    return true;
                }
                break;
            }
            case "110": {
                for (DynamicMember childMemb : this.getChilds()) {
                    if (childMemb.getChilds().isEmpty()) continue;
                    if (childMemb.number.equals(membNum)) {
                        return true;
                    }
                    result = childMemb.checkContainByScope(membNum, scope);
                    if (!result) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }
}

