/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.lang.Lang;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.AbstractTree;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class Member
extends BaseCache {
    private static final long serialVersionUID = 7958018515876602322L;
    private Map<Lang, String> names = null;
    private String simpleName = "";
    private String showNumber = "";
    private int level = 0;
    private String longNumber = null;
    private Long creator = null;
    private Long parentId = null;
    private String parentNumber = null;
    private String source = null;
    private int allChildCount = 0;
    private static final String PROP_KEY_AGG = "aggType";
    private static final String PROP_KEY_HASAGG = "hasAgg";
    private static final String PROP_KEY_HASPERIODDISTRIBUTION = "hasPeriodDistribution";
    private Dimension dimension = null;
    private List<Member> children = new LinkedList<Member>();
    private boolean isSorted = false;
    private Long datasetId = null;
    public Long refViewId;
    private static final String PROP_KEY_DATATYPE = "datatype";
    private static final String PROP_KEY_STORAGE = "storagetype";
    private static final String PROP_KEY_PRESET = "preset";
    private static final String PROP_KEY_METRIC_USE = "metric_use";
    @JSONField(serialize=false, deserialize=false)
    private Date periodDate = null;
    private String auditTrailUse;
    private String accountDirection;
    private boolean noLeafStorage;
    private Map<String, String> properties = null;
    private boolean disable;
    private boolean enable = true;

    public Member() {
    }

    public Member(Dimension dimension) {
        this.setDimension(dimension);
    }

    @Deprecated
    public boolean isAnalyzeMember() {
        return false;
    }

    public void addName(Lang lang, String name) {
        if (lang == null || name == null) {
            return;
        }
        if (this.names == null) {
            this.names = new HashMap<Lang, String>();
        }
        this.names.put(lang, name);
    }

    protected Map<Lang, String> getNames() {
        return this.names;
    }

    @Override
    public String getName() {
        Lang currLang = RequestContext.get().getLang();
        if (this.getViewOrDim() == null || this.getViewOrDim().getLang() == currLang) {
            return super.getName();
        }
        if (!this.getViewOrDim().getLangs().contains(currLang)) {
            this.getViewOrDim().initLang(currLang);
        }
        return this.getNames() != null ? this.getNames().get(currLang) : "";
    }

    public final String getSimpleName() {
        return this.simpleName;
    }

    public final void setSimpleName(String simpleName) {
        if (StringUtils.isNotEmpty(simpleName)) {
            this.simpleName = simpleName;
        }
    }

    public final String getShowNumber() {
        return this.showNumber;
    }

    public final void setShowNumber(String showNumber) {
        if (StringUtils.isNotEmpty(showNumber)) {
            this.showNumber = showNumber;
        }
    }

    public final int getLevel() {
        return this.level;
    }

    public final void setLevel(int level) {
        this.level = level;
    }

    public final void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    public final String getLongNumber() {
        return this.longNumber;
    }

    public final Long getCreator() {
        return this.creator;
    }

    public final void setCreator(Long creator) {
        this.creator = creator;
    }

    public final void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public final Long getParentId() {
        return this.parentId;
    }

    public void setParentNumber(String parentNumber) {
        this.parentNumber = parentNumber;
    }

    public String getParentNumber() {
        Member member;
        if (this.parentNumber == null && this.getDimension() != null && (member = this instanceof ViewMember ? this.getDimension().getMember(((ViewMember)this).getViewId(), this.getParentId()) : this.getDimension().getMember(this.getParentId())) != null) {
            return member.getNumber();
        }
        return this.parentNumber;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public int getGlobalSeq() {
        return ModelCacheServiceHelper.getMemberGlobalSeq(this);
    }

    public int getAllChildCount() {
        if (this.allChildCount == 0) {
            ++this.allChildCount;
            List<Member> children = this.getChildren();
            if (children != null) {
                for (Member c : children) {
                    this.allChildCount += c.getAllChildCount();
                }
            }
        }
        return this.allChildCount;
    }

    public final void setAggType(String aggType) {
        this.setPropertyValue(PROP_KEY_AGG, aggType);
    }

    public final String getAggType() {
        return this.getPropertyValue(PROP_KEY_AGG);
    }

    public final void setHasAgg(Boolean hasAgg) {
        if (hasAgg != null) {
            this.setPropertyValue(PROP_KEY_HASAGG, String.valueOf(hasAgg));
        }
    }

    public final boolean hasAgg() {
        return Boolean.parseBoolean(this.getPropertyValue(PROP_KEY_HASAGG));
    }

    public final void setHasPeriodDistribution(Boolean hasPeriodDistribution) {
        if (hasPeriodDistribution != null) {
            this.setPropertyValue(PROP_KEY_HASPERIODDISTRIBUTION, String.valueOf(hasPeriodDistribution));
        }
    }

    public final boolean hasPeriodDistribution() {
        return Boolean.parseBoolean(this.getPropertyValue(PROP_KEY_HASPERIODDISTRIBUTION));
    }

    public final void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public final Dimension getDimension() {
        return this.dimension;
    }

    public AbstractTree getViewOrDim() {
        return this.getDimension();
    }

    public final void setChildren(List<Member> children) {
        this.children = children;
    }

    public void setDatasetId(Long datasetId) {
        if (IDUtils.isNotNull(datasetId)) {
            this.datasetId = datasetId;
        }
    }

    public Long getDatasetId() {
        return this.datasetId;
    }

    public Long getRefViewId() {
        return this.refViewId;
    }

    public void setRefViewId(Long refViewId) {
        this.refViewId = refViewId;
    }

    public final String getDatatype() {
        return this.getPropertyValue(PROP_KEY_DATATYPE);
    }

    public final void setDatatype(String datatype) {
        this.setPropertyValue(PROP_KEY_DATATYPE, datatype);
    }

    public final String getStorageType() {
        return this.getPropertyValue(PROP_KEY_STORAGE);
    }

    public final void setStorageType(String storageType) {
        this.setPropertyValue(PROP_KEY_STORAGE, storageType);
    }

    public final boolean isPreset() {
        return Boolean.parseBoolean(this.getPropertyValue(PROP_KEY_PRESET));
    }

    public final void setPreset(boolean preset) {
        this.setPropertyValue(PROP_KEY_PRESET, String.valueOf(preset));
    }

    public String getUse() {
        return this.getPropertyValue(PROP_KEY_METRIC_USE);
    }

    public void setUse(String use) {
        this.setPropertyValue(PROP_KEY_METRIC_USE, use);
    }

    @JSONField(serialize=false, deserialize=false)
    public Date getPeriodDate() {
        if (this.periodDate == null && SysDimensionEnum.BudgetPeriod.getNumber().equals(this.getDimension().getNumber())) {
            try {
                String number = this.getNumber();
                int level = this.getLevel();
                if (level == 1) {
                    this.periodDate = new Date(0, 0, 1);
                } else {
                    Pattern pattern = Pattern.compile("\\d+");
                    Matcher matcher = pattern.matcher(number);
                    int[] numbers = new int[2];
                    int index = 0;
                    while (matcher.find()) {
                        numbers[index++] = Integer.parseInt(matcher.group());
                    }
                    if (level == 2) {
                        this.periodDate = new Date(numbers[0] - 1900, 0, 1);
                    } else if (level == 3) {
                        this.periodDate = new Date(numbers[0] - 1900, (numbers[1] - 1) * 6, 1);
                    } else if (level == 4) {
                        this.periodDate = new Date(numbers[0] - 1900, (numbers[1] - 1) * 3, 1);
                    } else if (level == 5) {
                        this.periodDate = new Date(numbers[0] - 1900, numbers[1] - 1, 1);
                    }
                }
            }
            catch (Exception e) {
                ModelCacheContext.log.error("getPeriodDate", (Throwable)e);
            }
        }
        return this.periodDate;
    }

    public String getAuditTrailUse() {
        return this.auditTrailUse;
    }

    public void setAuditTrailUse(String auditTrailUse) {
        this.auditTrailUse = auditTrailUse;
    }

    public String getAccountDirection() {
        return this.accountDirection;
    }

    public void setAccountDirection(String accountDirection) {
        this.accountDirection = accountDirection;
    }

    public boolean isNoLeafStorage() {
        return this.noLeafStorage;
    }

    public void setNoLeafStorage(boolean noLeafStorage) {
        this.noLeafStorage = noLeafStorage;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getPropertyValue(String propKey) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(propKey);
    }

    public void setPropertyValue(String propKey, String propValue) {
        if (propKey == null) {
            return;
        }
        if (StringUtils.isEmpty(propValue)) {
            if (this.properties != null) {
                this.properties.remove(propKey);
            }
        } else {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>(2);
            }
            this.properties.put(propKey, propValue);
        }
    }

    public int disableToInt() {
        if (this.disable) {
            return 1;
        }
        return 0;
    }

    public boolean isDisable() {
        return this.disable;
    }

    public void setDisable(boolean disable) {
        this.disable = disable;
    }

    public final List<Member> getChildrenBySort() {
        if (!this.isSorted) {
            this.children.sort((o1, o2) -> {
                int seq = o1.getSeq() - o2.getSeq();
                if (seq == 0) {
                    return o1.getNumber().compareToIgnoreCase(o2.getNumber());
                }
                return seq;
            });
            this.isSorted = true;
        }
        return this.children;
    }

    public final List<Member> getChildren(boolean needSort) {
        if (needSort) {
            return this.getChildrenBySort();
        }
        return this.children;
    }

    public final List<Member> getChildren() {
        return this.children;
    }

    public final List<Member> getChildrenNotWithCosmic() {
        if (this.children != null) {
            return this.children.stream().filter(e -> !e.getNumber().endsWith("._inv")).collect(Collectors.toList());
        }
        return this.children;
    }

    public final List<Member> getChildrenNotWithCosmic(boolean needSort) {
        List<Member> children = this.getChildren(needSort);
        if (children != null) {
            return children.stream().filter(e -> !e.getNumber().endsWith("._inv")).collect(Collectors.toList());
        }
        return children;
    }

    public final List<Member> getLeaf() {
        LinkedList<Member> members = new LinkedList<Member>();
        if (this.isLeaf()) {
            members.add(this);
        } else {
            for (Member child : this.getChildren()) {
                this.getLeaf(child, members);
            }
        }
        return Collections.unmodifiableList(members);
    }

    private void getLeaf(Member member, List<Member> members) {
        if (member == null || members == null) {
            return;
        }
        if (member.isLeaf()) {
            members.add(member);
        } else {
            for (Member child : member.getChildren()) {
                this.getLeaf(child, members);
            }
        }
    }

    public void addChild(Member member) {
        if (member != null && member.getParentId() != null && this.getId().compareTo(member.getParentId()) == 0) {
            if (this.children == null) {
                this.children = new LinkedList<Member>();
            }
            this.children.add(member);
        }
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public List<Member> getAllMembers() {
        LinkedList<Member> members = new LinkedList<Member>();
        members.add(this);
        if (this.children != null && !this.children.isEmpty()) {
            for (Member member : this.children) {
                members.addAll(member.getAllMembers());
            }
        }
        return Collections.unmodifiableList(members);
    }

    public List<Member> getAllMembers(int level) {
        LinkedList<Member> members = new LinkedList<Member>();
        if (this.getLevel() < level) {
            members.add(this);
            if (this.children != null && !this.children.isEmpty()) {
                for (Member member : this.children) {
                    members.addAll(member.getAllMembers(level));
                }
            }
        } else if (this.getLevel() == level) {
            members.add(this);
        }
        return members;
    }

    public List<Member> getLevelMembers(int level) {
        ArrayList<Member> members = new ArrayList<Member>(128);
        if (this.getLevel() < level) {
            if (this.children != null && !this.children.isEmpty()) {
                for (Member member : this.children) {
                    members.addAll(member.getLevelMembers(level));
                }
            }
        } else if (this.getLevel() == level) {
            members.add(this);
        }
        return members;
    }

    @Override
    public Object clone() {
        Member clone = (Member)super.clone();
        clone.setLongNumber(this.getLongNumber());
        clone.setParentId(this.getParentId());
        clone.setAggType(this.getAggType());
        if (this.getProperties() != null) {
            clone.setProperties(new HashMap<String, String>(this.getProperties()));
        }
        clone.setDimension(this.getDimension());
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            LinkedList<Member> children = new LinkedList<Member>();
            for (Member child : this.getChildren()) {
                children.add((Member)child.clone());
            }
            clone.setChildren(children);
        }
        return clone;
    }

    public Member cloneNoChild() {
        Member clone = (Member)super.clone();
        clone.setLongNumber(this.getLongNumber());
        clone.setParentId(this.getParentId());
        clone.setAggType(this.getAggType());
        if (this.getProperties() != null) {
            clone.setProperties(new HashMap<String, String>(this.getProperties()));
        }
        clone.setChildren(new LinkedList<Member>());
        clone.allChildCount = 0;
        clone.setDimension(this.getDimension());
        return clone;
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getNumber(), this.getDimension().getId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Member) {
            Member member = (Member)obj;
            if (this.getId().compareTo(member.getId()) == 0 && this.getNumber().equals(member.getNumber()) && this.getDimension().getId().equals(member.getDimension().getId())) {
                return true;
            }
        }
        return false;
    }

    public static List<Member> of(List<DynamicObject> memberObjs, boolean isAccount) {
        List children;
        if (CollectionUtils.isEmpty(memberObjs)) {
            return Collections.emptyList();
        }
        ArrayList<Member> members = new ArrayList<Member>(memberObjs.size());
        LinkedHashMap childrenMap = Maps.newLinkedHashMap();
        for (DynamicObject memberObj : memberObjs) {
            Member member = new Member();
            member.setId(memberObj.getLong("id"));
            member.setNumber(memberObj.getString("number"));
            member.setSeq(memberObj.getInt("dseq"));
            member.setAggType(memberObj.getString("aggoprt"));
            Object parent = memberObj.get("parent");
            if (parent instanceof DynamicObject) {
                member.setParentId(((DynamicObject)parent).getLong("id"));
            } else if (parent instanceof Long) {
                member.setParentId((Long)parent);
            }
            if (isAccount) {
                member.setStorageType(memberObj.getString(PROP_KEY_STORAGE));
            }
            members.add(member);
            children = childrenMap.computeIfAbsent(member.getParentId(), f -> Lists.newLinkedList());
            children.add(member);
        }
        for (Member member : members) {
            children = (List)childrenMap.get(member.getId());
            if (children == null) continue;
            member.setChildren(children);
        }
        return members;
    }

    public static Member of(DynamicObject memberObj, Collection<DynamicObject> children) {
        if (memberObj == null) {
            return null;
        }
        Member member = new Member();
        member.setId(memberObj.getLong("id"));
        member.setNumber(memberObj.getString("number"));
        member.setSeq(memberObj.getInt("dseq"));
        if (memberObj.getDynamicObjectType().getProperties().containsKey((Object)"aggoprt")) {
            member.setAggType(memberObj.getString("aggoprt"));
        } else {
            member.setAggType(AggOprtEnum.ADD.getSign());
        }
        DataEntityPropertyCollection property = memberObj.getDynamicObjectType().getProperties();
        if (property.containsKey((Object)"level")) {
            member.setLevel(memberObj.getInt("level"));
        }
        if (property.containsKey((Object)PROP_KEY_STORAGE) && org.apache.commons.lang.StringUtils.isNotBlank((String)memberObj.getString(PROP_KEY_STORAGE))) {
            member.setStorageType(memberObj.getString(PROP_KEY_STORAGE));
        }
        if (!memberObj.getBoolean("isleaf")) {
            ArrayList<Member> mems = new ArrayList<Member>(children.size());
            boolean hasAggoprt = false;
            boolean hasLevel = false;
            if (!children.isEmpty()) {
                property = children.iterator().next().getDynamicObjectType().getProperties();
                hasAggoprt = property.containsKey((Object)"aggoprt");
                hasLevel = property.containsKey((Object)"level");
            }
            for (DynamicObject dynamicObject : children) {
                Member mem = new Member();
                mem.setId(dynamicObject.getLong("id"));
                mem.setNumber(dynamicObject.getString("number"));
                mem.setSeq(dynamicObject.getInt("dseq"));
                if (hasLevel) {
                    mem.setLevel(dynamicObject.getInt("level"));
                }
                if (hasAggoprt) {
                    mem.setAggType(dynamicObject.getString("aggoprt"));
                } else {
                    mem.setAggType(AggOprtEnum.ADD.getSign());
                }
                mems.add(mem);
            }
            member.setChildren(mems);
        }
        return member;
    }

    public boolean iterateAll(Function<Member, Boolean> callback) {
        if (callback.apply(this).booleanValue()) {
            if (!this.getChildren().isEmpty()) {
                for (Member child : this.getChildren()) {
                    if (child.iterateAll(callback)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void iterate(Consumer<Member> callback) {
        callback.accept(this);
        if (!this.getChildren().isEmpty()) {
            for (Member child : this.getChildren()) {
                child.iterate(callback);
            }
        }
    }

    @JSONField(serialize=false, deserialize=false)
    public String getLongName(List<Member> parents) {
        StringBuilder lna = new StringBuilder();
        if (parents != null && !parents.isEmpty()) {
            for (Member parent : parents) {
                lna.append(parent.getName()).append('_');
            }
        }
        lna.append(this.getName());
        return lna.toString();
    }

    public void iterateNoRoot(Consumer<Member> callback) {
        if (!this.getChildren().isEmpty()) {
            for (Member child : this.getChildren()) {
                callback.accept(child);
                child.iterateNoRoot(callback);
            }
        }
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }
}

