/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.impl;

import java.io.Serializable;
import java.util.Arrays;

public class MembersKey
implements Serializable {
    private Object[] keys;
    private transient int hashcode = 0;
    private boolean isDetail = false;
    private String originCellKey;
    private String[] originCellMeta;

    public MembersKey() {
    }

    public MembersKey(Object[] keys) {
        this.keys = keys;
    }

    public MembersKey(Object[] keys, boolean isDetail) {
        this(keys);
        this.isDetail = isDetail;
    }

    public MembersKey(Object[] keys, String originCellKey, String[] originCellMeta, boolean isDetail) {
        this(keys, isDetail);
        this.originCellKey = originCellKey;
        this.originCellMeta = originCellMeta;
    }

    public void setKeys(Object[] keys) {
        this.keys = keys;
        this.initHashCode();
    }

    public Object[] getKeys() {
        return this.keys;
    }

    public boolean isDetail() {
        return this.isDetail;
    }

    public void setDetail(boolean detail) {
        this.isDetail = detail;
    }

    public int hashCode() {
        if (this.hashcode != 0) {
            return this.hashcode;
        }
        this.initHashCode();
        return this.hashcode;
    }

    public void initHashCode() {
        int hash = 1315423911;
        int len = this.keys.length;
        for (int i = 1; i < len; ++i) {
            if (this.keys[i] == null) continue;
            hash ^= (hash << 5) + this.keys[i].hashCode() + (hash >>> 2);
        }
        this.hashcode = hash;
    }

    public boolean equals(Object other) {
        Object[] oKeys;
        if (other instanceof MembersKey && (oKeys = ((MembersKey)other).keys).length == this.keys.length) {
            int len = this.keys.length;
            for (int i = 1; i < len; ++i) {
                if ((this.keys[i] == null || this.keys[i].equals(oKeys[i])) && (oKeys[i] == null || oKeys[i].equals(this.keys[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getOriginCellKey() {
        return this.originCellKey;
    }

    public void setOriginCellKey(String originCellKey) {
        this.originCellKey = originCellKey;
    }

    public String[] getOriginCellMeta() {
        return this.originCellMeta;
    }

    public void setOriginCellMeta(String[] originCellMeta) {
        this.originCellMeta = originCellMeta;
    }

    public static MembersKey of(String[] metas) {
        if (metas == null || metas.length == 0) {
            return null;
        }
        Object[] values = new Object[metas.length + 1];
        System.arraycopy(metas, 0, values, 1, metas.length);
        return new MembersKey(values);
    }

    public String toString() {
        return Arrays.toString(this.keys);
    }
}

