/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.BusModel;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class Model
extends BaseCache {
    private static final Log log = LogFactory.getLog(Model.class);
    private static final long serialVersionUID = -860952831984613278L;
    private boolean checkVersion = false;
    private String cubeNumber = null;
    private Long version = 0L;
    private Date createTime;
    private String reportType = "";
    private Long dataSourceId = null;
    private Long creator = null;
    private Long levelLong;
    private List<Dimension> dimensions = new ArrayList<Dimension>();
    private final Map<Long, Dataset> datasetMap = new ConcurrentHashMap<Long, Dataset>();
    private final Map<Long, BusModel> busModelMap = new ConcurrentHashMap<Long, BusModel>();
    private Map<String, Dimension> dimensionNumMap = new ConcurrentHashMap<String, Dimension>();
    private Map<Long, Dimension> dimensionMap = new LinkedHashMap<Long, Dimension>();
    private Map<Long, Map<Long, List<Member>>> shareMembers = new LinkedHashMap<Long, Map<Long, List<Member>>>();
    private Boolean isEb = null;
    private Map<Long, List<Long>> baseViewToAnalyzeViewMap = new ConcurrentHashMap<Long, List<Long>>();
    private Lang lang = null;
    private Set<Lang> langs = Sets.newHashSetWithExpectedSize((int)16);

    public void setCheckVersion(boolean checkVersion) {
        this.checkVersion = checkVersion;
    }

    public boolean isCheckVersion() {
        return this.checkVersion;
    }

    public final void setCubeNumber(String cubeNumber) {
        this.cubeNumber = cubeNumber;
    }

    public final String getCubeNumber() {
        return this.cubeNumber;
    }

    public void setVersion(Long version) {
        this.version = version;
        this.createTime = new Date();
    }

    public Long getVersion() {
        return this.version;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setDataSourceId(Long dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public Long getDataSourceId() {
        return this.dataSourceId;
    }

    public void setCreator(Long creator) {
        this.creator = creator;
    }

    public Long getCreator() {
        return this.creator;
    }

    public Long getLevelLong() {
        return this.levelLong;
    }

    public void setLevelLong(Long levelLong) {
        this.levelLong = levelLong;
    }

    public List<Dimension> getDimension() {
        return Collections.unmodifiableList(this.dimensions);
    }

    public Dataset getDataset(@NotNull Long datasetId) {
        if (IDUtils.isNull(datasetId)) {
            return null;
        }
        return this.datasetMap.computeIfAbsent(datasetId, v -> this.createDataSet(datasetId));
    }

    public BusModel getBusModel(@NotNull Long busModelId) {
        if (IDUtils.isNull(busModelId)) {
            return null;
        }
        return this.busModelMap.computeIfAbsent(busModelId, v -> this.createBusModel(busModelId));
    }

    private BusModel createBusModel(Long busModelId) {
        BusModel busModel = new BusModel(busModelId);
        List<Dimension> dimensionList = BusinessModelServiceHelper.getRefDim(busModelId, this.getDimension());
        Map<String, Long> viewMap = BusinessModelServiceHelper.getViewIds(busModelId);
        Map<String, Long> includeBaseViewMap = BusinessModelServiceHelper.getViewIds(busModelId, true);
        Map<String, Long> viewGroupMap = BusinessModelServiceHelper.getViewGroupIds(busModelId);
        Map<String, List<Long>> viewGroupViewsMap = BusinessModelServiceHelper.getViewGroupViewIdsByBusinessModel(busModelId);
        ArrayList<String> dimNumbers = new ArrayList<String>(16);
        if (dimensionList != null) {
            for (Dimension d : dimensionList) {
                dimNumbers.add(d.getNumber());
            }
        }
        busModel.setDimensionList(dimNumbers);
        busModel.setViewMap(viewMap);
        busModel.setIncludeBaseViewMap(includeBaseViewMap);
        busModel.setViewGroupViewsMap(viewGroupViewsMap);
        busModel.setViewGroupMap(viewGroupMap);
        return busModel;
    }

    private Dataset createDataSet(Long datasetId) {
        Dataset dataset = Dataset.of(DatasetServiceHelper.loadDatasets(datasetId));
        if (dataset == null) {
            return null;
        }
        DynamicObject busModelObj = DatasetServiceHelper.getBusModelObjByDataset(datasetId);
        if (busModelObj == null) {
            return null;
        }
        long busModelId = busModelObj.getLong("id");
        dataset.setBusModelId(busModelId);
        List<Dimension> dimensionList = DatasetServiceHelper.getRefDim(datasetId, this.getDimension());
        ArrayList<String> numbers = new ArrayList<String>(16);
        dimensionList.forEach(f -> numbers.add(f.getNumber()));
        dataset.setDimensionList(numbers);
        dataset.setCubeNumber(ShrekOlapUtils.getCubeNumber(dataset));
        BusModel busModel = this.getBusModel(busModelId);
        if (busModel == null) {
            dataset.setViewMap(Collections.emptyMap());
            dataset.setIncludeBaseViewMap(Collections.emptyMap());
            dataset.setViewGroupViewsMap(Collections.emptyMap());
            dataset.setViewGroupMap(Collections.emptyMap());
            return dataset;
        }
        dataset.setViewMap(busModel.getViewMap());
        dataset.setIncludeBaseViewMap(busModel.getIncludeBaseViewMap());
        dataset.setViewGroupViewsMap(busModel.getViewGroupViewsMap());
        dataset.setViewGroupMap(busModel.getViewGroupMap());
        return dataset;
    }

    public List<Dimension> getDimensionByDataset(@NotNull Long datasetId) {
        if (datasetId == null || datasetId == 0L) {
            log.error("budget-olap-log : warring:datasetId");
            return this.getDimension();
        }
        Dataset dataset = this.getDataset(datasetId);
        if (dataset == null) {
            log.error("budget-olap-log : " + String.format("warring:datasetId=%s, dimensionSize = 0", datasetId));
            return Collections.emptyList();
        }
        return this.getDimensionList(dataset.getDimensionList());
    }

    public List<Dimension> getDimensionList(Collection<String> dimNumbers) {
        ArrayList<Dimension> list = new ArrayList<Dimension>(16);
        if (dimNumbers == null || dimNumbers.isEmpty()) {
            return list;
        }
        dimNumbers.forEach(f -> list.add(this.getDimension((String)f)));
        return list;
    }

    public Map<String, Long> getViewsByDataSet(@NotNull Long dataSetId) {
        Dataset dataset = this.getDataset(dataSetId);
        if (dataset == null) {
            return Collections.emptyMap();
        }
        return dataset.getViewMap();
    }

    public Map<String, Long> getViewGroupsByDataSet(@NotNull Long dataSetId) {
        Dataset dataset = this.getDataset(dataSetId);
        if (dataset == null) {
            return Collections.emptyMap();
        }
        return dataset.getViewGroupMap();
    }

    public Map<String, List<Long>> getViewGroupViewsByDataSet(@NotNull Long dataSetId) {
        Dataset dataset = this.getDataset(dataSetId);
        if (dataset == null) {
            return Collections.emptyMap();
        }
        return dataset.getViewGroupViewsMap();
    }

    public Long getViewByDataSetAndDimNumber(@NotNull Long dataSetId, String dimNumber) {
        return this.getViewsByDataSet(dataSetId).get(dimNumber);
    }

    public List<Long> getViewsByDataSetAndDimNumber(@NotNull Long dataSetId, String dimNumber) {
        return this.getViewsByDataSetAndViewGroup(dataSetId).get(dimNumber);
    }

    public Map<String, List<Long>> getViewsByDataSetAndViewGroup(@NotNull Long dataSetId) {
        Dataset dataset = this.getDataset(dataSetId);
        if (dataset == null) {
            return Collections.emptyMap();
        }
        return dataset.getViewGroupViewsMap();
    }

    public String getDataSetNumberByDataSet(@NotNull Long dataSetId) {
        Dataset dataset = this.getDataset(dataSetId);
        if (dataset == null) {
            return null;
        }
        return dataset.getNumber();
    }

    public Long getViewByBusModelAndDimNumber(@NotNull Long busModelId, String dimNumber) {
        return this.getViewsByBusModel(busModelId).get(dimNumber);
    }

    public Long getViewGroupByBusModelAndDimNumber(@NotNull Long busModelId, String dimNumber) {
        return this.getViewGroupsByBusModel(busModelId).get(dimNumber);
    }

    public Long getViewGroupByDataSetAndDimNumber(@NotNull Long dataSetId, String dimNumber) {
        return this.getViewGroupsByDataSet(dataSetId).get(dimNumber);
    }

    public List<Long> getViewsByBusModelAndDimNumber(@NotNull Long busModelId, String dimNumber) {
        return this.getViewsByBusModelAndViewGroup(busModelId).get(dimNumber);
    }

    public Map<String, List<Long>> getViewsByBusModelAndViewGroup(@NotNull Long busModelId) {
        BusModel busModel = this.getBusModel(busModelId);
        if (busModel == null) {
            return Collections.emptyMap();
        }
        return busModel.getViewGroupViewsMap();
    }

    public Map<String, Long> getViewsByDataSetIncludeBase(@NotNull Long dataSetId) {
        Dataset dataset = this.getDataset(dataSetId);
        if (dataset == null) {
            return Collections.emptyMap();
        }
        return dataset.getIncludeBaseViewMap();
    }

    public Long getBusModelByDataSet(@NotNull Long dataSetId) {
        Dataset dataset = this.getDataset(dataSetId);
        if (dataset == null) {
            return null;
        }
        return dataset.getBusModelId();
    }

    public List<Dimension> getDimensionByBusModel(@NotNull Long busModelId) {
        BusModel busModel = this.getBusModel(busModelId);
        if (busModel == null) {
            return Collections.emptyList();
        }
        List<String> dimensionNumbers = busModel.getDimensionList();
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>(10);
        if (dimensionNumbers != null) {
            for (String d : dimensionNumbers) {
                dimensionList.add(this.getDimension(d));
            }
        }
        return Collections.unmodifiableList(dimensionList);
    }

    public Map<String, Long> getViewsByBusModel(@NotNull Long busModelId) {
        BusModel busModel = this.getBusModel(busModelId);
        if (busModel == null) {
            return Collections.emptyMap();
        }
        return busModel.getViewMap();
    }

    public Map<String, Long> getViewGroupsByBusModel(@NotNull Long busModelId) {
        BusModel busModel = this.getBusModel(busModelId);
        if (busModel == null) {
            return Collections.emptyMap();
        }
        return busModel.getViewGroupMap();
    }

    public Map<String, List<Long>> getViewGroupViewsByBusModel(@NotNull Long busModelId) {
        BusModel busModel = this.getBusModel(busModelId);
        if (busModel == null) {
            return Collections.emptyMap();
        }
        return busModel.getViewGroupViewsMap();
    }

    public Map<String, Long> getViewsByBusModelIncludeBase(@NotNull Long busModelId) {
        BusModel busModel = this.getBusModel(busModelId);
        if (busModel == null) {
            return Collections.emptyMap();
        }
        return busModel.getIncludeBaseViewMap();
    }

    public List<Dimension> getDimensionList(String[] dimNumbers) {
        if (dimNumbers == null || dimNumbers.length == 0) {
            return new ArrayList<Dimension>();
        }
        Dimension dimension = null;
        ArrayList dimensions = Lists.newArrayListWithCapacity((int)dimNumbers.length);
        for (String dimNumber : dimNumbers) {
            dimension = this.dimensionNumMap.get(dimNumber);
            if (dimension == null) continue;
            dimensions.add(dimension);
        }
        return dimensions;
    }

    public Map<Long, Dimension> getDimensions() {
        return Collections.unmodifiableMap(this.dimensionMap);
    }

    public Map<Long, Dimension> getDimensions(Long datasetId) {
        List<Dimension> dimensions = this.getDimensionByDataset(datasetId);
        return dimensions.stream().collect(Collectors.toMap(BaseCache::getId, dimension -> dimension));
    }

    public Map<Long, Dimension> getDimensionsByBusModel(Long busModelId) {
        List<Dimension> dimensions = this.getDimensionByBusModel(busModelId);
        return dimensions.stream().collect(Collectors.toMap(BaseCache::getId, dimension -> dimension));
    }

    public void add(Dimension dimension) {
        if (dimension == null) {
            return;
        }
        this.dimensions.add(dimension);
        this.dimensionMap.put(dimension.getId(), dimension);
        this.dimensionNumMap.put(dimension.getNumber(), dimension);
    }

    public Dimension getDimension(@NotNull String dimensionNumber) {
        return this.dimensionNumMap.get(dimensionNumber);
    }

    public Dimension getDimension(Long dimensionId) {
        return this.getDimensions().get(dimensionId);
    }

    public Map<String, Dimension> getDimensionMapByNum(String[] dimNumbers) {
        LinkedHashMap _dimensionMap = null;
        if (dimNumbers == null || dimNumbers.length == 0) {
            _dimensionMap = Maps.newLinkedHashMapWithExpectedSize((int)this.getDimension().size());
            for (Dimension dimension : this.getDimension()) {
                _dimensionMap.put(dimension.getNumber(), dimension);
            }
        } else {
            _dimensionMap = Maps.newLinkedHashMapWithExpectedSize((int)dimNumbers.length);
            for (String dimNumber : dimNumbers) {
                _dimensionMap.put(dimNumber, this.dimensionNumMap.get(dimNumber));
            }
        }
        return _dimensionMap;
    }

    public String[] getDimensionNums() {
        ArrayList<String> dimensionNums = new ArrayList<String>(this.getDimension().size());
        for (Dimension dimension : this.getDimension()) {
            dimensionNums.add(dimension.getNumber());
        }
        return dimensionNums.toArray(new String[dimensionNums.size()]);
    }

    public Set<String> getDimensionNumSet() {
        HashSet<String> dimensionNums = new HashSet<String>(this.getDimension().size());
        for (Dimension dimension : this.getDimension()) {
            dimensionNums.add(dimension.getNumber());
        }
        return dimensionNums;
    }

    public boolean isHasAgg() {
        Dimension account = this.getDimension(SysDimensionEnum.Account.getNumber());
        Dimension changeType = this.getDimension(SysDimensionEnum.ChangeType.getNumber());
        return account != null && account.isHasAgg() || changeType != null && changeType.isHasAgg();
    }

    private void reBuilder() {
        this.clear();
        this.buildDimensions(null);
        this.buildShareMembers();
    }

    private void clear() {
        this.dimensions.clear();
        this.dimensionMap.clear();
        this.dimensionNumMap.clear();
        this.busModelMap.clear();
        this.datasetMap.clear();
        this.baseViewToAnalyzeViewMap.clear();
    }

    public void reBuilderByBusModel(Long busModelId) {
        if (busModelId != null && busModelId != 0L) {
            this.busModelMap.remove(busModelId);
        } else {
            this.busModelMap.clear();
        }
        this.datasetMap.clear();
    }

    public void reBuilderByDataset(Long datasetId) {
        if (datasetId != null && datasetId != 0L) {
            this.datasetMap.remove(datasetId);
        } else {
            this.datasetMap.clear();
        }
    }

    public Map<Long, Map<Long, List<Member>>> getShareMembers() {
        return this.shareMembers;
    }

    public boolean isModelByEB() {
        if (this.isEb == null) {
            this.isEb = ApplicationTypeEnum.isEB(ApplicationTypeEnum.getEnumByIndex(this.getReportType()));
        }
        return this.isEb;
    }

    public boolean isModelByNewEB() {
        ApplicationTypeEnum app = ApplicationTypeEnum.getEnumByIndex(this.getReportType());
        if (app != null) {
            return ApplicationTypeEnum.BG == app;
        }
        return false;
    }

    public boolean isModelByBGMD() {
        return ApplicationTypeEnum.isBGMD(this.getReportType());
    }

    public static Model of(DynamicObject object) {
        if (object == null) {
            throw new KDBizException("model object is null.");
        }
        Model model = new Model();
        model.setId(object.getLong("id"));
        model.setName(object.getString("name"));
        model.setNumber(object.getString("shownumber"));
        model.setCubeNumber(object.getString("number"));
        model.setVersion(object.getLong("version"));
        model.setReportType(object.getString("reportType"));
        model.setDataSourceId(object.getLong("datasource.id"));
        return model;
    }

    public static Model of(BizModel bizModel) {
        if (bizModel == null) {
            throw new KDBizException("model object is null.");
        }
        Model model = new Model();
        model.setId(bizModel.getId());
        model.setName(bizModel.getName());
        model.setNumber(bizModel.getNumber());
        model.setCubeNumber(bizModel.getCubeNumber());
        model.setReportType(bizModel.getReportType());
        model.setDataSourceId(bizModel.getDataSourceId());
        return model;
    }

    public void checkDimensionVersion() {
        HashSet<String> changed = new HashSet<String>(10);
        if (this.dimensions != null) {
            for (Dimension d : this.dimensions) {
                if (d.getVersion() != null && String.valueOf(d.getVersion()).equals(String.valueOf(CubeUtils.getDimensionVersionNo(d.getId())))) continue;
                changed.add(d.getNumber());
            }
            if (!changed.isEmpty()) {
                LogStats stats = new LogStats("budget-data-log : ");
                stats.addInfo("changed-dimension. modelId = " + this.getId() + ", changeed = " + JSONUtils.toString(changed));
                this.buildDimensions(changed);
            }
        }
        this.setCheckVersion(false);
    }

    public void buildDimensions(Set<String> changed) {
        if (this.getId() == null || this.getId() == 0L) {
            return;
        }
        Dimension dimension = null;
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)this.getId()));
        String dimEntityKey = "epm_dimension";
        ArrayList<Dimension> _dimensions = new ArrayList<Dimension>();
        LinkedHashMap<Long, Dimension> _dimensionMap = new LinkedHashMap<Long, Dimension>();
        ConcurrentHashMap<String, Dimension> _dimensionNumMap = new ConcurrentHashMap<String, Dimension>();
        DynamicObjectCollection objects = QueryServiceHelper.query((String)dimEntityKey, (String)"id, name, number, shortnumber, dseq, fieldmapped, membermodel, issysdimension, version", (QFilter[])builder.toArrays(), (String)"dseq, number");
        if (objects != null && !objects.isEmpty()) {
            for (DynamicObject obj : objects) {
                dimension = new Dimension();
                dimension.setModel(this);
                dimension.setId(obj.getLong("id"));
                dimension.setName(obj.getString("name"));
                dimension.setNumber(obj.getString("number"));
                dimension.setShortNumber(obj.getString("shortnumber"));
                dimension.setFieldMapped(obj.getString("fieldmapped"));
                dimension.setMemberModel(obj.getString("membermodel"));
                dimension.setSeq(obj.getInt("dseq"));
                dimension.setPreset(obj.getBoolean("issysdimension"));
                dimension.setVersion(obj.getLong("version"));
                CubeUtils.setDimensionVersionNo(dimension.getId(), dimension.getVersion());
                if (!(changed != null && changed.contains(dimension.getNumber()) || this.dimensionNumMap.get(dimension.getNumber()) == null)) {
                    dimension = this.dimensionNumMap.get(dimension.getNumber());
                }
                _dimensions.add(dimension);
                _dimensionMap.put(dimension.getId(), dimension);
                _dimensionNumMap.put(dimension.getNumber(), dimension);
            }
        }
        this.dimensions = _dimensions;
        this.dimensionMap = _dimensionMap;
        this.dimensionNumMap = _dimensionNumMap;
        this.initDefaultViewOnDim();
        this.initAllViewOnDim();
    }

    private void initDefaultViewOnDim() {
        if (this.isModelByEB()) {
            return;
        }
        QFBuilder qfBuilder = new QFBuilder("model", "=", this.getId());
        qfBuilder.add("source", "=", "1");
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,dimension,source", (QFilter[])qfBuilder.toArray());
        if (CollectionUtils.isEmpty((Collection)objects)) {
            return;
        }
        objects.forEach(object -> {
            Long dimId = object.getLong("dimension");
            Long viewId = object.getLong("id");
            Dimension dimension = this.dimensionMap.get(dimId);
            if (dimension != null && IDUtils.isNotEmptyLong(viewId).booleanValue() && !View.NoViewDimNums.contains(dimension.getNumber())) {
                dimension.setDefaultViewId(viewId);
            }
        });
    }

    private void initAllViewOnDim() {
        if (this.isModelByEB()) {
            return;
        }
        QFBuilder qfBuilder = new QFBuilder("model", "=", this.getId());
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,dimension,source", (QFilter[])qfBuilder.toArray());
        if (CollectionUtils.isEmpty((Collection)objects)) {
            return;
        }
        objects.forEach(object -> {
            Long dimId = object.getLong("dimension");
            Long viewId = object.getLong("id");
            Dimension dimension = this.dimensionMap.get(dimId);
            if (dimension != null && IDUtils.isNotEmptyLong(viewId).booleanValue() && !View.NoViewDimNums.contains(dimension.getNumber())) {
                dimension.getViewList().add(viewId);
            }
        });
    }

    public void buildShareMembers() {
        this.getShareMembers().clear();
        if (this.isModelByEB()) {
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", this.getId());
            Map shareMembers = BusinessDataServiceHelper.loadFromCache((String)"eb_dimsharemember", (String)"id, number, name, longnumber, level, memberid, parent, dimension", (QFilter[])builder.toArrays());
            if (shareMembers != null) {
                Map shareMemberMap = null;
                List members = null;
                Member shareMember = null;
                for (DynamicObject share : shareMembers.values()) {
                    shareMember = new Member();
                    shareMember.setId(share.getLong("memberid"));
                    shareMember.setName(share.getString("name"));
                    shareMember.setNumber(share.getString("number"));
                    shareMember.setLongNumber(share.getString("longnumber"));
                    shareMember.setLevel(share.getInt("level"));
                    shareMemberMap = this.getShareMembers().computeIfAbsent(share.getLong("dimension.id"), f -> Maps.newLinkedHashMap());
                    members = shareMemberMap.computeIfAbsent(share.getLong("parent"), f -> Lists.newArrayList());
                    members.add(shareMember);
                }
            }
        }
    }

    public List<Long> getAnalyzeViewIdByBaseViewId(@NotNull Long baseViewId) {
        return this.baseViewToAnalyzeViewMap.computeIfAbsent(baseViewId, k -> DatasetServiceHelper.getAnalyzeViewIdByBaseViewId(baseViewId));
    }

    public void setLang(Lang lang) {
        this.lang = lang;
    }

    public Lang getLang() {
        return this.lang;
    }

    protected Set<Lang> getLangs() {
        return this.langs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initLang(Lang lang) {
        if (lang == null || this.getLangs().contains(lang)) {
            return;
        }
        if (this.getLangs().add(lang)) {
            LogStats stats = new LogStats("member-log:");
            stats.addInfo("begin-init-model:" + this.getNumber() + ",lang:" + lang);
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", this.getId());
            try {
                DynamicObjectCollection dimensions = QueryServiceHelper.query((String)"epm_dimension", (String)"id,name", (QFilter[])builder.toArray());
                for (DynamicObject _dimension : dimensions) {
                    Dimension dimension = this.getDimensions().get(_dimension.getLong("id"));
                    if (dimension == null) continue;
                    dimension.addName(lang, _dimension.getString("name"));
                }
            }
            catch (Throwable ex) {
                log.error(CommonServiceHelper.getStackTraceStr(ex));
            }
            finally {
                stats.add("end-init-lang.");
                log.info(stats.toString());
            }
        }
    }
}

