/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.impl.perm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.DimMembPermVerHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.perm.MemberPermCacheItem;
import kd.epm.eb.common.cache.impl.perm.RowRecord;
import kd.epm.eb.common.cache.impl.perm.SinglePermInfo;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.utils.UserUtils;

public class DimMembPermCacheContext {
    private static final Map<String, MemberPermCacheItem> allPermItem = new ConcurrentHashMap<String, MemberPermCacheItem>();
    private static int allCapacity = 0;
    private static final List<DimMembPermType> dataPermTypes = Arrays.asList(DimMembPermType.READ, DimMembPermType.WRITE);
    private static final int maxCapacity = 4000000;
    private static final int normalCapacity = 3000000;
    private static final int normalItemCapacity = 1000000;

    public static MemberPermCacheItem getOrCreateSingleDimPerm(Long modelId, Long bizModelId, String dimNum, Long targetUser, List<Long> allRefUserIds, boolean isGroup) {
        Map<Long, Set<Long>> allRefUserInfo;
        Map<Long, Long> userVersionMap;
        List<Long> userIds;
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        String dimShortNumsStr = DimMembPermUtil.getDimShortNumsStr(modelCacheHelper, Collections.singletonList(dimNum), false);
        MemberPermCacheItem memberPermCacheItem = DimMembPermCacheContext.getCacheItem(modelId, bizModelId, dimShortNumsStr, isGroup, userIds = Collections.singletonList(targetUser), null, userVersionMap = DimMembPermVerHelper.batGetMemberPermVersion(dimShortNumsStr, modelId, bizModelId, userIds, isGroup), allRefUserInfo = UserUtils.getAllRefUserInfo(userIds, false), null).get(targetUser);
        if (memberPermCacheItem == null) {
            memberPermCacheItem = DimMembPermCacheContext.loadSingleDimPermInfo(modelId, bizModelId, dimNum, dimShortNumsStr, targetUser, allRefUserIds, isGroup);
        }
        return memberPermCacheItem;
    }

    private static MemberPermCacheItem loadSingleDimPermInfo(Long modelId, Long bizModelId, String dimNum, String dimShortNumsStr, Long targetUser, List<Long> allRefUserIds, boolean isGroup) {
        ArrayList<Long> notExistUserGroupIds = new ArrayList<Long>(allRefUserIds.size());
        Map<Long, Long> userVersionMap = DimMembPermVerHelper.batGetMemberPermVersion(dimShortNumsStr, modelId, bizModelId, allRefUserIds, isGroup);
        Map<Long, Set<Long>> allRefUserInfo = UserUtils.getAllRefUserInfo(allRefUserIds, false);
        Map<Long, MemberPermCacheItem> userPermMap = DimMembPermCacheContext.getCacheItem(modelId, bizModelId, dimShortNumsStr, isGroup, allRefUserIds, targetUser, userVersionMap, allRefUserInfo, notExistUserGroupIds::add);
        notExistUserGroupIds.add(targetUser);
        MemberPermCacheItem cacheItem = new MemberPermCacheItem();
        Map<Long, List<SinglePermInfo>> singleDimPermBat = DimMembPermUtil.parseSingleDimPermBat(modelId, bizModelId, dimNum, notExistUserGroupIds, dataPermTypes, isGroup);
        for (Long userId : notExistUserGroupIds) {
            List<SinglePermInfo> permInfos = singleDimPermBat.get(userId);
            if (permInfos != null) {
                BitSet readPermInfo = permInfos.size() > 0 ? permInfos.get(0).getMemberPermVal() : null;
                BitSet writePermInfo = permInfos.size() > 1 ? permInfos.get(1).getMemberPermVal() : null;
                MemberPermCacheItem memberPermCacheItem = new MemberPermCacheItem(userVersionMap.get(userId), 0, System.currentTimeMillis(), readPermInfo, writePermInfo);
                DimMembPermCacheContext.mergeSinglePerm(memberPermCacheItem, cacheItem);
                if (userId.equals(targetUser)) continue;
                memberPermCacheItem.setRefUserGroups(allRefUserInfo.get(userId));
                DimMembPermCacheContext.putCacheItem(DimMembPermCacheContext.buildCacheStr(dimShortNumsStr, modelId, bizModelId, userId, isGroup), memberPermCacheItem);
                continue;
            }
            MemberPermCacheItem memberPermCacheItem = new MemberPermCacheItem();
            memberPermCacheItem.setRefUserGroups(allRefUserInfo.get(userId));
            memberPermCacheItem.setEmpty(true);
            memberPermCacheItem.setLoadTime(System.currentTimeMillis());
            memberPermCacheItem.setVersion(userVersionMap.get(userId));
            DimMembPermCacheContext.putCacheItem(DimMembPermCacheContext.buildCacheStr(dimShortNumsStr, modelId, bizModelId, userId, isGroup), memberPermCacheItem);
        }
        userPermMap.values().forEach(permInfo -> DimMembPermCacheContext.mergeSinglePerm(permInfo, cacheItem));
        cacheItem.setVersion(userVersionMap.get(targetUser));
        cacheItem.setLoadTime(System.currentTimeMillis());
        if (cacheItem.getSingleDimReadPermInfo() == null && cacheItem.getSingleDimWritePermInfo() == null) {
            cacheItem.setEmpty(true);
        }
        cacheItem.setRefUserGroups(allRefUserInfo.get(targetUser));
        DimMembPermCacheContext.putCacheItem(DimMembPermCacheContext.buildCacheStr(dimShortNumsStr, modelId, bizModelId, targetUser, isGroup), cacheItem);
        return cacheItem;
    }

    private static void mergeSinglePerm(MemberPermCacheItem sourceItem, MemberPermCacheItem targetItem) {
        BitSet singleDimWritePermInfo;
        BitSet singleDimReadPermInfo = sourceItem.getSingleDimReadPermInfo();
        if (singleDimReadPermInfo != null) {
            BitSet singleDimReadPermInfo1 = targetItem.getSingleDimReadPermInfo();
            if (singleDimReadPermInfo1 == null) {
                singleDimReadPermInfo1 = new BitSet();
                targetItem.setSingleDimReadPermInfo(singleDimReadPermInfo1);
            }
            singleDimReadPermInfo1.or(singleDimReadPermInfo);
        }
        if ((singleDimWritePermInfo = sourceItem.getSingleDimWritePermInfo()) != null) {
            BitSet singleDimWritePermInfo1 = targetItem.getSingleDimWritePermInfo();
            if (singleDimWritePermInfo1 == null) {
                singleDimWritePermInfo1 = new BitSet();
                targetItem.setSingleDimWritePermInfo(singleDimWritePermInfo1);
            }
            singleDimWritePermInfo1.or(singleDimWritePermInfo);
        }
    }

    public static Map<Long, MemberPermCacheItem> batGetOrCreateMultiPerm(Long modelId, Long bizModelId, List<String> dimNums, List<Long> userIds) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        String dimShortNumsStr = DimMembPermUtil.getDimShortNumsStr(modelCacheHelper, dimNums, false);
        ArrayList<Long> notExistUser = new ArrayList<Long>(16);
        Map<Long, Long> versionMap = DimMembPermVerHelper.batGetMemberPermVersion(dimShortNumsStr, modelId, bizModelId, userIds, true);
        Map<Long, Set<Long>> allRefUserInfo = UserUtils.getAllRefUserInfo(userIds, false);
        Map<Long, MemberPermCacheItem> result = DimMembPermCacheContext.getCacheItem(modelId, bizModelId, dimShortNumsStr, true, userIds, null, versionMap, allRefUserInfo, notExistUser::add);
        if (notExistUser.size() > 0) {
            Map<Long, List<RowRecord>> rowRecords = MembPermRecordUtil.getUserPermRowRecords(modelId, bizModelId, dimNums, notExistUser, PermGroupEnum.DATA, false, true, false);
            for (Long userId : notExistUser) {
                MemberPermCacheItem memberPermCacheItem = new MemberPermCacheItem(versionMap.get(userId), 0, System.currentTimeMillis(), rowRecords == null ? null : rowRecords.get(userId));
                if (memberPermCacheItem.getMultiDimPermInfo() == null) {
                    memberPermCacheItem.setEmpty(true);
                }
                memberPermCacheItem.setRefUserGroups(allRefUserInfo.get(userId));
                String cacheStr = DimMembPermCacheContext.buildCacheStr(dimShortNumsStr, modelId, bizModelId, userId, true);
                result.put(userId, memberPermCacheItem);
                DimMembPermCacheContext.putCacheItem(cacheStr, memberPermCacheItem);
            }
        }
        return result;
    }

    public static String buildCacheStr(String dimShortNumStr, Long modelId, Long bizModelId, Long userId, boolean isGroup) {
        return modelId + "-" + bizModelId + "-" + userId + "-" + dimShortNumStr + "-" + (isGroup ? (char)'1' : '0');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Map<Long, MemberPermCacheItem> getCacheItem(Long modelId, Long bizModelId, String dimShortNumsStr, boolean refGroup, List<Long> userIds, Long ignoreUser, Map<Long, Long> versionMap, Map<Long, Set<Long>> allRefUserInfo, Consumer<Long> notExistConsumer) {
        HashMap<Long, MemberPermCacheItem> result = new HashMap<Long, MemberPermCacheItem>(userIds.size());
        Iterator<Long> iterator = userIds.iterator();
        while (iterator.hasNext()) {
            Long userId = iterator.next();
            if (userId.equals(ignoreUser)) continue;
            String cacheKey = DimMembPermCacheContext.buildCacheStr(dimShortNumsStr, modelId, bizModelId, userId, refGroup);
            MemberPermCacheItem memberPermCacheItem = allPermItem.get(cacheKey);
            Long version = versionMap.get(userId);
            if (memberPermCacheItem != null) {
                Set<Long> newRefUserGroup = allRefUserInfo.get(userId);
                Set<Long> nowRefUserGroup = memberPermCacheItem.getRefUserGroups();
                if (!memberPermCacheItem.getVersion().equals(version) || newRefUserGroup != null && nowRefUserGroup != null && (newRefUserGroup.size() != nowRefUserGroup.size() || !newRefUserGroup.containsAll(nowRefUserGroup))) {
                    Class<DimMembPermCacheContext> clazz = DimMembPermCacheContext.class;
                    // MONITORENTER : kd.epm.eb.common.cache.impl.perm.DimMembPermCacheContext.class
                    allPermItem.remove(cacheKey);
                    allCapacity -= memberPermCacheItem.getCapacity();
                    // MONITOREXIT : clazz
                    memberPermCacheItem = null;
                }
            }
            if (memberPermCacheItem != null) {
                memberPermCacheItem.setLoadTime(System.currentTimeMillis());
                result.put(userId, memberPermCacheItem);
                continue;
            }
            if (notExistConsumer == null) continue;
            notExistConsumer.accept(userId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void putCacheItem(String cacheKey, MemberPermCacheItem cacheItem) {
        Set<Long> refUserGroups;
        BitSet singleDimWritePermInfo;
        BitSet singleDimReadPermInfo;
        int capacity = 0;
        List<RowRecord> multiDimPermInfo = cacheItem.getMultiDimPermInfo();
        if (multiDimPermInfo != null) {
            for (RowRecord rowRecord : multiDimPermInfo) {
                if (rowRecord.getRefRowsIndex() != null) {
                    capacity += rowRecord.getRefRowsIndex().size();
                }
                if (rowRecord.getMemberRecords() != null) {
                    capacity += rowRecord.getMemberRecords().size() * 2;
                }
                ++capacity;
            }
        }
        if ((singleDimReadPermInfo = cacheItem.getSingleDimReadPermInfo()) != null) {
            capacity += singleDimReadPermInfo.size() / 64;
        }
        if ((singleDimWritePermInfo = cacheItem.getSingleDimWritePermInfo()) != null) {
            capacity += singleDimWritePermInfo.size() / 64;
        }
        if ((refUserGroups = cacheItem.getRefUserGroups()) != null) {
            capacity += refUserGroups.size();
        }
        cacheItem.setCapacity(capacity += cacheKey.length() * 2 / 8);
        if (capacity > 1000000) return;
        Class<DimMembPermCacheContext> clazz = DimMembPermCacheContext.class;
        synchronized (DimMembPermCacheContext.class) {
            allPermItem.put(cacheKey, cacheItem);
            if ((allCapacity += capacity) <= 4000000) return;
            ArrayList<Pair> sortKeys = new ArrayList<Pair>(allPermItem.size());
            allPermItem.forEach((key, item) -> sortKeys.add(new Pair<Long, String>(item.getLoadTime(), (String)key)));
            sortKeys.sort(Comparator.comparing(p -> (Long)p.p1));
            for (Pair timeKey : sortKeys) {
                MemberPermCacheItem item2 = allPermItem.remove(timeKey.p2);
                if (item2 == null || (allCapacity -= item2.getCapacity()) > 3000000) continue;
                break;
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }
}

