/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.impl.perm;

import java.util.BitSet;
import java.util.List;
import java.util.Set;
import kd.epm.eb.common.cache.impl.perm.RowRecord;

public class MemberPermCacheItem {
    private Set<Long> refUserGroups;
    private Long version;
    private int capacity;
    private long loadTime;
    private BitSet[] singleDimPermInfo;
    private List<RowRecord> multiDimPermInfo;
    private boolean isEmpty;

    public MemberPermCacheItem() {
    }

    public MemberPermCacheItem(Long version, int capacity, long loadTime, BitSet singleDimReadPermInfo, BitSet singleDimWritePermInfo) {
        this.version = version;
        this.capacity = capacity;
        this.loadTime = loadTime;
        this.singleDimPermInfo = new BitSet[2];
        this.singleDimPermInfo[0] = singleDimReadPermInfo;
        this.singleDimPermInfo[1] = singleDimWritePermInfo;
    }

    public MemberPermCacheItem(Long version, int capacity, long loadTime, List<RowRecord> multiDimPermInfo) {
        this.version = version;
        this.capacity = capacity;
        this.loadTime = loadTime;
        this.multiDimPermInfo = multiDimPermInfo;
    }

    public Long getVersion() {
        return this.version;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public BitSet getSingleDimReadPermInfo() {
        return this.singleDimPermInfo == null ? null : this.singleDimPermInfo[0];
    }

    public BitSet getSingleDimWritePermInfo() {
        return this.singleDimPermInfo == null ? null : this.singleDimPermInfo[1];
    }

    public void setSingleDimReadPermInfo(BitSet permInfo) {
        if (this.singleDimPermInfo == null) {
            this.singleDimPermInfo = new BitSet[2];
        }
        this.singleDimPermInfo[0] = permInfo;
    }

    public void setSingleDimWritePermInfo(BitSet permInfo) {
        if (this.singleDimPermInfo == null) {
            this.singleDimPermInfo = new BitSet[2];
        }
        this.singleDimPermInfo[1] = permInfo;
    }

    public List<RowRecord> getMultiDimPermInfo() {
        return this.multiDimPermInfo;
    }

    public static MemberPermCacheItem getEmptyItem(Long versionId) {
        MemberPermCacheItem item = new MemberPermCacheItem();
        item.isEmpty = true;
        item.version = 0L;
        return item;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setLoadTime(long loadTime) {
        this.loadTime = loadTime;
    }

    public void setMultiDimPermInfo(List<RowRecord> multiDimPermInfo) {
        this.multiDimPermInfo = multiDimPermInfo;
    }

    public void setEmpty(boolean empty) {
        this.isEmpty = empty;
    }

    public Set<Long> getRefUserGroups() {
        return this.refUserGroups;
    }

    public void setRefUserGroups(Set<Long> refUserGroups) {
        this.refUserGroups = refUserGroups;
    }
}

