/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.localcache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.cache.LocalMemoryCache;
import kd.epm.eb.common.cache.GlobalCacheServiceHelper;
import kd.epm.eb.common.cache.ICache;

public abstract class AbstractLocalCache
implements ICache {
    private final LocalMemoryCache cache;
    private Set<String> cacheKey = new HashSet<String>();

    protected AbstractLocalCache(LocalMemoryCache cache) {
        this.cache = cache;
    }

    @Override
    public <T> T getOrLoad(String key, GlobalCacheServiceHelper.ILoader<T> loader) {
        Object value = this.cache.get(key);
        if (value == null) {
            value = loader.load();
            this.cache.put(key, value);
        }
        this.cacheKey.add(key);
        return (T)value;
    }

    @Override
    public <T> T getIfPresent(String key) {
        return (T)this.cache.get(key);
    }

    @Override
    public void replaceCache(String key, Object v) {
        this.cache.remove(new String[]{key});
        this.cache.put(key, v);
    }

    @Override
    public void invalidateStartsWithKey(String key) {
        ArrayList<String> removeKeys = new ArrayList<String>();
        removeKeys.add(key);
        this.cacheKey.forEach(k -> {
            if (k.startsWith(key)) {
                removeKeys.add((String)k);
            }
        });
        if (!removeKeys.isEmpty()) {
            this.cache.remove(removeKeys.toArray(new String[0]));
            this.cacheKey.removeAll(removeKeys);
        }
    }

    @Override
    public void invalidateByKey(String key) {
        this.cache.remove(new String[]{key});
        this.cacheKey.remove(key);
    }

    @Override
    public void invalidateAll() {
        this.cache.clear();
        this.cacheKey.clear();
    }
}

