/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.propertycache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropRelation;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyUtils;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.common.utils.cache.ICache;
import org.jetbrains.annotations.NotNull;

public class MemberPropCacheService {
    private static final Log log = LogFactory.getLog(MemberPropCacheService.class);
    private static final long MODEL_MAX_SIZE = 8L;
    private static final long MODEL_OVER_TIME = 2L;
    private static final LoadingCache<String, MemberPropCache> loadingCache = CacheBuilder.newBuilder().maximumSize(8L).expireAfterAccess(2L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, MemberPropCache>(){

        public MemberPropCache load(String modelIdkey) {
            return MemberPropCacheService.initMemberProp(modelIdkey);
        }
    });
    public static final String CACHE_MEMBER_PROP_VERSION_KEY = "epm:cacheMemberProp:version";
    private static volatile ThreadLocal<Map<String, String>> current;

    public static MemberPropCache getOrCreate(Long modelId) {
        MemberPropCache propCache;
        String modelIdKey = ModelCacheContext.getAcctId(modelId);
        try {
            propCache = (MemberPropCache)loadingCache.get((Object)modelIdKey);
        }
        catch (ExecutionException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        String versionNum = MemberPropCacheService.getVersionFromRedis(modelId);
        if (propCache != null && !propCache.getVersionId().equals(versionNum)) {
            loadingCache.refresh((Object)modelIdKey);
            try {
                propCache = (MemberPropCache)loadingCache.get((Object)modelIdKey);
            }
            catch (ExecutionException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        if (propCache != null) {
            propCache.setModelCache(null);
        }
        return propCache;
    }

    private static String getVersionFromRedis(Long modelId) {
        String cacheKey = MemberPropCacheService.getCacheKey(modelId);
        String versionStr = Cache.get().get(cacheKey);
        if (StringUtils.isNotEmpty(versionStr)) {
            return versionStr;
        }
        String newVersionNum = DBServiceHelper.genStringId();
        Cache.get().set(cacheKey, newVersionNum);
        return newVersionNum;
    }

    public static void rebulid(Long modelId) {
        MemberPropCacheService.clearVersionKey(modelId);
        loadingCache.refresh((Object)ModelCacheContext.getAcctId(modelId));
    }

    public static void updateVersion(Long modelId, List<Long> propIds) {
        if (propIds == null || propIds.isEmpty()) {
            return;
        }
        MemberPropCacheService.clearVersionKey(modelId);
    }

    public static void updateVersion(Long modelId) {
        MemberPropCacheService.clearVersionKey(modelId);
    }

    private static void clearVersionKey(Long modelId) {
        String cacheModelKey = MemberPropCacheService.getCacheKey(modelId);
        ICache cache = Cache.get();
        cache.remove(cacheModelKey);
        Map<String, String> localCache = MemberPropCacheService.getCurrent().get();
        localCache.remove(cacheModelKey);
        List<Dimension> dimensions = ModelCacheContext.getOrCreate(modelId).getDimensionList();
        if (dimensions != null) {
            for (Dimension d : dimensions) {
                if (!CustomPropertyUtils.hasCustomProperty(d.getNumber())) continue;
                MemberPropCacheService.updateVersion(modelId, d.getId());
            }
        }
    }

    private static String getCacheKey(Long modelId) {
        return CACHE_MEMBER_PROP_VERSION_KEY + ModelCacheContext.getAcctId(modelId);
    }

    private static String getCacheKey(Long modelId, Long dimensionId) {
        return CACHE_MEMBER_PROP_VERSION_KEY + ModelCacheContext.getAcctId(modelId) + "!" + dimensionId;
    }

    public static void updateVersion(Long modelId, Long dimensionId) {
        if (IDUtils.isNull(dimensionId)) {
            log.info("updateVersion-dimension-is-null");
            MemberPropCacheService.clearVersionKey(modelId);
        } else {
            String cacheKey = MemberPropCacheService.getCacheKey(modelId, dimensionId);
            String cacheValue = String.valueOf(System.currentTimeMillis());
            Cache.get().set(cacheKey, String.valueOf(System.currentTimeMillis()));
            Map<String, String> localCache = MemberPropCacheService.getCurrent().get();
            localCache.put(cacheKey, cacheValue);
        }
    }

    public static String getVersion(Long modelId, Long dimensionId) {
        String localKey = MemberPropCacheService.getCacheKey(modelId, dimensionId);
        Map<String, String> localCache = MemberPropCacheService.getCurrent().get();
        if (localCache.get(localKey) != null) {
            return localCache.get(localKey);
        }
        String version = Cache.get().get(localKey);
        if (version == null) {
            MemberPropCacheService.updateVersion(modelId, dimensionId);
        }
        version = Cache.get().get(localKey);
        localCache.put(localKey, version);
        return version;
    }

    public static String getVersionByCache(Long modelId, Long dimensionId) {
        String cacheKey = MemberPropCacheService.getCacheKey(modelId, dimensionId);
        String version = Cache.get().get(cacheKey);
        if (version == null) {
            MemberPropCacheService.updateVersion(modelId, dimensionId);
        }
        version = Cache.get().get(cacheKey);
        Map<String, String> localCache = MemberPropCacheService.getCurrent().get();
        localCache.put(cacheKey, version);
        return version;
    }

    public static ThreadLocal<Map<String, String>> getCurrent() {
        return current;
    }

    public static void remove() {
        MemberPropCacheService.getCurrent().remove();
    }

    public static MemberPropCache initMemberProp(String modelIdKey) {
        Long modelId = ModelCacheContext.getBaseDataId(modelIdKey);
        HashSet<String> dimensionNumbers = new HashSet<String>(32);
        List<Dimension> dimensions = ModelCacheContext.getOrCreate(modelId).getDimensionList();
        for (Dimension dim : dimensions) {
            if (!CustomPropertyUtils.hasCustomProperty(dim.getNumber())) continue;
            dimensionNumbers.add(dim.getNumber());
        }
        return MemberPropCacheService.initMemberProp(modelId, dimensionNumbers);
    }

    public static MemberPropCache initMemberProp(Long modelId, @NotNull Set<String> dimensionNumbers) {
        String versionId = MemberPropCacheService.getVersionFromRedis(modelId);
        log.info("initMemberProp versionid = " + versionId + " modelid = " + modelId + " dimensionNumbers = " + JSONUtils.toString(dimensionNumbers));
        List<CustomProperty> props = MemberPropCacheService.queryProps(modelId, dimensionNumbers);
        props = MemberPropCacheService.skipDirtyData(modelId, props);
        List<CustomPropertyValue> propValues = MemberPropCacheService.queryPropValues(props);
        List<CustomPropRelation> propRelations = MemberPropCacheService.queryPropRelation(propValues);
        HashMap propertyValueMap = Maps.newHashMapWithExpectedSize((int)propValues.size());
        HashMap propertyValueRefMemberMap = Maps.newHashMapWithExpectedSize((int)propValues.size());
        MemberPropCacheService.buildMap(modelId, props, propValues, propRelations, propertyValueMap, propertyValueRefMemberMap);
        MemberPropCacheService.setGlobalOrder(propValues);
        MemberPropCache memberPropCache = new MemberPropCache(modelId, dimensionNumbers, props, propValues, propRelations, propertyValueMap, propertyValueRefMemberMap);
        memberPropCache.setVersionId(versionId);
        return memberPropCache;
    }

    private static List<CustomProperty> skipDirtyData(Long modelId, List<CustomProperty> propertyList) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        ArrayList newPropList = Lists.newArrayListWithExpectedSize((int)propertyList.size());
        for (CustomProperty propValue : propertyList) {
            if (modelCache.getDimension(propValue.getDimId()) == null) continue;
            newPropList.add(propValue);
        }
        return newPropList;
    }

    private static void setGlobalOrder(List<CustomPropertyValue> propValues) {
        Map<Long, List<CustomPropertyValue>> collect = propValues.stream().collect(Collectors.groupingBy(k -> k.getProp().getId()));
        for (Map.Entry<Long, List<CustomPropertyValue>> entry : collect.entrySet()) {
            int seq = 1;
            for (CustomPropertyValue customPropertyValue : entry.getValue()) {
                customPropertyValue.setGlobalOrder(seq++);
            }
        }
    }

    private static void buildMap(Long modelId, List<CustomProperty> props, List<CustomPropertyValue> propValues, List<CustomPropRelation> propRelations, Map<String, Map<String, CustomPropertyValue>> propertyValueMap, Map<String, Map<String, Set<Long>>> propertyValueRefMemberMap) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        LinkedHashMap<Long, Set> propValueMemMap = new LinkedHashMap<Long, Set>();
        for (CustomPropRelation customPropRelation : propRelations) {
            Set memberIds = propValueMemMap.computeIfAbsent(customPropRelation.getPropValueId(), v -> new LinkedHashSet());
            memberIds.add(customPropRelation.getMemberId());
        }
        for (CustomPropertyValue propValue : propValues) {
            CustomProperty prop = propValue.getProp();
            Long dimId = prop.getDimId();
            Dimension dimension = modelCache.getDimension(dimId);
            propValue.setLongNumber(prop.getNumber() + "!" + propValue.getNumber());
            Map _propValueMap = propertyValueMap.computeIfAbsent(dimension.getNumber(), f -> Maps.newHashMap());
            _propValueMap.put(propValue.getLongNumber(), propValue);
            Set memberIds = (Set)propValueMemMap.get(propValue.getId());
            if (!CollectionUtils.isNotEmpty(memberIds)) continue;
            Map refMemberIdMap = propertyValueRefMemberMap.computeIfAbsent(dimension.getNumber(), f -> Maps.newHashMap());
            refMemberIdMap.put(propValue.getLongNumber(), memberIds);
        }
    }

    private static List<CustomProperty> queryProps(Long modelId, Set<String> dimensionNumbers) {
        if (dimensionNumbers == null || dimensionNumbers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CustomProperty> properties = new ArrayList<CustomProperty>(32);
        QFBuilder qf = new QFBuilder("model", "=", modelId);
        qf.and("dimension.number", "in", dimensionNumbers);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"MemberPropCacheService.reload", (String)"eb_customproperty", (String)"id,number,name,dimension.id, dimension.number,dseq,version", (QFilter[])qf.toArray(), (String)"dseq, number");){
            if (dataSet != null && !dataSet.isEmpty()) {
                while (dataSet.hasNext()) {
                    CustomProperty customProperty = new CustomProperty();
                    Row next = dataSet.next();
                    customProperty.setId(next.getLong("id"));
                    customProperty.setNumber(next.getString("number"));
                    customProperty.setName(next.getString("name"));
                    customProperty.setDimId(next.getLong("dimension.id"));
                    customProperty.setDimNumber(next.getString("dimension.number"));
                    customProperty.setVersion(next.getLong("version"));
                    customProperty.setDseq(next.getInteger("dseq"));
                    properties.add(customProperty);
                }
            }
        }
        return properties;
    }

    private static List<CustomPropertyValue> queryPropValues(List<CustomProperty> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<CustomPropertyValue> customPropertyValues = new LinkedList<CustomPropertyValue>();
        Map<Long, CustomProperty> propMap = list.stream().collect(Collectors.toMap(CustomProperty::getId, e -> e));
        QFBuilder qf = new QFBuilder("property", "in", propMap.keySet());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"MemberPropCacheService.queryPropValues", (String)"eb_custompropertyvalue", (String)"id,number,name,dseq,property", (QFilter[])qf.toArray(), (String)"dseq");){
            if (dataSet != null && !dataSet.isEmpty()) {
                while (dataSet.hasNext()) {
                    CustomPropertyValue customPropertyValue = new CustomPropertyValue();
                    Row next = dataSet.next();
                    customPropertyValue.setId(next.getLong("id"));
                    customPropertyValue.setNumber(next.getString("number"));
                    customPropertyValue.setName(next.getString("name"));
                    customPropertyValue.setDseq(next.getInteger("dseq"));
                    customPropertyValue.setProp(propMap.get(next.getLong("property")));
                    customPropertyValues.add(customPropertyValue);
                }
            }
        }
        return customPropertyValues;
    }

    private static List<CustomPropRelation> queryPropRelation(List<CustomPropertyValue> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CustomPropRelation> propRelations = new ArrayList<CustomPropRelation>(10);
        List<Object> params = list.stream().map(CustomPropertyValue::getId).collect(Collectors.toList());
        List<Map<String, Object>> dataList = SqlBatchUtils.batchQuery("select fid,fentryid,fpropertyvalueid from t_eb_memberpropertyvalue where fpropertyvalueid in (" + SqlBatchUtils.getBatchParamsSql(1000) + ")", params);
        for (Map<String, Object> dataMap : dataList) {
            CustomPropRelation customPropRelation = new CustomPropRelation();
            customPropRelation.setId(IDUtils.toLong(dataMap.get("fentryid")));
            customPropRelation.setMemberId(IDUtils.toLong(dataMap.get("fid")));
            customPropRelation.setPropValueId(IDUtils.toLong(dataMap.get("fpropertyvalueid")));
            propRelations.add(customPropRelation);
        }
        return propRelations;
    }

    static {
        try {
            ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            scheduledExecutor.scheduleAtFixedRate(() -> {
                log.info("\u5b9a\u65f6\u6e05\u7406\u81ea\u5b9a\u4e49\u5c5e\u6027\u7f13\u5b58");
                loadingCache.cleanUp();
            }, 10L, 30L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            log.warn("\u5b9a\u65f6\u6e05\u7406\u81ea\u5b9a\u4e49\u5c5e\u6027\u7f13\u5b58\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        current = ThreadLocal.withInitial(HashMap::new);
    }
}

