/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.propertycache.entity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.entity.property.CustomPropRelation;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.entity.property.IPropertyFilter;
import kd.epm.eb.common.model.IBaseData;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.MapUtils;

public class MemberProDimensionCache {
    private static final Log log = LogFactory.getLog(MemberProDimensionCache.class);
    private Long modelId;
    private String dimensionNumber;
    private String versionId;
    private IModelCacheHelper modelCache;
    private Map<Long, CustomProperty> properties;
    private Map<Long, CustomPropertyValue> propertyValues;
    private List<CustomPropRelation> propRelations;
    private Map<String, CustomPropertyValue> propertyValueMap = null;
    private Map<String, Set<String>> propertyValueRefMemberMap = null;
    private Map<String, Set<Long>> propertyValueRefMemberIdMap = null;

    public MemberProDimensionCache() {
    }

    public MemberProDimensionCache(Long modelId, String dimensionNumber, List<CustomProperty> properties, List<CustomPropertyValue> propertyValues, List<CustomPropRelation> propRelations, Map<String, Map<String, CustomPropertyValue>> propertyValueMap, Map<String, Map<String, Set<Long>>> propertyValueRefMemberMap) {
        this.properties = this.toMap(Sets.newHashSet((Object[])new String[]{dimensionNumber}), properties);
        Set<String> propIds = this.getKey(this.properties.values());
        this.propertyValues = this.toMap(propIds, propertyValues);
        Set<String> propValueIds = this.getKey(this.propertyValues.values());
        this.modelId = modelId;
        this.dimensionNumber = dimensionNumber;
        this.propRelations = new ArrayList<CustomPropRelation>(10);
        if (propRelations != null) {
            for (CustomPropRelation cpr : propRelations) {
                if (propValueIds != null && !propValueIds.contains(String.valueOf(cpr.getPropValueId()))) continue;
                this.propRelations.add(cpr);
            }
        }
        this.propertyValueMap = this.getMap(propertyValueMap.get(this.dimensionNumber));
        this.propertyValueRefMemberIdMap = propertyValueRefMemberMap.get(this.dimensionNumber);
    }

    private <V> Map<String, V> getMap(Map<String, V> dataMap) {
        return dataMap != null ? dataMap : Collections.emptyMap();
    }

    private Set<String> getKey(Collection<? extends IPropertyFilter> properties) {
        HashSet<String> keys = new HashSet<String>(16);
        if (properties != null) {
            for (IPropertyFilter iPropertyFilter : properties) {
                keys.add(iPropertyFilter.getKey());
            }
        }
        return keys;
    }

    private <K, V> Map toMap(Set<String> filter, List<V> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (V v : collection) {
            if (!(v instanceof IBaseData) || filter != null && v instanceof IPropertyFilter && !filter.contains(((IPropertyFilter)v).getForeignKey())) continue;
            map.put(((IBaseData)v).getId(), v);
        }
        return map;
    }

    private IModelCacheHelper getModelCache() {
        if (this.modelCache == null) {
            this.modelCache = ModelCacheContext.getOrCreate(this.modelId);
        }
        return this.modelCache;
    }

    public void setModelCache(IModelCacheHelper modelCache) {
        this.modelCache = modelCache;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
        log.info("versionid = " + versionId + ";modelid=" + this.getModelId() + ";dimensionNumber=" + this.getDimensionNumber());
    }

    public Long getModelId() {
        return this.modelId;
    }

    public String getDimensionNumber() {
        return this.dimensionNumber;
    }

    public Map<String, CustomPropertyValue> getPropertyValueMap() {
        if (this.propertyValueMap == null) {
            this.propertyValueMap = Collections.emptyMap();
        }
        return this.propertyValueMap;
    }

    public Map<String, Set<String>> getPropertyValueRefMemberMap() {
        if (this.propertyValueRefMemberMap == null) {
            if (CollectionUtils.isNotEmpty(this.propertyValueRefMemberIdMap)) {
                this.propertyValueRefMemberMap = Maps.newHashMapWithExpectedSize((int)this.propertyValueRefMemberIdMap.size());
                Dimension dimension = this.getModelCache().getDimension(this.getDimensionNumber());
                for (Map.Entry<String, Set<Long>> propValue : this.propertyValueRefMemberIdMap.entrySet()) {
                    List<Member> members = dimension.getStructOfMember((Collection<Long>)propValue.getValue());
                    this.propertyValueRefMemberMap.put(propValue.getKey(), members.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                }
            } else {
                this.propertyValueRefMemberMap = Collections.emptyMap();
            }
        }
        return this.propertyValueRefMemberMap;
    }

    public CustomProperty getProperty(Long props) {
        return this.properties.get(props);
    }

    public CustomProperty getProperty(String dimNumber, String propNum) {
        if (dimNumber == null || propNum == null) {
            return null;
        }
        IModelCacheHelper modelCache = this.getModelCache();
        Dimension dimension = modelCache.getDimension(dimNumber);
        for (CustomProperty property : this.properties.values()) {
            if (!dimension.getId().equals(property.getDimId()) || !propNum.equals(property.getNumber())) continue;
            return property;
        }
        return null;
    }

    public CustomPropertyValue getPropertyValue(Long propValueId) {
        return this.propertyValues.get(propValueId);
    }

    public List<CustomPropertyValue> getPropertyValue(Collection<Long> propValueIds) {
        if (propValueIds == null || propValueIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CustomPropertyValue> props = new ArrayList<CustomPropertyValue>(propValueIds.size());
        propValueIds.stream().filter(propValueId -> this.propertyValues.containsKey(propValueId)).forEach(propValueId -> props.add(this.propertyValues.get(propValueId)));
        return props;
    }

    public CustomPropertyValue getPropertyValue(String dimNumber, String propNum, String propValueNum) {
        return this.getPropertyValue(String.join((CharSequence)"!", propNum, propValueNum));
    }

    public CustomPropertyValue getPropertyValue(String customPropertyValueLongNumberString) {
        return this.getPropertyValueMap().get(customPropertyValueLongNumberString);
    }

    public CustomPropertyValue getPropertyValueByMemNumber(String dimNumber, String propNum, String memNumber) {
        if (dimNumber == null || propNum == null || memNumber == null) {
            return null;
        }
        for (Map.Entry<String, Set<String>> entry : this.getPropertyValueRefMemberMap().entrySet()) {
            String key = entry.getKey();
            Set<String> value = entry.getValue();
            if (!value.contains(memNumber) || !key.startsWith(propNum)) continue;
            return this.getPropertyValueMap().get(key);
        }
        return null;
    }

    public List<CustomProperty> getPropertiesByDim(Long dimensionId) {
        return this.properties.values().stream().filter(e -> e.getDimId().equals(dimensionId)).collect(Collectors.toList());
    }

    public List<CustomProperty> getPropertiesByDim(String dimensionNumber) {
        IModelCacheHelper modelCache = this.getModelCache();
        Dimension dimension = modelCache.getDimension(dimensionNumber);
        return this.getPropertiesByDim(dimension.getId());
    }

    public Map<Long, CustomPropertyValue> getPropertyValues() {
        return this.propertyValues;
    }

    public List<CustomPropertyValue> getPropertyValuesByProp(Long propId) {
        if (IDUtils.isNull(propId)) {
            return Collections.emptyList();
        }
        return this.getPropertyValues().values().stream().filter(e -> e.getProp() != null && propId.equals(e.getProp().getId())).collect(Collectors.toList());
    }

    public List<CustomPropertyValue> getPropertyValuesByDim(Long dimId) {
        if (IDUtils.isNull(dimId)) {
            return Collections.emptyList();
        }
        Set collect = this.properties.values().stream().filter(e -> dimId.equals(e.getDimId())).collect(Collectors.toSet());
        return this.propertyValues.values().stream().filter(e -> collect.contains(e.getProp())).collect(Collectors.toList());
    }

    public List<CustomPropRelation> getPropRelations() {
        return this.propRelations;
    }

    public Set<String> getRefMembers(String dimNumber, String propNumber, String propValueNumber) {
        if (MapUtils.isEmpty(this.getPropertyValueRefMemberMap())) {
            return Collections.emptySet();
        }
        return this.getPropertyValueRefMemberMap().get(propNumber + "!" + propValueNumber);
    }

    public Set<String> getRefMembersByLongNumber(String dimNumber, String longNumber) {
        return this.getPropertyValueRefMemberMap().get(longNumber);
    }
}

