/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.propertycache.entity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberProDimensionCache;
import kd.epm.eb.common.entity.property.CustomPropRelation;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyUtils;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;

public class MemberPropCache {
    private static final Log log = LogFactory.getLog(MemberPropCache.class);
    private Long modelId;
    private String versionId;
    private IModelCacheHelper modelCache;
    private LoadingCache<String, MemberProDimensionCache> dimensionCaches = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(2L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, MemberProDimensionCache>(){

        @NotNull
        public MemberProDimensionCache load(String dimNumber) {
            return MemberPropCache.this.initPropDimensionCache(dimNumber);
        }
    });

    public MemberPropCache() {
    }

    protected MemberProDimensionCache initPropDimensionCache(String dimNumber) {
        HashSet dimNumbers = Sets.newHashSet((Object[])new String[]{dimNumber});
        MemberPropCache cache = MemberPropCacheService.initMemberProp(this.getModelId(), dimNumbers);
        return (MemberProDimensionCache)cache.dimensionCaches.getIfPresent((Object)dimNumber);
    }

    public MemberPropCache(Long modelId, @NotNull Set<String> dimensionNumbers, List<CustomProperty> properties, List<CustomPropertyValue> propertyValues, List<CustomPropRelation> propRelations, Map<String, Map<String, CustomPropertyValue>> propertyValueMap, Map<String, Map<String, Set<Long>>> propertyValueRefMemberMap) {
        this.modelId = modelId;
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        for (String dimNumber : dimensionNumbers) {
            MemberProDimensionCache dimCache = new MemberProDimensionCache(modelId, dimNumber, properties, propertyValues, propRelations, propertyValueMap, propertyValueRefMemberMap);
            if (modelCache.getDimension(dimNumber) != null) {
                dimCache.setVersionId(MemberPropCacheService.getVersionByCache(modelId, modelCache.getDimension(dimNumber).getId()));
            }
            this.dimensionCaches.put((Object)dimNumber, (Object)dimCache);
        }
    }

    private IModelCacheHelper getModelCache() {
        if (this.modelCache == null) {
            this.modelCache = ModelCacheContext.getOrCreate(this.modelId);
        }
        return this.modelCache;
    }

    public void setModelCache(IModelCacheHelper modelCache) {
        this.modelCache = modelCache;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public Long getModelId() {
        return this.modelId;
    }

    private List<MemberProDimensionCache> getCache(String dimNumber) {
        ArrayList<MemberProDimensionCache> caches = new ArrayList<MemberProDimensionCache>(10);
        HashSet<String> dimnumbers = new HashSet<String>(32);
        if (dimNumber == null) {
            dimnumbers.addAll(this.getModelCache().getDimensionMap().keySet());
        } else {
            dimnumbers.add(dimNumber);
        }
        Iterator it = dimnumbers.iterator();
        while (it.hasNext()) {
            if (CustomPropertyUtils.hasCustomProperty((String)it.next())) continue;
            it.remove();
        }
        for (String dNumber : dimnumbers) {
            if (this.getModelCache().getDimension(dNumber) == null) continue;
            try {
                MemberProDimensionCache cache = (MemberProDimensionCache)this.dimensionCaches.get((Object)dNumber);
                if (!StringUtils.equals(cache.getVersionId(), MemberPropCacheService.getVersion(this.modelId, this.getModelCache().getDimension(dNumber).getId()))) {
                    this.dimensionCaches.refresh((Object)dNumber);
                    cache = (MemberProDimensionCache)this.dimensionCaches.get((Object)dNumber);
                }
                cache.setModelCache(this.getModelCache());
                caches.add(cache);
            }
            catch (ExecutionException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        return caches;
    }

    private Map<String, Set<String>> getPropertyValueRefMemberMap(String dimNumber) {
        HashMap<String, Set<String>> values = new HashMap<String, Set<String>>(16);
        List<MemberProDimensionCache> caches = this.getCache(dimNumber);
        for (MemberProDimensionCache cache : caches) {
            Map<String, Set<String>> v = cache.getPropertyValueRefMemberMap();
            if (v == null) continue;
            values.putAll(v);
        }
        return values;
    }

    public CustomProperty getProperty(Long props) {
        return this.getProperty(null, props);
    }

    public CustomProperty getProperty(String dimNumber, Long props) {
        List<MemberProDimensionCache> caches = this.getCache(dimNumber);
        for (MemberProDimensionCache cache : caches) {
            CustomProperty p = cache.getProperty(props);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public CustomProperty getProperty(String dimNumber, String propNum) {
        if (dimNumber == null || propNum == null) {
            return null;
        }
        List<MemberProDimensionCache> caches = this.getCache(dimNumber);
        for (MemberProDimensionCache cache : caches) {
            CustomProperty p = cache.getProperty(dimNumber, propNum);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @Deprecated
    public CustomPropertyValue getPropertyValue(Long propValueId) {
        return this.getPropertyValue(null, propValueId);
    }

    public CustomPropertyValue getPropertyValue(String dimNumber, Long propValueId) {
        List<MemberProDimensionCache> caches = this.getCache(dimNumber);
        for (MemberProDimensionCache cache : caches) {
            CustomPropertyValue v = cache.getPropertyValue(propValueId);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    @Deprecated
    public List<CustomPropertyValue> getPropertyValue(Collection<Long> propValueIds) {
        if (propValueIds == null || propValueIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CustomPropertyValue> props = new ArrayList<CustomPropertyValue>(propValueIds.size());
        List<MemberProDimensionCache> caches = this.getCache(null);
        for (MemberProDimensionCache cache : caches) {
            props.addAll(cache.getPropertyValue(propValueIds));
        }
        return props;
    }

    public CustomPropertyValue getPropertyValue(@NotNull String dimNumber, String propNum, String propValueNum) {
        List<MemberProDimensionCache> caches = this.getCache(dimNumber);
        for (MemberProDimensionCache cache : caches) {
            CustomPropertyValue value = cache.getPropertyValue(dimNumber, propNum, propValueNum);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public CustomPropertyValue getPropertyValue(String dimNumber, String customPropertyValueLongNumberString) {
        if (StringUtils.isEmpty(dimNumber) || StringUtils.isEmpty(customPropertyValueLongNumberString)) {
            return null;
        }
        List<MemberProDimensionCache> caches = this.getCache(dimNumber);
        for (MemberProDimensionCache cache : caches) {
            CustomPropertyValue value = cache.getPropertyValue(customPropertyValueLongNumberString);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public CustomPropertyValue getPropertyValueByMemNumber(String dimNumber, String propNum, String memNumber) {
        if (dimNumber == null || propNum == null || memNumber == null) {
            return null;
        }
        List<MemberProDimensionCache> caches = this.getCache(dimNumber);
        for (MemberProDimensionCache cache : caches) {
            CustomPropertyValue value = cache.getPropertyValueByMemNumber(dimNumber, propNum, memNumber);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public List<CustomProperty> getPropertiesByDim(Long dimensionId) {
        String dimNumber = this.getModelCache().getDimension(dimensionId).getNumber();
        return this.getPropertiesByDim(dimNumber);
    }

    public List<CustomProperty> getPropertiesByDim(String dimensionNumber) {
        List<MemberProDimensionCache> caches = this.getCache(dimensionNumber);
        ArrayList<CustomProperty> result = new ArrayList<CustomProperty>(16);
        for (MemberProDimensionCache cache : caches) {
            List<CustomProperty> values = cache.getPropertiesByDim(dimensionNumber);
            if (values == null) continue;
            result.addAll(values);
        }
        return result;
    }

    public Map<Long, CustomPropertyValue> getPropertyValues(@NotNull String dimNumber) {
        List<MemberProDimensionCache> caches = this.getCache(dimNumber);
        HashMap<Long, CustomPropertyValue> result = new HashMap<Long, CustomPropertyValue>(16);
        for (MemberProDimensionCache cache : caches) {
            Map<Long, CustomPropertyValue> values = cache.getPropertyValues();
            if (values == null) continue;
            result.putAll(values);
        }
        return result;
    }

    public List<CustomPropertyValue> getPropertyValuesByProp(String dimNumber, Long propId) {
        List<MemberProDimensionCache> caches = this.getCache(dimNumber);
        ArrayList<CustomPropertyValue> result = new ArrayList<CustomPropertyValue>(16);
        for (MemberProDimensionCache cache : caches) {
            List<CustomPropertyValue> values = cache.getPropertyValuesByProp(propId);
            if (values == null) continue;
            result.addAll(values);
        }
        return result;
    }

    public List<CustomPropertyValue> getPropertyValuesByDim(Long dimId) {
        ArrayList<CustomPropertyValue> result = new ArrayList<CustomPropertyValue>(10);
        if (IDUtils.isNull(dimId)) {
            return result;
        }
        Dimension dimension = this.getModelCache().getDimension(dimId);
        List<MemberProDimensionCache> caches = this.getCache(dimension.getNumber());
        for (MemberProDimensionCache cache : caches) {
            List<CustomPropertyValue> list = cache.getPropertyValuesByDim(dimId);
            if (list == null) continue;
            result.addAll(list);
        }
        return result;
    }

    @Deprecated
    public List<CustomPropertyValue> getPropValuesByMember(Long memberId) {
        if (IDUtils.isNull(memberId)) {
            return Collections.emptyList();
        }
        Set<Long> propValueIds = this.getPropRelations(null).stream().filter(p -> memberId.equals(p.getMemberId())).map(CustomPropRelation::getPropValueId).collect(Collectors.toSet());
        return this.getPropertyValue(propValueIds);
    }

    public List<Member> getMembersByPropValues(Long dimensionId, Long viewId, List<Long> propValueIds) {
        if (propValueIds == null || propValueIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Member> members = new ArrayList<Member>(propValueIds.size());
        for (Long propValueId : propValueIds) {
            members.addAll(this.getMembersByPropValues(dimensionId, viewId, propValueId));
        }
        return members;
    }

    public List<Member> getMembersByPropValuesAnyView(Long dimensionId, Long busModelId, Long propValueId) {
        if (dimensionId == null || propValueId == null) {
            return Collections.emptyList();
        }
        IModelCacheHelper modelCache = this.getModelCache();
        Dimension dimension = modelCache.getDimension(dimensionId);
        String dimNumber = dimension.getNumber();
        Set memberIds = this.getPropRelations(dimNumber).stream().filter(p -> propValueId.equals(p.getPropValueId())).map(CustomPropRelation::getMemberId).collect(Collectors.toSet());
        if (memberIds == null || memberIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Member> members = new ArrayList<Member>(memberIds.size());
        for (Long id : memberIds) {
            Member m = modelCache.getMemberByAnyView(busModelId, dimNumber, id);
            if (m == null) continue;
            members.add(m);
        }
        return members.stream().filter(e -> !e.getNumber().endsWith("._inv")).collect(Collectors.toList());
    }

    public List<Member> getMembersByPropValues(Long dimensionId, Long viewId, Long propValueId) {
        List<Member> members;
        if (dimensionId == null || propValueId == null) {
            return Collections.emptyList();
        }
        IModelCacheHelper modelCache = this.getModelCache();
        Dimension dimension = modelCache.getDimension(dimensionId);
        String dimNumber = dimension.getNumber();
        Set<Long> memberIds = this.getPropRelations(dimNumber).stream().filter(p -> propValueId.equals(p.getPropValueId())).map(CustomPropRelation::getMemberId).collect(Collectors.toSet());
        View view = dimension.getView(viewId);
        List<Member> list = members = view != null ? view.getMemberByIds(memberIds) : dimension.getMemberByIds(memberIds);
        if (members == null) {
            return Collections.emptyList();
        }
        return members.stream().filter(e -> !e.getNumber().endsWith("._inv")).collect(Collectors.toList());
    }

    public List<CustomPropRelation> getPropRelations(String dimNumber) {
        ArrayList<CustomPropRelation> result = new ArrayList<CustomPropRelation>(16);
        List<MemberProDimensionCache> caches = this.getCache(dimNumber);
        for (MemberProDimensionCache cache : caches) {
            List<CustomPropRelation> values = cache.getPropRelations();
            if (values == null) continue;
            result.addAll(values);
        }
        return result;
    }

    public Set<String> getRefMemberNums(String dimNum, Long propValId) {
        CustomPropertyValue propertyValue = this.getPropertyValue(dimNum, propValId);
        if (propertyValue == null || propertyValue.getProp() == null) {
            return null;
        }
        return this.getRefMembers(dimNum, propertyValue.getProp().getNumber(), propertyValue.getNumber());
    }

    public Set<String> getRefMembers(String dimNumber, String propNumber, String propValueNumber) {
        List<MemberProDimensionCache> caches = this.getCache(dimNumber);
        HashSet<String> result = new HashSet<String>(16);
        for (MemberProDimensionCache cache : caches) {
            Set<String> values = cache.getRefMembers(dimNumber, propNumber, propValueNumber);
            if (values == null) continue;
            result.addAll(values);
        }
        return result;
    }

    public Set<String> getRefMembersByLongNumber(String dimNumber, String longNumber) {
        List<MemberProDimensionCache> caches = this.getCache(dimNumber);
        HashSet<String> result = new HashSet<String>(16);
        for (MemberProDimensionCache cache : caches) {
            Set<String> values = cache.getRefMembersByLongNumber(dimNumber, longNumber);
            if (values == null) continue;
            result.addAll(values);
        }
        return result;
    }

    public static List<Member> getMembersByPropValues(IModelCacheHelper modelCacheHelper, MemberPropCache memberPropCache, Long viewIdLong, String dimensionNumberString, String customPropertyNumberString, String customPropertyValueNumberString) {
        if (modelCacheHelper == null || memberPropCache == null) {
            return Collections.emptyList();
        }
        Map<String, Set<String>> propertyValueRefMemberMap = memberPropCache.getPropertyValueRefMemberMap(dimensionNumberString);
        Set<String> memberNumberStringSet = propertyValueRefMemberMap.get(String.join((CharSequence)"!", customPropertyNumberString, customPropertyValueNumberString));
        if (memberNumberStringSet == null) {
            return Collections.emptyList();
        }
        Dimension dimension = modelCacheHelper.getDimension(dimensionNumberString);
        return memberNumberStringSet.stream().map(item -> dimension.getMember(viewIdLong, (String)item)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<Member> getMembersByPropValues(IModelCacheHelper modelCacheHelper, MemberPropCache memberPropCache, Long viewIdLong, CustomPropertyValue customPropertyValue) {
        if (customPropertyValue == null || customPropertyValue.getProp() == null) {
            return Collections.emptyList();
        }
        Dimension dimension = modelCacheHelper.getDimension(customPropertyValue.getProp().getDimId());
        return MemberPropCache.getMembersByPropValues(modelCacheHelper, memberPropCache, viewIdLong, dimension.getNumber(), customPropertyValue.getProp().getNumber(), customPropertyValue.getNumber());
    }

    public static Set<String> getMembersByPropValues(MemberPropCache memberPropCache, String dimNumber, String customPropertyValueLongNumberString) {
        if (memberPropCache == null || StringUtils.isEmpty(dimNumber) || StringUtils.isEmpty(customPropertyValueLongNumberString)) {
            return Collections.emptySet();
        }
        Map<String, Set<String>> propertyValueRefMemberMap = memberPropCache.getPropertyValueRefMemberMap(dimNumber);
        if (MapUtils.isEmpty(propertyValueRefMemberMap)) {
            return Collections.emptySet();
        }
        return propertyValueRefMemberMap.get(customPropertyValueLongNumberString);
    }

    public static CustomPropertyValue getCustomPropertyValue(MemberPropCache memberPropCache, String dimNumber, String customPropertyValueLongNumberString) {
        return memberPropCache.getPropertyValue(dimNumber, customPropertyValueLongNumberString);
    }

    public static CustomPropertyValue getCustomPropertyValue(MemberPropCache memberPropCache, String dimNumber, Long customPropertyValueId) {
        return memberPropCache.getPropertyValue(dimNumber, customPropertyValueId);
    }
}

