/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.threadlocal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.utils.DataSourceUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.UserUtils;

public class EpmThreadLocalUtils {
    private static final ThreadLocal<Map<String, Object>> COMM_LOCAL = ThreadLocal.withInitial(HashMap::new);
    private static final String LIMIT_MODEL_PERM_KEY = "LIMIT_MODEL_PERM_KEY";
    private static final String EFFECTIVE_MODEL_PERM_KEY = "EFFECTIVE_MODEL_PERM_KEY";
    private static final String EPM_SHREK_CHECK_ACCOUNT_KEY = "EPM_SHREK_CHECK_ACCOUNT_KEY";
    private static final String EPM_DECOMPOSE_ADJUST_DATA_KEY = "EPM_DECOMPOSE_ADJUST_DATA_KEY";
    private static final String EPM_PERM_DATA_KEY = "EPM_PERM_NUM_DATA_KEY";
    private static final String EPM_PERM_ID_DATA_KEY = "EPM_PERM_ID_DATA_KEY";
    private static final String EPM_PERM_CHECK_DATA_KEY = "EPM_PERM_CHECK_DATA_KEY";
    private static final String DIM_VER_CHECK = "DIM_VER_NO_CHECK_KEY";
    private static final String DIM_VIEW_MEM_RANGE = "DIM_VIEW_MEM_RANGE";
    private static final String BUDGET_EXPORT_FLAG = "BUDGET_EXPORT_FLAG";

    protected static ThreadLocal<Map<String, Object>> getCommLocal() {
        return COMM_LOCAL;
    }

    private static String getApplicationNum(ApplicationTypeEnum application) {
        return application != null ? application.getIndex() : "nullApp";
    }

    public static void remove() {
        EpmThreadLocalUtils.getCommLocal().remove();
    }

    public static Set<Long> getLimitedModelListByUser(ApplicationTypeEnum application, Long userId) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getCommLocal().get();
        Long _userId = IDUtils.isNull(userId) ? UserUtils.getUserId() : userId;
        HashSet<Long> modelIds = new HashSet<Long>();
        String _localKey = "LIMIT_MODEL_PERM_KEY." + EpmThreadLocalUtils.getApplicationNum(application) + '.' + _userId;
        Object _result = _dataMap.computeIfAbsent(_localKey, f -> ModelServiceHelper.$getLimitedModelListByUser(application, _userId));
        if (_result instanceof Set) {
            modelIds = new HashSet((Set)_result);
        }
        return modelIds;
    }

    public static Set<Long> getEffectiveByPermModel(String entity, ApplicationTypeEnum application) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getCommLocal().get();
        HashSet<Long> modelIds = new HashSet<Long>();
        String _localKey = "EFFECTIVE_MODEL_PERM_KEY." + EpmThreadLocalUtils.getApplicationNum(application) + '.' + entity;
        Object _result = _dataMap.computeIfAbsent(_localKey, f -> FunPermissionHelper.$getEffectiveByPermModel(entity, application));
        if (_result instanceof Set) {
            modelIds = new HashSet((Set)_result);
        }
        return modelIds;
    }

    public static boolean verifyAccountId(Long dataSourceId, String accountId) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getCommLocal().get();
        boolean verify = true;
        String _localKey = "EPM_SHREK_CHECK_ACCOUNT_KEY." + dataSourceId + '.' + accountId;
        Object _result = _dataMap.computeIfAbsent(_localKey, f -> DataSourceUtils.$verifyAccountByPrivate(dataSourceId, accountId));
        if (_result instanceof Boolean) {
            verify = (Boolean)_result;
        }
        return verify;
    }

    public static DynamicObjectCollection getAdjustDys(String entity, String field, QFilter filter) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getCommLocal().get();
        DynamicObjectCollection result = new DynamicObjectCollection();
        String _localKey = "EPM_DECOMPOSE_ADJUST_DATA_KEY." + filter.toString();
        Object _result = _dataMap.computeIfAbsent(_localKey, f -> QueryServiceHelper.query((String)entity, (String)field, (QFilter[])filter.toArray()));
        if (_result instanceof DynamicObjectCollection) {
            result = (DynamicObjectCollection)_result;
        }
        return result;
    }

    public static Set<String> getPermMembNumbers(String dimensionNumber, Long modelId, Long bizModelId, Long viewId, DimMembPermType permTypeEnum, boolean needHasPerm) {
        return EpmThreadLocalUtils.getPermMembNumbers(UserUtils.getUserId(), dimensionNumber, modelId, bizModelId, viewId, permTypeEnum, needHasPerm);
    }

    public static Set<String> getPermMembNumbers(Long userId, String dimensionNumber, Long modelId, Long bizModelId, Long viewId, DimMembPermType permTypeEnum, boolean needHasPerm) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getCommLocal().get();
        HashSet result = null;
        String _localKey = "EPM_PERM_NUM_DATA_KEY." + userId + '.' + dimensionNumber + '.' + modelId + '.' + bizModelId + '.' + viewId + '.' + (Object)((Object)permTypeEnum) + '.' + needHasPerm;
        Object _result = _dataMap.computeIfAbsent(_localKey, f -> DimMembPermHelper.getPermMembNumbers(userId, dimensionNumber, modelId, bizModelId, viewId, permTypeEnum, needHasPerm));
        if (_result instanceof Set) {
            result = new HashSet((Set)_result);
        }
        return result;
    }

    public static Set<Long> getPermMembIds(String dimensionNumber, Long modelId, Long bizModelId, Long viewId, DimMembPermType permTypeEnum, boolean needHasPerm) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getCommLocal().get();
        HashSet result = null;
        String _localKey = "EPM_PERM_ID_DATA_KEY." + dimensionNumber + '.' + modelId + '.' + bizModelId + '.' + viewId + '.' + (Object)((Object)permTypeEnum) + '.' + needHasPerm;
        Object _result = _dataMap.computeIfAbsent(_localKey, f -> DimMembPermHelper.getPermMembIds(dimensionNumber, modelId, bizModelId, viewId, permTypeEnum, needHasPerm));
        if (_result instanceof Set) {
            result = new HashSet((Set)_result);
        }
        return result;
    }

    public static DimMemberPermChecker getWritePermChecker(Long modelId, Long datasetId) {
        return EpmThreadLocalUtils.getPermChecker(modelId, datasetId, null, DimMembPermType.WRITE);
    }

    public static DimMemberPermChecker getPermChecker(Long modelId, Long datasetId, Long userId, DimMembPermType permType) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getCommLocal().get();
        String _localKey = "EPM_PERM_CHECK_DATA_KEY." + modelId + '.' + datasetId + '.' + userId + '.' + (Object)((Object)permType);
        return (DimMemberPermChecker)_dataMap.computeIfAbsent(_localKey, f -> DimMembPermHelper.getPermChecker(modelId, datasetId, userId, permType));
    }

    public static void setDimNoCheckVersion(long modelId) {
        String key = DIM_VER_CHECK + modelId;
        Map<String, Object> map = COMM_LOCAL.get();
        map.put(key, "noCheck");
        COMM_LOCAL.set(map);
    }

    public static boolean needDimCheckVersion(long modelId) {
        String key = DIM_VER_CHECK + modelId;
        Map<String, Object> map = COMM_LOCAL.get();
        return map == null || !map.containsKey(key);
    }

    public static List<Member> getMemberRange(long modelId, String dimNumber, long viewId, String memNumber, int range) {
        Map<String, Object> _dataMap = COMM_LOCAL.get();
        String _localKey = "DIM_VIEW_MEM_RANGE." + modelId + '.' + dimNumber + '.' + viewId + '.' + memNumber + '.' + range;
        return (List)_dataMap.computeIfAbsent(_localKey, f -> {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
            return modelCache.getMember(dimNumber, (Long)viewId, memNumber, range);
        });
    }

    public static void setBudgetExportFlag() {
        String key = BUDGET_EXPORT_FLAG;
        Map<String, Object> map = COMM_LOCAL.get();
        map.put(key, "export");
        COMM_LOCAL.set(map);
    }

    public static boolean budgetExporgFlag() {
        String key = BUDGET_EXPORT_FLAG;
        Map<String, Object> map = COMM_LOCAL.get();
        return map != null && map.containsKey(key);
    }
}

