/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.central;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.central.CentralizedUtils;
import kd.epm.eb.common.central.ContralBO;
import kd.epm.eb.common.central.ContralCellDao;
import kd.epm.eb.common.central.ContralDao;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;

public class CentraliTransUtils {
    public static ContralBO dao2bo(IModelCacheHelper modelCache, ContralDao contralDao) {
        String accounts = contralDao.getAccounts();
        Set<String> members = CentralizedUtils.mbgRangeString(accounts);
        ContralBO currentBo = new ContralBO();
        currentBo.setControlAccounts(members);
        kd.epm.eb.common.cache.impl.Dimension dimension = modelCache.getDimension(contralDao.getDimensionId());
        currentBo.setControlDimension(new Dimension(dimension.getId(), dimension.getName(), dimension.getNumber()));
        List<ContralCellDao> cells = contralDao.getCells();
        if (cells == null || cells.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ba1\u63a7\u8303\u56f4\u5355\u636e\u4f53\u6570\u636e\u3002", (String)"CentralizedServiceImpl_2", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        ArrayList<Set<String>> empty = new ArrayList<Set<String>>();
        ArrayList<Pair<Set<String>, List<Set<String>>>> controls = new ArrayList<Pair<Set<String>, List<Set<String>>>>();
        HashSet<String> result = new HashSet<String>();
        CentraliTransUtils.checkSelf(modelCache, dimension.getNumber(), cells, contralDao.getBussmodelId());
        for (int i = 0; i < cells.size(); ++i) {
            ContralCellDao cellDao = cells.get(i);
            Set<String> entityMember = CentraliTransUtils.getAllDetailMember(modelCache, "Entity", cellDao.getEntityRange(), contralDao.getBussmodelId());
            Set<String> allDetailMember = CentraliTransUtils.getAllDetailMember(modelCache, dimension.getNumber(), cellDao.getDimensionrange(), contralDao.getBussmodelId());
            if (entityMember.isEmpty() && StringUtils.isEmpty(cellDao.getEntityRange())) {
                empty.add(allDetailMember);
                continue;
            }
            if (controls.isEmpty()) {
                ArrayList<Set<String>> es = new ArrayList<Set<String>>(16);
                es.add(allDetailMember);
                controls.add(new Pair(entityMember, es));
                continue;
            }
            ArrayList<Pair<Set<String>, List<Set<String>>>> newcontrol = new ArrayList<Pair<Set<String>, List<Set<String>>>>();
            for (int j = 0; j < controls.size(); ++j) {
                Pair<Set<String>, List<Set<String>>> pair = controls.get(j);
                HashSet key = new HashSet(pair.getKey());
                result.clear();
                result.addAll(entityMember);
                result.retainAll(key);
                if (!result.isEmpty()) {
                    List<Set<String>> value = pair.getValue();
                    entityMember.removeAll(result);
                    key.removeAll(result);
                    if (key.isEmpty()) {
                        value.add(allDetailMember);
                        newcontrol.add(pair);
                    } else {
                        newcontrol.add(new Pair(key, value));
                        HashSet strings = new HashSet(result);
                        ArrayList<Set<String>> newvalue = new ArrayList<Set<String>>(value);
                        newvalue.add(allDetailMember);
                        newcontrol.add(new Pair(strings, newvalue));
                    }
                } else {
                    newcontrol.add(pair);
                }
                if (entityMember.isEmpty()) break;
            }
            if (!entityMember.isEmpty()) {
                ArrayList<Set<String>> es = new ArrayList<Set<String>>(16);
                es.add(allDetailMember);
                newcontrol.add(new Pair(entityMember, es));
            }
            controls = newcontrol;
        }
        currentBo.setEmptyControl(empty);
        currentBo.setControlMembers(controls);
        return currentBo;
    }

    public static Set<String> getAllDetailMember(IModelCacheHelper modelCache, String dimNumber, String dimensionrange, Long busModelId) {
        if (dimensionrange == null || StringUtils.isEmpty(dimensionrange)) {
            return new HashSet<String>(0);
        }
        HashSet<String> dimNumbers = new HashSet<String>(200);
        Set<String> dimMembers = CentralizedUtils.mbgRangeString(dimensionrange);
        MemberPropCache propCache = MemberPropCacheService.getOrCreate(modelCache.getModelobj().getId());
        Set<String> proMembers = dimMembers.stream().filter(k -> k.startsWith("pro")).collect(Collectors.toSet());
        Set<String> members = dimMembers.stream().filter(k -> !k.startsWith("pro")).collect(Collectors.toSet());
        members.forEach(number -> {
            List<Member> memberList = modelCache.getMemberByAnyView(dimNumber, busModelId, (String)number, RangeEnum.ALL_DETAIL.getIndex());
            if (memberList == null || memberList.size() < 1) {
                dimNumbers.add((String)number);
            } else {
                for (Member member : memberList) {
                    dimNumbers.add(member.getNumber());
                }
            }
        });
        proMembers.forEach(proMember -> {
            Long propvalueId = IDUtils.toLong(proMember.split("=")[1]);
            dimNumbers.addAll(propCache.getMembersByPropValuesAnyView(modelCache.getDimension("Entity").getId(), busModelId, propvalueId).stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
        });
        return dimNumbers;
    }

    public static ContralDao doj2dao(DynamicObject entity) {
        if (entity == null) {
            return null;
        }
        ContralDao contralDao = new ContralDao();
        contralDao.setId(entity.getLong("id"));
        contralDao.setNumber(entity.getString("number"));
        contralDao.setDescription(entity.getLocaleString("description"));
        contralDao.setModelId(entity.getLong("model.id"));
        contralDao.setDimensionId(entity.getLong("dimension.id"));
        contralDao.setBussmodelId(entity.getLong("bussmodel.id"));
        contralDao.setAccounts(entity.getString("account"));
        contralDao.setEnable(entity.getBoolean("status"));
        DynamicObjectCollection orgrange = entity.getDynamicObjectCollection("orgrange");
        ArrayList<ContralCellDao> cells = new ArrayList<ContralCellDao>();
        contralDao.setCells(cells);
        for (DynamicObject dynamicObject : orgrange) {
            ContralCellDao cellDao = new ContralCellDao();
            cellDao.setTargetEntity(dynamicObject.getLong("entity.id"));
            cellDao.setDimensionrange(dynamicObject.getString("dimensionrange"));
            cellDao.setEntityRange(dynamicObject.getString("entityrange"));
            cells.add(cellDao);
        }
        return contralDao;
    }

    private static void checkSelf(IModelCacheHelper modelCache, String dimNumber, List<ContralCellDao> cells, Long bussModelId) {
        for (int i = 0; i < cells.size(); ++i) {
            for (int j = i + 1; j < cells.size(); ++j) {
                ContralCellDao c1 = cells.get(i);
                ContralCellDao c2 = cells.get(j);
                Set<String> entityMember1 = CentraliTransUtils.getAllDetailMember(modelCache, SysDimensionEnum.Entity.getNumber(), c1.getEntityRange(), bussModelId);
                Set<String> entityMember2 = CentraliTransUtils.getAllDetailMember(modelCache, SysDimensionEnum.Entity.getNumber(), c2.getEntityRange(), bussModelId);
                entityMember1.retainAll(entityMember2);
                if (entityMember1.isEmpty() && !SysDimensionEnum.Entity.getNumber().equals(dimNumber)) continue;
                Set<String> allDetailMember1 = CentraliTransUtils.getAllDetailMember(modelCache, dimNumber, c1.getDimensionrange(), bussModelId);
                Set<String> allDetailMember2 = CentraliTransUtils.getAllDetailMember(modelCache, dimNumber, c2.getDimensionrange(), bussModelId);
                allDetailMember1.retainAll(allDetailMember2);
                if (allDetailMember1.isEmpty()) continue;
                String errMsg = null;
                if (!SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
                    String showDim = dimNumber + "\u3001" + SysDimensionEnum.Entity.getNumber();
                    errMsg = ResManager.loadResFormat((String)"\u5f53\u524d\u5f52\u53e3\u65b9\u6848\u4e0e\u81ea\u8eab\u5f52\u53e3\u8303\u56f4\u76f8\u540c\uff0c\u63a7\u5236\u7ef4\u5ea6\uff1a%1\uff0c\u76f8\u540c\u8303\u56f4\u6210\u5458\uff1a%2\u3001%3\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5\u5e76\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"CentralizedServiceImpl_7", (String)"epm-eb-common", (Object[])new Object[]{showDim, allDetailMember1.toString(), entityMember1.toString()});
                } else {
                    errMsg = ResManager.loadResFormat((String)"\u5f53\u524d\u5f52\u53e3\u65b9\u6848\u4e0e\u81ea\u8eab\u5f52\u53e3\u8303\u56f4\u76f8\u540c\uff0c\u63a7\u5236\u7ef4\u5ea6\u4e3a\u201c%1\u201d\uff0c\u76f8\u540c\u8303\u56f4\u6210\u5458\u4e3a\u201c%2\u201d\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5\u5e76\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"CentralizedServiceImpl_4", (String)"epm-eb-common", (Object[])new Object[]{dimNumber, allDetailMember1.toString()});
                }
                throw new KDBizException(errMsg);
            }
        }
    }
}

