/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.central;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.central.CentraliTransUtils;
import kd.epm.eb.common.central.ContralCellDao;
import kd.epm.eb.common.central.ContralDao;

public class CentralizedMapper {
    private static final CentralizedMapper instance = new CentralizedMapper();
    private static final String ENTITYNAME = "eb_centralized_entity";

    public static CentralizedMapper getInstance() {
        return instance;
    }

    public ContralDao saveContral(ContralDao contralDao) {
        DynamicObject entity;
        Long id = contralDao.getId();
        if (id == 0L) {
            entity = BusinessDataServiceHelper.newDynamicObject((String)ENTITYNAME);
            entity.set("creater", (Object)contralDao.getCreater());
            entity.set("createdate", (Object)contralDao.getCreatedate());
        } else {
            entity = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITYNAME);
        }
        entity.set("status", (Object)contralDao.isEnable());
        entity.set("number", (Object)contralDao.getNumber());
        entity.set("bussmodel", (Object)contralDao.getBussmodelId());
        entity.set("description", (Object)contralDao.getDescription());
        entity.set("model", (Object)contralDao.getModelId());
        entity.set("dimension", (Object)contralDao.getDimensionId());
        entity.set("account", (Object)contralDao.getAccounts());
        entity.set("text0", (Object)contralDao.getAccountNames());
        DynamicObjectCollection orgrange = entity.getDynamicObjectCollection("orgrange");
        orgrange.clear();
        for (ContralCellDao cellDao : contralDao.getCells()) {
            DynamicObject childEntity = orgrange.addNew();
            childEntity.set("entity", (Object)cellDao.getTargetEntity());
            childEntity.set("range", (Object)cellDao.getDimensionrangeShow());
            childEntity.set("dimensionrange", (Object)cellDao.getDimensionrange());
            childEntity.set("rangenumbers", (Object)cellDao.getRangenumbers());
            childEntity.set("entityrange", (Object)cellDao.getEntityRange());
            childEntity.set("entityrangenumbers", (Object)cellDao.getEntityRangeNumbers());
        }
        entity.set("modifier", (Object)contralDao.getModifier());
        entity.set("modifydate", (Object)contralDao.getModifydate());
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
        contralDao.setId(((DynamicObject)save[0]).getLong("id"));
        return contralDao;
    }

    public void saveImportContral(List<ContralDao> contralDaos) {
        int initialCapacity = (int)Math.ceil((double)contralDaos.size() / 0.75);
        ArrayList<DynamicObject> template = new ArrayList<DynamicObject>(initialCapacity);
        for (ContralDao contralDao : contralDaos) {
            DynamicObject entity;
            Long id = contralDao.getId();
            if (id == 0L) {
                entity = BusinessDataServiceHelper.newDynamicObject((String)ENTITYNAME);
                entity.set("creater", (Object)contralDao.getCreater());
                entity.set("createdate", (Object)contralDao.getCreatedate());
            } else {
                entity = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITYNAME);
            }
            entity.set("status", (Object)contralDao.isEnable());
            entity.set("number", (Object)contralDao.getNumber());
            entity.set("description", (Object)contralDao.getDescription());
            entity.set("model", (Object)contralDao.getModelId());
            entity.set("dimension", (Object)contralDao.getDimensionId());
            entity.set("account", (Object)contralDao.getAccounts());
            entity.set("text0", (Object)contralDao.getAccountNames());
            entity.set("bussmodel", (Object)contralDao.getBussmodelId());
            DynamicObjectCollection orgrange = entity.getDynamicObjectCollection("orgrange");
            orgrange.clear();
            for (ContralCellDao cellDao : contralDao.getCells()) {
                DynamicObject childEntity = orgrange.addNew();
                childEntity.set("entity", (Object)cellDao.getTargetEntity());
                childEntity.set("range", (Object)cellDao.getDimensionrangeShow());
                childEntity.set("dimensionrange", (Object)cellDao.getDimensionrange());
                childEntity.set("rangenumbers", (Object)cellDao.getRangenumbers());
                childEntity.set("entityrange", (Object)cellDao.getEntityRange());
                childEntity.set("entityrangenumbers", (Object)cellDao.getEntityRangeNumbers());
            }
            entity.set("modifier", (Object)contralDao.getModifier());
            entity.set("modifydate", (Object)contralDao.getModifydate());
            template.add(entity);
        }
        if (template.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])template.toArray(new DynamicObject[0]));
        }
    }

    public ContralDao getContral(Long id) {
        DynamicObject entity = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITYNAME);
        return CentraliTransUtils.doj2dao(entity);
    }

    public List<ContralDao> getContralByModelId(Long modelId, Long bussmodelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("status", "=", (Object)true));
        qFilter.and(new QFilter("bussmodel", "=", (Object)bussmodelId));
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)ENTITYNAME, (QFilter[])qFilter.toArray());
        ArrayList<ContralDao> contralDaos = new ArrayList<ContralDao>();
        for (Map.Entry entry : objectMap.entrySet()) {
            ContralDao contralDao = CentraliTransUtils.doj2dao((DynamicObject)entry.getValue());
            contralDaos.add(contralDao);
        }
        return contralDaos;
    }
}

