/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.central;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.control.BgControlCache;
import kd.epm.eb.common.central.CentraliTransUtils;
import kd.epm.eb.common.central.CentralizedMapper;
import kd.epm.eb.common.central.CentralizedUtils;
import kd.epm.eb.common.central.ContralBO;
import kd.epm.eb.common.central.ContralCell;
import kd.epm.eb.common.central.ContralCellDao;
import kd.epm.eb.common.central.ContralDao;
import kd.epm.eb.common.central.ContralVO;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections.CollectionUtils;

public class CentralizedServiceImpl {
    private static final Log log = LogFactory.getLog(CentralizedServiceImpl.class);
    private static final CentralizedServiceImpl instance = new CentralizedServiceImpl();
    private static final String ENTITYNAME = "eb_centralized_entity";
    private static final CentralizedMapper mapper = CentralizedMapper.getInstance();

    public static CentralizedServiceImpl getInstance() {
        return instance;
    }

    private CentralizedServiceImpl() {
    }

    public ContralVO saveContral(ContralVO contralVO) {
        String number = contralVO.getNumber();
        QFilter qFilter = new QFilter("model", "=", (Object)contralVO.getModelId());
        qFilter.and(new QFilter("number", "=", (Object)number));
        String tips = NumberCheckUtils.checkNumberRule(number);
        if (StringUtils.isNotEmpty(tips)) {
            throw new KDBizException(tips);
        }
        boolean exist = NumberCheckUtils.checkNumberExist(ENTITYNAME, qFilter.toArray(), contralVO.getId());
        if (exist) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728", (String)"CentralizedServiceImpl_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(contralVO.getModelId());
        Map<String, Long> viewIds = modelCache.getViewsByBusModel(contralVO.getBussinessModelId());
        ContralDao contralDao = new ContralDao();
        contralDao.setNumber(contralVO.getNumber());
        contralDao.setDescription(contralVO.getDescription());
        contralDao.setBussmodelId(contralVO.getBussinessModelId());
        contralDao.setModelId(contralVO.getModelId());
        contralDao.setDimensionId(contralVO.getControlDimension().getId());
        contralDao.setEnable(contralVO.isEnable());
        contralDao.setAccounts(CentralizedUtils.toRangeJsonString(contralVO.getAccountMembers()));
        contralDao.setAccountNames(CentralizedUtils.toRangeStringShow(contralVO.getAccountMembers()));
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        Long id = contralVO.getId();
        if (id == 0L) {
            contralDao.setCreatedate(now);
            contralDao.setCreater(userId);
        }
        contralDao.setId(id);
        contralDao.setModifier(userId);
        contralDao.setModifydate(now);
        ArrayList<ContralCellDao> daoCells = new ArrayList<ContralCellDao>();
        contralDao.setCells(daoCells);
        Dimension controlDimension = contralVO.getControlDimension();
        String dimName = controlDimension.getName();
        List<ContralCell> cells = contralVO.getCells();
        for (ContralCell cell : cells) {
            ContralCellDao cellDao = new ContralCellDao();
            Long targetEntity = cell.getTargetEntity();
            List<Member> members = cell.getMembers();
            List<Member> orgMemberDtos = cell.getOrgMembers();
            if (targetEntity == null || targetEntity == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5f52\u53e3\u7ec4\u7ec7\u5355\u636e\u4f53\u6570\u636e\u3002", (String)"CentralizedServiceImpl_1", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            if (CollectionUtils.isEmpty(members)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ba1\u63a7\u8303\u56f4\u5355\u636e\u4f53\u6570\u636e\u3002", (String)"CentralizedServiceImpl_2", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            if (!SysDimensionEnum.Entity.getNumber().equals(controlDimension.getNumber()) && CollectionUtils.isEmpty(orgMemberDtos)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ec4\u7ec7\u8303\u56f4\u5355\u636e\u4f53\u6570\u636e\u3002", (String)"CentralizedServiceImpl_3", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            cellDao.setTargetEntity(targetEntity);
            cellDao.setDimensionrange(CentralizedUtils.toRangeJsonString(members));
            cellDao.setDimensionrangeShow(dimName + ":" + CentralizedUtils.toRangeStringShow(members));
            String rangenumbers = CentralizedUtils.toRangeNumbers(modelCache, contralVO.getControlDimension().getNumber(), contralVO.getBussinessModelId(), members);
            cellDao.setRangenumbers(rangenumbers);
            if (orgMemberDtos != null && !orgMemberDtos.isEmpty()) {
                cellDao.setEntityRange(CentralizedUtils.toRangeJsonString(orgMemberDtos));
                String orgrangenumbers = CentralizedUtils.toRangeNumbers(modelCache, SysDimensionEnum.Entity.getNumber(), contralVO.getBussinessModelId(), orgMemberDtos);
                cellDao.setEntityRangeNumbers(orgrangenumbers);
            }
            daoCells.add(cellDao);
        }
        if (contralDao.isEnable()) {
            this.checkCondition(contralDao, modelCache);
        }
        contralDao = mapper.saveContral(contralDao);
        contralVO.setId(contralDao.getId());
        return contralVO;
    }

    public void saveImportContral(List<ContralVO> contralVos) {
        ArrayList<ContralDao> contralDaos = new ArrayList<ContralDao>(contralVos.size());
        for (ContralVO contralVO : contralVos) {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(contralVO.getModelId());
            Map<String, Long> viewIds = modelCache.getViewsByBusModel(contralVO.getBussinessModelId());
            ContralDao contralDao = new ContralDao();
            contralDao.setNumber(contralVO.getNumber());
            contralDao.setDescription(contralVO.getDescription());
            contralDao.setBussmodelId(contralVO.getBussinessModelId());
            contralDao.setModelId(contralVO.getModelId());
            contralDao.setDimensionId(contralVO.getControlDimension().getId());
            contralDao.setEnable(contralVO.isEnable());
            contralDao.setAccounts(CentralizedUtils.toRangeJsonString(contralVO.getAccountMembers()));
            contralDao.setAccountNames(CentralizedUtils.toRangeStringShow(contralVO.getAccountMembers()));
            Long userId = UserUtils.getUserId();
            Date now = TimeServiceHelper.now();
            Long id = contralVO.getId();
            if (id == 0L) {
                contralDao.setCreatedate(now);
                contralDao.setCreater(userId);
            }
            contralDao.setId(id);
            contralDao.setModifier(userId);
            contralDao.setModifydate(now);
            ArrayList<ContralCellDao> daoCells = new ArrayList<ContralCellDao>();
            contralDao.setCells(daoCells);
            Dimension controlDimension = contralVO.getControlDimension();
            String dimName = controlDimension.getName();
            List<ContralCell> cells = contralVO.getCells();
            for (ContralCell cell : cells) {
                ContralCellDao cellDao = new ContralCellDao();
                Long targetEntity = cell.getTargetEntity();
                List<Member> members = cell.getMembers();
                List<Member> orgMembers = cell.getOrgMembers();
                cellDao.setTargetEntity(targetEntity);
                cellDao.setDimensionrange(CentralizedUtils.toRangeJsonString(members));
                cellDao.setDimensionrangeShow(dimName + ":" + CentralizedUtils.toRangeStringShow(members));
                String rangenumbers = CentralizedUtils.toRangeNumbers(modelCache, contralVO.getControlDimension().getNumber(), contralVO.getBussinessModelId(), members);
                cellDao.setRangenumbers(rangenumbers);
                if (orgMembers != null && !orgMembers.isEmpty()) {
                    cellDao.setEntityRange(CentralizedUtils.toRangeJsonString(orgMembers));
                    String orgrangenumbers = CentralizedUtils.toRangeNumbers(modelCache, SysDimensionEnum.Entity.getNumber(), contralVO.getBussinessModelId(), orgMembers);
                    cellDao.setEntityRangeNumbers(orgrangenumbers);
                }
                daoCells.add(cellDao);
            }
            contralDaos.add(contralDao);
            BgControlCache.clearCentralized(contralVO.getModelId());
        }
        mapper.saveImportContral(contralDaos);
    }

    public void changeContralStatus(Object pkId, Long modelId, boolean status) {
        ContralDao contral = mapper.getContral(Long.valueOf(pkId.toString()));
        this.checkCondition(contral, ModelCacheContext.getOrCreate(modelId));
    }

    private void checkCondition(ContralDao contralDao, IModelCacheHelper modelCache) {
        ContralBO contralBO = CentraliTransUtils.dao2bo(modelCache, contralDao);
        List<Set<String>> emptyControl = contralBO.getEmptyControl();
        List<Pair<Set<String>, List<Set<String>>>> controlMembers = contralBO.getControlMembers();
        boolean isCurrEntity = SysDimensionEnum.Entity.getNumber().equals(contralBO.getControlDimension().getNumber());
        ArrayList<Pair<Set<String>, Set<Object>>> newControlMembers = new ArrayList<Pair<Set<String>, Set<Object>>>(16);
        if (isCurrEntity) {
            if (emptyControl.isEmpty() || emptyControl.stream().allMatch(k -> k.isEmpty())) {
                return;
            }
            this.rebuildList(contralBO, emptyControl);
            for (Set<String> set : emptyControl) {
                newControlMembers.add(new Pair(set, new HashSet(0)));
            }
        } else {
            Set<String> emptyResult = null;
            if (CollectionUtils.isNotEmpty(emptyControl)) {
                emptyResult = this.rebuildList(contralBO, emptyControl);
                newControlMembers.add(new Pair(new HashSet(0), emptyResult));
            }
            if (CollectionUtils.isNotEmpty(controlMembers)) {
                for (Pair<Set<String>, List<Set<String>>> controlMember : controlMembers) {
                    List<Set<String>> value = controlMember.getValue();
                    Set<String> result1 = this.rebuildList(contralBO, value);
                    if (CollectionUtils.isNotEmpty(emptyResult)) {
                        this.checkContains(contralBO.getControlDimension().getNumber(), emptyResult, result1);
                    }
                    newControlMembers.add(new Pair<Set<String>, Set<String>>(controlMember.getKey(), result1));
                }
            }
        }
        Set<String> controlAccounts = contralBO.getControlAccounts();
        Dimension dimension = contralBO.getControlDimension();
        List<ContralDao> allDaos = mapper.getContralByModelId(contralDao.getModelId(), contralDao.getBussmodelId());
        for (ContralDao otherDao : allDaos) {
            if (otherDao.getId().equals(contralDao.getId()) || otherDao.getDimensionId() == 0L) continue;
            Set<String> accountMembers = CentralizedUtils.mbgRangeString(otherDao.getAccounts());
            accountMembers.retainAll(controlAccounts);
            if (accountMembers.isEmpty()) continue;
            Long dimensionId = otherDao.getDimensionId();
            kd.epm.eb.common.cache.impl.Dimension dimension2 = modelCache.getDimension(dimensionId);
            boolean daoIsEntity = SysDimensionEnum.Entity.getNumber().equals(dimension2.getNumber());
            if (!(daoIsEntity || isCurrEntity || dimension.getId().equals(dimensionId))) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524d\u5f52\u53e3\u65b9\u6848\u4e0e\u65b9\u6848\u201c%1\u201d\u542b\u6709\u76f8\u540c\u7684\u79d1\u76ee\u201c%2\u201d\uff0c\u4f46\u63a7\u5236\u7684\u7ef4\u5ea6\u4e0d\u540c\uff0c\u4ee3\u8868\u542b\u6709\u76f8\u540c\u8303\u56f4\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5\u5e76\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"CentralizedServiceImpl_5", (String)"epm-eb-common", (Object[])new Object[]{otherDao.getNumber(), accountMembers.toString()}));
            }
            List<ContralCellDao> cells = otherDao.getCells();
            if (CollectionUtils.isEmpty(cells)) continue;
            for (ContralCellDao cellDao : cells) {
                Set<String> entityMember = CentraliTransUtils.getAllDetailMember(modelCache, "Entity", cellDao.getEntityRange(), contralDao.getBussmodelId());
                Set<String> allDetailMember = CentraliTransUtils.getAllDetailMember(modelCache, dimension2.getNumber(), cellDao.getDimensionrange(), contralDao.getBussmodelId());
                Pair<Set<String>, Set<String>> cellPair = null;
                if (daoIsEntity) {
                    if (allDetailMember.isEmpty()) continue;
                    cellPair = new Pair(allDetailMember, new HashSet(0));
                } else {
                    cellPair = new Pair<Set<String>, Set<String>>(entityMember, allDetailMember);
                }
                for (Pair pair : newControlMembers) {
                    if (!(this.checkContains(cellPair.getKey(), (Set)pair.getKey()) && this.checkContains(cellPair.getValue(), (Set)pair.getValue()) || daoIsEntity && !isCurrEntity && this.checkContains((Set)pair.getKey(), cellPair.getKey())) && (daoIsEntity || !isCurrEntity || !this.checkContains(cellPair.getKey(), (Set)pair.getKey()))) continue;
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524d\u5f52\u53e3\u65b9\u6848\u4e0e\u65b9\u6848\u201c%1\u201d\u542b\u6709\u76f8\u540c\u79d1\u76ee\uff1a%2\uff0c\u5e76\u4e14\u542b\u6709\u76f8\u540c\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5\u5e76\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"CentralizedServiceImpl_6", (String)"epm-eb-common", (Object[])new Object[]{otherDao.getNumber(), accountMembers.toString()}));
                }
            }
        }
    }

    private boolean checkContains(Set<String> key, Set<String> key1) {
        if (key.isEmpty() && key1.isEmpty()) {
            return true;
        }
        HashSet<String> strings = new HashSet<String>(key);
        strings.retainAll(key1);
        return !strings.isEmpty();
    }

    private void checkContains(String dimNumber, Set<String> result1, Set<String> result2) {
        HashSet<String> strings = new HashSet<String>(result1);
        strings.retainAll(result2);
        if (!strings.isEmpty()) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524d\u5f52\u53e3\u65b9\u6848\u4e0e\u81ea\u8eab\u5f52\u53e3\u8303\u56f4\u76f8\u540c\uff0c\u63a7\u5236\u7ef4\u5ea6\u4e3a\u201c%1\u201d\uff0c\u76f8\u540c\u8303\u56f4\u6210\u5458\u4e3a\u201c%2\u201d\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5\u5e76\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"CentralizedServiceImpl_4", (String)"epm-eb-common", (Object[])new Object[]{dimNumber, strings.toString()}));
        }
    }

    private Set<String> rebuildList(ContralBO contralBO, List<Set<String>> emptyControl) {
        HashSet<String> result = new HashSet<String>();
        for (Set<String> strings : emptyControl) {
            this.checkContains(contralBO.getControlDimension().getNumber(), result, strings);
            result.addAll(strings);
        }
        return result;
    }

    public ContralVO getContral(Long id) {
        ContralDao contral = mapper.getContral(id);
        return contral.toVO();
    }
}

