/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.central;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.central.ContralBO;
import kd.epm.eb.common.central.OrgMemberDto;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Member;
import org.apache.commons.lang3.StringUtils;

public class CentralizedUtils {
    public static String toRangeStringShow(List<Member> members) {
        List collect = members.stream().map(e -> e.getName()).collect(Collectors.toList());
        return StringUtils.join(collect, (String)",");
    }

    public static String toRangeJsonString(List<Member> members) {
        StringBuilder sb = new StringBuilder();
        for (Member member : members) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)member.getName());
            jsonObject.put("number", (Object)member.getNumber());
            if (member.isProperty().booleanValue()) {
                jsonObject.put("pro", (Object)"1");
                jsonObject.put("id", (Object)member.getId());
            }
            String memberJson = jsonObject.toJSONString();
            sb.append("@").append(memberJson);
        }
        return sb.toString();
    }

    public static String toRangeNumbers(IModelCacheHelper modelCache, String dimensionNumber, Long businessModelId, List<Member> members) {
        HashSet<String> numbers = new HashSet<String>();
        Long viewId = modelCache.getViewByBusModelAndDimNumber(businessModelId, dimensionNumber);
        block0: for (Member member : members) {
            if (member.isProperty().booleanValue()) continue;
            List<kd.epm.eb.common.cache.impl.Member> member1 = modelCache.getMember(dimensionNumber, viewId, member.getNumber(), RangeEnum.ALL.getIndex());
            if (member1 == null || member1.isEmpty()) {
                if (modelCache.getModelobj().isModelByEB() || SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) continue;
                List<Long> views = modelCache.getViewGroupViewsByBusModelAndDimNumber(businessModelId, dimensionNumber);
                for (Long view : views) {
                    member1 = modelCache.getMember(dimensionNumber, view, member.getNumber(), RangeEnum.ALL.getIndex());
                    if (member1 == null || member1.isEmpty()) continue;
                    numbers.addAll(member1.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                    kd.epm.eb.common.cache.impl.Member myself = modelCache.getMember(dimensionNumber, view, member.getNumber());
                    if (myself == null || !myself.isLeaf()) continue block0;
                    numbers.add(myself.getNumber());
                    continue block0;
                }
                continue;
            }
            numbers.addAll(member1.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
            kd.epm.eb.common.cache.impl.Member myself = modelCache.getMember(dimensionNumber, viewId, member.getNumber());
            if (myself == null || !myself.isLeaf()) continue;
            numbers.add(myself.getNumber());
        }
        String rangeStr = "";
        if (!numbers.isEmpty()) {
            rangeStr = numbers.stream().collect(Collectors.joining(","));
        }
        if (members.stream().anyMatch(k -> k.isProperty())) {
            String proNumStr = members.stream().filter(Member::isProperty).map(Member::getNumber).collect(Collectors.joining(","));
            rangeStr = rangeStr + "##" + proNumStr;
        }
        return rangeStr;
    }

    public static String toRangeNumbersPro(IModelCacheHelper modelCache, String dimensionNumber, Long viewId, List<OrgMemberDto> members) {
        HashSet<String> numbers = new HashSet<String>();
        List memberList = members.stream().filter(k -> !"property".equals(k.getType())).collect(Collectors.toList());
        for (OrgMemberDto member : memberList) {
            List<kd.epm.eb.common.cache.impl.Member> member1 = modelCache.getMember(dimensionNumber, viewId, member.getNumber(), RangeEnum.ALL.getIndex());
            numbers.addAll(member1.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
            kd.epm.eb.common.cache.impl.Member myself = modelCache.getMember(dimensionNumber, viewId, member.getNumber());
            if (myself == null || !myself.isLeaf()) continue;
            numbers.add(myself.getNumber());
        }
        List propertyList = members.stream().filter(k -> "property".equals(k.getType())).collect(Collectors.toList());
        return StringUtils.join(numbers, (String)",") + "##" + propertyList.stream().map(OrgMemberDto::getNumber).collect(Collectors.joining(","));
    }

    public static Set<String> mbgRangeString(String memberString) {
        String[] splits = memberString.split("@");
        HashSet<String> members = new HashSet<String>();
        for (String split : splits) {
            if (StringUtils.isEmpty((CharSequence)split)) continue;
            JSONObject jsonObject = JSON.parseObject((String)split);
            if (jsonObject.containsKey((Object)"pro") && "1".equals(jsonObject.getString("pro"))) {
                members.add(StringUtils.join((Object[])new String[]{"pro", jsonObject.getString("id")}, (String)"="));
                continue;
            }
            members.add(jsonObject.getString("number"));
        }
        return members;
    }

    public static List<Member> mbgRangeString(IModelCacheHelper modelCache, String dimNumber, Long BusinessModel2, String memberString) {
        if (StringUtils.isEmpty((CharSequence)memberString)) {
            return Collections.emptyList();
        }
        String[] splits = memberString.split("@");
        ArrayList<Member> orgMemberDtos = new ArrayList<Member>(splits.length);
        for (String split : splits) {
            if (StringUtils.isEmpty((CharSequence)split)) continue;
            JSONObject jsonObject = JSON.parseObject((String)split);
            if (jsonObject.containsKey((Object)"pro")) {
                orgMemberDtos.add(new Member(jsonObject.getLong("id"), jsonObject.getString("name"), jsonObject.getString("number"), true));
                continue;
            }
            if (modelCache.getModelobj().isModelByEB() || SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                kd.epm.eb.common.cache.impl.Member member = modelCache.getMember(dimNumber, null, jsonObject.getString("number"));
                if (member == null) continue;
                orgMemberDtos.add(new Member(member.getId(), member.getName(), member.getNumber()));
                continue;
            }
            List<Long> views = modelCache.getViewGroupViewsByBusModelAndDimNumber(BusinessModel2, dimNumber);
            if (views != null) {
                for (Long viewId : views) {
                    kd.epm.eb.common.cache.impl.Member member = modelCache.getMember(dimNumber, viewId, jsonObject.getString("number"));
                    if (member == null || !orgMemberDtos.stream().noneMatch(k -> member.getId() != null && member.getId().equals(k.getId()))) continue;
                    orgMemberDtos.add(new Member(member.getId(), member.getName(), member.getNumber()));
                }
                continue;
            }
            kd.epm.eb.common.cache.impl.Member member = modelCache.getMember(dimNumber, (Long)0L, jsonObject.getString("number"));
            if (member == null || !orgMemberDtos.stream().noneMatch(k -> member.getId() != null && member.getId().equals(k.getId()))) continue;
            orgMemberDtos.add(new Member(member.getId(), member.getName(), member.getNumber()));
        }
        return orgMemberDtos;
    }

    public static List<ContralBO> parseCentData(Map<Long, Map<String, Object>> memberCache) {
        return null;
    }

    public static Map<Long, Map<String, Object>> queryCentralized(Long modelId) {
        return null;
    }
}

