/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.central;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.central.CentralizedUtils;
import kd.epm.eb.common.central.ContralCell;
import kd.epm.eb.common.central.ContralCellDao;
import kd.epm.eb.common.central.ContralVO;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.StringUtils;

public class ContralDao {
    private String number;
    private ILocaleString description;
    private Long modelId;
    private Long dimensionId;
    private String accounts;
    private String accountNames;
    private Long creater;
    private Long modifier;
    private Date createdate;
    private Date modifydate;
    private List<ContralCellDao> cells;
    private Long id;
    private boolean enable;
    private Long bussmodelId;

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public ILocaleString getDescription() {
        return this.description;
    }

    public void setDescription(ILocaleString description) {
        this.description = description;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getDimensionId() {
        return this.dimensionId;
    }

    public void setDimensionId(Long dimensionId) {
        this.dimensionId = dimensionId;
    }

    public String getAccounts() {
        return this.accounts;
    }

    public void setAccounts(String accounts) {
        this.accounts = accounts;
    }

    public Long getCreater() {
        return this.creater;
    }

    public void setCreater(Long creater) {
        this.creater = creater;
    }

    public Long getModifier() {
        return this.modifier;
    }

    public void setModifier(Long modifier) {
        this.modifier = modifier;
    }

    public Date getCreatedate() {
        return this.createdate;
    }

    public void setCreatedate(Date createdate) {
        this.createdate = createdate;
    }

    public Date getModifydate() {
        return this.modifydate;
    }

    public void setModifydate(Date modifydate) {
        this.modifydate = modifydate;
    }

    public List<ContralCellDao> getCells() {
        return this.cells;
    }

    public void setCells(List<ContralCellDao> cells) {
        this.cells = cells;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public String getAccountNames() {
        return this.accountNames;
    }

    public void setAccountNames(String accountNames) {
        this.accountNames = accountNames;
    }

    public Long getBussmodelId() {
        return this.bussmodelId;
    }

    public void setBussmodelId(Long bussmodelId) {
        this.bussmodelId = bussmodelId;
    }

    public ContralVO toVO() {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(this.getModelId());
        ContralVO contralVO = new ContralVO();
        contralVO.setId(this.id);
        contralVO.setNumber(this.number);
        contralVO.setDescription(this.description);
        contralVO.setEnable(this.enable);
        Dimension dimension = modelCache.getDimension(this.dimensionId);
        contralVO.setControlDimension(new kd.epm.eb.common.model.Dimension(dimension.getId(), dimension.getName(), dimension.getNumber()));
        contralVO.setModelId(this.modelId);
        contralVO.setBussinessModelId(this.bussmodelId);
        contralVO.setAccountMembers(CentralizedUtils.mbgRangeString(modelCache, SysDimensionEnum.Account.getNumber(), this.bussmodelId, this.accounts));
        ArrayList<ContralCell> cellVOs = new ArrayList<ContralCell>(this.cells.size());
        contralVO.setCells(cellVOs);
        Map<String, Long> viewIds = BusinessModelServiceHelper.getViewIds(this.bussmodelId);
        for (ContralCellDao cell : this.cells) {
            ContralCell contralCell = new ContralCell();
            contralCell.setTargetEntity(cell.getTargetEntity());
            contralCell.setMembers(CentralizedUtils.mbgRangeString(modelCache, contralVO.getControlDimension().getNumber(), this.bussmodelId, cell.getDimensionrange()));
            String entityRange = cell.getEntityRange();
            if (StringUtils.isNotEmpty(entityRange)) {
                contralCell.setOrgMembers(CentralizedUtils.mbgRangeString(modelCache, SysDimensionEnum.Entity.getNumber(), this.bussmodelId, entityRange));
            }
            cellVOs.add(contralCell);
        }
        return contralVO;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isEnable() {
        return this.enable;
    }
}

