/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.centralapproval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.epm.eb.common.centralapproval.entity.ApproveAdjMemberRangeDto;
import kd.epm.eb.common.enums.MultiLangEnumBridge;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public enum ApproveAdjDimTypeEnum {
    TYPE_ONE(ApproveAdjDimTypeEnum.getTypeOneDesc(), "", "1"),
    TYPE_TWO(ApproveAdjDimTypeEnum.getTypeTwoDesc(), "", "2");

    private final MultiLangEnumBridge desc;
    private final String code;
    private final String value;
    private static final String[] isAdjSysDims;

    public String getDesc() {
        return this.desc.loadKDString();
    }

    public String getCode() {
        return this.code;
    }

    public String getValue() {
        return this.value;
    }

    private ApproveAdjDimTypeEnum(MultiLangEnumBridge desc, String code, String value) {
        this.desc = desc;
        this.code = code;
        this.value = value;
    }

    private static MultiLangEnumBridge getTypeOneDesc() {
        return new MultiLangEnumBridge("\u79d1\u76ee\u6216\u8005\u81ea\u5b9a\u4e49\u7ef4\u5ea6", "ApproveAdjDimTypeEnum_0", "epm-eb-common");
    }

    private static MultiLangEnumBridge getTypeTwoDesc() {
        return new MultiLangEnumBridge("\u7ec4\u7ec7\u7ef4\u5ea6", "ApproveAdjDimTypeEnum_1", "epm-eb-common");
    }

    public static ApproveAdjDimTypeEnum getTypeByDimNumber(String dimNumber) {
        if (!ApproveAdjDimTypeEnum.isAdjDim(dimNumber)) {
            return null;
        }
        if (StringUtils.equals(dimNumber, SysDimensionEnum.Entity.getNumber())) {
            return TYPE_TWO;
        }
        if (StringUtils.equals(dimNumber, SysDimensionEnum.Account.getNumber())) {
            return TYPE_ONE;
        }
        boolean flag = false;
        for (SysDimensionEnum value : SysDimensionEnum.values()) {
            if (!StringUtils.equals(dimNumber, value.getNumber())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return TYPE_ONE;
        }
        return null;
    }

    public static ApproveAdjDimTypeEnum getTypeByValue(String value) {
        for (ApproveAdjDimTypeEnum approveAdjDimTypeEnum : ApproveAdjDimTypeEnum.values()) {
            if (!StringUtils.equals(value, approveAdjDimTypeEnum.getValue())) continue;
            return approveAdjDimTypeEnum;
        }
        return null;
    }

    public static boolean isAdjDim(String dimNumber) {
        List<String> list = Arrays.asList(isAdjSysDims);
        if (list.contains(dimNumber)) {
            return true;
        }
        for (SysDimensionEnum value : SysDimensionEnum.values()) {
            if (!StringUtils.equals(dimNumber, value.getNumber())) continue;
            return false;
        }
        return true;
    }

    public static Map<String, String> getLevelsByDimNumber(String dimNumber, Set<Integer> levels) {
        Map<String, String> result = new HashMap<String, String>(16);
        ApproveAdjDimTypeEnum typeByDimNumber = ApproveAdjDimTypeEnum.getTypeByDimNumber(dimNumber);
        if (typeByDimNumber == null) {
            return result;
        }
        switch (typeByDimNumber) {
            case TYPE_ONE: {
                result = ApproveAdjDimTypeEnum.getTypeOneLevels(levels);
                break;
            }
            case TYPE_TWO: {
                TypeTwoLevelEnum[] values;
                for (TypeTwoLevelEnum value : values = TypeTwoLevelEnum.values()) {
                    String desc = value.getDesc();
                    String code = value.getValue();
                    result.put(code, desc);
                }
                break;
            }
        }
        return result;
    }

    public static Map<String, String> getTypeOneLevels(Set<Integer> levels) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (CollectionUtils.isEmpty(levels)) {
            return result;
        }
        ArrayList<Integer> levelList = new ArrayList<Integer>(levels);
        if (CollectionUtils.isNotEmpty(levelList)) {
            for (int i = 0; i < levelList.size(); ++i) {
                String level = levelList.get(i) + "";
                String levelValue = level + TypeOneLevelEnum.COMMON.getValueSuffix();
                if (i == levelList.size() - 1) {
                    levelValue = TypeOneLevelEnum.SPECIAL.getDesc();
                    level = TypeOneLevelEnum.SPECIAL.value;
                }
                result.put(level, levelValue);
            }
        }
        return result;
    }

    public static String getDimMemberRange(ApproveAdjMemberRangeDto memberRange, boolean isImportScheme) {
        String dimMemRangeValue = "";
        RangeTypeEnum rangeType = memberRange.getRangeType();
        ApproveAdjDimTypeEnum dimType = memberRange.getDimType();
        List<Map<String, String>> members = memberRange.getMembers();
        String dimmemlevel = memberRange.getDimMemLevel();
        if (rangeType == RangeTypeEnum.RANGE_LEVEL) {
            TypeTwoLevelEnum levelByValue;
            if (TYPE_ONE == dimType) {
                TypeOneLevelEnum levelByValue2 = TypeOneLevelEnum.getLevelByValue(dimmemlevel);
                if (levelByValue2 != null) {
                    if (levelByValue2 == TypeOneLevelEnum.SPECIAL) {
                        dimMemRangeValue = levelByValue2.getDesc();
                        if (isImportScheme) {
                            dimMemRangeValue = memberRange.getDimName() + "_" + levelByValue2.getDesc();
                        }
                    } else {
                        dimMemRangeValue = dimmemlevel + levelByValue2.getDesc();
                        if (isImportScheme) {
                            dimMemRangeValue = memberRange.getDimName() + "_" + dimmemlevel + levelByValue2.getValueSuffix();
                        }
                    }
                }
            } else if (TYPE_TWO == dimType && (levelByValue = TypeTwoLevelEnum.getLevelByValue(dimmemlevel)) != null) {
                List<Map<String, String>> budgetEntityBaseEntityData = memberRange.getBudgetEntityBaseEntityData();
                for (Map<String, String> map : budgetEntityBaseEntityData) {
                    String displayName = map.get(memberRange.getOrgReferenceField());
                    if (StringUtils.isEmpty(displayName)) continue;
                    dimMemRangeValue = memberRange.getBillTypeName() + "\uff1a" + displayName + "_" + levelByValue.getDesc();
                    break;
                }
            }
        } else if (rangeType == RangeTypeEnum.RANGE_MEMBER && CollectionUtils.isNotEmpty(members)) {
            ArrayList<String> names = new ArrayList<String>(16);
            for (Map<String, String> member : members) {
                String name = member.get("name");
                names.add(name);
            }
            dimMemRangeValue = String.join((CharSequence)";", names);
        }
        return dimMemRangeValue;
    }

    static {
        isAdjSysDims = new String[]{SysDimensionEnum.Account.getNumber(), SysDimensionEnum.Entity.getNumber()};
    }

    public static enum RangeTypeEnum {
        RANGE_LEVEL(RangeTypeEnum.getRangeLevelDesc(), false, "1"),
        RANGE_MEMBER(RangeTypeEnum.getRangeMemberDesc(), true, "2");

        private final MultiLangEnumBridge desc;
        private final boolean isDefault;
        private final String value;

        private RangeTypeEnum(MultiLangEnumBridge desc, boolean isDefault, String value) {
            this.desc = desc;
            this.value = value;
            this.isDefault = isDefault;
        }

        public String getDesc() {
            return this.desc.loadKDString();
        }

        public String getValue() {
            return this.value;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        private static MultiLangEnumBridge getRangeLevelDesc() {
            return new MultiLangEnumBridge("\u6307\u5b9a\u5c42\u7ea7", "ApproveAdjDimTypeEnum_02", "epm-eb-common");
        }

        private static MultiLangEnumBridge getRangeMemberDesc() {
            return new MultiLangEnumBridge("\u6307\u5b9a\u6210\u5458", "ApproveAdjDimTypeEnum_01", "epm-eb-common");
        }

        public static RangeTypeEnum getTypeByValue(String value) {
            for (RangeTypeEnum rangeTypeEnum : RangeTypeEnum.values()) {
                if (!StringUtils.equals(value, rangeTypeEnum.getValue())) continue;
                return rangeTypeEnum;
            }
            return null;
        }
    }

    public static enum TypeTwoLevelEnum {
        ONE(TypeTwoLevelEnum.getOneDesc(), false, "1"),
        TWO(TypeTwoLevelEnum.getTwoDesc(), false, "2"),
        THREE(TypeTwoLevelEnum.getThreeDesc(), false, "3"),
        FOUR(TypeTwoLevelEnum.getFourDesc(), true, "4");

        private final MultiLangEnumBridge desc;
        private final boolean isDefault;
        private final String value;

        private TypeTwoLevelEnum(MultiLangEnumBridge desc, boolean isDefault, String value) {
            this.desc = desc;
            this.value = value;
            this.isDefault = isDefault;
        }

        public String getDesc() {
            return this.desc.loadKDString();
        }

        public String getValue() {
            return this.value;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public static TypeTwoLevelEnum getLevelByValue(String value) {
            for (TypeTwoLevelEnum typeTwoLevelEnum : TypeTwoLevelEnum.values()) {
                if (!typeTwoLevelEnum.getValue().equals(value)) continue;
                return typeTwoLevelEnum;
            }
            return null;
        }

        private static MultiLangEnumBridge getOneDesc() {
            return new MultiLangEnumBridge("\u76f4\u63a5\u4e0b\u7ea7", "ApproveAdjDimTypeEnum_06", "epm-eb-common");
        }

        private static MultiLangEnumBridge getTwoDesc() {
            return new MultiLangEnumBridge("\u95f4\u63a5\u4e0b\u7ea7", "ApproveAdjDimTypeEnum_05", "epm-eb-common");
        }

        private static MultiLangEnumBridge getThreeDesc() {
            return new MultiLangEnumBridge("\u4ec5\u81ea\u5df1", "ApproveAdjDimTypeEnum_04", "epm-eb-common");
        }

        private static MultiLangEnumBridge getFourDesc() {
            return new MultiLangEnumBridge("\u4ec5\u660e\u7ec6\u6210\u5458", "ApproveAdjDimTypeEnum_03", "epm-eb-common");
        }
    }

    public static enum TypeOneLevelEnum {
        COMMON(TypeOneLevelEnum.getCommonDesc(), "", TypeOneLevelEnum.getCommonValueSuffix()),
        SPECIAL(TypeOneLevelEnum.getSpecialDesc(), "-1", new MultiLangEnumBridge());

        private final MultiLangEnumBridge desc;
        private final String value;
        private final MultiLangEnumBridge valueSuffix;

        private TypeOneLevelEnum(MultiLangEnumBridge desc, String value, MultiLangEnumBridge valueSuffix) {
            this.desc = desc;
            this.value = value;
            this.valueSuffix = valueSuffix;
        }

        public String getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc.loadKDString();
        }

        public String getValueSuffix() {
            return this.valueSuffix.loadKDString();
        }

        private static MultiLangEnumBridge getCommonValueSuffix() {
            return new MultiLangEnumBridge("\u7ea7", "ApproveAdjDimTypeEnum_09", "epm-eb-common");
        }

        private static MultiLangEnumBridge getCommonDesc() {
            return new MultiLangEnumBridge("\u7ea7\u6210\u5458\u81f3\u660e\u7ec6\u6210\u5458", "ApproveAdjDimTypeEnum_08", "epm-eb-common");
        }

        private static MultiLangEnumBridge getSpecialDesc() {
            return new MultiLangEnumBridge("\u4ec5\u660e\u7ec6\u6210\u5458", "ApproveAdjDimTypeEnum_07", "epm-eb-common");
        }

        public static TypeOneLevelEnum getLevelByValue(String value) {
            if (StringUtils.isEmpty(value)) {
                return null;
            }
            Pattern compile = Pattern.compile("^[0-9]*[1-9][0-9]*$");
            for (TypeOneLevelEnum typeOneLevelEnum : TypeOneLevelEnum.values()) {
                if (StringUtils.equals(SPECIAL.getValue(), value)) {
                    return SPECIAL;
                }
                boolean matches = compile.matcher(value).matches();
                if (!matches) continue;
                return typeOneLevelEnum;
            }
            return null;
        }
    }
}

