/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.centralrelation;

import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.enums.RangeEnum;
import org.apache.commons.lang3.StringUtils;

public class CentralRelation
implements Serializable {
    private Long schemeId;
    private Long entityId;
    private Map<String, MemberCondition> centralDimMemberInfo;
    private int seq;

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public Map<String, MemberCondition> getCentralDimMemberInfo() {
        return this.centralDimMemberInfo;
    }

    public void setCentralDimMemberInfo(Map<String, MemberCondition> centralDimMemberInfo) {
        this.centralDimMemberInfo = centralDimMemberInfo;
    }

    public void addCentralDimMemberInfo(Long viewId, Member member, RangeEnum range) {
        if (this.centralDimMemberInfo == null) {
            this.centralDimMemberInfo = new LinkedHashMap<String, MemberCondition>(16);
        }
        MemberCondition condition = new MemberCondition(viewId, member.getId(), member.getNumber(), member.getName(), String.valueOf(range.getIndex()));
        this.centralDimMemberInfo.put(member.getDimension().getNumber(), condition);
    }

    public int getSeq() {
        return this.seq;
    }

    public CentralRelation setSeq(int seq) {
        this.seq = seq;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CentralRelation)) {
            return false;
        }
        CentralRelation relation = (CentralRelation)o;
        return this.getSeq() == relation.getSeq() && Objects.equals(this.getSchemeId(), relation.getSchemeId()) && Objects.equals(this.getEntityId(), relation.getEntityId()) && Objects.equals(this.getCentralDimMemberInfoJson(), relation.getCentralDimMemberInfoJson());
    }

    public int hashCode() {
        return Objects.hash(this.getSchemeId(), this.getEntityId(), this.getCentralDimMemberInfoJson(), this.getSeq());
    }

    public static Map<String, MemberCondition> parseDimMemberInfoJson(String dimMemberInfoJson) {
        if (StringUtils.isEmpty((CharSequence)dimMemberInfoJson)) {
            return new HashMap<String, MemberCondition>(0);
        }
        return ObjectSerialUtil.parseObject(dimMemberInfoJson, new TypeReference<LinkedHashMap<String, MemberCondition>>(){}, new Feature[0]);
    }

    public String getCentralDimMemberInfoJson() {
        if (this.centralDimMemberInfo == null || this.centralDimMemberInfo.size() == 0) {
            return "";
        }
        return SerializationUtils.toJsonString(this.centralDimMemberInfo);
    }
}

