/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.constant;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.DataConnectCacheUtil;
import kd.epm.eb.common.utils.DatasourceModel;

public class OlapConstant {
    public static final String SEP_EXCLAMATION_MARK = "!";
    public static final String SEP_DECIMAL_MARK = ".";
    public static final String SEP_UNDERLINE_MARK = "_";
    public static final String SEP_COMMA_MARK = ",";
    public static final String SEP_COMMA_MARK_CHS = "\uff0c";
    public static final String SEP_PERCENT_MARK = "%";
    public static final String SEP_AT_MARK = "@";
    public static final String SEP_POUND_MARK = "#";
    public static final String SEP_SINGLE_QUOTATION_MARK = "'";
    public static final String SEP_OLAP_MARK = "`";
    public static final String SEP_MDX = "->";
    public static final String SEP_SPACE_MARK_SBC = "\u3000";
    public static final String MEASURES = "measures";
    public static final String MEASURES_VALUE = "va";
    public static final String OLAP_SERVER_NAME = "OLAP_SERVER_NAME";
    public static final String OLAP_STORAGE_NAME = "OLAP_STORAGE_NAME";
    public static final String OLAP_STORAGE_DB = "OLAP_STORAGE_DB";
    public static final String OLAP_STORAGE_SHREK = "OLAP_STORAGE_SHREK";
    public static final String OLAP_SQL_GROUPBY = "BudgetOlap.hasGroupBy";
    public static final boolean hasGroupBy = Boolean.parseBoolean(System.getProperty("BudgetOlap.hasGroupBy", "true"));
    public static final String MAX_THREAD_SIZE = "MAX_THREAD_SIZE";
    public static final String MAX_THREAD_VALUE = "4";
    public static final String OLAP_QUERY_NAME = "BudgetOlapThreadPool";
    public static final int OLAP_QUERY_CORE_SIZE = 8;
    public static final String OLAP_QUERY_MAX_SIZE = "BudgetOlapThreadPool.maxThreads";
    public static final String OLAP_SAVE_NAME = "BudgetSaveThreadPool";
    public static final int OLAP_SAVE_CORE_SIZE = 8;
    public static final String OLAP_SAVE_MAX_SIZE = "BudgetSaveThreadPool.maxThreads";
    public static final String MAX_DATAFACT_SIZE = "MAX_DATAFACT_SIZE";
    public static final int MAX_DATAFACT_VALUE = 32;
    public static final String MODEL_CUBE_SHOWNUMBER = "MODEL_CUBE_SHOWNUMBER";
    public static final String CUBE_TABLE_MANAGER = "t_eb_cubemanager";
    public static final String CUBE_TABLE_DIMKEY = "t_eb_dim";
    public static final String CUBE_TABLE_DIMPK = "pk_eb_dim";
    public static final String CUBE_TABLE_DIMUIX = "ux_eb_dim";
    public static final String CUBE_TABLE_DIMIX = "ix_eb_dim";
    public static final String CUBE_TABLE_FACT = "t_eb_d";
    public static final String CUBE_TABLE_PK = "pk_eb_d";
    public static final String CUBE_TABLE_UIX = "ux_eb_d";
    public static final String CUBE_TABLE_IX = "ix_eb_d";
    public static final String CUBE_DIMENSION_FACT = "t_eb_d";
    public static final String CUBE_DIMENSION_PK = "pk_eb_d";
    public static final String CUBE_DIMENSION_IX = "ix_eb_d";
    public static final String CUBE_DIMENSION_CLOSURE = "t_eb_c";
    public static final String CUBE_DIMENSION_CLOSURE_UX = "ux_eb_c";
    public static final String CUBE_TABLE_OTHER_FACT = "t_eb_od";
    public static final String CUBE_TABLE_OTHER_PK = "pk_eb_od";
    public static final String CUBE_TABLE_OTHER_UIX = "ux_eb_od";
    public static final String CUBE_TABLE_OTHER_IX = "ix_eb_od";
    public static final String FIELD_ORG = "forgunitid";
    public static final String FIELD_ACCOUNT = "faccountid";
    public static final String FIELD_YEAR = "fyearid";
    public static final String FIELD_PERIOD = "fperiodid";
    public static final String FIELD_CURRENCY = "fcurrencyid";
    public static final String FIELD_VERSION = "fversionid";
    public static final String FIELD_SCENARIO = "fscenarioid";
    public static final String FIELD_PROCESS = "fprocessid";
    public static final String FIELD_AT = "fatid";
    public static final String FIELD_CT = "fctid";
    public static final String FIELD_IC = "ficid";
    public static final String FIELD_DT = "fdtid";
    public static final String FIELD_METRIC = "fmetricid";
    public static final String FIELD_BUDGETPERIOD = "fbgperiodid";
    public static final String FIELD_VALUE = "fvalue";
    public static final char FIELD_USERDEFAULT = 'f';
    private static final Map<String, String> fieldMap;
    public static final String[] DEFAULT_EPM_FIX_DIMENSION;
    public static final String REPORT_ID = "REPORT_ID";
    public static final String DEF_MEMBER_NUMBER = "DEF_MEMBER_NUM_";
    public static final String DEF_MEMBER_ID = "DEF_MEMBER_ID_";
    public static final String DEF_MEMBER_MDX_NUMBER = "DEF_MEMBER_MDX_NUM_";
    public static final String SCHEMA = "Schema";
    public static final String SCHEMA_VALUE = "KDOLAP";
    public static final String DATA_FACT_TABLES = "DATA_FACT_TABLES";
    public static final String DATA_FACT_TABLES_DIM = "DATA_FACT_TABLES_DIM";
    public static final String DATA_FACT_ACCOUNT = "DATA_FACT_ACCOUNT";
    public static final String CUBE = "Cube";
    public static final String VIEW = "View";
    public static final String SQL = "SQL";
    public static final String PARAMETER = "Parameter";
    public static final String DIMENSION = "Dimension";
    public static final String HIERARCHY = "Hierarchy";
    public static final String TABLE = "Table";
    public static final String TABLE_L = "table";
    public static final String LEVEL = "Level";
    public static final String MEASURE = "Measure";
    public static final String PROPERTY = "Property";
    public static final String CALCMEMBER = "CalculatedMember";
    public static final String RELATION = "Relation";
    public static final String PARTITION = "Partition";
    public static final String VALUE = "fvalue";
    public static final String HAS_ORG_DIMENSION = "HAS_ORG_DIMENSION";
    public static final String NAME = "name";
    public static final String ALIAS = "alias";
    public static final String DIALECT = "dialect";
    public static final String FOREIGNKEY = "foreignKey";
    public static final String TYPE = "type";
    public static final String HASALL = "hasAll";
    public static final String ALLMEMBERNAME = "allMemberName";
    public static final String PRIMARYKEY = "primaryKey";
    public static final String PRIMARYKEYTABLE = "primaryKeyTable";
    public static final String UNIQUEMEMBERS = "uniqueMembers";
    public static final String COLUMN = "column";
    public static final String NAMECOLUMN = "nameColumn";
    public static final String ORDERCOLUMN = "ordinalColumn";
    public static final String PARENTCOLUMN = "parentColumn";
    public static final String NULLPARENTVALUE = "nullParentValue";
    public static final String CHILDCOLUMN = "childColumn";
    public static final String FORMULA = "formula";
    public static final String DIMUSAGE = "DimensionUsage";
    public static final String ORDER_BY = "orderBy";
    public static final String DIMENSIONS = "dimensions";
    public static final String WEIGHT = "weight";
    public static final String AGGREGATE = "disableAgg";
    public static final String BPTYPE = "bpType";
    public static final String CurrentMember = "CurrentMember";
    public static final String COLUMN_ID = "fid";
    public static final String COLUMN_NUMBER = "fnumber";
    public static final String COLUMN_PARENTID = "fparent";
    public static final String COLUMN_WEIGHT = "fweight";
    public static final String COLUMN_AGGREGATE = "faggregate";
    public static final String COLUMN_BPTYPE = "fbptype";
    public static final String AGGREGATOR = "aggregator";
    public static final String OPTIMIZE_VALUE_TRUE;
    public static final String OPTIMIZE_VALUE_FALSE;
    public static final String OPTIMIZE_TAG = "OPTIMIZE_TAG_";
    public static final String PREFIX = "CUBE";

    public static Map<String, String> getFieldMap() {
        return fieldMap;
    }

    public static String getConnectSerial(String catalog) {
        String olapconnect = DataConnectCacheUtil.getCacheConnectAddress(catalog).getAddress();
        String CUBE_CATALOG = "provider=kingdee.olap.Shrek;initialcatalog={0};isForTest=false;language=zh;datasource=" + olapconnect;
        return MessageFormat.format(CUBE_CATALOG, catalog);
    }

    public static String getConnectSerial(String catalog, int version) {
        String olapconnect = DataConnectCacheUtil.getCacheConnectAddress(catalog).getAddress();
        String CUBE_CATALOG = "provider=kingdee.olap.Shrek;initialcatalog={0};isForTest=false;datasource=" + olapconnect + ";ClientVersion=" + String.valueOf(version);
        return MessageFormat.format(CUBE_CATALOG, catalog);
    }

    public static String getConnectSerial(String olapconnect, String catalog) {
        String CUBE_CATALOG = "provider=kingdee.olap.Shrek;initialcatalog={0};isForTest=false;datasource=" + olapconnect;
        return MessageFormat.format(CUBE_CATALOG, catalog);
    }

    public static DatasourceModel getConnectMsg(String catalog) {
        return DataConnectCacheUtil.getCacheConnectAddress(catalog);
    }

    static {
        HashMap _fieldMap = Maps.newHashMapWithExpectedSize((int)32);
        _fieldMap.put(SysDimensionEnum.Entity.getNumber(), FIELD_ORG);
        _fieldMap.put(SysDimensionEnum.Account.getNumber(), FIELD_ACCOUNT);
        _fieldMap.put(SysDimensionEnum.Year.getNumber(), FIELD_YEAR);
        _fieldMap.put(SysDimensionEnum.Period.getNumber(), FIELD_PERIOD);
        _fieldMap.put(SysDimensionEnum.Currency.getNumber(), FIELD_CURRENCY);
        _fieldMap.put(SysDimensionEnum.Version.getNumber(), FIELD_VERSION);
        _fieldMap.put(SysDimensionEnum.AuditTrail.getNumber(), FIELD_AT);
        _fieldMap.put(SysDimensionEnum.ChangeType.getNumber(), FIELD_CT);
        _fieldMap.put(SysDimensionEnum.InternalCompany.getNumber(), FIELD_IC);
        _fieldMap.put(SysDimensionEnum.DataType.getNumber(), FIELD_DT);
        _fieldMap.put(SysDimensionEnum.Metric.getNumber(), FIELD_METRIC);
        _fieldMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), FIELD_BUDGETPERIOD);
        fieldMap = Collections.unmodifiableMap(_fieldMap);
        DEFAULT_EPM_FIX_DIMENSION = new String[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Account.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.AuditTrail.getNumber(), SysDimensionEnum.ChangeType.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.Metric.getNumber(), SysDimensionEnum.Currency.getNumber()};
        OPTIMIZE_VALUE_TRUE = BgConstant.TRUE_STR;
        OPTIMIZE_VALUE_FALSE = BgConstant.FALSE_STR;
    }
}

