/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.control.dimmaterule;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;

public class DimmateruleUtils {
    public static DimmateruleUtils getInstance() {
        return new DimmateruleUtils();
    }

    public void ruleBillUpgrade(String condition) {
        List<Object> ruleList = new ArrayList(16);
        StringBuilder sqlBuilder = new StringBuilder("select a.fmodelid,b.fapplication,c.fentryid,c.fdetailid,c.fnumber,c.ftitle,c.fbillid,c.feffectivetime,c.finvalidtime,c.fserqfilter,c.fpriority,c.fdiscription,c.fmetricfield");
        sqlBuilder.append(",c.fuserdefineddimid1,c.fuserdefined1fieldid,c.fuserdefineddimid2,c.fuserdefined2fieldid,c.fuserdefineddimid3,c.fuserdefined3fieldid,c.fuserdefineddimid4,c.fuserdefined4fieldid,c.fuserdefineddimid5,c.fuserdefined5fieldid,c.fuserdefineddimid6,c.fuserdefined6fieldid");
        sqlBuilder.append(" from t_eb_dimmaterule a,t_eb_dimmateruleapp b,t_eb_dimmaterulebill c where a.fid = b.fid and b.fentryid = c.fentryid ");
        if (condition != null) {
            sqlBuilder.append(condition);
        }
        try (DataSet ds = DB.queryDataSet((String)"queryModel", (DBRoute)BgBaseConstant.epm, (String)sqlBuilder.toString());){
            if (ds != null) {
                ruleList = CommonServiceHelper.transDataSet(ds);
            }
        }
        if (ruleList.isEmpty()) {
            return;
        }
        Set<Long> modelIds = ruleList.stream().map(k -> IDUtils.toLong(k.get("fmodelid"))).collect(Collectors.toSet());
        Map<Long, String> dimNameMaps = this.dimensionNameMaps(modelIds);
        Map<String, Boolean> billIsMultiContorlMap = this.billIsMultiContorlMap();
        Map billGrp = ruleList.stream().collect(Collectors.groupingBy(k -> k.get("fbillid").toString(), Collectors.toList()));
        ArrayList<Object[]> insertObjs = new ArrayList<Object[]>(16);
        ArrayList<Object[]> insertLangObjs = new ArrayList<Object[]>(16);
        ArrayList<Object[]> updateObjs = new ArrayList<Object[]>(16);
        ArrayList<Object[]> dimmateruleBillLangObjs = new ArrayList<Object[]>(16);
        for (Map.Entry entry : billGrp.entrySet()) {
            String billId = entry.getKey();
            Boolean isMultiCtl = billIsMultiContorlMap.containsKey(billId) && billIsMultiContorlMap.get(billId) != false;
            int index = 0;
            Long groupId = GlobalIdUtil.genGlobalLongId();
            String groupNumber = null;
            String disrcription = "";
            String groupName = ResManager.loadResFormat((String)"\u9ed8\u8ba4\u89c4\u5219\u5206\u7ec4%1", (String)"DimmateruleUtils_2", (String)"epm-eb-common", (Object[])new Object[]{""});
            Map numberGrp = entry.getValue().stream().collect(Collectors.groupingBy(k -> k.get("fnumber").toString(), Collectors.toList()));
            int groupIndex = 0;
            for (Map.Entry subEntry : numberGrp.entrySet()) {
                String number = subEntry.getKey();
                List dimmateRuleList = subEntry.getValue().stream().sorted(Comparator.comparing(k -> this.getPriorityOld(k.get("fpriority")))).collect(Collectors.toList());
                disrcription = ((Map)dimmateRuleList.get(0)).get("fdiscription");
                if (isMultiCtl.booleanValue()) {
                    groupId = GlobalIdUtil.genGlobalLongId();
                    groupName = ResManager.loadResFormat((String)"\u9ed8\u8ba4\u89c4\u5219\u5206\u7ec4%1", (String)"DimmateruleUtils_2", (String)"epm-eb-common", (Object[])new Object[]{++groupIndex});
                    index = 0;
                    insertObjs.add(new Object[]{groupId, IDUtils.toLong(billId), IDUtils.toLong(((Map)entry.getValue().get(0)).get("fapplication")), "1", "0", groupName, disrcription, number});
                    insertLangObjs.add(new Object[]{UUID.randomUUID().toString().replaceAll("-", "").toLowerCase().substring(0, 12), groupId, "zh_CN", groupName, disrcription});
                }
                for (Map dr : dimmateRuleList) {
                    if (groupNumber == null) {
                        groupNumber = number;
                    }
                    String serqfilter = "";
                    if (dr.get("fpriority") != null) {
                        if (dr.get("fpriority").toString().contains("tab")) {
                            if (dr.get("fserqfilter") != null && !"".equals(dr.get("fserqfilter").toString())) {
                                Map<String, String> rowSerqfilter = this.getqfilterMap(dr.get("fserqfilter").toString(), dr.get("fpriority").toString());
                                serqfilter = dr.get("fpriority").toString().substring(1) + "," + SerializationUtils.serializeToBase64(rowSerqfilter);
                            }
                        } else {
                            serqfilter = dr.get("fserqfilter");
                        }
                    }
                    int seqId = ++index;
                    String title = "";
                    title = dr.get("ftitle") != null && !"".equals(dr.get("ftitle")) ? dr.get("ftitle").toString() : ResManager.loadResFormat((String)"\u5339\u914d\u89c4\u5219%1", (String)"DimmateruleUtils_1", (String)"epm-eb-common", (Object[])new Object[]{index});
                    ArrayList dimnames = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.Entity.getChineseName(), SysDimensionEnum.Account.getChineseName(), SysDimensionEnum.BudgetPeriod.getChineseName(), SysDimensionEnum.Currency.getChineseName(), SysDimensionEnum.Metric.getChineseName()});
                    if (dr.get("fmetricfield") == null || "0".equals(dr.get("fmetricfield").toString())) {
                        dimnames = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.Entity.getChineseName(), SysDimensionEnum.Account.getChineseName(), SysDimensionEnum.Year.getChineseName(), SysDimensionEnum.Currency.getChineseName()});
                    }
                    for (int i = 1; i < 7; ++i) {
                        Object o = dr.get("fuserdefined" + i + "fieldid");
                        if (o == null || "0".equals(o.toString()) || dr.get("fuserdefineddimid" + i) == null || "0".equals(dr.get("fuserdefineddimid" + i).toString()) || !dimNameMaps.containsKey(IDUtils.toLong(dr.get("fuserdefineddimid" + i)))) continue;
                        dimnames.add(dimNameMaps.get(IDUtils.toLong(dr.get("fuserdefineddimid" + i))));
                    }
                    Object[] dimmateRuleObj = new Object[]{title, groupId, IDUtils.toLong(dr.get("fmodelid")), serqfilter, seqId, seqId, StringUtils.join((Collection)dimnames, "\u3001"), IDUtils.toLong(dr.get("fdetailid"))};
                    updateObjs.add(dimmateRuleObj);
                    dimmateruleBillLangObjs.add(new Object[]{UUID.randomUUID().toString().replaceAll("-", "").toLowerCase().substring(0, 12), IDUtils.toLong(dr.get("fdetailid")), "zh_CN", title});
                }
            }
            if (isMultiCtl.booleanValue()) continue;
            insertObjs.add(new Object[]{groupId, IDUtils.toLong(billId), IDUtils.toLong(((Map)entry.getValue().get(0)).get("fapplication")), "1", "0", groupName, disrcription, groupNumber});
            insertLangObjs.add(new Object[]{UUID.randomUUID().toString().replaceAll("-", "").toLowerCase().substring(0, 12), groupId, "zh_CN", groupName, disrcription});
        }
        if (insertObjs.size() > 0) {
            String insertSql = "insert into t_eb_dimmaterulegroup(fid,fbill,fapplication,fstatus,fisonlycheck,fgroupname,fdiscription,fnumber) values(?,?,?,?,?,?,?,?);";
            DB.executeBatch((DBRoute)new DBRoute("epm"), (String)insertSql, insertObjs);
        }
        if (insertLangObjs.size() > 0) {
            String insertLangSql = "insert into t_eb_dimmaterulegroup_l(fpkid,fid,flocaleid,fgroupname,fdiscription) values(?,?,?,?,?);";
            DB.executeBatch((DBRoute)new DBRoute("epm"), (String)insertLangSql, insertLangObjs);
        }
        if (updateObjs.size() > 0) {
            String updateSql = "update t_eb_dimmaterulebill set ftitle = ?,fid=?,fmodelid=?,fserqfilter=?,fpriority=?,fseq=?,fisonlycontrolsuit='1',fcontroldimension=? where fdetailid = ?;";
            DB.executeBatch((DBRoute)new DBRoute("epm"), (String)updateSql, updateObjs);
            String dimmateruleBillLang = "insert into t_eb_dimmaterulebill_l (fpkid,fdetailid,flocaleid,ftitle) values (?,?,?,?)";
            DB.executeBatch((DBRoute)new DBRoute("epm"), (String)dimmateruleBillLang, dimmateruleBillLangObjs);
        }
    }

    public String checkGroup(DynamicObject obj) {
        QFilter multiContFilter;
        DynamicObject bgcontrolDefault;
        QFilter[] qFilter = QFBuilder.newQFilter().add("bill.id", "=", obj.getLong("bill.id")).add("status", "=", true).toArray();
        String field1 = "number,name,isonlycheck,cardentity.model,cardentity.bussmodel,cardentity.controldimension,";
        String field2 = "cardentity.entityfield,cardentity.accountfield,cardentity.yearfield,cardentity.currencyfield,cardentity.metricfield,cardentity.changetypefield,cardentity.userdefined1field,cardentity.userdefined2field,cardentity.userdefined3field,cardentity.userdefined4field,cardentity.userdefined5field,cardentity.userdefined6field,cardentity.entityfieldext,cardentity.accountfieldext,cardentity.currencyfieldext,cardentity.userdefined1fieldext,cardentity.userdefined2fieldext,cardentity.userdefined3fieldext,cardentity.userdefined4fieldext,cardentity.userdefined5fieldext,cardentity.userdefined6fieldext,cardentity.changetypefieldext";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"eb_adddimmaterule", (String)(field1 + field2), (QFilter[])qFilter);
        if (Arrays.stream(dynamicObjects).filter(k -> !k.getString("number").equals(obj.getString("number"))).count() > 0L && Arrays.stream(dynamicObjects).filter(k -> !k.getString("number").equals(obj.getString("number")) && !k.getBoolean("isonlycheck")).count() < 1L && (!obj.getBoolean("status") || obj.getBoolean("isonlycheck")) || Arrays.stream(dynamicObjects).filter(k -> !k.getString("number").equals(obj.getString("number"))).count() == 0L && obj.getBoolean("status") && obj.getBoolean("isonlycheck")) {
            return ResManager.loadKDString((String)"\u552f\u4e00\u5339\u914d\u89c4\u5219\u7ec4\u5fc5\u987b\u8bb0\u5f55\u5b9e\u9645\u6570", (String)"DimmateruleUtils_6", (String)"epm-eb-common", (Object[])new Object[0]);
        }
        if (!obj.getBoolean("status")) {
            return null;
        }
        long effectCnt = Arrays.stream(dynamicObjects).filter(k -> StringUtils.isEmpty(obj.getString("number")) || !obj.getString("number").equals(k.getString("number"))).count();
        if (!(effectCnt <= 0L || (bgcontrolDefault = BusinessDataServiceHelper.loadSingle((String)"eb_bgcontroldefault", (String)"orgfield,periodfield,fieldtable,ismapping,ismulticontrol", (QFilter[])(multiContFilter = new QFilter("fieldtable", "=", (Object)obj.getString("bill.number"))).toArray())) != null && bgcontrolDefault.getBoolean("ismulticontrol"))) {
            return ResManager.loadKDString((String)"\u5355\u91cd\u63a7\u5236\u4e0d\u5141\u8bb8\u591a\u4e2a\u751f\u6548\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u7ec4", (String)"DimmateruleUtils_4", (String)"epm-eb-common", (Object[])new Object[0]);
        }
        if (effectCnt > 4L) {
            return ResManager.loadKDString((String)"\u6700\u591a\u53ef\u5b58\u57285\u4e2a\u751f\u6548\u89c4\u5219\u7ec4", (String)"DimmateruleUtils_5", (String)"epm-eb-common", (Object[])new Object[0]);
        }
        if (obj.getBoolean("isonlycheck")) {
            return null;
        }
        DynamicObjectCollection currentObjEntity = obj.getDynamicObjectCollection("cardentity");
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject.getBoolean("isonlycheck") || obj.getString("number").equals(dynamicObject.getString("number"))) continue;
            DynamicObjectCollection compareObjEntity = dynamicObject.getDynamicObjectCollection("cardentity");
            String[] checkVal = field2.split(",");
            for (DynamicObject o1 : currentObjEntity) {
                String checkKey1 = this.getCheckKey(o1, checkVal);
                for (DynamicObject o2 : compareObjEntity) {
                    String checkKey2;
                    if (o1.getString("model.id") == null || !o1.getString("model.id").equals(o2.getString("model.id")) || (o1.get("bussmodel") != null || o2.get("bussmodel") != null) && (o2.get("bussmodel") == null || !o2.getString("bussmodel.id").equals(o1.getString("bussmodel.id"))) || !checkKey1.equals(checkKey2 = this.getCheckKey(o2, checkVal))) continue;
                    if (CommonUtils.isBgmdModel(o1.getLong("model.id"))) {
                        return ResManager.loadResFormat((String)"\u5f53\u524d\u5339\u914d\u89c4\u5219\u5206\u7ec4\u4e0e%1\u89c4\u5219\u7ec4\u5b58\u5728\u76f8\u540c\u7684\u5339\u914d\u89c4\u5219\uff1b\u89c4\u5219\u4fe1\u606f\uff1a\u4f53\u7cfb\uff1a%2\uff0c\u4e1a\u52a1\u6a21\u578b\uff1a%3\uff0c\u63a7\u5236\u7ef4\u5ea6\uff1a%4", (String)"DimmateruleUtils_0", (String)"epm-eb-common", (Object[])new Object[]{dynamicObject.getString("name"), o1.getString("model.name"), o2.getString("bussmodel.name"), o2.getString("controldimension")});
                    }
                    return ResManager.loadResFormat((String)"\u5f53\u524d\u5339\u914d\u89c4\u5219\u5206\u7ec4\u4e0e%1\u89c4\u5219\u7ec4\u5b58\u5728\u76f8\u540c\u7684\u5339\u914d\u89c4\u5219\uff1b\u89c4\u5219\u4fe1\u606f\uff1a\u4f53\u7cfb\uff1a%2\uff0c\u63a7\u5236\u7ef4\u5ea6\uff1a%3", (String)"DimmateruleUtils_7", (String)"epm-eb-common", (Object[])new Object[]{dynamicObject.getString("name"), o1.getString("model.name"), o2.getString("controldimension")});
                }
            }
        }
        return null;
    }

    private String getCheckKey(DynamicObject o1, String[] checkVal) {
        StringBuilder value = new StringBuilder();
        if (checkVal == null || o1 == null) {
            return value.toString();
        }
        for (String field : checkVal) {
            if (o1.getLong(field = field.replaceFirst("cardentity.", "") + ".id") == 0L) continue;
            value.append(field).append("_").append(o1.getLong(field)).append("!");
        }
        return value.toString();
    }

    public Map<String, String> getqfilterMap(String serqfilter, String priority) {
        Map map = (Map)SerializationUtils.deSerializeFromBase64((String)serqfilter);
        priority = (priority.contains("tabpage") ? priority.substring(1) : this.transOld(priority)) + "Qf";
        return (Map)map.get(priority);
    }

    public String transOld(String priority) {
        int is = Integer.parseInt(priority);
        if (is == 1) {
            return "tabpageap";
        }
        if (is == 3) {
            return "tabpage1";
        }
        if (is == 4) {
            return "tabpage2";
        }
        return "tabpage" + is;
    }

    public int getPriorityOld(Object oldPriority) {
        if (oldPriority == null || "".equals(oldPriority.toString())) {
            return 1;
        }
        if (oldPriority.toString().contains("tabpage")) {
            String substring;
            switch (substring = oldPriority.toString().substring(0, 1)) {
                case "0": {
                    return 1;
                }
                case "1": {
                    return 2;
                }
                case "2": {
                    return 3;
                }
                case "3": {
                    return 4;
                }
            }
            return 4;
        }
        try {
            return Integer.parseInt(oldPriority.toString());
        }
        catch (Exception e) {
            return 1;
        }
    }

    public String getAfterMark(Object value) {
        if (value == null || StringUtils.isEmpty(value.toString())) {
            return "";
        }
        int i = Integer.parseInt(value.toString());
        if (i == 1) {
            return "";
        }
        if (i == 2) {
            return ")";
        }
        if (i == 3) {
            return "))";
        }
        if (i == 4) {
            return ")))";
        }
        if (i == 5) {
            return "))))";
        }
        if (i == 6) {
            return ")!";
        }
        if (i == 7) {
            return "))!";
        }
        if (i == 8) {
            return ")))!";
        }
        if (i == 9) {
            return "))))!";
        }
        return "";
    }

    public String getBeforeMark(Object value) {
        if (value == null || StringUtils.isEmpty(value.toString())) {
            return "";
        }
        int i = Integer.parseInt(value.toString());
        if (i == 1) {
            return "";
        }
        if (i == 2) {
            return "(";
        }
        if (i == 3) {
            return "((";
        }
        if (i == 4) {
            return "(((";
        }
        if (i == 5) {
            return "((((";
        }
        if (i == 6) {
            return "!(";
        }
        if (i == 7) {
            return "!((";
        }
        if (i == 8) {
            return "!(((";
        }
        if (i == 9) {
            return "!((((";
        }
        return "";
    }

    public Map<Integer, Integer> sortPrioritys(List<DynamicObject> prioritys, List<Integer> realseqInt) {
        int i2;
        HashMap<Integer, Integer> realPriorityMap = new HashMap<Integer, Integer>(realseqInt.size());
        try {
            for (i2 = 0; i2 < prioritys.size(); ++i2) {
                int fi = i2;
                if (!realseqInt.stream().noneMatch(k -> k.intValue() == ((DynamicObject)prioritys.get(fi)).getInt("seq"))) continue;
                int insertindex = -1;
                block3: for (int j = fi - 1; j >= 0; --j) {
                    for (int k2 = 0; k2 < realseqInt.size(); ++k2) {
                        if (prioritys.get(j).getInt("seq") != realseqInt.get(k2).intValue()) continue;
                        insertindex = k2 + 1;
                        break block3;
                    }
                }
                if (insertindex != -1) {
                    realseqInt.add(insertindex, prioritys.get(fi).getInt("seq"));
                    continue;
                }
                if (i2 == 0) {
                    realseqInt.add(0, prioritys.get(fi).getInt("seq"));
                    continue;
                }
                realseqInt.add(prioritys.get(fi).getInt("seq"));
            }
        }
        catch (Exception i2) {
            // empty catch block
        }
        for (i2 = 0; i2 < realseqInt.size(); ++i2) {
            realPriorityMap.put(realseqInt.get(i2), i2 + 1);
        }
        return realPriorityMap;
    }

    private Map<String, Boolean> billIsMultiContorlMap() {
        HashMap<String, Boolean> billMultiConrolMap = new HashMap<String, Boolean>(16);
        try (DataSet ds = DB.queryDataSet((String)"querybgcontrolrefdefault", (DBRoute)BgBaseConstant.epm, (String)"select fbill,fismulticontrol from t_eb_bgconbizregdefault;", null);){
            if (ds != null) {
                while (ds.hasNext()) {
                    Row next = ds.next();
                    billMultiConrolMap.put(next.getString("fbill"), next.getBoolean("fismulticontrol"));
                }
            }
        }
        return billMultiConrolMap;
    }

    private Map<Long, String> dimensionNameMaps(Set<Long> modelIds) {
        HashMap<Long, String> dimensionNameMap = new HashMap<Long, String>(16);
        StringBuilder querysql = new StringBuilder();
        querysql.append("select d.fid,d.fnumber,dl.fname from t_eb_dimension d left join t_eb_dimension_l dl on d.fid=dl.fid where dl.flocaleid = 'zh_CN' and  fmodelid in (");
        for (Long aLong : modelIds) {
            querysql.append(aLong).append(",");
        }
        querysql.deleteCharAt(querysql.length() - 1).append(")");
        try (DataSet ds = DB.queryDataSet((String)"querydimensionSet", (DBRoute)BgBaseConstant.epm, (String)querysql.toString(), null);){
            if (ds != null) {
                while (ds.hasNext()) {
                    Row next = ds.next();
                    dimensionNameMap.put(next.getLong("fid"), next.getString("fname"));
                }
            }
        }
        return dimensionNameMap;
    }
}

