/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.currencyConvert;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.MapUtils;

public class CurrencyConvertCache {
    public static final String CURRENCY_CONVERT_CACHE = "CURRENCY_CONVERT_CACHE";
    private static final CurrencyConvertCache instance = new CurrencyConvertCache();

    private CurrencyConvertCache() {
    }

    public static CurrencyConvertCache getInstance() {
        return instance;
    }

    public Set<String> getSchemeIdFromCacheByModelIdAndEntityNumber(Long modelId, String entityNumber) {
        if (modelId == null || modelId == 0L || StringUtils.isEmpty(entityNumber)) {
            return Collections.emptySet();
        }
        Map<String, Set<String>> modelScheme = this.getSchemeFromCacheByModelId(modelId);
        Set<String> schemeIds = modelScheme.get(entityNumber);
        return schemeIds == null ? Collections.emptySet() : schemeIds;
    }

    public Map<String, Set<String>> getSchemeIdFromCacheByModelIdAndCollection(Long modelId, Collection<String> entitys) {
        if (modelId == null || modelId == 0L || CollectionUtils.isEmpty(entitys)) {
            return Collections.emptyMap();
        }
        Map<String, Set<String>> modelScheme = this.getSchemeFromCacheByModelId(modelId);
        HashMap<String, Set<String>> entitySchemes = new HashMap<String, Set<String>>(entitys.size());
        for (String entity : entitys) {
            Set<String> value = modelScheme.get(entity);
            if (value == null) continue;
            entitySchemes.put(entity, value);
        }
        return entitySchemes;
    }

    private Map<String, Set<String>> getSchemeFromCacheByModelId(Long modelId) {
        Map modelScheme;
        String _modelId;
        String schemeData;
        HashMap<String, String> schemeCacheMap = CacheServiceHelper.get(CURRENCY_CONVERT_CACHE, Map.class);
        if (schemeCacheMap == null) {
            schemeCacheMap = new HashMap<String, String>();
        }
        if (StringUtils.isEmpty(schemeData = (String)schemeCacheMap.get(_modelId = String.valueOf(modelId)))) {
            modelScheme = this.buildSchemeCacheDataByModelId(modelId);
            schemeCacheMap.put(_modelId, JSON.toJSONString((Object)modelScheme, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
            CacheServiceHelper.put(CURRENCY_CONVERT_CACHE, schemeCacheMap);
        } else {
            modelScheme = (Map)JSON.parseObject((String)schemeData, Map.class);
        }
        return modelScheme;
    }

    public void clearSchemeCacheForModelId(Long modelId) {
        if (modelId == null || modelId == 0L) {
            return;
        }
        Map schemeCacheMap = CacheServiceHelper.get(CURRENCY_CONVERT_CACHE, Map.class);
        String _modelId = String.valueOf(modelId);
        if (schemeCacheMap != null && schemeCacheMap.containsKey(_modelId)) {
            schemeCacheMap.remove(_modelId);
            CacheServiceHelper.put(CURRENCY_CONVERT_CACHE, schemeCacheMap);
        }
    }

    private Map<String, Set<String>> buildSchemeCacheDataByModelId(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("state", "!=", (Object)"0");
        IModelCacheHelper model = ModelCacheContext.getOrCreate(modelId);
        HashMap<String, Set<String>> allCache = new HashMap<String, Set<String>>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"buildCurrencyConvertSchemeCache", (String)"eb_currencyconvertschem", (String)"id,entityrang_tag", (QFilter[])qFilter.toArray(), null);){
            if (ds == null || ds.isEmpty()) {
                HashMap<String, Set<String>> hashMap = allCache;
                return hashMap;
            }
            for (Row row : ds) {
                String entityrang = row.getString("entityrang_tag");
                List<Member> entityMembers = this.getSchemeEntityRange(model, entityrang);
                if (entityMembers == null || entityMembers.isEmpty()) continue;
                for (Member entityMember : entityMembers) {
                    allCache.computeIfAbsent(entityMember.getNumber(), v -> new HashSet()).add(row.getString("id"));
                }
            }
        }
        return allCache;
    }

    public List<Member> getSchemeEntityRange(IModelCacheHelper model, String entityrang) {
        if (StringUtils.isEmpty(entityrang)) {
            return Collections.emptyList();
        }
        List serialize = SerializationUtils.fromJsonStringToList((String)entityrang, Map.class);
        ArrayList<Member> members = new ArrayList<Member>();
        for (Map stringMap : serialize) {
            long viewId = MapUtils.getLong((Map)stringMap, (Object)"viewId", (Long)0L);
            List<Member> entityMembers = model.getMember(SysDimensionEnum.Entity.getNumber(), (Long)viewId, (String)stringMap.get("number"), Integer.parseInt((String)stringMap.get("scope")));
            members.addAll(entityMembers);
        }
        return members;
    }
}

