/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.dao.formula;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.common.dao.formula.DimMemberPojo;

public class FormulaMemberPojo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String memberKey;
    private Long ruleId;
    private Long mainDimMemberId;
    private List<DimMemberPojo> refDimMembers;
    private Long mainViewId;
    private String mainViewNumber;

    public void setRefDimMembers(List<DimMemberPojo> refDimMembers) {
        this.refDimMembers = refDimMembers;
    }

    public void setMemberKey(String memberKey) {
        this.memberKey = memberKey;
    }

    public String getMemberKey() {
        return this.memberKey;
    }

    public Long getRuleId() {
        return this.ruleId;
    }

    public Long getMainDimMemberId() {
        return this.mainDimMemberId;
    }

    public List<DimMemberPojo> getRefDimMembers() {
        return this.refDimMembers;
    }

    public FormulaMemberPojo() {
    }

    public FormulaMemberPojo(String memberKey, Long ruleId, Long mainDimMemberId) {
        this.memberKey = memberKey;
        this.ruleId = ruleId;
        this.mainDimMemberId = mainDimMemberId;
        this.refDimMembers = new ArrayList<DimMemberPojo>(16);
    }

    public FormulaMemberPojo(String memberKey) {
        this(memberKey, null, null);
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public void setMainDimMemberId(Long mainDimMemberId) {
        this.mainDimMemberId = mainDimMemberId;
    }

    public void addRefDimMember(DimMemberPojo member) {
        this.refDimMembers.add(member);
    }

    public void addRefDimMember(Long memberId, String membNumber, String membLongNum, String membName, String dimNumber, String dimShortNum, String dataModelNumber, Long viewId, String viewNumber) {
        DimMemberPojo member = new DimMemberPojo(memberId, membNumber, membLongNum, membName, dimNumber, dimShortNum, dataModelNumber);
        member.setViewId(viewId);
        member.setViewNumber(viewNumber);
        this.refDimMembers.add(member);
    }

    public DimMemberPojo getRefDimMemberByDimNum(String dimNumber) {
        DimMemberPojo result = null;
        if (dimNumber != null) {
            for (DimMemberPojo memberPojo : this.refDimMembers) {
                if (!dimNumber.equals(memberPojo.getDimNumber())) continue;
                result = memberPojo;
                break;
            }
        }
        return result;
    }

    public void delRefDimMemberByDimNum(String dimNumber) {
        if (dimNumber != null) {
            this.refDimMembers.removeIf(memb -> memb.getDimNumber().equals(dimNumber));
        }
    }

    public FormulaMemberPojo clone() {
        FormulaMemberPojo newObj = new FormulaMemberPojo(this.memberKey);
        newObj.setMainDimMemberId(this.mainDimMemberId);
        newObj.setRuleId(this.ruleId);
        newObj.setMainViewId(this.mainViewId);
        newObj.setMainViewNumber(this.mainViewNumber);
        List<DimMemberPojo> dimMemberPojos = newObj.getRefDimMembers();
        for (DimMemberPojo dimMemberPojo : this.refDimMembers) {
            dimMemberPojos.add(dimMemberPojo.clone());
        }
        return newObj;
    }

    public Long getMainViewId() {
        return this.mainViewId;
    }

    public void setMainViewId(Long mainViewId) {
        this.mainViewId = mainViewId;
    }

    public String getMainViewNumber() {
        return this.mainViewNumber;
    }

    public void setMainViewNumber(String mainViewNumber) {
        this.mainViewNumber = mainViewNumber;
    }
}

