/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.dao.formula;

import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import org.apache.commons.lang3.tuple.Pair;

public class LambdaParser {
    public static Pair<String, String> parseExpression(String expression) {
        String value = expression.trim();
        if (LambdaParser.startCheck(value, "value(") || LambdaParser.startCheck(value, "v(")) {
            return LambdaParser.valueParse(value);
        }
        return LambdaParser.stringParse(value);
    }

    private static boolean startCheck(String data, String startString) {
        int i = 0;
        for (char c : startString.toCharArray()) {
            if (i >= data.length()) {
                return false;
            }
            if (data.charAt(i) <= ' ') {
                ++i;
                continue;
            }
            if (c != data.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Pair<String, String> stringParse(String expression) {
        int i;
        StringBuilder left = new StringBuilder();
        char temp = expression.charAt(0);
        if (!(temp >= 'a' && temp <= 'z' || temp >= 'A' && temp <= 'Z' || temp == '_')) {
            throw new RuntimeException(ResManager.loadResFormat((String)"\u8868\u8fbe\u5f0f\uff1a%1\uff0c\u7b49\u53f7\u7684\u5de6\u8fb9\u5b57\u7b26\u5e94\u7b26\u5408\u8981\u6c42\uff1a[_a-zA-Z][_a-zA-Z0-9]*?", (String)"LambdaParser_0", (String)"epm-eb-common", (Object[])new Object[]{expression}));
        }
        left.append(expression.charAt(0));
        for (i = 1; i < expression.length() && (temp = expression.charAt(i)) != '='; ++i) {
            if (!(temp >= 'a' && temp <= 'z' || temp >= 'A' && temp <= 'Z' || temp >= '0' && temp <= '9' || temp == '_')) {
                throw new RuntimeException(ResManager.loadResFormat((String)"\u8868\u8fbe\u5f0f\uff1a%1\uff0c\u7b49\u53f7\u7684\u5de6\u8fb9\u5b57\u7b26\u5e94\u7b26\u5408\u8981\u6c42\uff1a[_a-zA-Z][_a-zA-Z0-9]*?", (String)"LambdaParser_0", (String)"epm-eb-common", (Object[])new Object[]{expression}));
            }
            left.append(expression.charAt(i));
        }
        String right = expression.substring(i + 1);
        String leftStr = left.toString().trim();
        return Pair.of((Object)leftStr, (Object)right.trim());
    }

    private static Pair<String, String> valueParse(String expression) {
        String leftStr;
        char temp;
        int i;
        StringBuilder left = new StringBuilder();
        Stack<Character> stack = new Stack<Character>();
        for (i = 0; i < expression.length(); ++i) {
            temp = expression.charAt(i);
            if (temp != '(') continue;
            stack.push(Character.valueOf(expression.charAt(i)));
            ++i;
            break;
        }
        int errorFlg = -1;
        while (i < expression.length() && errorFlg <= 0) {
            temp = expression.charAt(i);
            if (stack.empty()) {
                if (temp == '=') break;
                if (temp >= '!' && temp <= '~') {
                    errorFlg = 4;
                    break;
                }
            }
            if (temp == '\'') {
                if (((Character)stack.lastElement()).charValue() == expression.charAt(i)) {
                    stack.pop();
                    ++errorFlg;
                } else {
                    stack.push(Character.valueOf(expression.charAt(i)));
                }
            } else if (temp == ')') {
                if (((Character)stack.lastElement()).charValue() == '(') {
                    stack.pop();
                } else if (((Character)stack.lastElement()).charValue() != '\'') {
                    errorFlg = 2;
                    break;
                }
            } else if (temp >= '!' && temp <= '~' && ((Character)stack.lastElement()).charValue() != '\'') {
                errorFlg = 3;
                break;
            }
            left.append(expression.charAt(i));
            ++i;
        }
        if ((leftStr = left.toString().trim()).endsWith(")")) {
            leftStr = leftStr.substring(0, leftStr.length() - 1).trim();
        }
        if (leftStr.startsWith("'")) {
            leftStr = leftStr.substring(1);
        }
        if (leftStr.endsWith("'")) {
            leftStr = leftStr.substring(0, leftStr.length() - 1);
        }
        if (errorFlg > 0 || i >= expression.length() - 1) {
            throw new RuntimeException(ResManager.loadResFormat((String)"\u89e3\u6790\u8868\u8fbe\u5f0f\u5931\u8d25\uff1a%1\uff0c\u8868\u8fbe\u5f0f\u7b49\u53f7\u5de6\u8fb9\u5e94\u7b26\u5408\uff1avalue('a,b,...,c')\u6216\u8005 v('a,b,...,c')\u4e14a\u3001b\u3001c\u5747\u4e0d\u80fd\u542b\u6709\u5355\u5f15\u53f7(')\u3002", (String)"LambdaParser_1", (String)"epm-eb-common", (Object[])new Object[]{expression}));
        }
        String right = expression.substring(i + 1);
        return Pair.of((Object)leftStr, (Object)right.trim());
    }
}

