/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.dao.formula;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.dao.formula.LambdaParser;
import kd.epm.eb.common.dao.formula.service.FelExpress;
import kd.epm.eb.common.enums.RangeEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class UserCreateFelExpress
implements FelExpress {
    private String felContent;
    private String id;
    private String name;
    private Boolean status;
    private Long model;
    private String modelCube;
    private String expression;
    private String expressLeft;
    private String scopeInfo;
    private boolean isTemplateExecute;
    private Map<String, Set<String>> dimentionMembers = new HashMap<String, Set<String>>(16);
    private Map<String, Set<String>> idescendantsMembers = new HashMap<String, Set<String>>(16);

    public UserCreateFelExpress(String id, String name, Boolean status, Long model, String modelCube, String felContent, boolean isTemplateExecute) {
        this.id = id;
        this.status = status;
        this.name = name;
        this.model = model;
        this.modelCube = modelCube;
        this.isTemplateExecute = isTemplateExecute;
        this.felContent = felContent;
        if (felContent.startsWith("run(")) {
            if (!felContent.endsWith(")")) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u811a\u672c\u201c%1\u201d\u89e3\u6790\u9519\u8bef\uff1arun\u51fd\u6570\u65e0\u53cd\u62ec\u53f7\uff0c\u201c%2\u201d\u3002", (String)"UserCreateFelExpress_0", (String)"epm-eb-common", (Object[])new Object[]{name, felContent}));
            }
        } else {
            throw new KDBizException(ResManager.loadResFormat((String)"\u516c\u5f0f\u201c%1\u201d\u89e3\u6790\u9519\u8bef\uff1a\u65e0run\u51fd\u6570\uff0c\u201c%2\u201d\u3002", (String)"UserCreateFelExpress_1", (String)"epm-eb-common", (Object[])new Object[]{name, felContent}));
        }
        felContent = StringUtils.substring((String)felContent, (int)4, (int)(felContent.length() - 1));
        int index = felContent.indexOf("value(");
        if (index == -1) {
            index = felContent.indexOf("v(");
        }
        String value = index != -1 ? felContent.substring(index, felContent.length() - 1) : felContent;
        Pair<String, String> valuePair = LambdaParser.parseExpression(value);
        this.expression = (String)valuePair.getRight();
        this.expressLeft = (String)valuePair.getLeft();
        int scopeIndex = felContent.indexOf("scope(");
        this.scopeInfo = scopeIndex != -1 && index != -1 ? felContent.substring(scopeIndex + 6, index - 3) : null;
        if (this.scopeInfo != null) {
            this.dealScope();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dealScope() {
        Stack<Character> stack = new Stack<Character>();
        int i = 0;
        StringBuilder dimension = new StringBuilder();
        StringBuilder member = new StringBuilder();
        while (i < this.scopeInfo.length()) {
            char temp;
            if ((temp = this.scopeInfo.charAt(i++)) == '(') {
                String function = dimension.toString();
                if (!"idescendants".equals(function)) throw new KDBizException(ResManager.loadResFormat((String)"\u516c\u5f0f\u201c%1\u201d\u89e3\u6790\u9519\u8bef\uff1a\u4e0d\u652f\u6301\u7684\u51fd\u6570\u7c7b\u578b\u201c%2\u201d\u3002", (String)"UserCreateFelExpress_3", (String)"epm-eb-common", (Object[])new Object[]{this.name, function}));
                temp = this.scopeInfo.charAt(i++);
                StringBuilder stringBuilder = new StringBuilder();
                while (temp != ')') {
                    stringBuilder.append(temp);
                    temp = this.scopeInfo.charAt(i++);
                }
                StringBuilder sb2 = new StringBuilder();
                String[] strings = new String[2];
                int x = 0;
                boolean begin = false;
                for (int j = 0; j < stringBuilder.length(); ++j) {
                    char c = stringBuilder.charAt(j);
                    if (c == '\"' || c == '\'') {
                        if (!begin) {
                            begin = true;
                            continue;
                        }
                        strings[x] = sb2.toString();
                        ++x;
                        sb2.setLength(0);
                        begin = false;
                        continue;
                    }
                    if (!begin) continue;
                    sb2.append(c);
                }
                Set strings1 = this.idescendantsMembers.computeIfAbsent(strings[0], e -> new HashSet(16));
                strings1.add(strings[1]);
                dimension.setLength(0);
            } else if (temp == '.' || temp == '@') {
                HashSet<String> members;
                block18: {
                    stack.push(Character.valueOf(temp));
                    temp = this.scopeInfo.charAt(i++);
                    int j = i + 3;
                    member.setLength(0);
                    members = new HashSet<String>();
                    do {
                        member.append(temp);
                        temp = this.scopeInfo.charAt(i++);
                        if (i < this.scopeInfo.length()) continue;
                        member.append(temp);
                        break;
                    } while (i < j && temp != ',');
                    if (member.toString().equalsIgnoreCase("in(") && temp != ')') {
                        stack.pop();
                        stack.push(Character.valueOf(temp));
                        boolean first = true;
                        while (i < this.scopeInfo.length() && temp != ')') {
                            if (first) {
                                if (temp != '\"' && temp != '\'') {
                                    throw new KDBizException(ResManager.loadResFormat((String)"\u516c\u5f0f\u201c%1\u201d\u89e3\u6790\u9519\u8bef\uff1ain\u5185\u7ef4\u5ea6\u6210\u5458\u9700\u8981\u4ee5\u201c\"\u201d\u6216\u201c'\u201d\u5f00\u59cb\uff0c\u201c%2\u201d\u3002", (String)"UserCreateFelExpress_4", (String)"epm-eb-common", (Object[])new Object[]{this.name, this.felContent}));
                                }
                                first = false;
                            }
                            member.setLength(0);
                            stack.push(Character.valueOf(temp));
                            while (i < this.scopeInfo.length()) {
                                if ((temp = this.scopeInfo.charAt(i++)) == '\"' || temp == '\'') {
                                    if ((temp = this.scopeInfo.charAt(i++)) == ',') {
                                        temp = this.scopeInfo.charAt(i++);
                                        first = true;
                                        break;
                                    }
                                    if (temp != ')') throw new KDBizException(ResManager.loadResFormat((String)"\u516c\u5f0f\u201c%1\u201d\u89e3\u6790\u9519\u8bef\uff1ain\u5185\u7ef4\u5ea6\u6210\u5458\u9700\u8981\u4ee5\u201c\"\u201d\u6216\u201c'\u201d\u7ed3\u675f\uff0c\u201c%2\u201d\u3002", (String)"UserCreateFelExpress_5", (String)"epm-eb-common", (Object[])new Object[]{this.name, this.felContent}));
                                    members.add(member.toString());
                                    break block18;
                                }
                                member.append(temp);
                            }
                            members.add(member.toString());
                            stack.pop();
                        }
                    } else {
                        while (i < this.scopeInfo.length() && temp != ',') {
                            member.append(temp);
                            temp = this.scopeInfo.charAt(i++);
                        }
                        members.add(member.toString());
                    }
                }
                stack.pop();
                this.dimentionMembers.put(dimension.toString(), members);
                dimension.setLength(0);
            }
            if (temp == '(' || temp == ',' || temp == ')') continue;
            dimension.append(temp);
        }
    }

    @Override
    public Map<String, Set<String>> getDimensionFilter(Model model, Map<String, Set<String>> templateMembers) {
        if (model == null) {
            return null;
        }
        if (templateMembers == null) {
            templateMembers = new HashMap<String, Set<String>>(16);
        }
        HashMap<String, Set<String>> filters = new HashMap<String, Set<String>>(16);
        Set<String> dimensionNumLists = model.getDimensionNumSet();
        Set<String> keySet = this.dimentionMembers.keySet();
        Set<String> keySet2 = this.idescendantsMembers.keySet();
        if (!dimensionNumLists.containsAll(keySet2)) {
            keySet2.removeAll(dimensionNumLists);
            throw new KDBizException(ResManager.loadResFormat((String)"\u516c\u5f0f\u201c%1 \u89e3\u6790\u9519\u8bef\uff1a\u4f7f\u7528\u4e86\u9519\u8bef\u7684\u7ef4\u5ea6\u201c%2\u201d\u3002", (String)"UserCreateFelExpress_6", (String)"epm-eb-common", (Object[])new Object[]{this.name, keySet}));
        }
        if (!dimensionNumLists.containsAll(keySet)) {
            keySet.removeAll(dimensionNumLists);
            throw new KDBizException(ResManager.loadResFormat((String)"\u516c\u5f0f\u201c%1 \u89e3\u6790\u9519\u8bef\uff1a\u4f7f\u7528\u4e86\u9519\u8bef\u7684\u7ef4\u5ea6\u201c%2\u201d\u3002", (String)"UserCreateFelExpress_6", (String)"epm-eb-common", (Object[])new Object[]{this.name, keySet}));
        }
        for (String dimensionNumber : dimensionNumLists) {
            if (this.expressLeft.contains(dimensionNumber + ".") || this.expressLeft.contains(dimensionNumber + "@")) continue;
            Set<String> templateValue = templateMembers.get(dimensionNumber);
            Set<String> currentExprNumbers = this.dimentionMembers.get(dimensionNumber);
            Set<String> idescendantsNumber = this.idescendantsMembers.get(dimensionNumber);
            Set<String> calcScope = new HashSet<String>(16);
            if (templateValue != null) {
                calcScope.addAll(templateValue);
            }
            HashSet<String> userCreateScope = new HashSet<String>(16);
            if (CollectionUtils.isNotEmpty(currentExprNumbers)) {
                userCreateScope.addAll(currentExprNumbers);
            }
            if (CollectionUtils.isNotEmpty(idescendantsNumber)) {
                for (String memberNumber : idescendantsNumber) {
                    List<Member> member = ModelCacheServiceHelper.getMember(model, dimensionNumber, memberNumber, RangeEnum.ALL.getIndex());
                    if (!CollectionUtils.isNotEmpty(member)) continue;
                    calcScope = member.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                }
            }
            if (calcScope.isEmpty()) {
                calcScope = userCreateScope;
            } else if (CollectionUtils.isNotEmpty(userCreateScope)) {
                calcScope.retainAll(userCreateScope);
            }
            if (this.isTemplateExecute && calcScope.isEmpty()) {
                return null;
            }
            filters.put(dimensionNumber, calcScope);
        }
        return filters;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Boolean getStatus() {
        return this.status;
    }

    @Override
    public Long getModel() {
        return this.model;
    }

    @Override
    public String getModelCube() {
        return this.modelCube;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public String getExpressLeft() {
        return this.expressLeft;
    }

    @Override
    public boolean isTemplateExecute() {
        return this.isTemplateExecute;
    }

    public void setTemplateExecute(boolean templateExecute) {
        this.isTemplateExecute = templateExecute;
    }
}

