/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.dao.memberQuote;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MemberQuoteDao
implements Serializable {
    private static final long serialVersionUID = -6806226553016918208L;
    private Long modelId;
    private Long datasetId;
    private Long dimensionId;
    private Set<Long> memberIds = new LinkedHashSet<Long>();
    private Map<Long, Set<Integer>> memberRangeMap = new LinkedHashMap<Long, Set<Integer>>(16);
    private Map<Long, Long> memberViewMap = new LinkedHashMap<Long, Long>(16);
    private Map<Long, Map<String, String>> extInfo = null;
    private MemberTypeEnum memberType = MemberTypeEnum.MEMBER;
    private MemberQuoteResourceEnum resource;
    private Long resourceId;
    public static final String EXT_TYPE_OFFSET = "offset";
    private transient String quoteKey = null;

    public MemberQuoteDao(@NotNull Long modelId, @NotNull Long datasetId, @NotNull Long dimensionId, @NotNull MemberQuoteResourceEnum resource, @NotNull Long resourceId) {
        this.modelId = modelId;
        this.datasetId = datasetId;
        this.dimensionId = dimensionId;
        this.resource = resource;
        this.resourceId = resourceId;
        if (modelId == null) {
            throw new KDBizException("modelId is null.");
        }
        if (datasetId == null) {
            throw new KDBizException("datasetId is null.");
        }
        if (dimensionId == null) {
            throw new KDBizException("dimensionId is null.");
        }
        if (resource == null) {
            throw new KDBizException("resource is null.");
        }
        if (resourceId == null) {
            throw new KDBizException("resourceId is null.");
        }
    }

    public MemberQuoteDao(@NotNull Long modelId, @NotNull Long datasetId, @NotNull Long dimensionId, @NotNull MemberQuoteResourceEnum resource, @NotNull Long resourceId, @NotNull Map<Long, Set<Integer>> memberRangeMap) {
        this(modelId, datasetId, dimensionId, resource, resourceId);
        this.memberRangeMap = memberRangeMap;
    }

    public MemberQuoteDao(@NotNull Long modelId, @NotNull Long datasetId, @NotNull Long dimensionId, @NotNull Long memberId, @NotNull MemberQuoteResourceEnum resource, @NotNull Long sourceId) {
        this(modelId, datasetId, dimensionId, resource, sourceId);
        if (IDUtils.isNotNull(memberId)) {
            this.memberIds.add(memberId);
        }
    }

    public MemberQuoteDao(@NotNull Long modelId, @NotNull Long datasetId, @NotNull Long dimensionId, @NotNull Long memberId, @NotNull MemberTypeEnum memberType, @NotNull MemberQuoteResourceEnum resource, @NotNull Long sourceId) {
        this(modelId, datasetId, dimensionId, resource, sourceId);
        if (IDUtils.isNotNull(memberId)) {
            this.memberIds.add(memberId);
        }
        this.memberType = memberType;
    }

    public MemberQuoteDao(@NotNull Long modelId, @NotNull Long datasetId, @NotNull Long dimensionId, Collection<Long> memberIds, @NotNull MemberQuoteResourceEnum resource, @NotNull Long sourceId) {
        this(modelId, datasetId, dimensionId, resource, sourceId);
        if (memberIds != null && !memberIds.isEmpty()) {
            this.memberIds.addAll(memberIds);
        }
    }

    public MemberQuoteDao(@NotNull Long modelId, @NotNull Long datasetId, @NotNull Long dimensionId, Collection<Long> memberIds, @NotNull MemberQuoteResourceEnum resource, @NotNull Long sourceId, @NotNull Map<Long, Set<Integer>> memberRangeMap) {
        this(modelId, datasetId, dimensionId, resource, sourceId);
        if (memberIds != null && !memberIds.isEmpty()) {
            this.memberIds.addAll(memberIds);
        }
        if (this.memberRangeMap != null) {
            for (Map.Entry<Long, Set<Integer>> entry : memberRangeMap.entrySet()) {
                Set integers = this.memberRangeMap.computeIfAbsent(entry.getKey(), t -> (Set)entry.getValue());
                integers.addAll((Collection)entry.getValue());
            }
        }
    }

    public MemberQuoteDao(@NotNull Long modelId, @NotNull Long datasetId, @NotNull Long dimensionId, Collection<Long> memberIds, @NotNull MemberTypeEnum memberType, @NotNull MemberQuoteResourceEnum resource, @NotNull Long sourceId) {
        this(modelId, datasetId, dimensionId, resource, sourceId);
        this.memberType = memberType;
        if (memberIds != null && !memberIds.isEmpty()) {
            this.memberIds.addAll(memberIds);
        }
    }

    public Map<Long, Set<Integer>> getMemberRangeMap() {
        return this.memberRangeMap;
    }

    public void setMemberRangeMap(Map<Long, Set<Integer>> memberRangeMap) {
        this.memberRangeMap = memberRangeMap;
    }

    public Map<Long, Long> getMemberViewMap() {
        return this.memberViewMap;
    }

    public void setMemberViewMap(Map<Long, Long> memberViewMap) {
        this.memberViewMap = memberViewMap;
    }

    public void setModelId(@NotNull Long modelId) {
        this.modelId = modelId;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setDatasetId(@NotNull Long datasetId) {
        this.datasetId = datasetId;
    }

    public Long getDatasetId() {
        return this.datasetId;
    }

    public void setDimensionId(@NotNull Long dimensionId) {
        this.dimensionId = dimensionId;
    }

    public Long getDimensionId() {
        return this.dimensionId;
    }

    public void setMemberIds(Set<Long> memberIds) {
        this.memberIds = memberIds;
    }

    public Set<Long> getMemberIds() {
        return this.memberIds;
    }

    public void setMemberType(@NotNull MemberTypeEnum quoteType) {
        this.memberType = quoteType;
    }

    public MemberTypeEnum getMemberType() {
        return this.memberType;
    }

    public void setResource(@NotNull MemberQuoteResourceEnum resource) {
        this.resource = resource;
    }

    public MemberQuoteResourceEnum getResource() {
        return this.resource;
    }

    public void setResourceId(@NotNull Long resourceId) {
        this.resourceId = resourceId;
    }

    public Long getResourceId() {
        return this.resourceId;
    }

    public void setExtInfo(Map<Long, Map<String, String>> extInfo) {
        this.extInfo = extInfo;
    }

    public Map<Long, Map<String, String>> getExtInfo() {
        return this.extInfo;
    }

    public void mergeExtInfo(Map<Long, Map<String, String>> extInfo) {
        if (extInfo == null || extInfo.isEmpty()) {
            return;
        }
        if (this.getExtInfo() == null) {
            this.setExtInfo(new HashMap<Long, Map<String, String>>());
        }
        for (Map.Entry<Long, Map<String, String>> entry : extInfo.entrySet()) {
            if (IDUtils.isNull(entry.getKey()) || entry.getValue() == null || entry.getValue().isEmpty()) continue;
            Map<String, String> _extMap = this.getExtInfo().get(entry.getKey());
            if (_extMap == null) {
                this.getExtInfo().put(entry.getKey(), entry.getValue());
                continue;
            }
            for (Map.Entry<String, String> memExt : _extMap.entrySet()) {
                if (StringUtils.isEmpty(memExt.getKey()) || StringUtils.isEmpty(memExt.getValue())) continue;
                String _extValue = _extMap.get(memExt.getKey());
                if (_extValue == null) {
                    _extMap.put(memExt.getKey(), memExt.getValue());
                    continue;
                }
                _extMap.put(memExt.getKey(), _extValue + ';' + memExt.getValue());
            }
        }
    }

    public String getQuoteKey() {
        if (this.quoteKey == null) {
            StringBuilder str = new StringBuilder();
            str.append(this.getModelId()).append('@').append(this.getDatasetId()).append('@');
            str.append(this.getDimensionId()).append('@').append(this.getMemberType().getType()).append('@');
            str.append(this.getResource().getType()).append('@').append(this.getResourceId());
            this.quoteKey = str.toString();
        }
        return this.quoteKey;
    }
}

