/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.dao.variable;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.dao.variable.VariableCacheContext;
import kd.epm.eb.common.dao.variable.VariableDto;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.common.var.ReportVarUtil;
import org.jetbrains.annotations.NotNull;

public class VariableCacheService {
    private static final Log log = LogFactory.getLog(VariableCacheService.class);
    public static final String CACHE_VARIABLE_GRAPHNODE_VERSION_KEY = "epm:cacheVariable:v";
    private static final long MODEL_MAX_SIZE = 16L;
    private static final long MODEL_OVER_TIME = 2L;
    private static LoadingCache<Long, VariableCacheContext> caches = CacheBuilder.newBuilder().maximumSize(16L).expireAfterAccess(2L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<Long, VariableCacheContext>(){

        public VariableCacheContext load(Long bizModelId) {
            return VariableCacheService.getInstance().initCache(bizModelId);
        }
    });

    public static VariableCacheService getInstance() {
        return InnerClass.instance;
    }

    public VariableCacheContext listVariableFromLocalCache(Long modelId) {
        VariableCacheContext cacheContext;
        try {
            cacheContext = (VariableCacheContext)caches.get((Object)modelId);
        }
        catch (ExecutionException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        String versionNum = this.getVersionFromRedis(modelId);
        if (cacheContext != null && !cacheContext.getVersionId().equals(versionNum)) {
            caches.refresh((Object)modelId);
            try {
                cacheContext = (VariableCacheContext)caches.get((Object)modelId);
            }
            catch (ExecutionException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
        }
        if (cacheContext != null) {
            return cacheContext;
        }
        return new VariableCacheContext();
    }

    private String getCacheKey(Long modelId) {
        return CACHE_VARIABLE_GRAPHNODE_VERSION_KEY + modelId + "v3";
    }

    public VariableCacheContext initCache(@NotNull Long bizModelId) {
        if (bizModelId == 0L) {
            throw new NullPointerException("getFromCache error.(bizModelId is null)");
        }
        VariableCacheContext variableCacheContext = new VariableCacheContext();
        String versionNum = this.getVersionFromRedis(bizModelId);
        log.info("\u89c4\u5219\u7f13\u5b58\u7248\u672c\u53f7\uff1a" + versionNum);
        variableCacheContext.setVersionId(versionNum);
        Map<String, VariableDto> variableDtoMap = ReportVarUtil.queryAllVariable(bizModelId);
        variableCacheContext.setVariableDtoMap(variableDtoMap);
        return variableCacheContext;
    }

    private String getVersionFromRedis(Long modelId) {
        String versionStr = Cache.get().get(this.getCacheKey(modelId));
        if (StringUtils.isNotEmpty(versionStr)) {
            return versionStr;
        }
        String newVersionNum = DBServiceHelper.genStringId();
        Cache.get().set(this.getCacheKey(modelId), newVersionNum);
        return newVersionNum;
    }

    public void clearCache(Long modelId) {
        if (modelId == null) {
            return;
        }
        Cache.get().remove(this.getCacheKey(modelId));
        caches.invalidate((Object)modelId);
    }

    static {
        try {
            ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            scheduledExecutor.scheduleAtFixedRate(() -> {
                log.info("\u5b9a\u65f6\u6e05\u7406\u89c4\u5219\u7f13\u5b58");
                caches.cleanUp();
            }, 10L, 30L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            log.warn("\u5b9a\u65f6\u6e05\u7406\u89c4\u5219\u7f13\u5b58\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    private static class InnerClass {
        private static VariableCacheService instance = new VariableCacheService();

        private InnerClass() {
        }
    }
}

