/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.datalock;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.datalock.DataLockCacheHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class DataLockCache {
    private Map<String, Map<String, Set<String>>> dataLockMap;
    private Long modelId;
    private IModelCacheHelper modelCacheHelper;

    public Map<String, Map<String, Set<String>>> getDataLockMap() {
        return this.dataLockMap;
    }

    public void setDataLockMap(Map<String, Map<String, Set<String>>> dataLockMap) {
        this.dataLockMap = dataLockMap;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public void setModelCacheHelper(IModelCacheHelper modelCacheHelper) {
        this.modelCacheHelper = modelCacheHelper;
    }

    public static DataLockCache init(Long modelId) {
        DataLockCache dataLockCache = new DataLockCache();
        dataLockCache.setModelId(modelId);
        dataLockCache.setModelCacheHelper(ModelCacheContext.getOrCreate(modelId));
        Map<String, Map<String, Set<String>>> dataLock = DataLockCacheHelper.getDataLock(modelId);
        if (dataLock != null) {
            String jsonString = JsonUtils.getJsonString(dataLock);
            dataLock = JsonUtils.readValue(jsonString, new TypeReference<Map<String, Map<String, Set<String>>>>(){});
        }
        dataLockCache.setDataLockMap(dataLock);
        return dataLockCache;
    }

    public boolean checkLock(Map<String, String> memberMap) {
        if (MapUtils.isEmpty(this.getDataLockMap())) {
            return false;
        }
        String yearNumber = memberMap.get(SysDimensionEnum.Year.getNumber());
        String currencyNumber = memberMap.get(SysDimensionEnum.Currency.getNumber());
        String versionNumber = memberMap.get(SysDimensionEnum.Version.getNumber());
        String entityNumber = memberMap.get(SysDimensionEnum.Entity.getNumber());
        String periodNumber = memberMap.get(SysDimensionEnum.Period.getNumber());
        if (StringUtils.isEmpty(yearNumber) || StringUtils.isEmpty(currencyNumber) || StringUtils.isEmpty(versionNumber) || StringUtils.isEmpty(entityNumber) || StringUtils.isEmpty(periodNumber)) {
            return false;
        }
        String firstKey = yearNumber + "_" + currencyNumber + "_" + versionNumber;
        Map<String, Set<String>> secondMap = this.getDataLockMap().get(firstKey);
        Member member = this.modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), null, entityNumber);
        if (MapUtils.isNotEmpty(secondMap)) {
            while (member != null) {
                Set<String> thirdMap = secondMap.get(member.getNumber());
                if (CollectionUtils.isNotEmpty(thirdMap) && thirdMap.contains(periodNumber)) {
                    return true;
                }
                Long parentId = member.getParentId();
                member = this.modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), null, parentId);
            }
        }
        return false;
    }
}

