/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.datalock;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.datalock.DataLockService;
import kd.epm.eb.common.utils.CacheServiceHelper;

public class DataLockCacheHelper {
    private static final String DATA_LOCK_CACHE = "DATA_LOCK_CACHE";
    private static final DataLockService service = DataLockService.getInstance();

    public static Map<String, Map<String, Set<String>>> getDataLock(Long modelId) {
        String _modelId;
        Map _cache;
        HashMap<String, Map<String, Map<String, Set<String>>>> caches = CacheServiceHelper.get(DATA_LOCK_CACHE, Map.class);
        if (caches == null) {
            caches = new HashMap<String, Map<String, Map<String, Set<String>>>>();
        }
        if ((_cache = (Map)caches.get(_modelId = String.valueOf(modelId))) != null) {
            return _cache;
        }
        Map<String, Map<String, Set<String>>> maps = service.buildCache(modelId);
        caches.put(_modelId, maps);
        CacheServiceHelper.put(DATA_LOCK_CACHE, caches);
        return maps;
    }

    public static void clearDataLock(Long modelId) {
        if (modelId == null || modelId == 0L) {
            return;
        }
        Map caches = CacheServiceHelper.get(DATA_LOCK_CACHE, Map.class);
        String _modelId = String.valueOf(modelId);
        if (caches != null && caches.containsKey(_modelId)) {
            caches.remove(_modelId);
            CacheServiceHelper.put(DATA_LOCK_CACHE, caches);
        }
    }
}

