/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.datalock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.datalock.DataLockCacheHelper;
import kd.epm.eb.common.datalock.DataLockEntry;
import kd.epm.eb.common.datalock.DataLockKey;
import kd.epm.eb.common.datalock.DataLockLogEntry;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.lazytree.datalock.DataLockUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class DataLockService {
    private static final Log log = LogFactory.getLog(DataLockService.class);
    private static final String LOGTAG = "DATALOCKLOG";
    private static final DataLockService instance = new DataLockService();

    private DataLockService() {
    }

    public static DataLockService getInstance() {
        return instance;
    }

    public Map<String, Map<String, Set<String>>> buildCache(Long modelId) {
        HashMap<String, Map<String, Set<String>>> dataLockMap = new HashMap<String, Map<String, Set<String>>>(16);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        List<String> leafPeriods = DataLockUtils.getPeriods(modelCache, false);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"buildDataLockCache", (String)"eb_datalock", (String)"id,year.number,currency.number,version.number,entity.number,periodbinary", (QFilter[])qFilter.toArray(), (String)"year,currency,version");
        DataLockKey dataLockKey = null;
        HashMap cache = null;
        LogStats logStats = new LogStats("datalockbuildcache" + leafPeriods.toString());
        int periodSize = leafPeriods.size();
        ArrayList<Long> needDelete = new ArrayList<Long>(16);
        while (dataSet.hasNext()) {
            String entityNumber;
            Row next = dataSet.next();
            String currYear = next.getString("year.number");
            String currCurrency = next.getString("currency.number");
            String currVersion = next.getString("version.number");
            if (dataLockKey == null || !new EqualsBuilder().append((Object)dataLockKey.getYear(), (Object)currYear).append((Object)dataLockKey.getCurrency(), (Object)currCurrency).append((Object)dataLockKey.getVersion(), (Object)currVersion).isEquals()) {
                dataLockKey = new DataLockKey(currYear, currCurrency, currVersion);
                cache = new HashMap(16);
                dataLockMap.put(dataLockKey.toString(), cache);
            }
            if (StringUtils.isEmpty((CharSequence)(entityNumber = next.getString("entity.number")))) continue;
            Integer periodbinary = next.getInteger("periodbinary");
            String binaryString = Integer.toBinaryString(periodbinary);
            HashSet<String> periods = new HashSet<String>(16);
            char[] chars = binaryString.toCharArray();
            if (chars.length != periodSize + 1) {
                needDelete.add(next.getLong("id"));
                continue;
            }
            for (int i = 0; i < periodSize; ++i) {
                String period = leafPeriods.get(i);
                char aChar = chars[i + 1];
                if (aChar != '1') continue;
                periods.add(period);
            }
            if (cache != null) {
                cache.put(entityNumber, periods);
            }
            logStats.addInfo(dataLockKey.toString() + "," + entityNumber + "," + binaryString + ((Object)periods).toString());
        }
        if (needDelete.size() > 0) {
            DeleteServiceHelper.delete((String)"eb_datalock", (QFilter[])new QFilter("id", "in", needDelete).toArray());
        }
        log.info(logStats.toString());
        return dataLockMap;
    }

    public void updatePeriods(long modelId, List<String> oldPeriods, List<String> newPeriods) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_datalock", (String)"periodbinary", (QFilter[])qFilter.toArray());
        if (load != null && load.length > 0) {
            for (DynamicObject doj : load) {
                this.updatePeriod(oldPeriods, newPeriods, doj);
            }
            SaveServiceHelper.save((DynamicObject[])load);
        }
    }

    public void updatePeriod(List<String> oldPeriods, List<String> newPeriods, DynamicObject doj) {
        int periodbinary = doj.getInt("periodbinary");
        String binaryString = Integer.toBinaryString(periodbinary);
        HashSet<Object> periods = new HashSet<Object>(16);
        char[] chars = binaryString.toCharArray();
        for (int i = 0; i < oldPeriods.size(); ++i) {
            String period = oldPeriods.get(i);
            char aChar = chars[i + 1];
            if (aChar != '1') continue;
            periods.add(period);
        }
        StringBuilder sb = new StringBuilder();
        sb.append('1');
        for (String newPeriod : newPeriods) {
            sb.append(periods.contains(newPeriod) ? (char)'1' : '0');
        }
        Integer periodInt = Integer.parseInt(sb.toString(), 2);
        doj.set("periodbinary", (Object)periodInt);
    }

    public void saveDataLock(long modelId, DataLockKey dataLockKey, List<DataLockEntry> dataLockEntitys) {
        Long dataLockYear = Long.valueOf(dataLockKey.getYear());
        Long dataLockCurrency = Long.valueOf(dataLockKey.getCurrency());
        Long dataLockVersion = Long.valueOf(dataLockKey.getVersion());
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("year", "=", (Object)dataLockYear);
        qFilter.and("currency", "=", (Object)dataLockCurrency);
        qFilter.and("version", "=", (Object)dataLockVersion);
        List<DataLockLogEntry> dataLockLog = this.getDataLockLog(modelId, dataLockKey, dataLockEntitys, qFilter);
        ArrayList<DynamicObject> dataLockObjs = new ArrayList<DynamicObject>(16);
        for (DataLockEntry entity : dataLockEntitys) {
            DynamicObject doj = BusinessDataServiceHelper.newDynamicObject((String)"eb_datalock");
            doj.set("model", (Object)modelId);
            doj.set("year", (Object)dataLockYear);
            doj.set("currency", (Object)dataLockCurrency);
            doj.set("version", (Object)dataLockVersion);
            doj.set("entity", (Object)entity.getEntityId());
            doj.set("periodbinary", (Object)entity.getPeriodInt());
            dataLockObjs.add(doj);
        }
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        ArrayList<DynamicObject> dataLockLogObjs = new ArrayList<DynamicObject>(16);
        for (DataLockLogEntry dataLockLogEntry : dataLockLog) {
            DynamicObject dataLockLogObj = BusinessDataServiceHelper.newDynamicObject((String)"eb_datalocklog");
            dataLockLogObj.set("model", (Object)modelId);
            dataLockLogObj.set("year", (Object)dataLockYear);
            dataLockLogObj.set("currency", (Object)dataLockCurrency);
            dataLockLogObj.set("version", (Object)dataLockVersion);
            dataLockLogObj.set("entity", (Object)dataLockLogEntry.getEntity());
            dataLockLogObj.set("period", (Object)dataLockLogEntry.getPeriods());
            dataLockLogObj.set("executor", (Object)userId);
            dataLockLogObj.set("executeoperation", (Object)dataLockLogEntry.getType().getStatus());
            dataLockLogObj.set("executetime", (Object)now);
            dataLockLogObjs.add(dataLockLogObj);
        }
        try (TXHandle tx = TX.requiresNew((String)"saveDataLock");){
            try {
                DeleteServiceHelper.delete((String)"eb_datalock", (QFilter[])qFilter.toArray());
                if (!dataLockObjs.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])dataLockObjs.toArray(new DynamicObject[0]));
                }
                if (!dataLockLogObjs.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])dataLockLogObjs.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        DataLockCacheHelper.clearDataLock(modelId);
    }

    private List<DataLockLogEntry> getDataLockLog(long modelId, DataLockKey dataLockKey, List<DataLockEntry> entitys, QFilter qFilter) {
        List<DataLockEntry> historyDatas = this.getDataLockHistoryData(qFilter);
        Map<Long, Integer> historyMap = historyDatas.stream().collect(Collectors.toMap(DataLockEntry::getEntityId, DataLockEntry::getPeriodInt));
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        List<Member> periods = modelCacheHelper.getMemberSort(SysDimensionEnum.Period.getNumber(), null, "Period", RangeEnum.ALL_EXCLUDE.getIndex());
        ArrayList<DataLockLogEntry> dataLockLogEntries = new ArrayList<DataLockLogEntry>(10);
        for (DataLockEntry entity : entitys) {
            Integer integer = historyMap.remove(entity.getEntityId());
            if (integer == null) {
                DataLockLogEntry dataLockLogEntry = this.appendDataLockLogWhileAddRow(dataLockKey, periods, entity);
                dataLockLogEntries.add(dataLockLogEntry);
                continue;
            }
            if (integer.equals(entity.getPeriodInt())) continue;
            this.appendDataLockLogWhileRowChange(dataLockKey, periods, dataLockLogEntries, entity, integer);
        }
        if (!historyMap.isEmpty()) {
            historyMap.forEach((entityId, periodInteger) -> this.appendDataLockRowWhileRowDelete(dataLockKey, periods, (List<DataLockLogEntry>)dataLockLogEntries, (Long)entityId, (Integer)periodInteger));
        }
        return dataLockLogEntries;
    }

    private void appendDataLockRowWhileRowDelete(DataLockKey dataLockKey, List<Member> periods, List<DataLockLogEntry> dataLockLogEntries, Long entityId, Integer periodInteger) {
        DataLockLogEntry dataLockLogEntry = new DataLockLogEntry();
        try {
            BeanUtils.copyProperties((Object)dataLockLogEntry, (Object)dataLockKey);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String binaryString = Integer.toBinaryString(periodInteger);
        char[] chars = binaryString.toCharArray();
        for (int i = 1; i < chars.length; ++i) {
            Member member;
            char aChar = chars[i];
            if (aChar != '1' || !(member = periods.get(i - 1)).isLeaf()) continue;
            stringBuilder.append(member.getName()).append(',');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
            dataLockLogEntry.setEntity(entityId);
            dataLockLogEntry.setType(DataLockLogEntry.Type.unlock);
            dataLockLogEntry.setPeriods(stringBuilder.toString());
            dataLockLogEntries.add(dataLockLogEntry);
        }
    }

    private void appendDataLockLogWhileRowChange(DataLockKey dataLockKey, List<Member> periods, List<DataLockLogEntry> dataLockLogEntries, DataLockEntry entity, Integer integer) {
        DataLockLogEntry dataLockLogEntry = new DataLockLogEntry();
        try {
            BeanUtils.copyProperties((Object)dataLockLogEntry, (Object)dataLockKey);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int periodInt = entity.getPeriodInt();
        String binaryString = Integer.toBinaryString(periodInt);
        char[] chars = binaryString.toCharArray();
        String binaryString2 = Integer.toBinaryString(integer);
        char[] chars2 = binaryString2.toCharArray();
        for (int i = 1; i < chars.length; ++i) {
            Member member;
            char aChar = chars[i];
            char aChar2 = chars2[i];
            if (aChar == aChar2 || !(member = periods.get(i - 1)).isLeaf()) continue;
            if (aChar == '0') {
                stringBuilder2.append(member.getName()).append(',');
                continue;
            }
            stringBuilder.append(member.getName()).append(',');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
            dataLockLogEntry.setEntity(entity.getEntityId());
            dataLockLogEntry.setPeriods(stringBuilder.toString());
            dataLockLogEntry.setType(DataLockLogEntry.Type.lock);
            dataLockLogEntries.add(dataLockLogEntry);
        }
        if (stringBuilder2.length() > 0) {
            DataLockLogEntry dataLockLogEntry1 = new DataLockLogEntry();
            try {
                BeanUtils.copyProperties((Object)dataLockLogEntry1, (Object)dataLockLogEntry);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            stringBuilder2.setLength(stringBuilder2.length() - 1);
            dataLockLogEntry1.setEntity(entity.getEntityId());
            dataLockLogEntry1.setPeriods(stringBuilder2.toString());
            dataLockLogEntry1.setType(DataLockLogEntry.Type.unlock);
            dataLockLogEntries.add(dataLockLogEntry1);
        }
    }

    private DataLockLogEntry appendDataLockLogWhileAddRow(DataLockKey dataLockKey, List<Member> periods, DataLockEntry entity) {
        DataLockLogEntry dataLockLogEntry = new DataLockLogEntry();
        try {
            BeanUtils.copyProperties((Object)dataLockLogEntry, (Object)dataLockKey);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        StringBuilder lockSb = new StringBuilder();
        StringBuilder unlockSb = new StringBuilder();
        int periodInt = entity.getPeriodInt();
        String binaryString = Integer.toBinaryString(periodInt);
        char[] chars = binaryString.toCharArray();
        for (int i = 1; i < chars.length; ++i) {
            char aChar = chars[i];
            Member member = periods.get(i - 1);
            if (!member.isLeaf()) continue;
            if (aChar == '1') {
                lockSb.append(member.getName()).append(',');
                continue;
            }
            unlockSb.append(member.getName()).append(',');
        }
        if (lockSb.length() > 0) {
            lockSb.setLength(lockSb.length() - 1);
            dataLockLogEntry.setType(DataLockLogEntry.Type.lock);
            dataLockLogEntry.setPeriods(lockSb.toString());
        } else {
            unlockSb.setLength(unlockSb.length() - 1);
            dataLockLogEntry.setType(DataLockLogEntry.Type.unlock);
            dataLockLogEntry.setPeriods(unlockSb.toString());
        }
        dataLockLogEntry.setEntity(entity.getEntityId());
        return dataLockLogEntry;
    }

    private List<DataLockEntry> getDataLockHistoryData(QFilter qFilter) {
        ArrayList<DataLockEntry> dataLockEntitys = new ArrayList<DataLockEntry>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getDataLockHistoryData", (String)"eb_datalock", (String)"entity,periodbinary", (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                dataLockEntitys.add(new DataLockEntry(row.getLong("entity"), row.getInteger("periodbinary")));
            }
        }
        return dataLockEntitys;
    }

    public Map<DataLockKey, Map<String, Set<String>>> getDataLockMap(Long modelId, Map<String, Set<String>> filters) {
        Map<String, Map<String, Set<String>>> dataLockMap = DataLockCacheHelper.getDataLock(modelId);
        if (dataLockMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Set<String> yearSet = filters.get(SysDimensionEnum.Year.getNumber());
        Set<String> currencySet = filters.get(SysDimensionEnum.Currency.getNumber());
        Set<String> versionSet = filters.get(SysDimensionEnum.Version.getNumber());
        if (CollectionUtils.isEmpty(yearSet) || CollectionUtils.isEmpty(currencySet) || CollectionUtils.isEmpty(versionSet)) {
            log.error(LOGTAG + ResManager.loadResFormat((String)"\u6570\u636e\u9501\u5b9a\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef:%1", (String)"DataLockService_1", (String)"epm-eb-budget", (Object[])new Object[]{filters}));
            throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u9501\u5b9a\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef:%1", (String)"DataLockService_1", (String)"epm-eb-budget", (Object[])new Object[]{filters}));
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        HashMap<DataLockKey, Map<String, Set<String>>> returnDataLockMap = new HashMap<DataLockKey, Map<String, Set<String>>>();
        for (String year : yearSet) {
            for (String currency : currencySet) {
                for (String version : versionSet) {
                    DataLockKey dataLockKey = new DataLockKey(year, currency, version);
                    Map<String, Set<String>> stringSetHashMap = this.fillEntityAndPeriod(dataLockMap, modelCache, dataLockKey, true);
                    if (stringSetHashMap == null) continue;
                    returnDataLockMap.put(dataLockKey, stringSetHashMap);
                }
            }
        }
        return returnDataLockMap;
    }

    public Map<String, Set<String>> getDataLockData(Long modelId, DataLockKey dataLockKey) {
        Map<String, Map<String, Set<String>>> dataLockMap = DataLockCacheHelper.getDataLock(modelId);
        if (dataLockMap.isEmpty()) {
            return Collections.emptyMap();
        }
        if (StringUtils.isEmpty((CharSequence)dataLockKey.getYear()) || StringUtils.isEmpty((CharSequence)dataLockKey.getCurrency()) || StringUtils.isEmpty((CharSequence)dataLockKey.getVersion())) {
            return Collections.emptyMap();
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        Map<String, Set<String>> stringSetHashMap = this.fillEntityAndPeriod(dataLockMap, modelCache, dataLockKey, false);
        if (stringSetHashMap == null) {
            return Collections.emptyMap();
        }
        return stringSetHashMap;
    }

    private Map<String, Set<String>> fillEntityAndPeriod(Map<String, Map<String, Set<String>>> dataLockMap, IModelCacheHelper modelCache, DataLockKey dataLockKey, boolean isOnlyLeaf) {
        Map<String, Set<String>> stringSetMap = dataLockMap.get(dataLockKey.toString());
        if (MapUtils.isEmpty(stringSetMap)) {
            return null;
        }
        HashMap<String, Set<String>> stringSetHashMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : stringSetMap.entrySet()) {
            List<Member> members = modelCache.getMembers(SysDimensionEnum.Period.getNumber(), null, (Collection<String>)entry.getValue());
            HashSet<String> periodMembers = new HashSet<String>();
            for (Member member : members) {
                if (member.isLeaf()) {
                    periodMembers.add(member.getNumber());
                    continue;
                }
                if (!isOnlyLeaf) {
                    periodMembers.add(member.getNumber());
                }
                List<String> leafOfNumbers = modelCache.getLeafOfNumbers(member);
                periodMembers.addAll(leafOfNumbers);
            }
            if (isOnlyLeaf) {
                List<Member> entityMembers = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), (Long)0L, entry.getKey(), RangeEnum.ALL_DETAIL_INCLUDE.getIndex());
                if (CollectionUtils.isEmpty(entityMembers)) continue;
                for (Member entityMember : entityMembers) {
                    stringSetHashMap.put(entityMember.getNumber(), periodMembers);
                }
                continue;
            }
            stringSetHashMap.put(entry.getKey(), periodMembers);
        }
        return stringSetHashMap;
    }
}

