/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.decompose;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.decompose.TaskStatus;
import kd.epm.eb.common.decompose.entity.DecDimension;
import kd.epm.eb.common.decompose.entity.DecomposeAgentEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;

public class DecDimensionUtil {
    private static Long getViewId(IModelCacheHelper modelCacheContext, DynamicObject scheme, String dimNumber) {
        if (scheme == null) {
            return 0L;
        }
        return modelCacheContext.getViewByBusModelAndDimNumber(scheme.getLong("bizmodel_id"), dimNumber);
    }

    public static List<DecDimension> getDecDimensionListFromSrc(IModelCacheHelper modelCacheContext, String srcdimensionjson, String viewjson, DynamicObject scheme) {
        JSONObject srcdimension = JSON.parseObject((String)srcdimensionjson);
        JSONObject viewMap = JSON.parseObject((String)viewjson);
        LinkedList<DecDimension> decDimensionList = new LinkedList<DecDimension>();
        for (Map.Entry entry : srcdimension.entrySet()) {
            Member member;
            String dimensionNumber = entry.getKey().toString();
            String memberNumber = entry.getValue().toString();
            Long viewId = null;
            if (viewMap != null) {
                viewId = viewMap.getLong(dimensionNumber);
            }
            if (viewId == null) {
                viewId = DecDimensionUtil.getViewId(modelCacheContext, scheme, dimensionNumber);
            }
            if ((member = modelCacheContext.getMember(dimensionNumber, viewId, memberNumber)) == null || member.isLeaf()) {
                viewId = DecDimensionUtil.getViewId(modelCacheContext, scheme, dimensionNumber);
                member = modelCacheContext.getMember(dimensionNumber, viewId, memberNumber);
            }
            if (member == null || member.isLeaf()) continue;
            Member decomposeAuditTrail = null;
            if (SysDimensionEnum.AuditTrail.getNumber().equals(dimensionNumber)) {
                decomposeAuditTrail = AdjustServiceHelper.getChildDecomposeAuditTrail(modelCacheContext, member.getNumber());
            }
            if (decomposeAuditTrail != null) continue;
            DecDimension decDimension = new DecDimension(dimensionNumber, memberNumber, TaskStatus.WAIT.getValue(), DecomposeAgentEnum.INPUT.getValue());
            decDimensionList.add(decDimension);
        }
        LinkedList<DecDimension> list = new LinkedList<DecDimension>();
        for (DecDimension decDimension : decDimensionList) {
            if (!SysDimensionEnum.Entity.getNumber().equals(decDimension.getDimNumber())) continue;
            list.add(decDimension);
            break;
        }
        for (DecDimension decDimension : decDimensionList) {
            if (!SysDimensionEnum.Account.getNumber().equals(decDimension.getDimNumber())) continue;
            list.add(decDimension);
        }
        for (DecDimension decDimension : decDimensionList) {
            if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(decDimension.getDimNumber())) continue;
            list.add(decDimension);
            break;
        }
        for (DecDimension decDimension : decDimensionList) {
            if (SysDimensionEnum.Entity.getNumber().equals(decDimension.getDimNumber()) || SysDimensionEnum.Account.getNumber().equals(decDimension.getDimNumber()) || SysDimensionEnum.BudgetPeriod.getNumber().equals(decDimension.getDimNumber())) continue;
            list.add(decDimension);
        }
        return list;
    }

    public static String setThisDecDimension(String decdimensionjson, DecDimension thisDecDimension) {
        JSONArray fromJsonArray = JSONArray.parseArray((String)decdimensionjson);
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < fromJsonArray.size(); ++i) {
            DecDimension decDimension = (DecDimension)JSON.parseObject((String)fromJsonArray.getString(i), DecDimension.class);
            if (StringUtils.equals(decDimension.getDimNumber(), thisDecDimension.getDimNumber())) {
                decDimension.setStatus(thisDecDimension.getStatus());
                decDimension.setAgent(thisDecDimension.getAgent());
            }
            jsonArray.add((Object)decDimension);
        }
        return JSON.toJSONString((Object)jsonArray);
    }

    public static void setDecDimension(DynamicObject log, DecDimension decDimension) {
        if (decDimension != null) {
            log.set("dimension", (Object)decDimension.getDimNumber());
            log.set("dimmember", (Object)decDimension.getDimMember());
        } else {
            log.set("dimension", (Object)"0");
            log.set("dimmember", (Object)"0");
        }
    }

    public static DecDimension getPreviousDecDimen(DecDimension decDimension, List<DecDimension> decDimensions) {
        DecDimension previousDecDimen = null;
        for (int i = 0; i < decDimensions.size(); ++i) {
            if (!StringUtils.equals(decDimension.getDimNumber(), decDimensions.get(i).getDimNumber())) continue;
            previousDecDimen = i == 0 ? null : decDimensions.get(i - 1);
        }
        return previousDecDimen;
    }

    public static Long getDatasetId(IModelCacheHelper modelCache, Map<String, String> memberMap) {
        String accountNumber = SysDimensionEnum.Account.getNumber();
        if (memberMap.isEmpty() || memberMap.get(accountNumber) == null) {
            return 0L;
        }
        Member account = modelCache.getMember(accountNumber, null, memberMap.get(accountNumber));
        return account.getDatasetId();
    }
}

