/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.dimension.dimensionrelation;

import com.google.common.collect.Sets;
import com.google.common.graph.ImmutableValueGraph;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelGraph;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelGraphEdge;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelGraphNode;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DimRelGraphHelper {
    public static final Log log = LogFactory.getLog(DimRelGraphHelper.class);

    public static void addNode2Graph(DimRelGraph dimRelGraph, DimRelGraphNode fromNode, DimRelGraphNode toNode, Long startPeriod, Long endPeriod, DimRelGraphNode ... preOrderNodes) {
        MutableValueGraph<DimRelGraphNode, DimRelGraphEdge> graph = dimRelGraph.getMutableGraph();
        Optional optional = graph.edgeValue((Object)fromNode, (Object)toNode);
        DimRelGraphEdge dimRelGraphEdge = optional.orElseGet(DimRelGraphEdge::new);
        Map<String, Set<DimRelGraphNode>> preNodes = dimRelGraphEdge.getPreNodes();
        if (preNodes == null) {
            preNodes = new HashMap<String, Set<DimRelGraphNode>>(16);
            dimRelGraphEdge.setPreNodes(preNodes);
        }
        if (startPeriod != null && endPeriod != null) {
            fromNode.addPeriod(startPeriod, endPeriod);
            toNode.addPeriod(startPeriod, endPeriod);
        }
        for (DimRelGraphNode preOrderNode : preOrderNodes) {
            Set set = preNodes.computeIfAbsent(preOrderNode.getDimNum(), k -> new HashSet(16));
            set.add(preOrderNode);
        }
        graph.putEdgeValue((Object)fromNode, (Object)toNode, (Object)dimRelGraphEdge);
    }

    public static boolean isValidRel(IModelCacheHelper modelCache, long bizModelId, Long period, DimRelGraph dimRelGraph, DimRelGraphNode ... preOrderNodes) {
        if (preOrderNodes.length < 2) {
            return true;
        }
        ArrayList<DimRelGraphNode> preNodes = new ArrayList<DimRelGraphNode>(preOrderNodes.length);
        for (int i = 0; i < preOrderNodes.length - 1; ++i) {
            preNodes.add(preOrderNodes[i]);
            DimRelGraphNode postOrderNode = preOrderNodes[i + 1];
            Set<DimRelGraphNode> postNode = DimRelGraphHelper.getPostNode(modelCache, bizModelId, period, postOrderNode.getDimNum(), dimRelGraph, preNodes.toArray(new DimRelGraphNode[0]));
            if (postNode.contains(postOrderNode)) continue;
            return false;
        }
        return true;
    }

    public static Set<DimRelGraphNode> getPostNode(IModelCacheHelper modelCache, long bizModelId, Long period, String dimNumber, DimRelGraph dimRelGraph, DimRelGraphNode ... preOrderNodes) {
        ImmutableValueGraph<DimRelGraphNode, DimRelGraphEdge> graph = dimRelGraph.getGraph();
        Object postNodes = new HashSet(16);
        if (preOrderNodes == null || preOrderNodes.length == 0) {
            postNodes = graph.nodes().stream().filter(n -> n.getDimNum().equals(dimNumber)).collect(Collectors.toSet());
        } else {
            for (DimRelGraphNode preOrderNode : preOrderNodes) {
                if (!graph.nodes().contains(preOrderNode)) continue;
                Set successors = graph.successors((Object)preOrderNode);
                Set dimRelGraphNodes = successors.stream().filter(dimRelNode -> dimNumber.equals(dimRelNode.getDimNum())).collect(Collectors.toSet());
                postNodes = postNodes.isEmpty() ? dimRelGraphNodes : Sets.intersection(postNodes, dimRelGraphNodes);
            }
        }
        Set<DimRelGraphNode> nodes = DimRelGraphHelper.filterValidNode(modelCache, graph, postNodes, period, preOrderNodes);
        if (bizModelId > 0L) {
            List<Long> viewIds = dimRelGraph.getDimViewMap().get(dimNumber);
            return DimRelGraphHelper.filterPerm(modelCache, bizModelId, dimNumber, viewIds, nodes);
        }
        return nodes;
    }

    private static Set<DimRelGraphNode> filterPerm(IModelCacheHelper modelCache, long bizModelId, String dimNumber, List<Long> viewIds, Set<DimRelGraphNode> postNodes) {
        if (postNodes.isEmpty() || bizModelId == 0L) {
            return postNodes;
        }
        HashSet<String> permMemberNumbers = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(viewIds) && !View.NoViewDimNums.contains(dimNumber)) {
            for (Long viewId : viewIds) {
                Set<String> permMembNumbers = EpmThreadLocalUtils.getPermMembNumbers(dimNumber, modelCache.getModelobj().getId(), bizModelId, viewId, DimMembPermType.READ, true);
                if (!CollectionUtils.isNotEmpty(permMembNumbers)) continue;
                permMemberNumbers.addAll(permMembNumbers);
            }
        } else {
            Set<String> permMembNumbers = EpmThreadLocalUtils.getPermMembNumbers(dimNumber, modelCache.getModelobj().getId(), bizModelId, 0L, DimMembPermType.READ, true);
            if (CollectionUtils.isNotEmpty(permMembNumbers)) {
                permMemberNumbers.addAll(permMembNumbers);
            }
        }
        if (CollectionUtils.isEmpty(permMemberNumbers)) {
            return postNodes;
        }
        return postNodes.stream().filter(node -> permMemberNumbers.contains(node.getMemNum())).collect(Collectors.toSet());
    }

    private static Set<DimRelGraphNode> filterValidNode(IModelCacheHelper modelCache, ValueGraph<DimRelGraphNode, DimRelGraphEdge> graph, Set<DimRelGraphNode> postNodes, Long period, DimRelGraphNode ... preOrderNodes) {
        if (postNodes.isEmpty()) {
            return postNodes;
        }
        HashSet<DimRelGraphNode> resultNodes = new HashSet<DimRelGraphNode>(postNodes.size());
        DimRelGraphNode preNode = preOrderNodes.length > 0 ? preOrderNodes[preOrderNodes.length - 1] : null;
        postNodes.forEach(postNode -> {
            Optional optional;
            boolean match = period == 0L;
            List<Pair<Long, Long>> periodList = postNode.getPeriodList();
            if (periodList != null && period > 0L) {
                for (Pair<Long, Long> pair : periodList) {
                    if (!DimRelGraphHelper.isValidPeriod((Long)pair.getLeft(), (Long)pair.getRight(), modelCache, period)) continue;
                    match = true;
                    break;
                }
            }
            if (!match) {
                return;
            }
            if (preNode != null && (optional = graph.edgeValue((Object)preNode, postNode)).isPresent()) {
                DimRelGraphEdge dimRelGraphEdge = (DimRelGraphEdge)optional.get();
                for (int i = 0; i < preOrderNodes.length - 1; ++i) {
                    Set<DimRelGraphNode> set;
                    DimRelGraphNode preOrderNode = preOrderNodes[i];
                    Map<String, Set<DimRelGraphNode>> preNodes = dimRelGraphEdge.getPreNodes();
                    if (preNodes == null || (set = preNodes.get(preOrderNode.getDimNum())) != null && set.contains(preOrderNode)) continue;
                    match = false;
                    break;
                }
            }
            if (match) {
                resultNodes.add((DimRelGraphNode)postNode);
            }
        });
        return resultNodes;
    }

    private static boolean isValidPeriod(long startPeriod, long endPeriod, IModelCacheHelper modelCache, Long periodId) {
        if (periodId == null || periodId == 0L) {
            return true;
        }
        if (startPeriod == 0L && endPeriod == 0L) {
            return true;
        }
        Member member = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), (Long)0L, periodId);
        if (member == null) {
            return true;
        }
        List<Object> members = new ArrayList<Member>(10);
        if (member.isLeaf()) {
            members.add(member);
        } else {
            members = modelCache.getDetailChildren(member);
        }
        boolean isValid = true;
        try {
            List finalMembers = members.stream().filter(e -> !e.getNumber().endsWith("._inv") && !e.getNumber().endsWith(".cosmic_invisible")).collect(Collectors.toList());
            int startYear = 0;
            int startMon = 1;
            int endYear = 9999;
            int endMon = 12;
            if (startPeriod != 0L) {
                Member startPeriodMember = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), (Long)0L, startPeriod);
                String[] startPeriodMemberStr = startPeriodMember.getNumber().split("\\.");
                startYear = Integer.parseInt(startPeriodMemberStr[0].replace("FY", ""));
                startMon = Integer.parseInt(startPeriodMemberStr[1].replace("M", ""));
            }
            if (endPeriod != 0L) {
                Member endPeriodMember = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), (Long)0L, endPeriod);
                String[] endPeriodMemberStr = endPeriodMember.getNumber().split("\\.");
                endYear = Integer.parseInt(endPeriodMemberStr[0].replace("FY", ""));
                endMon = Integer.parseInt(endPeriodMemberStr[1].replace("M", ""));
            }
            for (Member member1 : finalMembers) {
                String[] memberStr = member1.getNumber().split("\\.");
                int year = Integer.parseInt(memberStr[0].replace("FY", ""));
                int mon = Integer.parseInt(memberStr[1].replace("M", ""));
                if (year < startYear || year > endYear) {
                    isValid = false;
                    continue;
                }
                if (year == startYear && mon < startMon) {
                    isValid = false;
                    continue;
                }
                if (year != endYear || mon <= endMon) continue;
                isValid = false;
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        return isValid;
    }
}

